/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class ManagedSCSIPCInstrumentation
extends BaseAssocInstrumentation {
    protected ManagedSCSIPCInstrumentation() {
        super("HITACHI_ManagedSCSIPC", "HITACHI_ControllerConfigurationService", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ControllerConfigurationServiceInstrumentation"), "HITACHI_SCSIProtocolController", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolControllerInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_ManagedSCSIPC".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        CIMProperty cpSysName = objectName.getKey("SystemName");
                        Hashtable<String, Object> expectedVals = new Hashtable<String, Object>();
                        expectedVals.put("ElementName", cpSysName.getValue());
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, expectedVals, null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                    needToCloseIter = true;
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CIMObjectPath ccsOP = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath scsipcOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference2ClassName(), null);
                ReferenceInfo newRefInfo = new ReferenceInfo(ccsOP, null, this.getReference1PropertyName(), this.getReference2PropertyName(), propertyList, isObjectPath, this);
                Hashtable<String, Object> expectedVals = new Hashtable<String, Object>();
                expectedVals.put("ElementName", device.getStorageSystemName());
                this.getReference2Instrumentation().enumerate(deviceIter, scsipcOP, new String[0], null, null, continueOnError, true, expectedVals, newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath scsipcOP;
            String ccsPropName = this.getReference1PropertyName();
            CIMObjectPath ccsOP = op.getKey(ccsPropName) != null ? (CIMObjectPath)op.getKey(ccsPropName).getValue() : null;
            String scsipcPropName = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = scsipcOP = op.getKey(scsipcPropName) != null ? (CIMObjectPath)op.getKey(scsipcPropName).getValue() : null;
            if (null != scsipcOP && null != ccsOP) {
                String ccsSysName = ccsOP.getKey("SystemName") != null && ccsOP.getKey("SystemName").getValue() != null ? (String)ccsOP.getKey("SystemName").getValue() : null;
                String scsipcSysName = scsipcOP.getKey("SystemName") != null && scsipcOP.getKey("SystemName").getValue() != null ? (String)scsipcOP.getKey("SystemName").getValue() : null;
                String scsiPCSSName = ProviderLibs.getAllButEndString(scsipcSysName, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(ccsOP, "SystemName");
                if (null != ccsSysName && null != scsiPCSSName && ccsSysName.equals(scsiPCSSName) && ccsSysName.equals(device.getStorageSystemName())) {
                    try {
                        CIMInstance ci = this.getReference2Instrumentation().getInstance(scsipcOP, new String[0]);
                        scsipcOP = ci.getObjectPath();
                        ccsOP = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                        return this.generateInstance(op, propertyList, ccsOP, scsipcOP);
                    }
                    catch (WBEMException we) {}
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_ManagedSCSIPC".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMObjectPath scsipcOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null, objectName.getXmlSchemaName());
                    CIMObjectPath opObjectName = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference1ClassName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo newRefInfo = new ReferenceInfo(opObjectName, null, this.getReference1PropertyName(), this.getReference2PropertyName(), propertyList, isObjectPath, this);
                    Hashtable<String, Object> expectedVals = new Hashtable<String, Object>();
                    expectedVals.put("ElementName", device.getStorageSystemName());
                    this.getReference2Instrumentation().enumerate(iter, scsipcOP, new String[0], null, null, continueOnError, true, expectedVals, newRefInfo);
                    needToCloseIter = false;
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMObjectPath ccsOP = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CIMObjectPath opObjectName = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, ccsOP, opObjectName));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, ccsOP, opObjectName));
                    }
                    needToCloseIter = true;
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

