/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.SnapshotInfo2;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class MemberOfSnapshotSourceVolumeCollectionInstrumentation
extends BaseAssocInstrumentation {
    protected MemberOfSnapshotSourceVolumeCollectionInstrumentation() {
        super("HITACHI_MemberOfSnapshotSourceVolumeCollection", "HITACHI_AllocatedSnapshotSourceResources", "Collection", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.AllocatedSnapshotSourceResourcesInstrumentation"), "HITACHI_StorageVolume", "Member", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_MemberOfSnapshotSourceVolumeCollection".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Collection")) && (null == resultRole || resultRole.equalsIgnoreCase("Member"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        SnapshotInfo2 pairData;
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                        HashSet<String> sourceSet = new HashSet<String>();
                        CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                        SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback);
                        LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                        while ((pairData = (SnapshotInfo2)pairDataList.poll()) != null) {
                            DeviceNumber pVolDN = pairData.getPVol();
                            if (sourceSet.contains(pVolDN.getDNAsString())) continue;
                            sourceSet.add(pVolDN.getDNAsString());
                            if (isObjectPath) {
                                iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, pVolDN));
                                continue;
                            }
                            iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, pVolDN));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Member")) && (null == resultRole || resultRole.equalsIgnoreCase("Collection")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                    if (null != cpDeviceID) {
                        String deviceNum = (String)cpDeviceID.getValue();
                        CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                        SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, deviceNum, Boolean.TRUE);
                        LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                        if (!pairDataList.isEmpty()) {
                            pairDataList = null;
                            if (isObjectPath) {
                                iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                            } else {
                                iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                SnapshotInfo2 pairData;
                CIMObjectPath opSnapShotSourceResource = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                HashSet<String> sourceSet = new HashSet<String>();
                CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback);
                LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                while ((pairData = (SnapshotInfo2)pairDataList.poll()) != null) {
                    DeviceNumber pVolDN = pairData.getPVol();
                    if (sourceSet.contains(pVolDN.getDNAsString())) continue;
                    sourceSet.add(pVolDN.getDNAsString());
                    CIMObjectPath opStorageVolume = this.getReference2Instrumentation().generateObjectPath(op, pVolDN);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, opSnapShotSourceResource, opStorageVolume));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, opSnapShotSourceResource, opStorageVolume));
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block9: {
            try {
                String pnStorageVolume = this.getReference2PropertyName();
                CIMObjectPath opStorageVolume = opObjectName.getKey(pnStorageVolume) != null ? (CIMObjectPath)opObjectName.getKey(pnStorageVolume).getValue() : null;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageVolume, "SystemName");
                CIMInstance instStorageVolume = null;
                try {
                    instStorageVolume = this.getReference2Instrumentation().getInstance(opStorageVolume, null);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null == instStorageVolume) break block9;
                String pnSnapshotSourceResource = this.getReference1PropertyName();
                CIMObjectPath opSnapshotSourceResource = opObjectName.getKey(pnSnapshotSourceResource) != null ? (CIMObjectPath)opObjectName.getKey(pnSnapshotSourceResource).getValue() : null;
                CIMInstance instSnapshotSourceResource = null;
                try {
                    instSnapshotSourceResource = this.getReference1Instrumentation().getInstance(opSnapshotSourceResource, new String[0]);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null != instSnapshotSourceResource) {
                    opStorageVolume = instStorageVolume.getObjectPath();
                    String cpvDeviceID = (String)instStorageVolume.getPropertyValue("DeviceID");
                    CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                    SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, cpvDeviceID, Boolean.TRUE);
                    LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                    if (!pairDataList.isEmpty()) {
                        return this.generateInstance(opObjectName, propertyList, instSnapshotSourceResource.getObjectPath(), opStorageVolume);
                    }
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_MemberOfSnapshotSourceVolumeCollection".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_AllocatedSnapshotSourceResources") && (null == role || role.equalsIgnoreCase("Collection")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    SnapshotInfo2 pairData;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    CIMObjectPath opSnapshotSourceResource = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    HashSet<String> sourceSet = new HashSet<String>();
                    CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                    SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback);
                    LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                    while ((pairData = (SnapshotInfo2)pairDataList.poll()) != null) {
                        DeviceNumber pVolDN = pairData.getPVol();
                        if (sourceSet.contains(pVolDN.getDNAsString())) continue;
                        sourceSet.add(pVolDN.getDNAsString());
                        CIMObjectPath opStorageVolume = this.getReference2Instrumentation().generateObjectPath(objectName, pVolDN);
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, opSnapshotSourceResource, opStorageVolume));
                            continue;
                        }
                        iter.add(this.generateInstance(objectName, propertyList, opSnapshotSourceResource, opStorageVolume));
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageVolume") && (null == role || role.equalsIgnoreCase("Member")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping map = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                    if (null != cpDeviceID) {
                        String deviceNum = (String)cpDeviceID.getValue();
                        CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                        SnapshotInfo2.getSnapshotInfo2(map.getRMIObject(), callback, deviceNum, Boolean.TRUE);
                        LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                        if (!pairDataList.isEmpty()) {
                            DeviceNumber dn = ((SnapshotInfo2)pairDataList.poll()).getPVol();
                            pairDataList = null;
                            CIMObjectPath opStorageVolume = this.getReference2Instrumentation().generateObjectPath(objectName, dn);
                            CIMObjectPath opSnapshotSourceResource = this.getReference1Instrumentation().generateObjectPath(objectName, map.getRMIObject());
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, opSnapshotSourceResource, opStorageVolume));
                            } else {
                                iter.add(this.generateInstance(objectName, propertyList, opSnapshotSourceResource, opStorageVolume));
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

