/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class MemberOfStatisticsCollectionFCPortInstrumentation
extends BaseAssocInstrumentation {
    protected MemberOfStatisticsCollectionFCPortInstrumentation() {
        super("HITACHI_MemberOfStatisticsCollectionFCPort", "HITACHI_StatisticsCollection", "Collection", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StatisticsCollectionInstrumentation"), "HITACHI_BlockStatisticalDataFCPort", "Member", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.BlockStatisticalDataFCPortInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_MemberOfStatisticsCollectionFCPort".equalsIgnoreCase(assocName.getObjectName())) {
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Collection")) && (null == resultRole || resultRole.equalsIgnoreCase("Member"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        Hashtable<String, Object> expectedValues = this.getSystemNameForHash(objectName);
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, expectedValues, null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Member")) && (null == resultRole || resultRole.equalsIgnoreCase("Collection")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opRedundancySet = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath opStorageProcessorSystem = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_BlockStatisticalDataFCPort", null);
                ReferenceInfo newRefInfo = new ReferenceInfo(opRedundancySet, null, "Collection", "Member", propertyList, isObjectPath, this);
                Hashtable<String, Object> systemName = new Hashtable<String, Object>();
                systemName.put("SystemName", device.getStorageSystemName());
                this.getReference2Instrumentation().enumerate(deviceIter, opStorageProcessorSystem, new String[0], null, null, continueOnError, true, systemName, newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    private Hashtable<String, Object> getSystemNameForHash(CIMObjectPath objectName) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        ret.put("SystemName", device.getStorageSystemName());
        return ret;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_MemberOfStatisticsCollectionFCPort".equalsIgnoreCase(assocName.getObjectName())) {
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StatisticsCollection") && (null == role || role.equalsIgnoreCase("Collection")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    CIMObjectPath opStorageProcessorSystem = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_BlockStatisticalDataFCPort", null);
                    CIMObjectPath opRedundancySet = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo newRefInfo = new ReferenceInfo(opRedundancySet, null, "Collection", "Member", propertyList, isObjectPath, this);
                    Hashtable<String, Object> systemName = this.getSystemNameForHash(objectName);
                    this.getReference2Instrumentation().enumerate(iter, opStorageProcessorSystem, new String[0], null, null, continueOnError, true, systemName, newRefInfo);
                    needToCloseIter = false;
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_BlockStatisticalDataFCPort") && (null == role || role.equalsIgnoreCase("Member")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    CIMObjectPath opRedundancySet = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CIMObjectPath opStorageProcessorSystem = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opRedundancySet, opStorageProcessorSystem, device.getRMIObject()));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, opRedundancySet, opStorageProcessorSystem, device.getRMIObject()));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

