/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ChassisInfo;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class PhysicalDiskDKUInstrumentation
extends BaseAssocInstrumentation {
    protected PhysicalDiskDKUInstrumentation() {
        super("HITACHI_PhysicalDiskDKU", "HITACHI_DKUChassis", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DKUChassisInstrumentation"), "HITACHI_PhysicalDisk", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.PhysicalDiskInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_PhysicalDiskDKU".equalsIgnoreCase(assocName.getObjectName())) {
                String tagVal;
                int[] deviceIDValues;
                CIMProperty tagProp;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    CIMInstance dkuInst;
                    block19: {
                        dkuInst = null;
                        try {
                            dkuInst = this.getReference1Instrumentation().getInstance(objectName, new String[0]);
                        }
                        catch (WBEMException e) {
                            if (e.getID() == 6) break block19;
                            throw e;
                        }
                    }
                    if (null != dkuInst) {
                        CIMObjectPath opDKU = dkuInst.getObjectPath();
                        Hashtable<String, Object> depSearchProps = this.getReference2SearchProperties(opDKU);
                        CIMObjectPath depOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), assocName.getNamespace(), this.getReference2ClassName(), null);
                        needToCloseIter = false;
                        this.getReference2Instrumentation().enumerate(iter, depOP, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, depSearchProps, null);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && null != (tagProp = objectName.getKey("Tag")) && null != (deviceIDValues = PDEVInfoEntry.parseTag(tagVal = (String)tagProp.getValue(), null))) {
                    String chassisLocation;
                    try {
                        ChassisInfo info = ChassisInfo.getChassisInfo(ProviderLibs.getSerialFromString(tagVal));
                        chassisLocation = info.getChassisLocation(deviceIDValues[0], deviceIDValues[1]);
                    }
                    catch (WBEMException we) {
                        mLogger.log(Level.SEVERE, "Error getting ChassisInfo", we);
                        chassisLocation = null;
                    }
                    if (null != chassisLocation) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                        if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject(), String.valueOf(chassisLocation)));
                        } else {
                            iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject(), String.valueOf(chassisLocation)));
                        }
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                Callback<PDEVInfoEntry> callback = new Callback<PDEVInfoEntry>(deviceIter, isObjectPath, null, op, propertyList);
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1, null, -1, -1);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opPD;
            String dkuPropName = this.getReference1PropertyName();
            CIMObjectPath opDKU = op.getKey(dkuPropName) != null ? (CIMObjectPath)op.getKey(dkuPropName).getValue() : null;
            String pdPropName = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opPD = op.getKey(pdPropName) != null ? (CIMObjectPath)op.getKey(pdPropName).getValue() : null;
            if (null != opPD && null != opDKU) {
                CIMInstance instDKU = this.getReference1Instrumentation().getInstance(opDKU, new String[0]);
                CIMInstance instPD = this.getReference2Instrumentation().getInstance(opPD, new String[0]);
                opPD = instPD.getObjectPath();
                instPD = null;
                opDKU = instDKU.getObjectPath();
                instDKU = null;
                String dkuTag = (String)opDKU.getKey("Tag").getValue();
                String pdTag = (String)opPD.getKey("Tag").getValue();
                if (dkuTag != null && pdTag != null) {
                    PDEVInfoEntry entry;
                    String chassisID = ProviderLibs.getEndString(dkuTag, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opPD, "Tag");
                    int[] deviceIDValues = PDEVInfoEntry.parseTag(pdTag, null);
                    if (null != deviceIDValues && null != (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1])) && chassisID.equals(entry.getChassisLocation())) {
                        return this.generateInstance(op, propertyList, opDKU, opPD);
                    }
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opRef1) {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        CIMProperty tagProp = opRef1.getKey("Tag");
        if (null != tagProp) {
            String tag = (String)tagProp.getValue();
            ret.put("SystemName", tag);
            String chassisID = ProviderLibs.getEndString(tag, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            ret.put("ChassisLocation", chassisID);
        }
        return ret;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_PhysicalDiskDKU".equalsIgnoreCase(assocName.getObjectName())) {
                RMIObjectMapping device;
                RMIObjectCache rmiObj;
                PDEVInfoEntry entry;
                String tagVal;
                int[] deviceIDValues;
                CIMProperty tagProp;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    String tag;
                    String chassisID;
                    CIMObjectPath opDKU;
                    CIMProperty tagProp2;
                    CIMInstance dkuInst;
                    block15: {
                        dkuInst = null;
                        try {
                            dkuInst = this.getReference1Instrumentation().getInstance(objectName, new String[0]);
                        }
                        catch (WBEMException e) {
                            if (e.getID() == 6) break block15;
                            throw e;
                        }
                    }
                    if (null != dkuInst && null != (tagProp2 = (opDKU = dkuInst.getObjectPath()).getKey("Tag")) && null != (chassisID = ProviderLibs.getEndString(tag = (String)tagProp2.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR))) {
                        RMIObjectMapping device2 = ProviderLibs.getManagedDeviceFromObjectPath(opDKU, "Tag");
                        needToCloseIter = false;
                        Callback<PDEVInfoEntry> callback = new Callback<PDEVInfoEntry>(iter, isObjectPath, null, opDKU, propertyList);
                        PDEVInfoEntry.getPDEVInfoEntry(device2.getRMIObject(), callback, -1, -1, chassisID, -1, -1);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName) && null != (tagProp = objectName.getKey("Tag")) && null != (deviceIDValues = PDEVInfoEntry.parseTag(tagVal = (String)tagProp.getValue(), null)) && null != (entry = PDEVInfoEntry.find(rmiObj = (device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag")).getRMIObject(), deviceIDValues[0], deviceIDValues[1])) && null != entry.getChassisLocation()) {
                    CIMObjectPath opDKU = this.getReference1Instrumentation().generateObjectPath(objectName, rmiObj, entry.getChassisLocation());
                    CIMObjectPath opPD = this.getReference2Instrumentation().generateObjectPath(objectName, entry);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opDKU, opPD));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, opDKU, opPD));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    private class Callback<E extends PDEVInfoEntry>
    extends IteratorCallbackIMPL<E> {
        protected Callback(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block8: {
                ret = true;
                if (this.mIter.isClosed()) {
                    ret = false;
                } else {
                    try {
                        E entry = item;
                        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(((AbstractBaseCommonObject)entry).getSerialNumber());
                        if (null != device) {
                            RMIObjectCache rmiObj = device.getRMIObject();
                            CIMObjectPath opDKU = PhysicalDiskDKUInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, rmiObj, String.valueOf(((PDEVInfoEntry)entry).getChassisLocation()));
                            CIMObjectPath opPD = PhysicalDiskDKUInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.mOP, entry);
                            if (this.mIsObjectPath) {
                                this.mIter.add(PhysicalDiskDKUInstrumentation.this.generateObjectPath(this.mOP, opDKU, opPD));
                            } else {
                                this.mIter.add(PhysicalDiskDKUInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, opDKU, opPD));
                            }
                            break block8;
                        }
                        throw new WBEMException("could not locate managed device: " + ((AbstractBaseCommonObject)entry).getSerialNumber());
                    }
                    catch (WBEMException we) {
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                    catch (Exception e) {
                        WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                }
            }
            return ret;
        }
    }
}

