/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class PhysicalDiskRealizesDiskDriveInstrumentation
extends BaseAssocInstrumentation {
    protected PhysicalDiskRealizesDiskDriveInstrumentation() {
        super("HITACHI_PhysicalDiskRealizesDiskDrive", "HITACHI_PhysicalDisk", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.PhysicalDiskInstrumentation"), "HITACHI_DiskDrive", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskDriveInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_PhysicalDiskRealizesDiskDrive".equalsIgnoreCase(assocName.getObjectName())) {
                PDEVInfoEntry infoEntry;
                int[] deviceIDVals = null;
                String sysName = null;
                boolean returnPhysicalDisk = false;
                RMIObjectMapping device = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent")) && (null == resultRole || resultRole.equalsIgnoreCase("Dependent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        String cvTag;
                        device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                        CIMProperty cpTag = objectName.getKey("Tag");
                        String string = cvTag = cpTag != null ? (String)cpTag.getValue() : null;
                        if (null != cvTag) {
                            String[] retSysName = new String[1];
                            deviceIDVals = PDEVInfoEntry.parseTag(cvTag, retSysName);
                            sysName = retSysName[0];
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                    CIMProperty cpSystemName = objectName.getKey("SystemName");
                    String deviceID = cpDeviceID != null ? (String)cpDeviceID.getValue() : null;
                    deviceIDVals = PDEVInfoEntry.parseDeviceID(deviceID);
                    sysName = cpSystemName != null ? (String)cpSystemName.getValue() : null;
                    returnPhysicalDisk = true;
                }
                if (null != device && null != deviceIDVals && null != sysName && sysName.equals(device.getStorageSystemName()) && (infoEntry = PDEVInfoEntry.find(device.getRMIObject(), (int)deviceIDVals[0], (int)deviceIDVals[1])) != null) {
                    if (returnPhysicalDisk) {
                        if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, infoEntry));
                        } else {
                            iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, infoEntry));
                        }
                    } else if (isObjectPath) {
                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, infoEntry));
                    } else {
                        iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, infoEntry));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackIMPL<PDEVInfoEntry> callback = new CallbackIMPL<PDEVInfoEntry>(deviceIter, isObjectPath, refInfo, op, propertyList);
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opDiskDrive;
            String pnPhysicalDisk = this.getReference1PropertyName();
            CIMObjectPath opPhysicalDisk = op.getKey(pnPhysicalDisk) != null ? (CIMObjectPath)op.getKey(pnPhysicalDisk).getValue() : null;
            String pnDiskDrive = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opDiskDrive = op.getKey(pnDiskDrive) != null ? (CIMObjectPath)op.getKey(pnDiskDrive).getValue() : null;
            if (null != opPhysicalDisk && null != opDiskDrive && this.getReference1Instrumentation().instanceExists(opPhysicalDisk) && this.getReference2Instrumentation().instanceExists(opDiskDrive)) {
                PDEVInfoEntry entry;
                String tag;
                CIMProperty cpDiskDriveDeviceID = opDiskDrive.getKey("DeviceID");
                String cvDiskDriveDeviceID = null != cpDiskDriveDeviceID ? (String)cpDiskDriveDeviceID.getValue() : null;
                int[] cvDiskDriveDeviceIDValues = PDEVInfoEntry.parseDeviceID(cvDiskDriveDeviceID);
                CIMProperty cpDiskDriveSystemName = opDiskDrive.getKey("SystemName");
                String cvDiskDriveSystemName = null != cpDiskDriveSystemName ? (String)cpDiskDriveSystemName.getValue() : null;
                int[] cvPhysicalDiskDeviceIDVals = null;
                String cvPhysicalDiskSystemName = null;
                CIMProperty cpPhysicalDiskTag = opPhysicalDisk.getKey("Tag");
                String string = tag = null != cpPhysicalDiskTag ? (String)cpPhysicalDiskTag.getValue() : null;
                if (null != tag) {
                    String[] sysName = new String[1];
                    cvPhysicalDiskDeviceIDVals = PDEVInfoEntry.parseTag(tag, sysName);
                    cvPhysicalDiskSystemName = sysName[0];
                }
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opDiskDrive, "SystemName");
                if (null != cvPhysicalDiskSystemName && null != cvDiskDriveSystemName && null != cvDiskDriveDeviceIDValues && null != cvPhysicalDiskDeviceIDVals && cvPhysicalDiskSystemName.equals(cvDiskDriveSystemName) && cvPhysicalDiskDeviceIDVals[0] == cvDiskDriveDeviceIDValues[0] && cvPhysicalDiskDeviceIDVals[1] == cvDiskDriveDeviceIDValues[1] && cvPhysicalDiskSystemName.equals(device.getStorageSystemName()) && (entry = PDEVInfoEntry.find(device.getRMIObject(), cvPhysicalDiskDeviceIDVals[0], cvPhysicalDiskDeviceIDVals[1])) != null) {
                    opPhysicalDisk = this.getReference1Instrumentation().generateObjectPath(op, entry);
                    opDiskDrive = this.getReference2Instrumentation().generateObjectPath(op, entry);
                    CIMInstance instAssoc = this.generateInstance(op, propertyList, opPhysicalDisk, opDiskDrive);
                    return instAssoc.filterProperties(propertyList);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_PhysicalDiskRealizesDiskDrive".equalsIgnoreCase(assocName.getObjectName())) {
                PDEVInfoEntry infoEntry;
                int[] deviceIDVals = null;
                String sysName = null;
                RMIObjectMapping device = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        String cvTag;
                        device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                        CIMProperty cpTag = objectName.getKey("Tag");
                        String string = cvTag = cpTag != null ? (String)cpTag.getValue() : null;
                        if (null != cvTag) {
                            String[] retSysName = new String[1];
                            deviceIDVals = PDEVInfoEntry.parseTag(cvTag, retSysName);
                            sysName = retSysName[0];
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                    CIMProperty cpSystemName = objectName.getKey("SystemName");
                    String deviceID = cpDeviceID != null ? (String)cpDeviceID.getValue() : null;
                    deviceIDVals = PDEVInfoEntry.parseDeviceID(deviceID);
                    String string = sysName = cpSystemName != null ? (String)cpSystemName.getValue() : null;
                }
                if (null != device && null != deviceIDVals && null != sysName && sysName.equals(device.getStorageSystemName()) && (infoEntry = PDEVInfoEntry.find(device.getRMIObject(), (int)deviceIDVals[0], (int)deviceIDVals[1])) != null) {
                    CIMObjectPath opPhysicalDisk = this.getReference1Instrumentation().generateObjectPath(objectName, infoEntry);
                    CIMObjectPath opDiskDrive = this.getReference2Instrumentation().generateObjectPath(objectName, infoEntry);
                    CIMInstance instAssoc = this.generateInstance(objectName, propertyList, opPhysicalDisk, opDiskDrive);
                    if (isObjectPath) {
                        iter.add(instAssoc.getObjectPath());
                    } else {
                        iter.add(instAssoc.filterProperties(propertyList));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    public class CallbackIMPL<E extends PDEVInfoEntry>
    extends IteratorCallbackIMPL<E> {
        public CallbackIMPL(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block5: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E entry = item;
                        CIMObjectPath opPhysicalDisk = PhysicalDiskRealizesDiskDriveInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, entry);
                        CIMObjectPath opDiskDrive = PhysicalDiskRealizesDiskDriveInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.mOP, entry);
                        CIMInstance instAssoc = PhysicalDiskRealizesDiskDriveInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, opPhysicalDisk, opDiskDrive);
                        if (this.mIsObjectPath) {
                            this.mIter.add(instAssoc.getObjectPath());
                            break block5;
                        }
                        this.mIter.add(instAssoc.filterProperties(this.mPropertyList));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                        ret = false;
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

