/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ResourceRestriction;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.SnapshotSynchronizedInstrumentation;
import com.hitachi.smi.jobs.CreateElementReplica;
import com.hitachi.smi.jobs.ModifyReplicaSynchronization;
import com.ws.wbem.provider.jobservice.CIM_ConcreteJob;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;

public class ReplicationServiceInstrumentation
extends BaseInstrumentation {
    protected static int validateSourceElement(DeviceNumber dnSourceElement, boolean check4Paths, String methodName) throws WBEMException {
        String methName;
        int retVal = 0;
        String string = methName = null == methodName ? "CreateElementReplica" : methodName;
        if (check4Paths && !dnSourceElement.hasPaths()) {
            retVal = 5;
            mLogger.severe(methName + " returned error \"Invalid_Parameter\" (" + 5 + ") because the " + "StorageVolume referenced by the method argument \"" + "SourceElement" + "\" " + "did not have any LU Paths: " + dnSourceElement.getDNAsString());
        } else if (dnSourceElement.isVolumeIsPool()) {
            retVal = 5;
            mLogger.severe(methName + " returned error \"Invalid_Parameter\" (" + 5 + ") because the " + "StorageVolume referenced by the method argument \"" + "SourceElement" + "\" " + "is a pool volume: " + dnSourceElement.getDNAsString());
        } else if (dnSourceElement.isMFVolume()) {
            retVal = 5;
            mLogger.severe(methName + " returned error \"Invalid_Parameter\" (" + 5 + ") because the " + "StorageVolume referenced by the method argument \"" + "SourceElement" + "\" " + "is a MainFrame volume: " + dnSourceElement.getDNAsString());
        } else if (dnSourceElement.getUsageValue().intValue() != 32768 && dnSourceElement.getUsageValue().intValue() != 2) {
            retVal = 5;
            mLogger.severe(methName + " returned error \"Invalid_Parameter\" (" + 5 + ") because the " + "StorageVolume referenced by the method argument \"" + "SourceElement" + "\" " + "must have a Usage value of 2 (Unrestricted) or 32768" + " (Thin Provisioning volume) but it has a value of: " + dnSourceElement.getUsageValue());
        }
        return retVal;
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    private Object extrinsic_CreateElementReplica(CIMObjectPath pOp, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pOp, "SystemName");
        int retVal = 0;
        try {
            CreateElementReplicaParams params;
            try {
                params = new CreateElementReplicaParams(device, pInArgs);
            }
            catch (WBEMException we) {
                params = null;
                if (we.getID() == 4) {
                    retVal = 5;
                    String msg = we.getMessage();
                    if (null != msg) {
                        mLogger.severe(msg);
                    }
                }
                throw we;
            }
            if (retVal == 0 && null != params) {
                CreateElementReplica createElementReplica = new CreateElementReplica(mHandle.getProperty("javax.wbem.provider.Principal"), pOp.getHost(), pOp, params, mHandle);
                CIM_ConcreteJob conJob = createElementReplica.submitJob();
                if (conJob != null) {
                    mLogger.log(Level.INFO, "Job created: {0}, Params: {1}", new Object[]{conJob.getInstanceID(), createElementReplica});
                    CIMObjectPath tJob = conJob.getCIMObjectPath(pOp);
                    pOutArgs[0] = new CIMArgument("Job", new CIMDataType("CIM_ConcreteJob"), (Object)tJob);
                    retVal = 4096;
                } else {
                    retVal = 4;
                }
            }
        }
        catch (Throwable th) {
            retVal = 4;
            mLogger.log(Level.SEVERE, "CreateElementReplica- Returning \"Failed\" (4) because an exception was caught", th);
        }
        return new UnsignedInteger32((long)retVal);
    }

    private Object extrinsic_ModifyReplicaSynchronization(CIMObjectPath pOp, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pOp, "SystemName");
        UnsignedInteger16 mOperation = new UnsignedInteger16(19);
        CIMObjectPath opSynchronization = null;
        int retVal = 0;
        try {
            for (CIMArgument<?> arg : pInArgs) {
                String argName;
                if (null == arg || "WaitForCopyState".equalsIgnoreCase(argName = arg.getName()) || "SyncPair".equalsIgnoreCase(argName) || "Force".equalsIgnoreCase(argName) || "Job".equalsIgnoreCase(argName) || "ReplicationSettingData".equalsIgnoreCase(argName)) continue;
                if ("SettingsState".equalsIgnoreCase(argName)) {
                    if (null == arg.getValue()) continue;
                    retVal = 5;
                    mLogger.warning("ModifyReplicaSynchronization returned error \"Invalid_Parameter\" (5) because the method argument \"" + argName + "\"" + "had a non-null value but only " + "null is supported");
                    break;
                }
                if ("Operation".equalsIgnoreCase(argName)) {
                    UnsignedInteger16 operation = (UnsignedInteger16)arg.getValue();
                    if (null != operation && operation.intValue() == mOperation.intValue()) continue;
                    retVal = 5;
                    mLogger.warning("ModifyReplicaSynchronization returned error \"Invalid_Parameter\" (5) because the method argument \"Operation\" had a value of " + operation + " but only a value of " + mOperation + " is supported");
                    break;
                }
                if ("Synchronization".equalsIgnoreCase(argName)) {
                    opSynchronization = (CIMObjectPath)arg.getValue();
                    if (null == opSynchronization) {
                        retVal = 5;
                        mLogger.warning("ModifyReplicaSynchronization returned error \"Invalid_Parameter\" (5) because the method argument \"Synchronization was null but a non-null value is required");
                        break;
                    }
                    if (opSynchronization.getObjectName().toLowerCase().equals("HITACHI_SnapshotSynchronized".toLowerCase())) continue;
                    retVal = 5;
                    mLogger.severe("ModifyReplicaSynchronization returned error \"Invalid_Parameter\" (5) because the method argument \"Synchronization was not an object path for the class: HITACHI_SnapshotSynchronized");
                    break;
                }
                retVal = 5;
                mLogger.warning("ModifyReplicaSynchronization returned error \"Invalid_Parameter\" (5) because the method argument \"" + argName + "\" is not a valid argument name");
                break;
            }
            CIMInstance instSnapshotSynchronized = null;
            if (retVal == 0) {
                if (null == opSynchronization) {
                    retVal = 5;
                    mLogger.warning("ModifyReplicaSynchronization returned error \"Invalid_Parameter\" (5) because the method argument \"Synchronization was null but a non-null value is required");
                } else {
                    SnapshotSynchronizedInstrumentation snapshotSyncInst = (SnapshotSynchronizedInstrumentation)BaseAssocInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SnapshotSynchronizedInstrumentation");
                    try {
                        instSnapshotSynchronized = snapshotSyncInst.getInstance(opSynchronization, null);
                    }
                    catch (WBEMException e) {
                        // empty catch block
                    }
                    if (null == instSnapshotSynchronized) {
                        retVal = 5;
                        mLogger.warning("ModifyReplicaSynchronization returned error \"Invalid_Parameter\" (5) because the method argument \"Synchronization was null but a non-null value is required");
                    }
                }
            }
            if (retVal == 0) {
                CIMObjectPath opSyncedElement;
                DeviceNumber[] snapshotSynchronizedDNs = null;
                CIMObjectPath opSystemElement = null != opSynchronization.getKey("SystemElement") ? (CIMObjectPath)opSynchronization.getKey("SystemElement").getValue() : null;
                CIMObjectPath cIMObjectPath = opSyncedElement = null != opSynchronization.getKey("SyncedElement") ? (CIMObjectPath)opSynchronization.getKey("SyncedElement").getValue() : null;
                if (null != opSyncedElement && null != opSystemElement) {
                    String syncedElementDeviceID;
                    String systemElementDeviceID = null != opSystemElement.getKey("DeviceID") ? (String)opSystemElement.getKey("DeviceID").getValue() : null;
                    String string = syncedElementDeviceID = null != opSyncedElement.getKey("DeviceID") ? (String)opSyncedElement.getKey("DeviceID").getValue() : null;
                    if (null != systemElementDeviceID && null != syncedElementDeviceID) {
                        DeviceNumber systemElementDeviceNumber = DeviceNumber.find(systemElementDeviceID, device.getRMIObject());
                        if (null != systemElementDeviceNumber) {
                            if (!ResourceRestriction.isVolumeUsageUsable(systemElementDeviceNumber)) {
                                retVal = 4;
                                mLogger.severe("ModifyReplicaSynchronization returned error \"FAILED\" (4) because the SystemElement " + systemElementDeviceID + " belongs to a restricted pool");
                            } else {
                                DeviceNumber syncedElementDeviceNumber = DeviceNumber.find(syncedElementDeviceID, device.getRMIObject());
                                if (null != syncedElementDeviceNumber) {
                                    if (!ResourceRestriction.isVolumeUsageUsable(syncedElementDeviceNumber)) {
                                        retVal = 4;
                                        mLogger.severe("ModifyReplicaSynchronization returned error \"FAILED\" (4) because the SyncedElement " + syncedElementDeviceID + " belongs to a restricted pool");
                                    } else {
                                        snapshotSynchronizedDNs = new DeviceNumber[]{systemElementDeviceNumber, syncedElementDeviceNumber};
                                    }
                                } else {
                                    retVal = 4;
                                    mLogger.warning("ModifyReplicaSynchronization returned error \"FAILED\" (4) because the service could not find the DeviceNumber object for the SyncedElement");
                                }
                            }
                        } else {
                            retVal = 4;
                            mLogger.warning("ModifyReplicaSynchronization returned error \"FAILED\" (4) because the service could not find the DeviceNumber object for the SystemElement");
                        }
                    } else {
                        retVal = 4;
                    }
                } else {
                    retVal = 4;
                }
                if (null != snapshotSynchronizedDNs) {
                    ModifyReplicaSynchronization modifyReplicaSynchronization = new ModifyReplicaSynchronization(mHandle.getProperty("javax.wbem.provider.Principal"), pOp.getHost(), pOp, snapshotSynchronizedDNs, instSnapshotSynchronized);
                    CIM_ConcreteJob conJob = modifyReplicaSynchronization.submitJob();
                    if (conJob != null) {
                        mLogger.log(Level.INFO, "Job created: {0}, params : {1}", new Object[]{conJob.getInstanceID(), modifyReplicaSynchronization.toString()});
                        CIMObjectPath tJob = conJob.getCIMObjectPath(pOp);
                        pOutArgs[0] = new CIMArgument("Job", new CIMDataType("CIM_ConcreteJob"), (Object)tJob);
                        retVal = 4096;
                    } else {
                        retVal = 4;
                    }
                }
            }
        }
        catch (Throwable th) {
            retVal = 4;
            mLogger.log(Level.SEVERE, "ModifyReplicaSynchronization- Returning \"Failed\" (4) because an exception was caught", th);
        }
        return new UnsignedInteger32((long)retVal);
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        String repSrvcName = "HITACHI_ReplicationService".substring("HITACHI_".length());
        CIMProperty[] retProps = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("StartMode", CIMDataType.STRING_T, (Object)"Automatic", false), new CIMProperty("Started", CIMDataType.BOOLEAN_T, (Object)true, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)repSrvcName, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)repSrvcName, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)repSrvcName, false)};
        return new CIMInstance(retOP, retProps).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_ReplicationService");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_ReplicationService", true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)"HITACHI_ReplicationService".substring("HITACHI_".length()), true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)rmiObj.getSMISMappingContainer().getStorageSystemName(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_ReplicationService", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            String sysNameVal;
            String ccName;
            CIMProperty cpCCN = op.getKey("CreationClassName");
            String string = ccName = null != cpCCN ? (String)cpCCN.getValue() : null;
            if (null == ccName || !ccName.equals("HITACHI_ReplicationService")) {
                throw new WBEMException(6, op.toString());
            }
            String sysName = device.getStorageSystemName();
            String string2 = sysNameVal = null != op.getKey("SystemName") ? (String)op.getKey("SystemName").getValue() : null;
            if (null == sysNameVal || !sysNameVal.equals(sysName)) {
                throw new WBEMException(6, op.toString());
            }
            return this.generateInstance(op, propertyList, device.getRMIObject());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        try {
            Object ret = null;
            if (pMethodName.equalsIgnoreCase("CreateElementReplica")) {
                ret = this.extrinsic_CreateElementReplica(pOp, pInArgs, pOutArgs);
            } else if (pMethodName.equalsIgnoreCase("ModifyReplicaSynchronization")) {
                ret = this.extrinsic_ModifyReplicaSynchronization(pOp, pInArgs, pOutArgs);
            }
            if (null != ret) {
                return ret;
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(17, pOp.getObjectName() + " does not support the method: " + pMethodName);
    }

    public class CreateElementReplicaParams {
        String elementName;
        int syncType;
        int mode;
        int waitForCopyState;
        CIMObjectPath sourceElement;
        CIMObjectPath sourceAccessPoint;
        CIMObjectPath targetElement;
        CIMInstance replicationSettingData;
        CIMObjectPath targetSettingGoal;
        CIMObjectPath targetPool;
        private DeviceNumber dnSourceElement;
        private final RMIObjectMapping device;
        private ThinPool targetThinPoolPool;

        public CreateElementReplicaParams(RMIObjectMapping device, CIMArgument<?>[] args) throws WBEMException {
            if (null == args) {
                throw new WBEMException("CreateElementReplica parameters are null");
            }
            this.device = device;
            this.elementName = null;
            this.waitForCopyState = -1;
            this.mode = -1;
            this.syncType = -1;
            this.replicationSettingData = null;
            this.targetPool = null;
            this.targetSettingGoal = null;
            this.targetElement = null;
            this.sourceAccessPoint = null;
            this.sourceElement = null;
            this.processParameters(args);
            this.validateParams();
        }

        public DeviceNumber getDnSourceElement() {
            return this.dnSourceElement;
        }

        public String getElementName() {
            return this.elementName;
        }

        public int getMode() {
            return this.mode;
        }

        public CIMInstance getReplicationSettingData() {
            return this.replicationSettingData;
        }

        public CIMObjectPath getSourceAccessPoint() {
            return this.sourceAccessPoint;
        }

        public CIMObjectPath getSourceElement() {
            return this.sourceElement;
        }

        public int getSyncType() {
            return this.syncType;
        }

        public CIMObjectPath getTargetElement() {
            return this.targetElement;
        }

        public CIMObjectPath getTargetPool() {
            return this.targetPool;
        }

        public CIMObjectPath getTargetSettingGoal() {
            return this.targetSettingGoal;
        }

        public ThinPool getTargetThinPool() {
            return this.targetThinPoolPool;
        }

        public int getWaitForCopyState() {
            return this.waitForCopyState;
        }

        public boolean isSnapAndClone() {
            UnsignedInteger16 dcmUint;
            boolean ret = false;
            if (null != this.replicationSettingData && null != this.replicationSettingData && ProviderConstants.UINT16_TEN.compareTo(dcmUint = (UnsignedInteger16)this.replicationSettingData.getPropertyValue("DesiredCopyMethodology")) == 0) {
                ret = true;
            }
            return ret;
        }

        private void processParameters(CIMArgument<?>[] args) throws WBEMException {
            for (CIMArgument<?> arg : args) {
                if (null == arg) continue;
                String argName = arg.getName();
                if ("ElementName".equalsIgnoreCase(argName)) {
                    this.elementName = (String)arg.getValue();
                    if (ProviderLibs.isElementNameValid(this.elementName, 32)) continue;
                    throw new WBEMException(4, String.format("%s %s: \"%s\" is not valid elementName.", this.elementName, "CreateElementReplica", "ElementName"));
                }
                if ("SourceAccessPoint".equalsIgnoreCase(argName)) {
                    this.sourceAccessPoint = (CIMObjectPath)arg.getValue();
                    continue;
                }
                if ("ReplicationSettingData".equalsIgnoreCase(argName)) continue;
                if ("SourceAccessPoint".equalsIgnoreCase(argName)) {
                    this.sourceAccessPoint = (CIMObjectPath)arg.getValue();
                    continue;
                }
                if ("TargetElement".equalsIgnoreCase(argName)) {
                    if (null == arg.getValue()) continue;
                    throw new WBEMException(4, "CreateElementReplica returned error \"Invalid_Parameter\" (5) because the method argument \"" + argName + "\"" + "had a non-null value but only " + "null is supported");
                }
                if ("TargetPool".equalsIgnoreCase(argName)) {
                    this.targetPool = (CIMObjectPath)arg.getValue();
                    continue;
                }
                if ("SyncType".equalsIgnoreCase(argName)) {
                    UnsignedInteger16 syncTypeVal = (UnsignedInteger16)arg.getValue();
                    if (null == syncTypeVal || syncTypeVal.compareTo(ProviderConstants.UINT16_SEVEN) != 0 && syncTypeVal.compareTo(ProviderConstants.UINT16_EIGHT) != 0) {
                        throw new WBEMException(4, "CreateElementReplica returned error \"Invalid_Parameter\" (5) because the method argument \"SyncType\" had a value of " + this.syncType + " but only a value of 7 or 8 is supported");
                    }
                    this.syncType = syncTypeVal.intValue();
                    continue;
                }
                if ("Mode".equalsIgnoreCase(argName)) {
                    UnsignedInteger16 mode = (UnsignedInteger16)arg.getValue();
                    if (null == mode || mode.compareTo(ProviderConstants.UINT16_TWO) == 0) continue;
                    throw new WBEMException(4, "CreateElementReplica returned error \"Invalid_Parameter\" (5) because the method argument \"Mode\"had a value of " + mode + " but " + "only a value of " + ProviderConstants.UINT16_TWO + " or null is supported");
                }
                if ("WaitForCopyState".equalsIgnoreCase(argName)) {
                    UnsignedInteger16 waitForCopyState = (UnsignedInteger16)arg.getValue();
                    if (null != waitForCopyState && waitForCopyState.compareTo(ProviderConstants.UINT16_FOUR) == 0) continue;
                    throw new WBEMException(4, "CreateElementReplica returned error \"Invalid_Parameter\" (5) because the method argument \"WaitForCopyState\"had a value of " + waitForCopyState + " but only a value of 4 is supported");
                }
                if ("SourceElement".equalsIgnoreCase(argName)) {
                    this.sourceElement = (CIMObjectPath)arg.getValue();
                    if (null == this.sourceElement) {
                        throw new WBEMException(4, "CreateElementReplica returned error \"Invalid_Parameter\" (5) because the method argument \"SourceElement was null but a non-null value is required");
                    }
                    if (this.sourceElement.getObjectName().toLowerCase().equals("HITACHI_StorageVolume".toLowerCase())) continue;
                    throw new WBEMException(4, "CreateElementReplica returned error \"Invalid_Parameter\" (5) because the method argument \"SourceElement was not an object path for the class: HITACHI_StorageVolume");
                }
                if ("TargetSettingGoal".equalsIgnoreCase(argName)) {
                    String opName;
                    this.targetSettingGoal = (CIMObjectPath)arg.getValue();
                    if (null == this.targetSettingGoal || "HITACHI_SnapshotPoolSetting".equalsIgnoreCase(opName = this.targetSettingGoal.getObjectName())) continue;
                    throw new WBEMException(4, String.format("%s returned error \"Invalid_Parameter\" (%s) because the method argument \"%s\" is a %s but must a %s", "CreateElementReplica", 5, argName, this.targetSettingGoal.getObjectName(), "HITACHI_SnapshotPoolSetting"));
                }
                BaseInstrumentation.mLogger.log(Level.FINE, "{0} \"Invalid_Parameter\" ({1}), ignoring.", new Object[]{"CreateElementReplica", argName});
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CreateElementReplicaParams [sourceElement=");
            builder.append(this.sourceElement);
            builder.append(", targetPool=");
            builder.append(this.targetPool);
            builder.append(", syncType=");
            builder.append(this.syncType);
            builder.append(", elementName=");
            builder.append(this.elementName);
            builder.append(", mode=");
            builder.append(this.mode);
            builder.append(", waitForCopyState=");
            builder.append(this.waitForCopyState);
            builder.append(", sourceAccessPoint=");
            builder.append(this.sourceAccessPoint);
            builder.append(", targetElement=");
            builder.append(this.targetElement);
            builder.append(", replicationSettingData=");
            builder.append(this.replicationSettingData);
            builder.append(", targetSettingGoal=");
            builder.append(this.targetSettingGoal);
            builder.append(", device=");
            builder.append(this.device);
            builder.append("]");
            return builder.toString();
        }

        private void validateParams() throws WBEMException {
            String deviceIDKeyVal;
            if (null == this.sourceElement) {
                throw new WBEMException(4, "CreateElementReplica returned error \"Invalid_Parameter\" (5) because the method argument \"SourceElement was null but a non-null value is required");
            }
            String string = deviceIDKeyVal = null != this.sourceElement.getKey("DeviceID") ? (String)this.sourceElement.getKey("DeviceID").getValue() : null;
            if (null != deviceIDKeyVal) {
                this.dnSourceElement = DeviceNumber.find(deviceIDKeyVal, this.device.getRMIObject());
            }
            if (null != this.dnSourceElement) {
                if (0 != ReplicationServiceInstrumentation.validateSourceElement(this.dnSourceElement, null == this.targetPool, "CreateElementReplica")) {
                    throw new WBEMException(4);
                }
            } else {
                throw new WBEMException(4, "CreateElementReplica returned error \"Invalid_Parameter\" (5) because the StorageVolume referenced by the method argument \"SourceElement\" could not be found: " + this.sourceElement);
            }
            if (8 == this.syncType && null == this.getTargetPool()) {
                throw new WBEMException(4, "CreateElementReplica returned error \"Invalid_Parameter\" (5) because the method argument \"TargetPool was null but a non-null value is required when using SyncType 8 (Clone)");
            }
            if (null != this.getTargetPool()) {
                if (!this.getTargetPool().getObjectName().equalsIgnoreCase("HITACHI_ThinProvisioningPool")) {
                    throw new WBEMException(4, "CreateElementReplica returned error \"Invalid_Parameter\" (5) because the method argument \"TargetPool was not a HITACHI_ThinProvisioningPool");
                }
                this.targetThinPoolPool = ProviderLibs.getThinPool(this.targetPool);
                if (null == this.targetThinPoolPool) {
                    throw new WBEMException(4, "CreateElementReplica returned error \"Invalid_Parameter\" (5) because the method argument \"TargetPoolcould not be found!" + System.lineSeparator() + this.targetPool);
                }
            }
        }
    }
}

