/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.SnapshotInfo2;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.paralleltasker.ProcessTask;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.Wait4ProcessTasks;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public final class SnapshotReplicaPoolForStorageInstrumentation
extends BaseAssocInstrumentation {
    protected SnapshotReplicaPoolForStorageInstrumentation() {
        super("HITACHI_SnapshotReplicaPoolForStorage", "HITACHI_StorageVolume", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"), "HITACHI_SnapshotPool", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SnapshotPoolInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_SnapshotReplicaPoolForStorage".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        CIMProperty cpDevID = objectName.getKey("DeviceID");
                        String strDevID = (String)cpDevID.getValue();
                        DeviceNumber dn = DeviceNumber.find(strDevID, device.getRMIObject());
                        if (dn != null && !dn.isQSVvol()) {
                            CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                            SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, dn.getDNAsString(), Boolean.TRUE);
                            LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                            if (!pairDataList.isEmpty()) {
                                SnapshotInfo2 pairData = (SnapshotInfo2)pairDataList.get(0);
                                pairDataList = null;
                                ThinPool tp = ThinPool.find(device.getRMIObject(), (short)pairData.getTiPoolID(), ThinPool.ThinPoolType.QS);
                                if (tp != null) {
                                    if (isObjectPath) {
                                        CIMObjectPath retOP = this.getReference2Instrumentation().generateObjectPath(objectName, tp);
                                        if (retOP != null) {
                                            iter.add(retOP);
                                        }
                                    } else {
                                        CIMInstance ret = this.getReference2Instrumentation().generateInstance(objectName, propertyList, tp);
                                        if (ret != null) {
                                            iter.add(ret);
                                        }
                                    }
                                } else {
                                    mLogger.info("Could not find a snapshot pool with ID: " + pairData.getTiPoolID());
                                }
                            } else {
                                mLogger.info("Could not find SnapshotInfo2 for " + dn.getDNAsString());
                            }
                        } else {
                            mLogger.log(Level.FINE, "DeviceNumber with ID {0} is not a PoolVol", strDevID);
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    CIMProperty cpPoolID = objectName.getKey("InstanceID");
                    String strPoolID = (String)cpPoolID.getValue();
                    short poolID = Short.parseShort(ProviderLibs.getEndString(strPoolID, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                    this.getStorageVolumesFromSnapshotPool(device.getRMIObject(), iter, objectName, propertyList, isObjectPath, null, poolID, true);
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        PassthruIterator deviceIter = new PassthruIterator(iter);
        try {
            for (RMIObjectMapping device : devices) {
                CommonClassAsList<ThinPool> callback = new CommonClassAsList<ThinPool>();
                ThinPool.getThinPools(device.getRMIObject(), callback, (short)-1, ThinPool.ThinPoolType.QS);
                LinkedList<ThinPool> tps = callback.getReturnValue();
                callback = null;
                int numTPs = tps.size();
                if (numTPs > 1) {
                    ThinPool tp;
                    Wait4ProcessTasks task = new Wait4ProcessTasks(numTPs);
                    while (null != (tp = (ThinPool)tps.poll())) {
                        WorkerThread worker = new WorkerThread(deviceIter, tp, task, op, propertyList, isObjectPath);
                        ProcessTask.addTask(worker);
                    }
                    continue;
                }
                if (numTPs != 1) continue;
                this.getStorageVolumesFromSnapshotPool(device.getRMIObject(), iter, op, propertyList, isObjectPath, (ThinPool)tps.poll(), (short)-1, false);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        try {
            String pnStorageVolume = this.getReference1PropertyName();
            CIMObjectPath opStorageVolume = opObjectName.getKey(pnStorageVolume) != null ? (CIMObjectPath)opObjectName.getKey(pnStorageVolume).getValue() : null;
            CIMInstance instStorageVolume = null;
            try {
                instStorageVolume = this.getReference1Instrumentation().getInstance(opStorageVolume, null);
            }
            catch (WBEMException we) {
                // empty catch block
            }
            if (null == instStorageVolume) throw new WBEMException(6, opObjectName.toString());
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageVolume, "SystemName");
            String pnSnapshotPool = this.getReference2PropertyName();
            CIMObjectPath opSnapshotPool = opObjectName.getKey(pnSnapshotPool) != null ? (CIMObjectPath)opObjectName.getKey(pnSnapshotPool).getValue() : null;
            CIMInstance instSnapshotPool = null;
            try {
                instSnapshotPool = this.getReference2Instrumentation().getInstance(opSnapshotPool, null);
            }
            catch (WBEMException we) {
                // empty catch block
            }
            if (null == instSnapshotPool) throw new WBEMException(6, opObjectName.toString());
            opStorageVolume = instStorageVolume.getObjectPath();
            String cpvDeviceID = (String)instStorageVolume.getPropertyValue("DeviceID");
            CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
            SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, cpvDeviceID, Boolean.FALSE);
            LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
            if (pairDataList.size() == 1) {
                String poolID;
                SnapshotInfo2 pd = (SnapshotInfo2)pairDataList.poll();
                String pairDataPoolID = String.valueOf(pd.getTiPoolID());
                String cpvInstanceID = (String)instSnapshotPool.getPropertyValue("InstanceID");
                String string = poolID = null != cpvInstanceID ? ProviderLibs.getEndString(cpvInstanceID) : null;
                if (!pairDataPoolID.equals(poolID)) {
                    // empty if block
                }
            } else {
                mLogger.log(Level.SEVERE, "There is more then 1  PairData for PVol: ", cpvDeviceID);
            }
            CIMInstance instReturn = this.generateInstance(opObjectName, propertyList, instStorageVolume.getObjectPath(), instSnapshotPool.getObjectPath());
            return instReturn.filterProperties(propertyList);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    private void getStorageVolumesFromSnapshotPool(RMIObjectCache objCache, CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, boolean isObjectPath, ThinPool tPool, short tPoolID, boolean isAssocCall) throws Exception {
        ThinPool tp = null == tPool ? ThinPool.find(objCache, tPoolID, ThinPool.ThinPoolType.QS) : tPool;
        if (tp != null) {
            SnapshotInfo2 pairData;
            CIMObjectPath opSnapshotPool = this.getReference2Instrumentation().generateObjectPath(op, tp);
            CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
            SnapshotInfo2.getSnapshotInfo2(objCache, callback, tp.getPoolID(), false);
            LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
            while ((pairData = (SnapshotInfo2)pairDataList.poll()) != null) {
                DeviceNumber pVolDN = pairData.getPVol();
                if (null == pVolDN) continue;
                CIMObjectPath opStorageVolume = this.getReference1Instrumentation().generateObjectPath(op, pVolDN);
                if (isObjectPath) {
                    CIMObjectPath retOP = !isAssocCall ? this.generateObjectPath(op, opStorageVolume, opSnapshotPool) : opStorageVolume;
                    if (retOP == null) continue;
                    iter.add(retOP);
                    continue;
                }
                CIMInstance ret = !isAssocCall ? this.generateInstance(op, propertyList, opStorageVolume, opSnapshotPool) : this.getReference1Instrumentation().generateInstance(op, propertyList, pVolDN);
                if (ret == null) continue;
                iter.add(ret);
            }
        } else {
            mLogger.info("Could not find a Snapshot pool with ID: " + tPoolID);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_SnapshotReplicaPoolForStorage".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        CIMProperty cpDevID = objectName.getKey("DeviceID");
                        String strDevID = (String)cpDevID.getValue();
                        DeviceNumber dn = DeviceNumber.find(strDevID, device.getRMIObject());
                        if (dn != null) {
                            CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                            SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, dn.getDNAsString(), Boolean.TRUE);
                            LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                            if (!pairDataList.isEmpty()) {
                                SnapshotInfo2 pairData = (SnapshotInfo2)pairDataList.get(0);
                                ThinPool tp = ThinPool.find(device.getRMIObject(), (short)pairData.getTiPoolID(), ThinPool.ThinPoolType.QS);
                                if (tp != null) {
                                    CIMObjectPath opStorageVolume = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                                    CIMObjectPath opSnapshotPool = this.getReference2Instrumentation().generateObjectPath(objectName, tp);
                                    if (isObjectPath) {
                                        CIMObjectPath retOP = this.generateObjectPath(objectName, opStorageVolume, opSnapshotPool);
                                        if (retOP != null) {
                                            iter.add(retOP);
                                        }
                                    } else {
                                        CIMInstance ret = this.generateInstance(objectName, propertyList, opStorageVolume, opSnapshotPool);
                                        if (ret != null) {
                                            iter.add(ret);
                                        }
                                    }
                                } else {
                                    mLogger.info("Could not find a snapshot pool with ID: " + pairData.getTiPoolID());
                                }
                            } else {
                                mLogger.info("Could not find a DeviceNumber with ID: " + strDevID);
                            }
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    CIMProperty cpPoolID = objectName.getKey("InstanceID");
                    String strPoolID = (String)cpPoolID.getValue();
                    short poolID = Short.parseShort(ProviderLibs.getEndString(strPoolID, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                    this.getStorageVolumesFromSnapshotPool(device.getRMIObject(), iter, objectName, propertyList, isObjectPath, null, poolID, false);
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
    }

    private class WorkerThread
    implements Task {
        private final ThinPool tp;
        private final Wait4ProcessTasks theTask;
        private final CustomCloseableIterator<?> callBack;
        private final CIMObjectPath op;
        private final String[] propertyList;
        private final boolean isObjectPath;

        public WorkerThread(CustomCloseableIterator<?> callback, ThinPool tp, Wait4ProcessTasks task, CIMObjectPath op, String[] propertyList, boolean isObjectPath) {
            this.tp = tp;
            this.callBack = callback;
            this.theTask = task;
            this.op = op;
            this.propertyList = propertyList;
            this.isObjectPath = isObjectPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                if (!this.theTask.shouldStop()) {
                    RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.tp.getSerialNumber());
                    SnapshotReplicaPoolForStorageInstrumentation.this.getStorageVolumesFromSnapshotPool(device.getRMIObject(), this.callBack, this.op, this.propertyList, this.isObjectPath, this.tp, (short)-1, false);
                }
            }
            catch (Exception e) {
                WBEMException we = e.getClass().isInstance(WBEMException.class) ? (WBEMException)((Object)e) : new WBEMException(1, "Exception while processing items", null, (Throwable)e);
                this.callBack.setException(we);
                this.theTask.setStop(true);
            }
            finally {
                this.theTask.taskProcessed();
                if (this.theTask.shouldStop()) {
                    this.callBack.done();
                }
            }
        }
    }
}

