/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageCapabilitiesIMPL;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.StorageCapabilitiesInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class StorageCapabilitiesOfSnapshotPoolInstrumentation
extends StorageCapabilitiesInstrumentation {
    private static final UnsignedInteger16 UINT16_100 = new UnsignedInteger16(100);

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
        PassthruIterator deviceIter = new PassthruIterator(iter);
        try {
            String expVal;
            short poolID = -1;
            if (expectedValues != null && (expVal = (String)expectedValues.get("InstanceID")) != null) {
                String val = ProviderLibs.getEndString(expVal, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                poolID = Short.parseShort(val);
            }
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ThinPool> callback = new CallbackHandler<ThinPool>(deviceIter, isObjectPath, refInfo, op, propertyList, poolID, device.getStorageSystemName());
                ThinPool.getThinPools(device.getRMIObject(), callback, poolID, false);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    protected Object extrinsic_CreateSetting(CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs, CIMObjectPath op) throws WBEMException {
        return ProviderConstants.UINT32_ONE;
    }

    @Override
    protected Object extrinsic_GetSupportedParityLayouts(CIMObjectPath op, CIMArgument<?>[] outArgs) throws WBEMException {
        outArgs[0] = new CIMArgument("ParityLayout", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0]);
        return ProviderConstants.UINT32_TWO;
    }

    @Override
    protected Object extrinsic_GetSupportedStripeDepths(CIMObjectPath op, CIMArgument<?>[] outArgs) {
        outArgs[0] = new CIMArgument("StripeDepths", CIMDataType.UINT64_ARRAY_T, (Object)new UnsignedInteger64[0]);
        return ProviderConstants.UINT32_ZED;
    }

    @Override
    protected Object extrinsic_GetSupportedStripeLengths(CIMObjectPath op, CIMArgument<?>[] outArgs) throws WBEMException {
        outArgs[0] = new CIMArgument("StripeLengths", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0]);
        return ProviderConstants.UINT32_TWO;
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        StorageCapabilitiesIMPL storageCapabilitiesIMPL = (StorageCapabilitiesIMPL)o[0];
        CIMProperty[] keys = retOP.getKeys();
        String poolID = "StorageCapabilitiesOfSnapshotPool." + Integer.toString(storageCapabilitiesIMPL.getArrayGroup());
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("ElementType", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getElementType(), false), new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)storageCapabilitiesIMPL.isNoSinglePointOfFailure(), false), new CIMProperty("NoSinglePointOfFailureDefault", CIMDataType.BOOLEAN_T, (Object)storageCapabilitiesIMPL.isNoSinglePointOfFailure(), false), new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getDataRedunMax(), false), new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getDataRedunMin(), false), new CIMProperty("DataRedundancyDefault", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getDataRedun(), false), new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getPkgRedunMax(), false), new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getPkgRedunMin(), false), new CIMProperty("PackageRedundancyDefault", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getPkgRedun(), false), new CIMProperty("DeltaReservationMax", CIMDataType.UINT16_T, (Object)UINT16_100, false), new CIMProperty("DeltaReservationMin", CIMDataType.UINT16_T, (Object)UINT16_100, false), new CIMProperty("DeltaReservationDefault", CIMDataType.UINT16_T, (Object)UINT16_100, false), new CIMProperty("ExtentStripeLengthDefault", CIMDataType.UINT16_T, null, false), new CIMProperty("UserDataStripeDepthDefault", CIMDataType.UINT64_T, null, false), new CIMProperty("ParityLayoutDefault", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getParityLayout(), false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)poolID, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)poolID, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)poolID, false), new CIMProperty("SupportedDataOrganizations", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("SupportedExtentTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{StorageCapabilitiesIMPL.class}, o, "HITACHI_StorageCapabilitiesOfSnapshotPool");
        StorageCapabilitiesIMPL storageCapabilitiesIMPL = (StorageCapabilitiesIMPL)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)storageCapabilitiesIMPL.getInstanceID(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageCapabilitiesOfSnapshotPool", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            StorageCapabilitiesIMPL storageCapabilitiesIMPL;
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null == instID) {
                throw new WBEMException(6, op.toString());
            }
            String[] instanceIDParts = ProviderLibs.parseStorageCapabilitiesInstanceID(instID);
            String systemName = instanceIDParts[0];
            String chassisArrayID = instanceIDParts[1];
            if (null == systemName || null == chassisArrayID || !systemName.equals(device.getStorageSystemName())) {
                throw new WBEMException(6, op.toString());
            }
            ThinPool tp = ThinPool.find(device.getRMIObject(), Short.parseShort(chassisArrayID), ThinPool.ThinPoolType.QS);
            if (null != tp && null != (storageCapabilitiesIMPL = new StorageCapabilitiesIMPL(tp, systemName))) {
                return this.generateInstance(op, propertyList, storageCapabilitiesIMPL);
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    private class CallbackHandler<E extends ThinPool>
    extends IteratorCallbackIMPL<E> {
        private int mPoolID;
        private final String mSystemName;

        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, short pPoolID, String systemName) {
            super(iter, isObjectPath, refInfo, op, propertyList);
            this.mPoolID = -1;
            this.mPoolID = pPoolID;
            this.mSystemName = systemName;
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block7: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E tp = item;
                        if (this.mPoolID != -1) {
                            ret = ((ThinPool)tp).getPoolID() != this.mPoolID;
                        }
                        if (-1 != this.mPoolID && (this.mPoolID == -1 || ret)) break block7;
                        StorageCapabilitiesIMPL storageCapabilitiesIMPL = new StorageCapabilitiesIMPL((ThinPool)tp, this.mSystemName);
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, StorageCapabilitiesOfSnapshotPoolInstrumentation.this.generateObjectPath(this.mOP, storageCapabilitiesIMPL));
                            break block7;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(StorageCapabilitiesOfSnapshotPoolInstrumentation.this.generateObjectPath(this.mOP, storageCapabilitiesIMPL));
                            break block7;
                        }
                        this.mIter.add(StorageCapabilitiesOfSnapshotPoolInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, storageCapabilitiesIMPL));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

