/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageConfigurationCapabilitiesOfUnpairedSnapshotVolumePoolInstrumentation
extends BaseInstrumentation {
    private final String mPlaneClzName = "HITACHI_StorageConfigurationCapabilitiesOfUnpairedSnapshotVolumePool".substring("HITACHI_".length());

    private String createInstanceID(RMIObjectMapping device) throws Exception {
        StringBuilder ret = new StringBuilder(device.getStorageSystemName());
        ret.append(ProviderConstants.ID_SEPERATOR_AS_CHAR);
        ret.append(this.mPlaneClzName);
        return ret.toString();
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        try {
            for (RMIObjectMapping device : devices) {
                CIMInstance ci = this.generateInstance(op, propertyList, device.getRMIObject());
                if (null != refInfo) {
                    refInfo.addReference(iter, ci.getObjectPath());
                    continue;
                }
                if (isObjectPath) {
                    iter.add(ci.getObjectPath());
                    continue;
                }
                iter.add(ci);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        try {
            CIMObjectPath retOP = this.generateObjectPath(op, o);
            CIMProperty[] keys = retOP.getKeys();
            CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("ThinProvisionedClientSettableReserve", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("ThinProvisionedDefaultReserve", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false), new CIMProperty("SupportedAsynchronousActions", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0], false), new CIMProperty("SupportedSynchronousActions", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0], false), new CIMProperty("SupportedStorageElementTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0], false), new CIMProperty("SupportedStoragePoolFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0], false), new CIMProperty("SupportedStorageElementFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0], false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)this.mPlaneClzName, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)this.mPlaneClzName, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)this.mPlaneClzName, false)};
            return new CIMInstance(retOP, props).filterProperties(propList);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_StorageConfigurationCapabilitiesOfUnpairedSnapshotVolumePool");
        try {
            RMIObjectCache objCache = (RMIObjectCache)o[0];
            String instID = this.createInstanceID(objCache.getSMISMappingContainer());
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instID, true)};
            return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageConfigurationCapabilitiesOfUnpairedSnapshotVolumePool", keys, op.getXmlSchemaName());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String nameVal;
            String instID = this.createInstanceID(device);
            CIMProperty cpInstID = op.getKey("InstanceID");
            String string = nameVal = null != cpInstID ? (String)cpInstID.getValue() : null;
            if (null == nameVal || !nameVal.equalsIgnoreCase(instID)) {
                throw new WBEMException(6, op != null ? op.toString() : null);
            }
            return this.generateInstance(op, propertyList, device.getRMIObject());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }
}

