/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.GeneratedStorageSettingsIMPL;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.PoolNickname;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ResourceRestriction;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.StoragePoolPrimordialInstrumentation;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.CreateModifyNormalPool;
import com.hitachi.smi.jobs.CreateModifyNormalVolume;
import com.hitachi.smi.jobs.CreateModifyThinPool;
import com.hitachi.smi.jobs.CreateModifyThinVolume;
import com.hitachi.smi.jobs.CreateModifyVolumeBase;
import com.hitachi.smi.jobs.CreateModifyVolumeLabel;
import com.hitachi.smi.jobs.DeleteNormalPool;
import com.hitachi.smi.jobs.DeleteThinPool;
import com.hitachi.smi.jobs.DeleteThinVolume;
import com.hitachi.smi.jobs.DeleteVolume;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.provider.jobservice.CIM_ConcreteJob;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.SANRmiException;

public class StorageConfigurationServiceInstrumentation
extends BaseInstrumentation {
    private static final int MAX_EXTENTS_ALLOWED_FOR_THIN_POOL = 128;
    private static final String ERROR_INVALID_ARG = "The input parameter can not be null: ";
    private static final long MIN_VOLUME_SIZE_ALLOWED_TO_CREATE_THIN_POOL = 0x200000000L;
    private static int[] numDiskExtents = new int[]{4, 5, 7, 8, 14, 16};

    private long checkPoolSize(long poolSize, UnsignedInteger64 size) {
        long ret;
        if (poolSize > 0L) {
            if (null != size) {
                BigInteger size2 = size.bigIntegerValue();
                ret = BigInteger.valueOf(poolSize).compareTo(size2) >= 0 ? poolSize : 0L;
            } else {
                ret = poolSize;
            }
        } else {
            ret = poolSize;
        }
        return ret;
    }

    private String convertInExtents2DeviceNumbers(List<CIMObjectPath> inExtents, long[] sizeAndNumVols, ThinPool pool2Expand, List<DeviceNumber> dns, RMIObjectCache rmiObj) {
        Set<Object> contained;
        String msg = null;
        long totSize = 0L;
        int numExistingVolumes = 0;
        if (pool2Expand != null) {
            contained = pool2Expand.getContainingLDEVs();
            numExistingVolumes = contained.size();
        } else {
            contained = Collections.emptySet();
        }
        for (int idx = 0; idx < inExtents.size() && msg == null; ++idx) {
            CIMObjectPath cop = inExtents.get(idx);
            CIMProperty cpDevID = cop.getKey("DeviceID");
            if (cpDevID != null) {
                String strDevID = (String)cpDevID.getValue();
                if (strDevID != null) {
                    try {
                        DeviceNumber dn = DeviceNumber.find(strDevID, rmiObj);
                        if (dn != null) {
                            if (dn.isOpenVolume()) {
                                if (contained.contains(strDevID)) {
                                    totSize += dn.getNumOfBlocks().longValue() * dn.getBlockSize().longValue();
                                    --numExistingVolumes;
                                    continue;
                                }
                                msg = this.isDNValid4ThinElement(dn);
                                if (msg != null) continue;
                                totSize += dn.getNumOfBlocks().longValue() * dn.getBlockSize().longValue();
                                dns.add(dn);
                                continue;
                            }
                            msg = "DeviceNumber: " + strDevID + ", is not an open volume";
                            continue;
                        }
                        msg = "DeviceNumber.find(" + strDevID + ") failed to find object";
                    }
                    catch (WBEMException we) {
                        msg = "DeviceNumber.find(" + strDevID + ") received exception: " + (Object)((Object)we);
                    }
                    continue;
                }
                msg = "The InstanceID of InExtents[" + idx + "] is null: " + cop;
                continue;
            }
            msg = "InExtents[" + idx + "] does not have a " + "InstanceID" + " key: " + cop;
        }
        if (msg == null && numExistingVolumes != 0) {
            msg = "Not all component Volumes( " + contained.toString() + ") were passed in as an " + "InExtents" + ", " + "all component parts of the pool must be provided along with" + " the StorageVolumes that will be used to expand the pool";
            if (sizeAndNumVols != null && sizeAndNumVols.length > 1) {
                sizeAndNumVols[1] = 1L;
            }
        }
        if (sizeAndNumVols != null && sizeAndNumVols.length > 0) {
            sizeAndNumVols[0] = totSize;
            if (sizeAndNumVols.length > 1) {
                sizeAndNumVols[1] = 0L;
            }
        }
        return msg;
    }

    private Set<PDEVInfoEntry> convertInExtents2PDEVInfo(List<CIMObjectPath> inExtents, RMIObjectCache rmiObj) throws WBEMException {
        HashSet<PDEVInfoEntry> ret = new HashSet<PDEVInfoEntry>();
        for (CIMObjectPath de : inExtents) {
            int[] crdev = PDEVInfoEntry.parseDeviceID((String)de.getKeyValue("DeviceID"));
            if (null != crdev) {
                PDEVInfoEntry dd = PDEVInfoEntry.find(rmiObj, crdev[0], crdev[1]);
                if (null != dd) {
                    if (ret.add(dd)) continue;
                    mLogger.log(Level.FINE, "Duplicate found {0}", de);
                    continue;
                }
                mLogger.log(Level.SEVERE, "Could not find a DiskDrive with DeviceID {0}.{1}", new Object[]{crdev[0], crdev[1]});
                continue;
            }
            mLogger.log(Level.SEVERE, "DeviceID in {0} could not be parsed ", new Object[]{de});
        }
        return ret;
    }

    private UnsignedInteger32 createNormalPool(RMIObjectMapping device, CIMObjectPath pOwningSrvc, CIMObjectPath goal, UnsignedInteger64 size, List<CIMObjectPath> inExtents, CIMObjectPath inPool, CIMArgument<?>[] pOutArgs) throws WBEMException {
        String raidLvl;
        UnsignedInteger32 ret = null;
        if (inPool == null) {
            mLogger.log(Level.SEVERE, "{0} must be specified for concrete pools", "InPools");
            ret = ProviderConstants.UINT32_FIVE;
        }
        if (null == ret) {
            raidLvl = this.getRaidLevelFromGoal(goal);
            if ("UNKNOWN".equals(raidLvl)) {
                ret = ProviderConstants.UINT32_FIVE;
            }
        } else {
            raidLvl = "UNKNOWN";
        }
        if (null == ret) {
            int raidLvlInt;
            Set<PDEVInfoEntry> pdevInfos;
            if (null != inExtents && 0 != inExtents.size()) {
                pdevInfos = this.convertInExtents2PDEVInfo(inExtents, device.getRMIObject());
                if (inExtents.size() != pdevInfos.size()) {
                    mLogger.log(Level.SEVERE, "{0} contained a duplicate entry", new Object[]{"InExtents", inExtents});
                    return ProviderConstants.UINT32_FIVE;
                }
            } else {
                pdevInfos = this.findAvailableInExtents(device.getRMIObject());
            }
            if (-1 == (raidLvlInt = ProviderLibs.getRaidLevelValue(raidLvl, pdevInfos.size()))) {
                return ProviderConstants.UINT32_FIVE;
            }
            long poolSize = PDEVInfoEntry.isParityGroupCompatible(new ArrayList<PDEVInfoEntry>(pdevInfos));
            long checkRet = this.checkPoolSize(poolSize, size);
            if (checkRet > 0L) {
                ret = this.createPooljob(device, pdevInfos, raidLvlInt, pOwningSrvc, pOutArgs);
                if (ProviderConstants.UINT32_4096.equals((Object)ret)) {
                    pOutArgs[1] = new CIMArgument("Size", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(BigInteger.valueOf(poolSize)));
                }
            } else if (checkRet < 0L) {
                Object[] array = pdevInfos.toArray();
                mLogger.log(Level.SEVERE, "DiskExtents are not compatible for Parity Group, {0} is not compatible with {1}", new Object[]{array[0], array[(int)Math.abs(poolSize)]});
                ret = ProviderConstants.UINT32_FIVE;
            } else {
                mLogger.log(Level.SEVERE, "Requested {0} bytes but pool can be {1} bytes", new Object[]{size, poolSize});
                pOutArgs[0] = new CIMArgument("Size", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(BigInteger.valueOf(poolSize)));
                ret = ProviderConstants.UINT32_4097;
            }
        }
        return ret;
    }

    private UnsignedInteger32 createObjectPathArrayFromStringArray(List<CIMObjectPath> inExtents, String[] strArray, String requiredName) {
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        for (int idx = 0; idx < strArray.length && ret == ProviderConstants.UINT32_ZED; ++idx) {
            CIMObjectPath t = new CIMObjectPath(strArray[idx]);
            if (t.getKeys() != null || t.getKeys().length != 0) {
                if (requiredName != null && !requiredName.equalsIgnoreCase(t.getObjectName())) {
                    mLogger.log(Level.SEVERE, "Created objectpath must be an array of {0} but index {1} of the array is a \"{2}\", Created objectPath: \"{3}\"", new Object[]{requiredName, idx, t.getObjectName(), t});
                    ret = ProviderConstants.UINT32_FIVE;
                    continue;
                }
                inExtents.add(t);
                continue;
            }
            mLogger.severe("Created objectpath is invalid, must have keys: " + strArray[idx] + " = " + t);
            ret = ProviderConstants.UINT32_FIVE;
        }
        return ret;
    }

    private UnsignedInteger32 createOrModifyThinPool(CIMObjectPath pOwningSrvc, CIMObjectPath goal, UnsignedInteger64 size, List<CIMObjectPath> inExtents, CIMObjectPath pool, String elementName, CIMArgument<?>[] pOutArgs) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pOwningSrvc, "SystemName");
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        String msg = null;
        ThinPool pool2Expand = null;
        int poolID = -1;
        if (inExtents == null || inExtents.size() < 1) {
            msg = "InExtents must be specified for thin pools";
            return ProviderConstants.UINT32_FIVE;
        }
        if (inExtents.size() > 128) {
            msg = "InExtents - Too many extents specified max is: 128, number of extents passed in:" + inExtents.size();
            ret = ProviderConstants.UINT32_FIVE;
        }
        if (ret.intValue() == 0 && pool != null) {
            mLogger.info("Attempting to expand ThinPool: " + pool);
            pool2Expand = ProviderLibs.getThinPool(pool);
            if (null == pool2Expand) {
                mLogger.severe("Could not find ThinPool: " + pool);
                ret = ProviderConstants.UINT32_FIVE;
            } else if (inExtents.size() <= pool2Expand.getContainingLDEVs().size()) {
                msg = "InExtents must contain existing component StorageVolumes of the StoragePool and additional references to normal StorageVolumes which will be used to expand the pool.";
                ret = ProviderConstants.UINT32_4097;
            }
        }
        if (ret.intValue() == 0) {
            RMIObjectCache rmiObj = device.getRMIObject();
            long[] volSizeandExtents = new long[2];
            ArrayList<DeviceNumber> dns = new ArrayList<DeviceNumber>(inExtents.size());
            msg = this.convertInExtents2DeviceNumbers(inExtents, volSizeandExtents, pool2Expand, dns, rmiObj);
            if (null == msg) {
                if (this.isSizeValid(volSizeandExtents[0], size, pOutArgs) == 0) {
                    CreateModifyThinPool cmTP;
                    CIM_ConcreteJob job;
                    if (null == elementName && null != pool2Expand) {
                        PoolNickname nick = PoolNickname.find(rmiObj, pool2Expand.getPoolID());
                        elementName = nick != null ? nick.getNickname() : new Short(pool2Expand.getPoolID()).toString();
                    }
                    if ((job = (cmTP = new CreateModifyThinPool(device.getSerialNumber(), mHandle.getProperty("javax.wbem.provider.Principal"), pOwningSrvc.getHost(), pOwningSrvc, dns, pool2Expand, elementName)).submitJob()) != null) {
                        mLogger.log(Level.INFO, "Job created: {0}, params: {1}", new Object[]{job.getInstanceID(), cmTP.toString()});
                        CIMObjectPath coPath = job.getCIMObjectPath(pOwningSrvc);
                        pOutArgs[0] = new CIMArgument("Job", new CIMDataType("CIM_ConcreteJob"), (Object)coPath);
                        ret = ProviderConstants.UINT32_4096;
                    } else {
                        ret = ProviderConstants.UINT32_FOUR;
                    }
                } else {
                    ret = ProviderConstants.UINT32_4097;
                }
            } else {
                ret = volSizeandExtents[1] > 0L ? ProviderConstants.UINT32_4096 : ProviderConstants.UINT32_FIVE;
            }
        }
        if (ret.intValue() == 0) {
            long poolSize = 0L;
            if (null == pool2Expand) {
                pool2Expand = ThinPool.find(device.getRMIObject(), (short)-1, ThinPool.ThinPoolType.AOU);
            }
            if (pool2Expand != null) {
                poolSize = pool2Expand.getPoolCapaAsBytes();
            } else {
                mLogger.severe("Could not find pool with ID: -1");
            }
            pOutArgs[0] = new CIMArgument("Size", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(BigInteger.valueOf(poolSize)));
        } else if (ret.intValue() != 4096) {
            String logMsg = msg != null ? msg : "An unknown failure occurred.";
            mLogger.severe(logMsg);
        }
        return ret;
    }

    private UnsignedInteger32 createPooljob(RMIObjectMapping device, Set<PDEVInfoEntry> pdevInfos, int raidLvlInt, CIMObjectPath pOwningSrvc, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 ret;
        int[] fb4PG = ChassisArrayGroup.getAvailableFB4PG(device.getRMIObject());
        if (null != fb4PG) {
            CreateModifyNormalPool cmP = new CreateModifyNormalPool(device.getSerialNumber(), mHandle.getProperty("javax.wbem.provider.Principal"), pOwningSrvc.getHost(), pOwningSrvc, pdevInfos, raidLvlInt, fb4PG[0], fb4PG[1]);
            CIM_ConcreteJob job = cmP.submitJob();
            if (job != null) {
                mLogger.log(Level.INFO, "Job created: {0}, params: {1}", new Object[]{job.getInstanceID(), cmP.toString()});
                CIMObjectPath coPath = job.getCIMObjectPath(pOwningSrvc);
                pOutArgs[0] = new CIMArgument("Job", new CIMDataType("CIM_ConcreteJob"), (Object)coPath);
                ret = ProviderConstants.UINT32_4096;
            } else {
                ret = ProviderConstants.UINT32_FOUR;
            }
        } else {
            ret = ProviderConstants.UINT32_FIVE;
            mLogger.log(Level.SEVERE, "Could not find an available FB4/PG");
        }
        return ret;
    }

    private UnsignedInteger32 createStorageVolumes(CIMObjectPath pOwningSrvc, CIMObjectPath pInPool, UnsignedInteger16 pElementType, UnsignedInteger64 size, String[] elementNames, CIMObjectPath pGoal, CIMArgument<?>[] pOutArgs) throws WBEMException, IllegalArgumentException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pOwningSrvc, "SystemName");
        boolean thin = false;
        String errMsg = null;
        if (!pInPool.getObjectName().equalsIgnoreCase("HITACHI_StoragePool")) {
            if (!pInPool.getObjectName().equalsIgnoreCase("HITACHI_ThinProvisioningPool")) {
                errMsg = String.format("%s must be of type %s or %s but a %s was passed in", "InPool", "HITACHI_StoragePool", "HITACHI_ThinProvisioningPool", pInPool.getObjectName());
            }
            thin = true;
        }
        if (null == errMsg) {
            if (pElementType == null) {
                errMsg = "The input parameter can not be null: ElementType";
            } else if (thin) {
                if (pElementType.intValue() != 2 && pElementType.intValue() != 5) {
                    errMsg = String.format("%s parameter can only be 2 or 5 for pool %s, passed in was %d", "ElementType", pInPool.getObjectName(), pElementType.intValue());
                }
            } else if (pElementType.intValue() != 2 && pElementType.intValue() != 7) {
                errMsg = String.format("%s parameter can only be 2 or 7 for pool %s, passed in was %d", "ElementType", pInPool.getObjectName(), pElementType.intValue());
            }
        }
        if (null != errMsg) {
            throw new IllegalArgumentException(errMsg);
        }
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        ChassisArrayGroup cag = null;
        ThinPool tp = null;
        if (!thin) {
            cag = this.getCAG(device, pInPool);
            if (cag != null) {
                if (!ResourceRestriction.isPoolUsable(cag)) {
                    errMsg = String.format("pInPool(%s) is Restricted", pInPool);
                } else if (cag.isExternalVol()) {
                    errMsg = String.format("pInPool(%s) references an external pool which is not allowed", pInPool);
                } else if (cag.getFb4() > 44) {
                    errMsg = String.format("pInPool(%s) has a Chassis ID (Fb4) of %d which is not valid (must be between 1 & 44)", pInPool, cag.getFb4());
                } else if (!cag.isContainedDNsOpenVolume()) {
                    errMsg = String.format("%s is not an OPEN pool", pInPool);
                }
                if (null != errMsg) {
                    throw new IllegalArgumentException(errMsg);
                }
            }
        } else {
            tp = ProviderLibs.getThinPool(pInPool);
            if (!ResourceRestriction.isPoolUsable(tp, true)) {
                errMsg = String.format("pInPool(%s) is Restricted", tp.getPoolID());
                tp = null;
            }
        }
        if (cag != null || tp != null) {
            if (pGoal != null) {
                if (!thin) {
                    if (!ProviderLibs.checkSettingGoal(pGoal, cag, mHandle)) {
                        ret = ProviderConstants.UINT32_FIVE;
                    }
                } else if (!ProviderLibs.checkSettingGoal(pGoal, tp, mHandle)) {
                    ret = ProviderConstants.UINT32_FIVE;
                }
            }
            if (ret.intValue() == 0) {
                int emulationTypeVal = !thin ? this.isSizeValid(cag, size, elementNames.length, pOutArgs) : this.isSizeValid(tp, size, pOutArgs);
                if (emulationTypeVal >= 0) {
                    CreateModifyVolumeBase action = thin ? new CreateModifyThinVolume(mHandle.getProperty("javax.wbem.provider.Principal"), pOwningSrvc.getHost(), pOwningSrvc, tp, size.longValue(), emulationTypeVal, elementNames) : new CreateModifyNormalVolume(mHandle.getProperty("javax.wbem.provider.Principal"), pOwningSrvc.getHost(), pOwningSrvc, pInPool, cag, size.longValue(), emulationTypeVal, elementNames);
                    CIM_ConcreteJob job = action.submitJob();
                    if (job != null) {
                        mLogger.log(Level.INFO, "Job created: {0}, params: {1}", new Object[]{job.getInstanceID(), action.toString()});
                        CIMObjectPath coPath = job.getCIMObjectPath(pInPool);
                        pOutArgs[0] = new CIMArgument("Job", new CIMDataType("CIM_ConcreteJob"), (Object)coPath);
                        ret = ProviderConstants.UINT32_4096;
                    } else {
                        ret = ProviderConstants.UINT32_FOUR;
                    }
                } else {
                    switch (emulationTypeVal) {
                        case -4: {
                            ret = ProviderConstants.UINT32_FOUR;
                            break;
                        }
                        case -5: {
                            ret = ProviderConstants.UINT32_FIVE;
                            break;
                        }
                        case -4097: {
                            ret = ProviderConstants.UINT32_4097;
                            break;
                        }
                        default: {
                            ret = ProviderConstants.UINT32_TWO;
                            mLogger.log(Level.SEVERE, "isSizeValid returned an unknown value: {0}", emulationTypeVal);
                        }
                    }
                }
            }
        } else if (ret.intValue() == 0) {
            String msg = "Unable to find pool: " + pInPool;
            mLogger.severe(msg);
            ret = ProviderConstants.UINT32_FIVE;
        }
        return ret;
    }

    private Object createVolumeLabel(CIMObjectPath pService, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 ret;
        block19: {
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pService, "SystemName");
            ret = ProviderConstants.UINT32_TWO;
            String label = null;
            CIMObjectPath volume = null;
            for (CIMArgument<?> arg : pInArgs) {
                if ("TargetVolume".equalsIgnoreCase(arg.getName())) {
                    volume = (CIMObjectPath)arg.getValue();
                    continue;
                }
                if (!"Label".equalsIgnoreCase(arg.getName())) continue;
                label = (String)arg.getValue();
            }
            if (null == label) {
                mLogger.log(Level.WARNING, "{0} label can not be null", "CreateOrModifyVolumeLabel");
                ret = ProviderConstants.UINT32_FIVE;
            } else if (!ProviderLibs.isElementNameValid(label, 32)) {
                mLogger.log(Level.WARNING, "{0} label is invalid, label: {1}", new Object[]{"CreateOrModifyVolumeLabel", label});
                ret = ProviderConstants.UINT32_FIVE;
                label = null;
            }
            if (label != null && volume != null) {
                if (ProviderLibs.isElementNameValid(label, 32)) {
                    CIMProperty cpDevID = volume.getKey("DeviceID");
                    if (cpDevID != null) {
                        String strDevID = (String)cpDevID.getValue();
                        if (strDevID != null) {
                            try {
                                RMIObjectCache rmiObj = device.getRMIObject();
                                DeviceNumber dn = DeviceNumber.find(strDevID, rmiObj);
                                if (dn != null) {
                                    if (ResourceRestriction.isVolumeUsageUsable(dn)) {
                                        CreateModifyVolumeLabel cvl = new CreateModifyVolumeLabel(mHandle.getProperty("javax.wbem.provider.Principal"), pService.getHost(), pService, dn, label, volume);
                                        CIM_ConcreteJob job = cvl.submitJob();
                                        if (job != null) {
                                            mLogger.log(Level.INFO, "Job created: {0}, params: {1}", new Object[]{job.getInstanceID(), cvl.toString()});
                                            pOutArgs[0] = new CIMArgument("Job", new CIMDataType("CIM_ConcreteJob"), (Object)job.getCIMObjectPath(volume));
                                            ret = ProviderConstants.UINT32_4096;
                                        } else {
                                            mLogger.severe("Failed to create job to to set label (" + label + ") for Volume " + dn.getDNAsString());
                                            ret = ProviderConstants.UINT32_FOUR;
                                        }
                                    } else {
                                        mLogger.log(Level.SEVERE, "Volume {0} is in a restricted pool", dn.getDn());
                                        ret = ProviderConstants.UINT32_FIVE;
                                    }
                                    break block19;
                                }
                                mLogger.info("DeviceNumber.find(" + strDevID + ") failed to find object");
                                ret = ProviderConstants.UINT32_FIVE;
                            }
                            catch (WBEMException we) {
                                mLogger.log(Level.INFO, "DeviceNumber.find(" + strDevID + ") received exception: " + (Object)((Object)we), we);
                                ret = ProviderConstants.UINT32_FOUR;
                            }
                        } else {
                            mLogger.info("CreateOrModifyVolumeLabel invalid param. TargetVolume has invalid DeviceID: " + volume);
                            ret = ProviderConstants.UINT32_FIVE;
                        }
                    } else {
                        mLogger.info("CreateOrModifyVolumeLabel invalid param. Label: " + label + " " + "TargetVolume" + ": " + volume);
                        ret = ProviderConstants.UINT32_FIVE;
                    }
                } else {
                    mLogger.info("Passed in label is not valid, must be alpha-numeric, label: " + label);
                    ret = ProviderConstants.UINT32_FIVE;
                }
            }
        }
        return ret;
    }

    private UnsignedInteger32 deletePool(ChassisArrayGroup cag, CIMObjectPath opPool, CIMArgument<?>[] pOutArgs, String[] err) throws WBEMException {
        UnsignedInteger32 ret;
        String msg = null;
        try {
            if (!(cag.getContainedDNs().size() != 0 || cag.isAouVol() || cag.isExternalVol() || cag.isFICONDMVol())) {
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(cag.getSerialNumber());
                device.getRMIObject();
                DeleteNormalPool dtp = new DeleteNormalPool(mHandle.getProperty("javax.wbem.provider.Principal"), opPool.getHost(), opPool, cag);
                CIM_ConcreteJob job = dtp.submitJob();
                if (job != null) {
                    mLogger.log(Level.INFO, "Job created: {0}, params: {1}", new Object[]{job.getInstanceID(), dtp.toString()});
                    pOutArgs[0] = new CIMArgument("Job", new CIMDataType("CIM_ConcreteJob"), (Object)job.getCIMObjectPath(opPool));
                    ret = ProviderConstants.UINT32_4096;
                } else {
                    mLogger.severe("Failed to create job to to delete ThinPool.");
                    ret = ProviderConstants.UINT32_FOUR;
                }
            } else {
                msg = String.format("%s can not be deleted, it %s.", opPool, 0 != cag.getContainedDNs().size() ? "has existing volumes" : (cag.isAouVol() ? "is a thinPool" : (cag.isExternalVol() ? "is external" : "is FICON")));
                ret = ProviderConstants.UINT32_SIX;
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            msg = " Exception occurred during pool deletion: ";
            msg = t instanceof SANRmiException ? msg.concat(((SANRmiException)t).getErrMsgEn()) : msg.concat(t.toString());
            throw new WBEMException(1, msg, null, t);
        }
        if (err != null && err.length > 0) {
            err[0] = msg;
        }
        return ret;
    }

    private UnsignedInteger32 deletePool(CIMObjectPath pOp, ThinPool tp, CIMObjectPath opPool, CIMArgument<?>[] pOutArgs, String[] err) throws WBEMException {
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        String msg = null;
        try {
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(tp.getSerialNumber());
            RMIObjectCache rmiObj = device.getRMIObject();
            CommonClassAsList<DeviceNumber> callback = new CommonClassAsList<DeviceNumber>();
            DeviceNumber.getDNs(rmiObj, callback, tp.getPoolID(), false, VolumeTypeEnum.AOUVOL);
            LinkedList<DeviceNumber> dns = callback.getReturnValue();
            callback = null;
            if (dns.size() < 1) {
                DeleteThinPool dtp = new DeleteThinPool(mHandle.getProperty("javax.wbem.provider.Principal"), pOp.getHost(), pOp, tp);
                CIM_ConcreteJob job = dtp.submitJob();
                if (job != null) {
                    mLogger.log(Level.INFO, "Job created: {0}, params: {1}", new Object[]{job.getInstanceID(), dtp.toString()});
                    pOutArgs[0] = new CIMArgument("Job", new CIMDataType("CIM_ConcreteJob"), (Object)job.getCIMObjectPath(pOp));
                    ret = ProviderConstants.UINT32_4096;
                } else {
                    mLogger.severe("Failed to create job to to delete ThinPool.");
                    ret = ProviderConstants.UINT32_FOUR;
                }
            } else {
                ret = ProviderConstants.UINT32_SIX;
                StringBuilder msgBlder = new StringBuilder("Can not delete ThinPool(");
                msgBlder.append(tp.getPoolID());
                msgBlder.append(") because it contains volumes");
                msg = msgBlder.toString();
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            msg = " Exception occurred during thin pool deletion: ";
            msg = t instanceof SANRmiException ? msg.concat(((SANRmiException)t).getErrMsgEn()) : msg.concat(t.toString());
            throw new WBEMException(1, msg, null, t);
        }
        if (msg != null && err != null && err.length > 0) {
            err[0] = msg;
        }
        return ret;
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        try {
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    private Object extrinsic_createElementsFromStoragePools(CIMObjectPath pOwningSrvc, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        String[] elementNames = null;
        CIMObjectPath goal = null;
        UnsignedInteger64 size = null;
        CIMObjectPath inPool = null;
        UnsignedInteger16 elementType = null;
        long elementCount = -1L;
        for (CIMArgument<?> cIMArgument : pInArgs) {
            if ("ElementNames".equalsIgnoreCase(cIMArgument.getName())) {
                elementNames = (String[])cIMArgument.getValue();
            } else if ("ElementCount".equalsIgnoreCase(cIMArgument.getName())) {
                UnsignedInteger64 u64 = (UnsignedInteger64)cIMArgument.getValue();
                if (null != u64) {
                    elementCount = u64.longValue();
                    if (elementCount < 1L || elementCount > 63232L) {
                        mLogger.log(Level.WARNING, "{0}is {1} it must be greater then 1 but less then 63232", new Object[]{"ElementCount", elementCount});
                        ret = ProviderConstants.UINT32_FIVE;
                    }
                } else {
                    mLogger.log(Level.WARNING, "{0} must have a value", "ElementCount");
                    ret = ProviderConstants.UINT32_FIVE;
                }
            } else if ("ElementType".equalsIgnoreCase(cIMArgument.getName())) {
                elementType = (UnsignedInteger16)cIMArgument.getValue();
            } else if ("Goal".equalsIgnoreCase(cIMArgument.getName())) {
                goal = (CIMObjectPath)cIMArgument.getValue();
            } else if ("Size".equalsIgnoreCase(cIMArgument.getName())) {
                size = (UnsignedInteger64)cIMArgument.getValue();
            } else if ("InPools".equalsIgnoreCase(cIMArgument.getName())) {
                CIMObjectPath[] tmp = (CIMObjectPath[])cIMArgument.getValue();
                inPool = null != tmp && tmp.length > 0 ? tmp[0] : null;
            }
            if (ProviderConstants.UINT32_ZED != ret) break;
        }
        if (ret == ProviderConstants.UINT32_ZED && null != elementNames) {
            if (elementCount == (long)elementNames.length) {
                for (String string : elementNames) {
                    if (ProviderLibs.isElementNameValid(string, 32)) continue;
                    mLogger.log(Level.WARNING, "Element name is invalid: {0}", string);
                    ret = ProviderConstants.UINT32_FIVE;
                }
            } else {
                mLogger.log(Level.WARNING, "{0} is {1}, however {2} {3} where provided, these must match", new Object[]{"ElementCount", elementCount, elementNames.length, "ElementNames"});
                ret = ProviderConstants.UINT32_FIVE;
            }
        }
        if (ret == ProviderConstants.UINT32_ZED) {
            try {
                ret = this.createStorageVolumes(pOwningSrvc, inPool, elementType, size, elementNames, goal, pOutArgs);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ret = ProviderConstants.UINT32_FIVE;
                mLogger.log(Level.SEVERE, "CreateElementsFromStoragePools: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
        return ret;
    }

    private UnsignedInteger32 extrinsic_CreateOrModifyElementFromStoragePool(CIMObjectPath pOwningSrvc, String pElementName, UnsignedInteger16 pElementType, CIMObjectPath pGoal, UnsignedInteger64 pSize, CIMObjectPath pInPool, CIMObjectPath pTheElement, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        if (ProviderConstants.UINT32_ZED == ret && pSize == null) {
            mLogger.log(Level.WARNING, "The input parameter can not be null: Size");
            return ProviderConstants.UINT32_FIVE;
        }
        if (ProviderConstants.UINT32_ZED == ret && pInPool == null) {
            mLogger.log(Level.WARNING, "The input parameter can not be null: InPool");
            return ProviderConstants.UINT32_FIVE;
        }
        if (ProviderConstants.UINT32_ZED == ret && pTheElement != null) {
            mLogger.log(Level.WARNING, "TheElement must be null.");
            return ProviderConstants.UINT32_FIVE;
        }
        if (ProviderConstants.UINT32_ZED == ret) {
            try {
                ret = this.createStorageVolumes(pOwningSrvc, pInPool, pElementType, pSize, new String[]{pElementName}, pGoal, pOutArgs);
            }
            catch (IllegalArgumentException iae) {
                ret = ProviderConstants.UINT32_FIVE;
                mLogger.log(Level.SEVERE, "CreateOrModifyElementFromStoragePool: " + iae.getMessage(), iae);
            }
        }
        return ret;
    }

    private Object extrinsic_CreateStoragePool(CIMObjectPath pOp, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pOp, "SystemName");
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        CIMObjectPath goal = null;
        UnsignedInteger64 size = null;
        CIMObjectPath inPool = null;
        ArrayList<CIMObjectPath> inExtents = new ArrayList<CIMObjectPath>();
        CIMObjectPath pool = null;
        boolean thinPool = false;
        String elementName = null;
        for (CIMArgument<?> arg : pInArgs) {
            if ("ElementName".equalsIgnoreCase(arg.getName())) {
                elementName = (String)arg.getValue();
                if (null == elementName || ProviderLibs.isElementNameValid(elementName, 32)) continue;
                mLogger.log(Level.WARNING, "Element name is invalid: {0}", elementName);
                return ProviderConstants.UINT32_FIVE;
            }
            if (arg.getName().equalsIgnoreCase("InPools")) {
                if (arg.getDataType() != null && arg.getDataType() != CIMDataType.STRING_ARRAY_T) {
                    mLogger.severe("InPools is not a string array");
                    ret = ProviderConstants.UINT32_FIVE;
                    break;
                }
                String[] tempStr = (String[])arg.getValue();
                if (tempStr == null) continue;
                if (tempStr.length == 1) {
                    ArrayList<CIMObjectPath> inPools = new ArrayList<CIMObjectPath>();
                    ret = this.createObjectPathArrayFromStringArray(inPools, tempStr, "HITACHI_StoragePoolPrimordial");
                    if (ProviderConstants.UINT32_ZED == ret) {
                        inPool = (CIMObjectPath)inPools.get(0);
                        thinPool = false;
                        continue;
                    }
                    ret = ProviderConstants.UINT32_FIVE;
                    break;
                }
                mLogger.severe("InPools more then 1 pool specified, there is only 1 primordial pool");
                ret = ProviderConstants.UINT32_FIVE;
                break;
            }
            if (arg.getName().equalsIgnoreCase("InExtents")) {
                boolean[] temp = new boolean[]{false};
                ret = this.processInExtentsParam(arg, inExtents, temp);
                thinPool = temp[0];
                continue;
            }
            if (arg.getName().equalsIgnoreCase("Size")) {
                size = (UnsignedInteger64)arg.getValue();
                continue;
            }
            if (arg.getName().equalsIgnoreCase("Goal")) {
                goal = (CIMObjectPath)arg.getValue();
                continue;
            }
            if (!arg.getName().equalsIgnoreCase("Pool") || (pool = (CIMObjectPath)arg.getValue()) == null || pool.getObjectName().equalsIgnoreCase("HITACHI_ThinProvisioningPool")) continue;
            mLogger.severe("Pool must be a HITACHI_ThinProvisioningPool but a " + (null == pool ? "null" : pool.getObjectName()) + " was passed in");
            ret = ProviderConstants.UINT32_FIVE;
            break;
        }
        if (ret.compareTo(ProviderConstants.UINT32_ZED) == 0) {
            if (thinPool) {
                ret = this.createOrModifyThinPool(pOp, goal, size, inExtents, pool, elementName, pOutArgs);
            } else if (pool == null) {
                ret = this.createNormalPool(device, pOp, goal, size, inExtents, inPool, pOutArgs);
            } else {
                mLogger.log(Level.SEVERE, "{0} parameter must be null for concrete pool creation", "Pool");
                ret = ProviderConstants.UINT32_FIVE;
            }
        }
        return ret;
    }

    private Object extrinsic_DeleteStoragePool(CIMObjectPath pOp, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 ret = null;
        CIMObjectPath opPool = null;
        boolean thinPool = false;
        String msg = null;
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pOp, "SystemName");
        if (pInArgs.length == 1) {
            if (pInArgs[0].getName().equalsIgnoreCase("Pool")) {
                opPool = (CIMObjectPath)pInArgs[0].getValue();
                if (!opPool.getObjectName().equalsIgnoreCase("HITACHI_StoragePool")) {
                    if (opPool.getObjectName().equalsIgnoreCase("HITACHI_ThinProvisioningPool")) {
                        thinPool = true;
                    } else {
                        msg = "Pool param must be a HITACHI_StoragePool or HITACHI_ThinProvisioningPool however a " + opPool.getObjectName() + " was passed in.";
                        ret = ProviderConstants.UINT32_FIVE;
                    }
                }
            } else {
                msg = "Pool is required";
                ret = ProviderConstants.UINT32_FIVE;
            }
        } else {
            msg = "Pool must have only 1 parameter.";
            ret = ProviderConstants.UINT32_FIVE;
        }
        if (null == ret) {
            if (!thinPool) {
                ChassisArrayGroup cag = this.getCAG(device, opPool);
                if (cag != null) {
                    String[] err = new String[1];
                    ret = this.deletePool(cag, pOp, pOutArgs, err);
                    msg = err[0];
                } else {
                    msg = opPool + " does not exist.";
                    ret = ProviderConstants.UINT32_FIVE;
                }
            } else {
                ThinPool tp = ProviderLibs.getThinPool(opPool);
                if (tp != null) {
                    if (ResourceRestriction.isPoolUsable(tp, true)) {
                        String[] err = new String[1];
                        ret = this.deletePool(pOp, tp, opPool, pOutArgs, err);
                        msg = err[0];
                    } else {
                        msg = opPool + " is restricted.";
                        ret = ProviderConstants.UINT32_FIVE;
                    }
                } else {
                    msg = opPool + " not found";
                    ret = ProviderConstants.UINT32_FIVE;
                }
            }
        }
        if (ret.intValue() != 4096 && ret.intValue() != 0) {
            String logMsg = msg != null ? msg : "A failure occurred.";
            mLogger.severe(logMsg);
        }
        return ret;
    }

    private UnsignedInteger32 extrinsic_ReturnToStoragePool(CIMObjectPath pOwningSrvc, CIMObjectPath pTheElement, CIMArgument<?>[] pOutArgs) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pOwningSrvc, "SystemName");
        try {
            UnsignedInteger32 ret;
            if (pTheElement == null || !pTheElement.getObjectName().equalsIgnoreCase("HITACHI_StorageVolume")) {
                mLogger.log(Level.WARNING, "Expected a StorageVolume got: " + (pTheElement == null ? "null" : pTheElement.getObjectName()));
                ret = ProviderConstants.UINT32_FIVE;
            } else {
                RMIObjectCache rmiobj = device.getRMIObject();
                CIMProperty key = pTheElement.getKey("DeviceID");
                String keyVal = (String)key.getValue();
                DeviceNumber dn = DeviceNumber.find(keyVal, false, rmiobj);
                if (dn != null) {
                    AbstractJobImpl action;
                    boolean usable = ResourceRestriction.isVolumeUsageUsable(dn);
                    if (!usable) {
                        mLogger.log(Level.SEVERE, "Specified Volume {0} is in a restricted pool", dn.getDn());
                        return ProviderConstants.UINT32_FIVE;
                    }
                    if (!dn.isOpenVolume()) {
                        mLogger.log(Level.WARNING, "Specified LDEV( " + dn.getDNAsString() + " is not an OPEN volume");
                        return ProviderConstants.UINT32_FIVE;
                    }
                    if (dn.hasPaths()) {
                        mLogger.log(Level.WARNING, "Specified LDEV( " + dn.getDNAsString() + ") has paths");
                        return ProviderConstants.UINT32_SIX;
                    }
                    if (dn.isAOUVol()) {
                        mLogger.info("Setting up to delete an AOU volume: " + dn.getDNAsString());
                        action = new DeleteThinVolume(mHandle.getProperty("javax.wbem.provider.Principal"), pTheElement.getHost(), pOwningSrvc, dn);
                    } else {
                        mLogger.info("Setting up to delete a normal volume: " + dn.getDNAsString());
                        if (dn.isVolumeIsPool() || dn.isSystemDisk() || dn.isCommandDevice()) {
                            mLogger.severe("DN: " + dn.getDNAsString() + " can not be deleted.\n" + "isVolumeIsPool: " + dn.isVolumeIsPool() + " isSystemDisk: " + dn.isSystemDisk() + " isCommandDevice: " + dn.isCommandDevice());
                            return ProviderConstants.UINT32_FIVE;
                        }
                        action = new DeleteVolume(mHandle.getProperty("javax.wbem.provider.Principal"), pOwningSrvc.getHost(), pOwningSrvc, dn);
                    }
                    CIM_ConcreteJob job = action.submitJob();
                    if (job != null) {
                        mLogger.log(Level.INFO, "Job created: {0}, params: {1}", new Object[]{job.getInstanceID(), action.toString()});
                        pOutArgs[0] = new CIMArgument("Job", new CIMDataType("CIM_ConcreteJob"), (Object)job.getCIMObjectPath(pTheElement));
                        ret = ProviderConstants.UINT32_4096;
                    } else {
                        mLogger.severe("Failed to create job to delete " + dn);
                        ret = ProviderConstants.UINT32_FOUR;
                    }
                } else {
                    mLogger.log(Level.WARNING, "No such StorageVolume: " + pTheElement);
                    ret = ProviderConstants.UINT32_FIVE;
                }
            }
            return ret;
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, t.toString(), null, t);
        }
    }

    private Set<PDEVInfoEntry> findAvailableInExtents(RMIObjectCache rmiObj) throws WBEMException {
        HashSet<PDEVInfoEntry> inExtents = new HashSet<PDEVInfoEntry>();
        ClosableAddableIteratorCB<PDEVInfoEntry> cb = new ClosableAddableIteratorCB<PDEVInfoEntry>();
        CloseableAddableIterator iter = cb.getWrappedCloseableAddableIter();
        PDEVInfoEntry.getPDEVInfoEntry(rmiObj, cb);
        int numDisks = ProviderLibs.getNumDisksInRaid(StoragePoolPrimordialInstrumentation.getDefaultRaidLevel());
        HashMap<String, List<PDEVInfoEntry>> specCapaMap = new HashMap<String, List<PDEVInfoEntry>>();
        StoragePoolPrimordialInstrumentation.populateSpecCapaMap(iter, specCapaMap);
        Set keys = specCapaMap.keySet();
        for (String key : keys) {
            List pdevList = (List)specCapaMap.get(key);
            if (pdevList.size() < numDisks) continue;
            inExtents.addAll(pdevList.subList(0, numDisks));
            break;
        }
        return inExtents;
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        CIMProperty[] retProps = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("StartMode", CIMDataType.STRING_T, (Object)"Automatic", false), new CIMProperty("Started", CIMDataType.BOOLEAN_T, (Object)true, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)"HITACHI_StorageConfigurationService".substring("HITACHI_".length()), false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)"HITACHI_StorageConfigurationService".substring("HITACHI_".length()), false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"HITACHI_StorageConfigurationService".substring("HITACHI_".length()), false)};
        return new CIMInstance(retOP, retProps).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_StorageConfigurationService");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageConfigurationService", true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)"HITACHI_StorageConfigurationService".substring("HITACHI_".length()), true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)rmiObj.getSMISMappingContainer().getStorageSystemName(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageConfigurationService", keys, op.getXmlSchemaName());
    }

    private ChassisArrayGroup getCAG(RMIObjectMapping device, CIMObjectPath pInPool) {
        ChassisArrayGroup ret = null;
        CIMProperty cpInstID = pInPool.getKey("InstanceID");
        if (cpInstID != null) {
            String instID = (String)cpInstID.getValue();
            try {
                ret = ChassisArrayGroup.find(device.getRMIObject(), false, instID);
            }
            catch (WBEMException e) {
                mLogger.log(Level.WARNING, "ChassisArrayGroup find failed: " + pInPool, e);
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            String sysNameVal;
            String ccName;
            CIMProperty cpCCN = op.getKey("CreationClassName");
            String string = ccName = null != cpCCN ? (String)cpCCN.getValue() : null;
            if (null == ccName || !ccName.equals("HITACHI_StorageConfigurationService")) {
                throw new WBEMException(6, op.toString());
            }
            String sysName = device.getStorageSystemName();
            String string2 = sysNameVal = null != op.getKey("SystemName") ? (String)op.getKey("SystemName").getValue() : null;
            if (null == sysNameVal || !sysNameVal.equals(sysName)) {
                throw new WBEMException(6, op.toString());
            }
            return this.generateInstance(op, propertyList, device.getRMIObject());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    private String getRaidLevelFromGoal(CIMObjectPath goal) throws WBEMException {
        String raidLvl;
        if (null != goal) {
            String goalClz = goal.getObjectName();
            if (goalClz.equalsIgnoreCase("HITACHI_GeneratedStorageSettingOfPrimordialPool")) {
                String instID = (String)goal.getKeyValue("InstanceID");
                GeneratedStorageSettingsIMPL actual = GeneratedStorageSettingsIMPL.lookUpSetting(instID);
                raidLvl = actual.getRaidLevel();
            } else if (goalClz.equalsIgnoreCase("HITACHI_StorageSettingWithDiskLayoutOfPrimordialPool")) {
                raidLvl = ProviderLibs.getEndString((String)goal.getKeyValue("InstanceID"));
            } else {
                mLogger.log(Level.SEVERE, "{0} is not a valid setting for concrete pools", goalClz);
                raidLvl = "UNKNOWN";
            }
        } else {
            raidLvl = StoragePoolPrimordialInstrumentation.getDefaultRaidLevel();
        }
        return raidLvl;
    }

    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        if (pInArgs == null || pInArgs.length == 0) {
            mLogger.log(Level.WARNING, "input arguments are null or empty");
            return ProviderConstants.UINT32_FIVE;
        }
        Object oRet = null;
        if ("CreateOrModifyStoragePool".equalsIgnoreCase(pMethodName)) {
            oRet = this.extrinsic_CreateStoragePool(pOp, pInArgs, pOutArgs);
        } else if ("CreateOrModifyElementFromStoragePool".equalsIgnoreCase(pMethodName)) {
            String elementName = null;
            UnsignedInteger16 elementType = null;
            CIMObjectPath goal = null;
            UnsignedInteger64 size = null;
            CIMObjectPath inPool = null;
            CIMObjectPath theElement = null;
            for (CIMArgument<?> arg : pInArgs) {
                if ("ElementName".equalsIgnoreCase(arg.getName())) {
                    elementName = (String)arg.getValue();
                    if (null == elementName || ProviderLibs.isElementNameValid(elementName, 32)) continue;
                    mLogger.log(Level.WARNING, "Element name is invalid: {0}", elementName);
                    return ProviderConstants.UINT32_FIVE;
                }
                if ("ElementType".equalsIgnoreCase(arg.getName())) {
                    elementType = (UnsignedInteger16)arg.getValue();
                    continue;
                }
                if ("Goal".equalsIgnoreCase(arg.getName())) {
                    goal = (CIMObjectPath)arg.getValue();
                    continue;
                }
                if ("Size".equalsIgnoreCase(arg.getName())) {
                    size = (UnsignedInteger64)arg.getValue();
                    continue;
                }
                if ("InPool".equalsIgnoreCase(arg.getName())) {
                    inPool = (CIMObjectPath)arg.getValue();
                    continue;
                }
                if (!"TheElement".equalsIgnoreCase(arg.getName())) continue;
                theElement = (CIMObjectPath)arg.getValue();
            }
            oRet = this.extrinsic_CreateOrModifyElementFromStoragePool(pOp, elementName, elementType, goal, size, inPool, theElement, pOutArgs);
        } else if ("DeleteStoragePool".equalsIgnoreCase(pMethodName)) {
            oRet = this.extrinsic_DeleteStoragePool(pOp, pInArgs, pOutArgs);
        } else if ("ReturnToStoragePool".equalsIgnoreCase(pMethodName)) {
            CIMObjectPath theElement = null;
            for (CIMArgument<?> arg : pInArgs) {
                if (!"TheElement".equalsIgnoreCase(arg.getName())) continue;
                theElement = (CIMObjectPath)arg.getValue();
            }
            oRet = this.extrinsic_ReturnToStoragePool(pOp, theElement, pOutArgs);
        } else if ("CreateOrModifyVolumeLabel".equalsIgnoreCase(pMethodName)) {
            oRet = this.createVolumeLabel(pOp, pInArgs, pOutArgs);
        } else if ("CreateElementsFromStoragePools".equalsIgnoreCase(pMethodName)) {
            oRet = this.extrinsic_createElementsFromStoragePools(pOp, pInArgs, pOutArgs);
        } else {
            throw new WBEMException(17, "StorageConfigurationService doesn't know the method: " + pMethodName);
        }
        return oRet;
    }

    private String isDNValid4ThinElement(DeviceNumber dn) throws WBEMException {
        String msg = null;
        UnsignedInteger16 usage = dn.getUsageValue();
        if (usage == null || usage.intValue() != 2) {
            msg = "LDEV: " + dn.getDNAsString() + " can not be used for a Thin Element, usage is: " + (usage == null ? "null" : usage.toString());
        } else if (dn.hasPaths()) {
            msg = "LDEV: " + dn.getDNAsString() + " can not be used it has paths assigned to it";
        } else if (dn.getNumOfBytes() < 0x200000000L) {
            msg = "LDEV: " + dn.getDNAsString() + " can not be used it is " + dn.getNumOfBytes() + " bytes and the minimum allowed is " + 0x200000000L + " bytes";
        } else {
            mLogger.info("LDEV: " + dn.getDNAsString() + " can be used it is " + dn.getNumOfBytes() + " bytes, usage is " + usage + " and has no paths");
        }
        return msg;
    }

    private int isSizeValid(ChassisArrayGroup cag, UnsignedInteger64 pSize, int numberOfElements, CIMArgument<?>[] pOutArgs) {
        int ret = 0;
        int emulationTypeVal = -1;
        long largestFreeSize = -1L;
        long maxVolSize = 0L;
        List<BaseDeviceNumber> dns = cag.getContainedDNs();
        if (dns != null && dns.size() > 0) {
            BaseDeviceNumber bdn = dns.get(0);
            if (bdn.isOpenVolume()) {
                emulationTypeVal = bdn.getEmulationTypeVal();
                maxVolSize = BaseDeviceNumber.getMaxPoolSize(bdn.getEmulationType());
            } else {
                mLogger.log(Level.SEVERE, "LDEV(" + bdn + ") is not OPEN.");
                ret = -5;
            }
        } else {
            emulationTypeVal = 625;
            maxVolSize = BaseDeviceNumber.getMaxPoolSize("OPEN-V");
        }
        long size = pSize.longValue();
        long totalSize = size * (long)numberOfElements;
        if (size > maxVolSize) {
            mLogger.log(Level.SEVERE, "Size({0}) is too big, must be {1} or smaller.", new Object[]{pSize, maxVolSize});
            pOutArgs[0] = new CIMArgument("Size", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(BigInteger.valueOf(maxVolSize)));
            ret = -4097;
        }
        if (ret == 0) {
            long minSize = -1L;
            try {
                minSize = BaseDeviceNumber.getMinPoolSize(BaseDeviceNumber.getEmulationTypeStr(emulationTypeVal));
            }
            catch (Throwable e) {
                String msg = "Exception retrieving LDEV emulation type: ";
                msg = e instanceof GetRmiException ? msg.concat(((GetRmiException)e).getErrMsgEn()) : msg.concat(e.toString());
                mLogger.log(Level.SEVERE, msg);
                ret = -4;
            }
            if (ret == 0 && size > minSize) {
                largestFreeSize = cag.getLargestFreeSpace().longValue() * cag.getBlockSize().longValue();
                if (totalSize > 0L && totalSize <= largestFreeSize) {
                    ret = emulationTypeVal;
                } else {
                    String msg = "Size (" + totalSize + ") is larger then largest available freespace: " + largestFreeSize;
                    mLogger.log(Level.SEVERE, msg);
                    pOutArgs[0] = new CIMArgument("Size", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(BigInteger.valueOf(minSize)));
                    ret = -4097;
                }
            } else {
                String msg = "Size(" + pSize + ") is too small, must be " + minSize + " or larger.";
                mLogger.log(Level.SEVERE, msg);
                pOutArgs[0] = new CIMArgument("Size", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(BigInteger.valueOf(minSize)));
                ret = -4097;
            }
        }
        return ret;
    }

    private int isSizeValid(long volSize, UnsignedInteger64 size, CIMArgument<?>[] pOutArgs) {
        int ret = 0;
        if (size != null) {
            long requestedSize = size.longValue();
            mLogger.info("Checking size parameter is valid for extents, requested: " + requestedSize + ", extents size: " + volSize);
            if (volSize - requestedSize < 0L) {
                pOutArgs[1] = new CIMArgument("Size", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(BigInteger.valueOf(volSize)));
                ret = -1;
            } else {
                pOutArgs[1] = new CIMArgument("Size", CIMDataType.UINT64_T, (Object)size);
            }
        }
        return ret;
    }

    private int isSizeValid(ThinPool tp, UnsignedInteger64 pSize, CIMArgument<?>[] pOutArgs) {
        int ret = 0;
        if (pSize.compareTo(ProviderConstants.THIN_VOLUME_MIN_ALLOWED_SIZE) >= 0) {
            if (pSize.compareTo(ProviderConstants.THIN_VOLUME_MAX_ALLOWED_SIZE) <= 0) {
                ret = 625;
            } else {
                String msg = "Size (" + pSize + ") is larger then max allowed size: " + ProviderConstants.THIN_VOLUME_MAX_ALLOWED_SIZE;
                mLogger.log(Level.SEVERE, msg);
                pOutArgs[0] = new CIMArgument("Size", CIMDataType.UINT64_T, (Object)ProviderConstants.THIN_VOLUME_MIN_ALLOWED_SIZE);
                ret = -4097;
            }
        } else {
            String msg = "Size(" + pSize + ") is too small, must be " + ProviderConstants.THIN_VOLUME_MIN_ALLOWED_SIZE + " or larger.";
            mLogger.log(Level.SEVERE, msg);
            pOutArgs[0] = new CIMArgument("Size", CIMDataType.UINT64_T, (Object)ProviderConstants.THIN_VOLUME_MIN_ALLOWED_SIZE);
            ret = -4097;
        }
        return ret;
    }

    private UnsignedInteger32 processInExtentsParam(CIMArgument<?> arg, List<CIMObjectPath> inExtents, boolean[] isThinPool) {
        UnsignedInteger32 ret;
        if (arg.getDataType() != null && arg.getDataType() != CIMDataType.STRING_ARRAY_T) {
            mLogger.severe("InExtents is not a string array");
            return ProviderConstants.UINT32_FIVE;
        }
        Object[] tempStr = (String[])arg.getValue();
        if (tempStr != null && tempStr.length > 0) {
            String temp1 = tempStr[0].toUpperCase();
            if (temp1.contains("HITACHI_StorageVolume".toUpperCase())) {
                isThinPool[0] = true;
                ret = this.createObjectPathArrayFromStringArray(inExtents, (String[])tempStr, "HITACHI_StorageVolume");
            } else if (temp1.contains("HITACHI_DiskExtent".toUpperCase())) {
                if (Arrays.binarySearch(numDiskExtents, tempStr.length) > -1) {
                    isThinPool[0] = false;
                    ret = this.createObjectPathArrayFromStringArray(inExtents, (String[])tempStr, "HITACHI_DiskExtent");
                } else {
                    mLogger.log(Level.SEVERE, "{0} parameter contains {1} elements, but it must contain one of the following number of elements {2}", new Object[]{"InExtents", tempStr.length, Arrays.toString(numDiskExtents)});
                    ret = ProviderConstants.UINT32_FIVE;
                }
            } else {
                mLogger.log(Level.SEVERE, "{0} parameter can only contain {1} or {2} objects but it contained {3}", new Object[]{"InExtents", "HITACHI_StorageVolume", "HITACHI_DiskExtent", Arrays.toString(tempStr)});
                ret = ProviderConstants.UINT32_FIVE;
            }
            if (null == inExtents) {
                mLogger.log(Level.SEVERE, "{0}: Unable to convert {1} to objectpaths", new Object[]{"InExtents", Arrays.toString(tempStr)});
                ret = ProviderConstants.UINT32_FIVE;
            }
        } else {
            mLogger.log(Level.SEVERE, "{0} parameter can not be null or empty", "InExtents");
            ret = ProviderConstants.UINT32_FIVE;
        }
        return ret;
    }
}

