/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageHardwareIDs;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class StorageHardwareIDInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    private static StorageHardwareIDs ids = StorageHardwareIDs.getStorageHardwareIDs();

    protected StorageHardwareIDInstrumentation() {
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                String[] hostORiscsiNames;
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_StorageHardwareID", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                AbstractBaseCommonObject theObj = (AbstractBaseCommonObject)pObj;
                String serialNum = theObj.getSerialNumber();
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNum);
                if (theObj instanceof PortandHostGroupInfo) {
                    hostORiscsiNames = ((PortandHostGroupInfo)theObj).getHostWWNs();
                } else {
                    List<ISCSITargetPort.ISCSITarget> targets = ((ISCSITargetPort)theObj).getTargets();
                    HashSet<String> rNames = new HashSet<String>();
                    for (ISCSITargetPort.ISCSITarget target : targets) {
                        for (ISCSITargetPort.RemoteiSCSIName rName : target.getRemoteNames()) {
                            rNames.add(rName.getName());
                        }
                    }
                    hostORiscsiNames = rNames.toArray(new String[rNames.size()]);
                }
                for (String name : hostORiscsiNames) {
                    Set<String> idList = ids.getUnasignedStorageHardwareIDs(serialNum);
                    boolean isContained = null != idList ? idList.contains(name) : false;
                    if (isContained) {
                        ids.removeUnassignedStorageHardwareID(serialNum, name);
                        continue;
                    }
                    CIMInstance sourceInstance = this.generateInstance(op, null, device.getRMIObject(), name);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_StorageHardwareID added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                String[] hostORiscsiNames;
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_StorageHardwareID", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                AbstractBaseCommonObject theObj = (AbstractBaseCommonObject)pObj;
                String serialNum = theObj.getSerialNumber();
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNum);
                if (theObj instanceof PortandHostGroupInfo) {
                    hostORiscsiNames = ((PortandHostGroupInfo)theObj).getHostWWNs();
                } else {
                    List<ISCSITargetPort.ISCSITarget> targets = ((ISCSITargetPort)theObj).getTargets();
                    HashSet<String> rNames = new HashSet<String>();
                    for (ISCSITargetPort.ISCSITarget target : targets) {
                        for (ISCSITargetPort.RemoteiSCSIName rName : target.getRemoteNames()) {
                            rNames.add(rName.getName());
                        }
                    }
                    hostORiscsiNames = rNames.toArray(new String[rNames.size()]);
                }
                for (String name : hostORiscsiNames) {
                    CIMInstance sourceInstance = this.generateInstance(op, null, device.getRMIObject(), name);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_StorageHardwareID added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_StorageHardwareID", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                HashSet<String> prevWWNSet = new HashSet<String>();
                HashSet<String> newWWNSet = new HashSet<String>();
                AbstractBaseCommonObject theObj = (AbstractBaseCommonObject)pObj;
                String serialNum = theObj.getSerialNumber();
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNum);
                if (theObj instanceof PortandHostGroupInfo) {
                    PortandHostGroupInfo phgiPrev = (PortandHostGroupInfo)theObj;
                    List<String> tmpList = Arrays.asList(phgiPrev.getHostWWNs());
                    prevWWNSet.addAll(tmpList);
                    PortandHostGroupInfo phgiNew = PortandHostGroupInfo.find(serialNum, phgiPrev.getSystemName(), String.valueOf(phgiPrev.getCtrlID()), String.valueOf(phgiPrev.getPortID()), String.valueOf(phgiPrev.getHostgroupID()), null, false, phgiPrev.getClientType());
                    if (phgiNew != null) {
                        String[] newHostWWNs = phgiNew.getHostWWNs();
                        newWWNSet.addAll(Arrays.asList(newHostWWNs));
                    }
                } else {
                    ISCSITargetPort oldPort = (ISCSITargetPort)theObj;
                    List<ISCSITargetPort.ISCSITarget> targets = oldPort.getTargets();
                    for (ISCSITargetPort.ISCSITarget target : targets) {
                        for (ISCSITargetPort.RemoteiSCSIName rName : target.getRemoteNames()) {
                            prevWWNSet.add(rName.getName());
                        }
                    }
                    ISCSITargetPort newPort = ISCSITargetPort.find(device.getRMIObject(), oldPort.getPortId());
                    targets = newPort.getTargets();
                    for (ISCSITargetPort.ISCSITarget target : targets) {
                        for (ISCSITargetPort.RemoteiSCSIName rName : target.getRemoteNames()) {
                            newWWNSet.add(rName.getName());
                        }
                    }
                }
                if (this.isListen4InstDel()) {
                    Iterator iterPrevWWNs = prevWWNSet.iterator();
                    Set<String> idList = ids.getUnasignedStorageHardwareIDs(serialNum);
                    while (iterPrevWWNs.hasNext()) {
                        String hostWWN = (String)iterPrevWWNs.next();
                        if (newWWNSet.contains(hostWWN)) continue;
                        if (idList.contains(hostWWN)) {
                            ids.removeUnassignedStorageHardwareID(serialNum, hostWWN);
                            continue;
                        }
                        CIMInstance sourceInstance = this.generateInstance(op, null, device.getRMIObject(), hostWWN);
                        IndicationHelper helper = new IndicationHelper(mHandle);
                        CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                        mHandle.deliverEvent(indication, null);
                    }
                }
                if (this.isListen4InstAdd()) {
                    for (String hostWWN : newWWNSet) {
                        if (prevWWNSet.contains(hostWWN)) continue;
                        CIMInstance sourceInstance = this.generateInstance(op, null, device.getRMIObject(), hostWWN);
                        IndicationHelper helper = new IndicationHelper(mHandle);
                        CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                        mHandle.deliverEvent(indication, null);
                    }
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to process a HITACHI_StorageHardwareID cache item modified", t);
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
        try {
            String expClientType = null;
            String expHostWWN = null;
            String expCtrID = null;
            String expPortID = null;
            String expDomainID = null;
            ArrayList expIncluded = null;
            ArrayList expExcluded = null;
            if (null != expectedValues) {
                expCtrID = (String)expectedValues.get("CtrID");
                expPortID = (String)expectedValues.get("PortID");
                expDomainID = (String)expectedValues.get("DomainID");
                expClientType = (String)expectedValues.get("ClientType");
                expHostWWN = (String)expectedValues.get("HostWWN");
                expIncluded = (ArrayList)expectedValues.get("Included");
                expExcluded = (ArrayList)expectedValues.get("Excluded");
            }
            for (RMIObjectMapping device : devices) {
                Set<String> storageHardwareIDs = ids.getAllStorageHardwareIDs(device, expCtrID, expPortID, expDomainID, expHostWWN, expClientType, expIncluded, expExcluded);
                for (String id : storageHardwareIDs) {
                    if (null != refInfo) {
                        refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject(), id));
                        continue;
                    }
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, device.getRMIObject(), id));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, device.getRMIObject(), id));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        String theID = (String)o[1];
        CIMProperty[] keys = retOP.getKeys();
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("StorageID", CIMDataType.STRING_T, (Object)theID, false), new CIMProperty("IDType", CIMDataType.UINT16_T, (Object)(StorageHardwareIDs.isIDHostWWN(theID) ? StorageHardwareIDs.CPV_IDTYPE : StorageHardwareIDs.CPV_iSCSIIDTYPE), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)theID, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)theID, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)theID, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class, String.class}, o, "HITACHI_StorageHardwareID");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String theID = (String)o[1];
        String instanceID = rmiObj.getSMISMappingContainer().getStorageSystemName() + "." + theID;
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instanceID, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageHardwareID", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String hostIDValue;
            String ssName;
            String instanceID = (String)op.getKeyValue("InstanceID");
            if (null != instanceID && instanceID.startsWith(ssName = device.getStorageSystemName()) && ids.isIDCreated(device, hostIDValue = instanceID.substring(ssName.length() + 1))) {
                return this.generateInstance(op, propertyList, device.getRMIObject(), hostIDValue);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, "Could not find " + op);
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_StorageHardwareID".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstAdd(false);
                if (!this.isListen4InstDel()) {
                    this.setListen4InstMod(false);
                }
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_StorageHardwareID".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstDel(false);
                if (!this.isListen4InstAdd()) {
                    this.setListen4InstMod(false);
                }
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StorageHardwareID AND SourceInstance.IDType <> PreviousInstance.IDType".equalsIgnoreCase(query) || "SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StorageHardwareID AND SourceInstance.CIM_StorageHardwareID::IDType <> PreviousInstance.CIM_StorageHardwareID::IDType".equals(query) || "SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StroageHardwareID AND SourceInstance.StorageID <> PreviousInstance.StorageID".equals(query) || "SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StorageHardwareID AND SourceInstance.CIM_StorageHardwareID::StorageID <> PreviousInstance.CIM_StorageHardwareID::StorageID".equals(query)) {
            // empty if block
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.PORTHOSTGROUP, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.PORTHOSTGROUP, this, null);
        }
    }
}

