/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.PGInfo;
import com.hitachi.smi.common.PrimordialPoolIndicationThread;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.StoragePoolInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import sanproject.serverux.data.SANRmiException;

public class StoragePoolPrimordialInstrumentation
extends StoragePoolInstrumentation {
    private static PrimordialPoolIndicationThread mIndThread = null;
    private static String[][] SpecCapa2RaidSizeTable = new String[][]{{"HDDSpecCapa", "RAID1(2D+2D)", "RAID5(3D+1P)", "RAID5(4D+1P)", "RAID5(6D+1P)", "RAID5(7D+1P)", "RAID6(6D+2P)", "RAID6(12D+2P)", "RAID6(14D+2P)"}, {"200GB", "384614912", "576922368", "769229824", "1153844736", "1346152192", "1153844736", "2307689472", "2692304384"}, {"300GB", "562884096", "844326144", "1125768192", "1688652288", "1970094336", "1688652288", "3377304576", "3940188672"}, {"400GB", "769230336", "1153845504", "1538460672", "2307691008", "2692306176", "2307691008", "4615382016", "5384612352"}, {"600GB", "1125768192", "1688652288", "2251536384", "3377304576", "3940188672", "3377304576", "6754609152", "7880377344"}, {"1.2TB", "2251536896", "3377305344", "4503073792", "6754610688", "7880379136", "6754610688", "13509221376", "15760758272"}, {"1.6TB", "3435970048", "5153955072", "6871940096", "10307910144", "12025895168", "10307910144", "20615820288", "24051790336"}, {"1.8TB", "3377512448", "5066268672", "6755024896", "10132537344", "11821293568", "10132537344", "20265074688", "23642587136"}, {"3.2TB", "6871944704", "10307917056", "13743889408", "20615834112", "24051806464", "20615834112", "41231668224", "48103612928"}, {"4.0TB", "7648717824", "11473076736", "15297435648", "22946153472", "26770512384", "22946153472", "45892306944", "53541024768"}, {"6.0TB", "11473076736", "17209615104", "22946153472", "34419230208", "40155768576", "34419230208", "68838460416", "80311537152"}, {"6.4TB", "13743894016", "20615841024", "27487788032", "41231682048", "48103629056", "41231682048", "82463364096", "96207258112"}};

    public static String getDefaultRaidLevel() {
        return SpecCapa2RaidSizeTable[0][1];
    }

    protected static void populateSpecCapaMap(CloseableAddableIterator<PDEVInfoEntry> pdevs, Map<String, List<PDEVInfoEntry>> specCapaMap) {
        mLogger.fine("Iterating free disks");
        while (pdevs.hasNext()) {
            PDEVInfoEntry pdev = (PDEVInfoEntry)pdevs.next();
            if (5 == pdev.getDriveKind() && 0 == pdev.getHddStatus()) {
                String specCapaStr = pdev.getHddSpecCapacity();
                StringBuilder key = new StringBuilder(specCapaStr);
                key = key.append(".");
                key = key.append(pdev.getHddDriveDetail());
                List<PDEVInfoEntry> specList = specCapaMap.get((key = key.append(pdev.getHddRPM())).toString());
                if (null == specList) {
                    specList = new ArrayList<PDEVInfoEntry>();
                    specCapaMap.put(key.toString(), specList);
                }
                specList.add(pdev);
                continue;
            }
            if (5 != pdev.getDriveKind()) continue;
            mLogger.log(Level.FINE, "HDD status is non-zero: {0}", pdev);
        }
        mLogger.log(Level.FINE, "Done iterating free disks{0}{1}", new Object[]{System.lineSeparator(), specCapaMap});
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues);
        try {
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    protected Object extrinsic_getSupportedSizes(CIMObjectPath pOp, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 ret;
        mLogger.fine("Entering Primordial getSupportedSizes");
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pOp, "InstanceID");
        try {
            UnsignedInteger16 elementType = null;
            CIMObjectPath goal = null;
            for (CIMArgument<?> arg : pInArgs) {
                if ("ElementType".equalsIgnoreCase(arg.getName())) {
                    elementType = (UnsignedInteger16)arg.getValue();
                    continue;
                }
                if (!"Goal".equalsIgnoreCase(arg.getName())) continue;
                goal = (CIMObjectPath)arg.getValue();
            }
            ArrayList<UnsignedInteger64> sizes = new ArrayList<UnsignedInteger64>();
            if (null == elementType || 2 != elementType.intValue()) {
                mLogger.log(Level.SEVERE, "{0} is an invalid elementType, only 2 is supported", elementType);
                sizes.add(ProviderConstants.UINT64_ZED);
                ret = ProviderConstants.UINT32_ZED;
            } else if (null == goal) {
                sizes.add(ProviderConstants.UINT64_ZED);
                ret = ProviderConstants.UINT32_ZED;
            } else {
                this.getSizeRange(device, goal, sizes);
                if (sizes.size() < 1) {
                    sizes.add(ProviderConstants.UINT64_ZED);
                }
                ret = ProviderConstants.UINT32_ZED;
            }
            pOutArgs[0] = new CIMArgument("Sizes", CIMDataType.UINT64_ARRAY_T, (Object)sizes.toArray(new UnsignedInteger64[sizes.size()]));
            mLogger.log(Level.FINE, "Primordial getSupportedSizes returning {0}", sizes);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            while (null != t.getCause()) {
                t = t.getCause();
            }
            throw new WBEMException(1, t.toString(), null, t);
        }
        finally {
            mLogger.fine("exiting primordial getSupportedSizes");
        }
        return ret;
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws WBEMException {
        mLogger.fine("Entering StoragePoolPrimordial::generateInstance");
        try {
            CIMObjectPath retOP = this.generateObjectPath(op, o);
            RMIObjectCache rmiObj = (RMIObjectCache)o[0];
            String SPCAG = ProviderLibs.getEndString("HITACHI_StoragePoolPrimordial", '_');
            UnsignedInteger64 totalManagedSpace = this.getTotalManagedSpace(rmiObj.getSMISMappingContainer());
            UnsignedInteger64 remainingSpace = this.getRemainingManagedSpace(rmiObj, totalManagedSpace);
            CIMProperty[] keys = retOP.getKeys();
            CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("Name", CIMDataType.STRING_T, (Object)SPCAG, false), new CIMProperty("ConsistsOf", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("Primordial", CIMDataType.BOOLEAN_T, (Object)true, false), new CIMProperty("TotalManagedSpace", CIMDataType.UINT64_T, (Object)totalManagedSpace, false), new CIMProperty("RemainingManagedSpace", CIMDataType.UINT64_T, (Object)remainingSpace, false), new CIMProperty("PoolID", CIMDataType.STRING_T, (Object)((String)keys[0].getValue()), false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(ProviderConstants.OP_STATUS_INDEX.OK.getStatusValue())}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)SPCAG, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)SPCAG, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)SPCAG, false), new CIMProperty("ElementsShareSpace", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("ReservedSpace", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false)};
            CIMInstance cIMInstance = new CIMInstance(retOP, props).filterProperties(propList);
            return cIMInstance;
        }
        catch (Throwable th) {
            while (null != th.getCause()) {
                th = th.getCause();
            }
            mLogger.log(Level.SEVERE, "Error generating primordial pool instance", th);
            throw new WBEMException(1, th.toString(), null, th);
        }
        finally {
            mLogger.fine("Leaving StoragePoolPrimordial::generateInstance");
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_StoragePoolPrimordial");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        StringBuffer keyValue = new StringBuffer(rmiObj.getSMISMappingContainer().getStorageSystemName());
        keyValue.append(".");
        keyValue.append("Primordial");
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)keyValue.toString(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StoragePoolPrimordial", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            CIMProperty cpInstID = op.getKey("InstanceID");
            if (null != cpInstID) {
                String ssName = ProviderLibs.getAllButEndString((String)cpInstID.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR);
                String primordial = ProviderLibs.getEndString((String)cpInstID.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR);
                if (null != ssName && ssName.equals(device.getStorageSystemName()) && "Primordial".equals(primordial)) {
                    return this.generateInstance(op, propertyList, device.getRMIObject());
                }
            }
        }
        catch (WBEMException we) {
            if (6 == we.getID() || 1 == we.getID()) {
                throw we;
            }
            throw new WBEMException(1, we.toString(), null, (Throwable)we);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    private UnsignedInteger64 getRemainingManagedSpace(RMIObjectCache rmiObj, UnsignedInteger64 totalManagedSpace) throws WBEMException {
        mLogger.fine("Entering StoragePoolPrimordial::getRemainingManagedSpace");
        try {
            BigInteger result = totalManagedSpace.bigIntegerValue();
            ClosableAddableIteratorCB<PGInfo> callback = new ClosableAddableIteratorCB<PGInfo>();
            PGInfo.getPGInfos(rmiObj, callback);
            CloseableAddableIterator<PGInfo> details = callback.getWrappedCloseableAddableIter();
            while (details.hasNext()) {
                PGInfo detail = (PGInfo)details.next();
                mLogger.log(Level.FINE, "{0}", detail);
                BigInteger pgSize = BigInteger.valueOf(detail.getLPDEVSize());
                pgSize = pgSize.multiply(ProviderConstants.UINT64_512.bigIntegerValue());
                pgSize = pgSize.multiply(BigInteger.valueOf(detail.getSPDEVCount()));
                result = result.subtract(pgSize);
            }
            mLogger.log(Level.FINE, "RMS BigInt is {0}", result);
            if (result.compareTo(BigInteger.ZERO) < 0) {
                result = BigInteger.ZERO;
            }
            UnsignedInteger64 unsignedInteger64 = new UnsignedInteger64(result);
            return unsignedInteger64;
        }
        catch (Throwable t) {
            while (null != t.getCause()) {
                t = t.getCause();
            }
            mLogger.log(Level.SEVERE, "Exception iterating PDEVInfoEntry", t);
            if (t instanceof WBEMException) {
                throw (WBEMException)t;
            }
            throw new WBEMException(1, t.toString(), null, t);
        }
        finally {
            mLogger.fine("Leaving StoragePoolPrimordial::getRemainingManagedSpace");
        }
    }

    private void getSizeRange(RMIObjectMapping device, CIMObjectPath goal, List<UnsignedInteger64> sizes) throws WBEMException {
        String raidLvl;
        mLogger.fine("Getting free disks");
        HashMap<String, List<PDEVInfoEntry>> specCapaMap = new HashMap<String, List<PDEVInfoEntry>>();
        ClosableAddableIteratorCB<PDEVInfoEntry> cb = new ClosableAddableIteratorCB<PDEVInfoEntry>();
        PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), cb);
        if (null == goal) {
            raidLvl = StoragePoolPrimordialInstrumentation.getDefaultRaidLevel();
        } else {
            CIMInstance goalInst = mHandle.getInstance(goal, null);
            if (null != goalInst) {
                mLogger.log(Level.FINE, "Found goal instance {0}", goalInst);
                raidLvl = (String)goalInst.getPropertyValue("ElementName");
            } else {
                throw new WBEMException("Could not find " + goal);
            }
        }
        StoragePoolPrimordialInstrumentation.populateSpecCapaMap(cb.getWrappedCloseableAddableIter(), specCapaMap);
        this.getSizesFromSpecCapaTable(specCapaMap, raidLvl, sizes);
    }

    private void getSizesFromSpecCapaTable(Map<String, List<PDEVInfoEntry>> specCapaMap, String raidLvl, List<UnsignedInteger64> sizes) {
        mLogger.fine("Entering getSizesFromSpecCapaTable");
        Set<String> keys = specCapaMap.keySet();
        int numDisks = ProviderLibs.getNumDisksInRaid(raidLvl);
        mLogger.log(Level.FINE, "{0} requires {1} disks", new Object[]{raidLvl, numDisks});
        for (String key : keys) {
            List<PDEVInfoEntry> specList = specCapaMap.get(key);
            mLogger.log(Level.FINE, "Key: {0} has {1} disks", new Object[]{key, specList.size()});
            if (specList.size() < numDisks) continue;
            int xAxis = -1;
            int yAxis = -1;
            int MAX_X = SpecCapa2RaidSizeTable[0].length;
            int MAX_Y = SpecCapa2RaidSizeTable.length;
            for (int idx = 1; idx < MAX_Y; ++idx) {
                if (xAxis < 1 && idx < MAX_X) {
                    mLogger.log(Level.FINER, "{0}: Raid level: {1}: {2}", new Object[]{key, raidLvl, SpecCapa2RaidSizeTable[0][idx]});
                    if (raidLvl.equals(SpecCapa2RaidSizeTable[0][idx])) {
                        xAxis = idx;
                    }
                }
                String capacityStr = ProviderLibs.getAllButEndString(key, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                mLogger.log(Level.FINER, "{0}: Capacity: {1}: {2}", new Object[]{key, capacityStr, SpecCapa2RaidSizeTable[idx][0]});
                if (capacityStr.equals(SpecCapa2RaidSizeTable[idx][0])) {
                    yAxis = idx;
                }
                if (xAxis <= 0 || yAxis <= 0) continue;
                String tableCapString = SpecCapa2RaidSizeTable[yAxis][xAxis];
                mLogger.log(Level.INFO, "Found match for key: {0} at X: {1} Y: {2}, value: {3}", new Object[]{key, xAxis, yAxis, tableCapString});
                UnsignedInteger64 capValue = new UnsignedInteger64(tableCapString);
                sizes.add(capValue);
                yAxis = -1;
            }
        }
        mLogger.log(Level.FINE, "Exiting getSizesFromSpecCapaTable, sizes:{0}{1}", new Object[]{System.lineSeparator(), sizes});
    }

    @Override
    public UnsignedInteger64 getTotalManagedSpace(RMIObjectMapping device) throws RemoteException, SANRmiException, WBEMException {
        mLogger.fine("Entering StoragePoolPrimordial::getTotalManagedSpace");
        try {
            BigInteger result = BigInteger.ZERO;
            ClosableAddableIteratorCB<PGInfo> callback = new ClosableAddableIteratorCB<PGInfo>();
            PGInfo.getPGInfos(device.getRMIObject(), callback);
            CloseableAddableIterator<PGInfo> details = callback.getWrappedCloseableAddableIter();
            while (details.hasNext()) {
                PGInfo pg = (PGInfo)details.next();
                result = result.add(BigInteger.valueOf(pg.getLpDevSizeDependOnCE() * 512L * (long)pg.getSPDEVCount()));
                mLogger.log(Level.FINE, "{0}", pg);
            }
            mLogger.log(Level.FINE, "TMS BigInt is {0}", result);
            UnsignedInteger64 unsignedInteger64 = new UnsignedInteger64(result);
            return unsignedInteger64;
        }
        catch (Throwable t) {
            while (null != t.getCause()) {
                t = t.getCause();
            }
            mLogger.log(Level.SEVERE, "Exception iterating PDEVInfoEntry", t);
            if (t instanceof WBEMException) {
                throw (WBEMException)t;
            }
            throw new WBEMException(1, t.toString(), null, t);
        }
        finally {
            mLogger.fine("Leaving StoragePoolPrimordial::getTotalManagedSpace");
        }
    }

    @Override
    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        Object oRet = null;
        if ("GetSupportedSizes".equalsIgnoreCase(pMethodName)) {
            oRet = this.extrinsic_getSupportedSizes(pOp, pInArgs, pOutArgs);
        } else if ("GetSupportedSizeRange".equalsIgnoreCase(pMethodName)) {
            oRet = pOp.getObjectName().contains("Primordial") ? ProviderConstants.UINT32_TWO : this.extrinsic_GetSupportedSizeRange(pOp, pInArgs, pOutArgs);
        } else {
            throw new WBEMException(17, "StoragePool does not know about the method: " + pMethodName);
        }
        return oRet;
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StoragePool AND SourceInstance.CIM_StoragePool::TotalManagedSpace <> PreviousInstance.CIM_StoragePool::TotalManagedSpace".equalsIgnoreCase(query)) {
            if (startListening) {
                this.startModifyCheck();
            } else {
                this.stopModifyCheck();
            }
        }
    }

    private synchronized void startModifyCheck() {
        if (mIndThread == null) {
            try {
                mIndThread = new PrimordialPoolIndicationThread(this, mHandle, "HITACHI_StoragePoolPrimordial");
                mIndThread.start();
                this.setListen4InstMod(true);
            }
            catch (Throwable we) {
                mLogger.log(Level.SEVERE, "Encountered exception(" + we + ") trying to setup modify instance for " + "HITACHI_StoragePoolPrimordial", we);
            }
        }
    }

    private synchronized void stopModifyCheck() {
        if (mIndThread != null) {
            mIndThread.stopThread();
            mIndThread = null;
        }
    }
}

