/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class StorageSystemDeviceStorageVolumeInstrumentation
extends BaseAssocInstrumentation {
    protected StorageSystemDeviceStorageVolumeInstrumentation() {
        super("HITACHI_StorageSystemDeviceStorageVolume", "HITACHI_StorageSystem", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"), "HITACHI_StorageVolume", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        PassthruIterator deviceIter = new PassthruIterator(iter);
        try {
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMProperty cpName = opStorageSystem.getKey("Name");
                String nameVal = (String)cpName.getValue();
                CIMObjectPath opStorageVol = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageVolume", new CIMProperty[]{new CIMProperty("SystemName", cpName.getDataType(), (Object)nameVal)});
                ReferenceInfo newRefInfo = new ReferenceInfo(opStorageSystem, null, "GroupComponent", "PartComponent", propertyList, isObjectPath, this);
                this.getReference2Instrumentation().enumerate(deviceIter, opStorageVol, new String[0], null, null, continueOnError, true, this.getReference2SearchProperties(opStorageSystem), newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        block6: {
            try {
                CIMInstance instStorageVolume;
                CIMObjectPath opStorageSystem;
                block7: {
                    String cvStorageVolumeSystemName;
                    String ssName;
                    CIMObjectPath opStorageVolume;
                    String cpnStorageSystem = this.getReference1PropertyName();
                    opStorageSystem = op.getKey(cpnStorageSystem) != null ? (CIMObjectPath)op.getKey(cpnStorageSystem).getValue() : null;
                    String cpnStorageVolume = this.getReference2PropertyName();
                    CIMObjectPath cIMObjectPath = opStorageVolume = op.getKey(cpnStorageVolume) != null ? (CIMObjectPath)op.getKey(cpnStorageVolume).getValue() : null;
                    if (null == opStorageVolume || null == opStorageSystem) break block6;
                    String string = ssName = opStorageSystem.getKey("Name") != null && opStorageSystem.getKey("Name").getValue() != null ? (String)opStorageSystem.getKey("Name").getValue() : null;
                    if (null == ssName) break block6;
                    String string2 = cvStorageVolumeSystemName = opStorageVolume.getKey("SystemName") != null && opStorageVolume.getKey("SystemName").getValue() != null ? (String)opStorageVolume.getKey("SystemName").getValue() : null;
                    if (!ssName.equalsIgnoreCase(cvStorageVolumeSystemName)) break block6;
                    instStorageVolume = null;
                    try {
                        instStorageVolume = this.getReference2Instrumentation().getInstance(opStorageVolume, null);
                    }
                    catch (WBEMException we) {
                        if (we.getID() == 6) break block7;
                        throw we;
                    }
                }
                if (null != instStorageVolume) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageSystem, "Name");
                    opStorageSystem = this.getReference1Instrumentation().generateObjectPath(opStorageSystem, device.getRMIObject());
                    return this.generateInstance(op, propertyList, opStorageSystem, instStorageVolume.getObjectPath());
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opRef2) {
        String[] props;
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        for (String propName : props = new String[]{"SystemName", "DeviceID"}) {
            CIMProperty key = null != opRef2 ? opRef2.getKey(propName) : null;
            String val = null != key ? (String)key.getValue() : null;
            hTable.put(propName, val);
        }
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opRef1) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = null != opRef1 && null != opRef1.getKey("Name") ? (String)opRef1.getKey("Name").getValue() : null;
        hTable.put("SystemName", name);
        return hTable;
    }
}

