/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation.iSCSI;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSIreadPortNetworkConditions;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class EthernetPortInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_EthernetPort", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_EthernetPort added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_EthernetPort", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_EthernetPort deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_EthernetPort", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance prevInstance = this.generateInstance(op, null, pObj);
                FCPort port = (FCPort)pObj;
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(port.getSerialNumber());
                FCPort newInst = FCPort.find(port.getPortWWN(), FCPort.PortTypeRequested.iSCSI, device.getRMIObject());
                if (newInst != null) {
                    CIMInstance sourceInstance = this.generateInstance(op, null, newInst);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                    mHandle.deliverEvent(indication, null);
                } else {
                    mLogger.severe("Unable to find a fort that with WWN of: " + port.getPortWWN());
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_EthernetPort modified indication instance", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        Short port2Match = null;
        String expSysName = null;
        try {
            if (null != expectedValues) {
                if (1 != devices.size()) {
                    mLogger.log(Level.SEVERE, "{0} called with parameters for an association call, device infoinvalid. expValues: {1}, devices found: {2}", new Object[]{"HITACHI_EthernetPort", expectedValues, devices.size()});
                    if (null != iter) {
                        iter.done();
                    }
                    return;
                }
                expSysName = (String)expectedValues.get("SystemName");
                String val = (String)expectedValues.get("PortID");
                port2Match = null == val ? null : Short.valueOf(Short.parseShort(val));
            }
            for (RMIObjectMapping device : devices) {
                ClosableAddableIteratorCB<FCPort> callback = new ClosableAddableIteratorCB<FCPort>();
                FCPort.getFCPorts(device.getRMIObject(), callback, false, true, null, expSysName, port2Match);
                CloseableAddableIterator<FCPort> dataIter = callback.getWrappedCloseableAddableIter();
                while (dataIter.hasNext()) {
                    FCPort port = (FCPort)dataIter.next();
                    if (!port.isRequestedType(FCPort.PortTypeRequested.iSCSI)) continue;
                    CIMInstance inst = this.generateInstance(op, propertyList, port);
                    if (null != refInfo) {
                        refInfo.addReference(iter, inst.getObjectPath());
                        continue;
                    }
                    if (isObjectPath) {
                        iter.add(inst.getObjectPath());
                        continue;
                    }
                    iter.add(inst);
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath pOP, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(pOP, o);
        FCPort pInfo = (FCPort)o[0];
        CIMInstance ret = null;
        if (null != pInfo && null != pOP) {
            try {
                CIMProperty[] keys = retOP.getKeys();
                CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("PortType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("PortDiscriminator", CIMDataType.STRING_ARRAY_T, (Object)new String[]{"SNIA:iSCSI"}, false), new CIMProperty("PermanentAddress", CIMDataType.STRING_T, (Object)pInfo.getPortWWN(), false), new CIMProperty("NetworkAddresses", CIMDataType.STRING_ARRAY_T, null, false), new CIMProperty("MaxDataSize", CIMDataType.UINT32_T, null, false), new CIMProperty("Capabilities", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_ZED}, false), new CIMProperty("CapabilityDescriptions", CIMDataType.STRING_ARRAY_T, null, false), new CIMProperty("EnabledCapabilities", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_ZED}, false), new CIMProperty("OtherEnabledCapabilities", CIMDataType.STRING_ARRAY_T, null, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("PoEPowerEntityType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("PVID", CIMDataType.UINT16_T, null, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)pInfo.getStrPortDisplayName(), false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)pInfo.getStrPortDisplayName(), false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)pInfo.getStrPortDisplayName(), false)};
                ret = new CIMInstance(retOP, props).filterProperties(propList);
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        return ret;
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{FCPort.class}, o, "HITACHI_EthernetPort");
        FCPort pInfo = (FCPort)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(pInfo.getSerialNumber());
        String systemName = this.getStorageSystemName(device, pInfo);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_EthernetPort", true), new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)this.makeDeviceID(pInfo), true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageProcessorSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_EthernetPort", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        block4: {
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
            try {
                FCPort fcPort;
                String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
                String sccName = (String)op.getKeyValue("SystemCreationClassName");
                String deviceIDKeyVal = (String)op.getKeyValue("DeviceID");
                String sysNameKeyVal = (String)op.getKeyValue("SystemName");
                if (null != deviceIDKeyVal && null != sysNameKeyVal && null != ccName && !ccName.equals("HITACHI_EthernetPort") && null != sccName && !sccName.equals("HITACHI_StorageProcessorSystem") || null == (fcPort = FCPort.find(ProviderLibs.getEndString(deviceIDKeyVal, ProviderConstants.ID_SEPERATOR_AS_CHAR), FCPort.PortTypeRequested.iSCSI, device.getRMIObject()))) break block4;
                if (!fcPort.isRequestedType(FCPort.PortTypeRequested.iSCSI)) {
                    mLogger.log(Level.SEVERE, "Requested FCPort is not an iSCSI port: {0}", fcPort);
                    break block4;
                }
                return this.generateInstance(op, propertyList, fcPort);
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, op.toString());
    }

    private String getStorageSystemName(RMIObjectMapping device, FCPort pInfo) throws WBEMException {
        StringBuilder ret = new StringBuilder(device.getStorageSystemName());
        ret = ret.append(".");
        ret = ret.append(pInfo.getControlID());
        return ret.toString();
    }

    private String makeDeviceID(FCPort pInfo) throws WBEMException {
        ISCSIreadPortNetworkConditions info = pInfo.getISCSIInfo();
        StringBuilder ret = new StringBuilder();
        ret.append(info.getId());
        ret.append(ProviderConstants.ID_SEPERATOR_AS_CHAR);
        ret.append(info.getMacAddressAsString());
        return ret.toString();
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_EthernetPort".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_Ethernetport".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_EthernetPort AND SourceInstance.CIM_EthernetPort::OperationalStatus <> PreviousInstance.CIM_EthernetPort::OperationalStatus".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.PORT, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.PORT, this, null);
        }
    }
}

