/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation.iSCSI;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class iSCSIConfigurationCapabilitiesInstrumentation
extends BaseInstrumentation {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices;
        String expSysName;
        String string = expSysName = null != expectedValues ? (String)expectedValues.get("InstanceID") : null;
        if (null == expectedValues) {
            devices = ProviderLibs.getManagedDevicesFromObjectPath(op, "InstanceID");
        } else {
            if (null == expSysName) throw new WBEMException("iSCSIConfigurationCapabilities called with association parameters, but SystemName was not provided");
            String serialNum = ProviderLibs.getSerialFromString(expSysName);
            RMIObjectMapping mapObj = RMIObjectMapping.getRMIObjectMapping(serialNum);
            String systemName = mapObj.getStorageSystemName();
            if (!expSysName.equalsIgnoreCase(systemName)) throw new WBEMException("iSCSIConfigurationCapabilities called with association parameters, but SystemName was not valid. Expected: " + expSysName + " " + " but got " + systemName);
            devices = new ArrayList<RMIObjectMapping>(1);
            devices.add(mapObj);
        }
        try {
            for (RMIObjectMapping device : devices) {
                String ssName = device.getStorageSystemName();
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, ssName));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, ssName));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, ssName));
            }
        }
        catch (WBEMException we) {
            if (null == iter) throw we;
            iter.setException(we);
            iter.close();
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null == iter) throw we;
            iter.setException(we);
            iter.close();
            throw we;
        }
        if (null == iter) return;
        iter.done();
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("iSCSIProtocolEndpointCreationSupported", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("IdentifierSelectionSupported", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("iSCSINodeCreationSupported", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"HITACHI_iSCSIConfigurationCapabilities", false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{String.class}, o, "HITACHI_iSCSIConfigurationCapabilities");
        String storageSystemName = (String)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)storageSystemName, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_iSCSIConfigurationCapabilities", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null == instID) {
                throw new WBEMException(6, op.toString());
            }
            String storageSystemName = device.getStorageSystemName();
            if (instID.equals(storageSystemName)) {
                return this.generateInstance(op, propertyList, storageSystemName);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

