/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ResourceRestriction;
import com.hitachi.smi.common.SnapshotInfo2;
import com.hitachi.smi.common.SnapshotRestriction;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.common.keyvalueapis.MRCFreadSnapshotRootLdevInfo;
import com.hitachi.smi.common.keyvalueapis.MRCFreadTiPairOfSecondaryVolumes;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.StorageVolumeInstrumentation;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CreateElementReplica;
import com.hitachi.smi.jobs.ElementNameData;
import com.hitachi.smi.jobs.HitachiJobCallbackIF2;
import com.hitachi.smi.jobs.SetResourceNameHelper;
import com.ws.wbem.CloseableAddableIterator;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;
import sanproject.common.Robj_interface_MRCFsetQSPairDetail2;
import sanproject.common.Robj_interface_MRCFsetQSPairDetail3;
import sanproject.common.Robj_interface_MRCFsetQSPairInfo2_IN;
import sanproject.common.Robj_interface_MRCFsetQSPairInfo2_OUT;
import sanproject.common.Robj_interface_MRCFsetQSPairMain2;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiResourceName;
import sanproject.serverux.data.SANRmiException;

public class CoalescedCreateElementReplica
extends Coalescable {
    private static List<SnapshotRestriction> usableSVols = null;
    private static List<SnapshotRestriction> usableSnapshotPools = null;
    private static final short maxMU = 1024;
    final long LOG_WAIT_TIME = 10000L;
    final List<Robj_interface_RJiResourceName> elementNames;
    private String clientIP;
    private CreateElementReplica.TypeOfReplica typeOfOperation;

    protected CoalescedCreateElementReplica(String serialNumber) {
        super(serialNumber);
        if (null == usableSnapshotPools || null == usableSVols) {
            this.getRestrictionData();
        }
        this.elementNames = new ArrayList<Robj_interface_RJiResourceName>();
    }

    private void changeSVolNames() throws WBEMException {
        mLogger.log(Level.INFO, "Job {0} is now setting the replica name(s).", this.getJob().getInstanceID());
        try {
            ElementNameData.changeElementNames(this, this.elementNames);
        }
        catch (Throwable t) {
            while (null != t.getCause()) {
                t = t.getCause();
            }
            mLogger.log(Level.WARNING, "Job " + this.getJob().getInstanceID() + " Naming newly created replica(s) failed", t);
        }
    }

    private boolean checkStatus4FastClone(List<SnapshotInfo2> snapshotInfos, Map<String, PairVals> pairValsHash, List<DeviceNumber> sVolList, Map<String, Integer> childJobBySVolHash, Map<Integer, String> badJobHash, boolean logInfo) {
        boolean ret = true;
        if (!snapshotInfos.isEmpty()) {
            ret = false;
            for (SnapshotInfo2 snapshot : snapshotInfos) {
                int status = snapshot.getPairStatus();
                if (0 == status || 513 == status || 544 == status || 560 == status) continue;
                int sVolDNNumber = (int)snapshot.getPVol().getDn();
                String errorMsg = "The pair status value on sVol (DN ID:" + snapshot.getPVolDNString() + ") is 0x" + Integer.toHexString(snapshot.getPairStatus());
                badJobHash.put(childJobBySVolHash.get(sVolDNNumber), errorMsg);
                sVolList.remove(snapshot.getPVol());
            }
        } else {
            mLogger.log(Level.INFO, "Job {0}: checkStatus4FastClone: No elements in snapshotInfos list, status update complete", new Object[]{this.getJob().getInstanceID()});
            sVolList.clear();
        }
        return ret;
    }

    private boolean checkStatus4NormalOrSnap2Snap(List<SnapshotInfo2> snapshotInfos, Map<String, PairVals> pairValsHash, List<DeviceNumber> sVolList, Map<String, Integer> childJobBySVolHash, Map<Integer, String> badJobHash, boolean logInfo) {
        boolean ret = true;
        if (snapshotInfos.size() < sVolList.size()) {
            return false;
        }
        for (SnapshotInfo2 snapshotInfo : snapshotInfos) {
            DeviceNumber pVol = snapshotInfo.getPVol();
            DeviceNumber sVol = snapshotInfo.getSVol();
            String sVolDNNumber = sVol.getDNAsString();
            if (logInfo) {
                mLogger.info("Job " + this.getJob().getInstanceID() + ": validateSplitPairs: " + "pair status of sVol \"" + sVolDNNumber + "\" is " + Integer.toHexString(snapshotInfo.getPairStatus()));
            }
            if (snapshotInfo.getPairStatus() == 560) {
                mLogger.log(Level.INFO, "Job {0}: The status of sVol (DN ID: {1}) is now {2}.", new Object[]{this.getJob().getInstanceID(), sVolDNNumber, Integer.toHexString(560)});
                PairVals pairVals = new PairVals(pVol, sVol, (short)snapshotInfo.getMirrorUnit(), 0);
                pairValsHash.put(sVolDNNumber, pairVals);
                sVolList.remove(sVol);
                continue;
            }
            if (snapshotInfo.getPairStatus() != 544) {
                String errorMsg = "The pair status value on the getQSPairLdev for sVol (DN ID:" + sVolDNNumber + ") should be either 0x230 or " + "0x220 but it is = " + Integer.toHexString(snapshotInfo.getPairStatus());
                badJobHash.put(childJobBySVolHash.get(sVolDNNumber), errorMsg);
                sVolList.remove(sVol);
                continue;
            }
            if (logInfo) {
                mLogger.info("Job " + this.getJob().getInstanceID() + ": validateSplitPairs: waiting for pair " + "status of S-VOL \"" + sVolDNNumber + "\" to  change from 0x220 to 0x230");
            }
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Robj_interface_MRCFsetQSPairInfo2_IN createSetQSPairInfoINObjectSetPair(Hashtable<String, DeviceNumber> sVolDNStringHash) throws WBEMException {
        Robj_interface_MRCFsetQSPairInfo2_IN ret = null;
        HashSet<String> assignedSVolIDs = new HashSet<String>();
        Hashtable<String, HashSet<Short>> assignedMUHash = new Hashtable<String, HashSet<Short>>();
        try {
            CommonClassAsList<DeviceNumber> callback = new CommonClassAsList<DeviceNumber>();
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
            DeviceNumber.getDNs(rmiObj, callback, (short)-1, false, CreateElementReplica.TypeOfReplica.Snapshot == this.typeOfOperation ? VolumeTypeEnum.QSVVOL : VolumeTypeEnum.AOUVOL);
            LinkedList<DeviceNumber> dns = callback.getReturnValue();
            ArrayList<Robj_interface_MRCFsetQSPairDetail2> pairDetailList = new ArrayList<Robj_interface_MRCFsetQSPairDetail2>();
            List<AbstractJobImpl> childJobs = this.getAbstractJobImpls();
            Iterator<AbstractJobImpl> iter = childJobs.iterator();
            int x = 0;
            while (iter.hasNext()) {
                AbstractJobImpl childJob = iter.next();
                if (!(childJob instanceof CreateElementReplica)) {
                    String msg = "Expected all elements of the list to contain instances of CreateElementReplica, , however; job " + (null != childJob.getJob() ? childJob.getJob().getInstanceID() : "UNKNOWN") + " supplied a " + childJob.getClass().getSimpleName();
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                    continue;
                }
                CreateElementReplica child = (CreateElementReplica)childJob;
                if (null == this.clientIP) {
                    this.clientIP = child.getClientIP();
                }
                DeviceNumber dnPVol = (DeviceNumber)child.getActionItem();
                DeviceNumber dnSVol = null;
                HashSet<String> hashSet = assignedSVolIDs;
                synchronized (hashSet) {
                    dnSVol = CreateElementReplica.TypeOfReplica.Snapshot == this.typeOfOperation ? this.getSnapshotVolume(dnPVol, child.getTargetGoal(), dns, assignedSVolIDs, child.getHandle()) : this.getDPVolume(dnPVol, child.getTargetPool(), child.getTargetGoal(), dns, assignedSVolIDs, child.getHandle());
                    if (null == dnSVol) {
                        String msg = "Could not find available snapshot V-Vol which  meets all the required conditions for P-Vol: " + dnPVol.getDNAsString();
                        this.markAndRemoveChildJobWithError(iter, childJob, msg);
                        continue;
                    }
                    assignedSVolIDs.add(dnSVol.getDNAsString());
                    mLogger.log(Level.INFO, "Job {0} w/ pVol {1} using {2} as sVol", new Object[]{childJob.getJob().getInstanceID(), dnPVol.getDn(), dnSVol.getDn()});
                    this.setChildAffectedElement(childJob, dnSVol);
                    childJob.getJob().setDescription(childJob.getMethodName() + " Volume " + dnPVol.getDn() + " --> " + dnSVol.getDn() + " on " + this.getDeviceSerialNumber());
                }
                Robj_interface_MRCFsetQSPairDetail2 setPairDetail = (Robj_interface_MRCFsetQSPairDetail2)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.MRCFSETQSPAIRDETAIL2);
                if (CreateElementReplica.TypeOfReplica.Snapshot != this.typeOfOperation) {
                    ((Robj_interface_MRCFsetQSPairDetail3)setPairDetail).setBCascade(true);
                    ((Robj_interface_MRCFsetQSPairDetail3)setPairDetail).setBClone(CreateElementReplica.TypeOfReplica.Snap2Snap != this.typeOfOperation);
                }
                setPairDetail.setRobjPVolIndex(ProviderLibs.getRJiLDEVIndex(rmiObj, dnPVol));
                Robj_interface_RJiLDEVIndex sVol = ProviderLibs.getRJiLDEVIndex(rmiObj, dnSVol);
                setPairDetail.setRobjSVolIndex(sVol);
                setPairDetail.setSCmdKind((short)1);
                setPairDetail.setSPairKind((short)0);
                setPairDetail.setSSnapshotKind((short)1);
                setPairDetail.setSCmdOpt((short)0);
                HashSet<Short> assignedMUSet = (HashSet<Short>)assignedMUHash.get(dnPVol.getDNAsString());
                if (null == assignedMUSet) {
                    assignedMUSet = new HashSet<Short>();
                    assignedMUHash.put(dnPVol.getDNAsString(), assignedMUSet);
                }
                short muNum = this.getMUNumber(setPairDetail.getSSnapshotKind(), dnPVol.getDNAsString(), assignedMUSet);
                setPairDetail.setSMuNum(muNum);
                if (!this.setPoolID(rmiObj, dnPVol, setPairDetail)) {
                    String msg = "Could not find available pool ID";
                    this.markAndRemoveChildJobWithError(iter, childJob, "Could not find available pool ID");
                    assignedSVolIDs.remove(dnSVol.getDNAsString());
                    continue;
                }
                pairDetailList.add(setPairDetail);
                String jobID = childJob.getJob().getInstanceID();
                mLogger.log(Level.FINE, "Job {0}: Placing sVol {1} in hash with ID {2}", new Object[]{this.getJob().getInstanceID(), dnSVol.getDn(), jobID});
                sVolDNStringHash.put(jobID, dnSVol);
                child.setResultIndex(x++);
            }
            if (!pairDetailList.isEmpty()) {
                Robj_interface_MRCFsetQSPairDetail2[] pairDetailArray = pairDetailList.toArray(new Robj_interface_MRCFsetQSPairDetail2[pairDetailList.size()]);
                Robj_interface_MRCFsetQSPairMain2 qsPairMain = (Robj_interface_MRCFsetQSPairMain2)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.MRCFSETQSPAIRMAIN);
                qsPairMain.setQSPairDetail2(pairDetailArray);
                qsPairMain.setIPairNum(pairDetailArray.length);
                ret = (Robj_interface_MRCFsetQSPairInfo2_IN)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.MRCFSETQSPAIRINFO_IN);
                ret.setQSPairMain2(qsPairMain);
            }
        }
        catch (SANRmiException sre) {
            String msg = String.format("Job %s: Exception communicating with backend: %s", this.getJob().getInstanceID(), sre.getErrMsgEn());
            mLogger.log(Level.SEVERE, msg, sre);
            throw new WBEMException(1, msg, null, (Throwable)sre);
        }
        catch (RemoteException re) {
            String msg = String.format("Job %s: Remote Exception with backend: ", this.getJob().getInstanceID(), re);
            mLogger.log(Level.SEVERE, msg, re);
            throw new WBEMException(1, msg, null, (Throwable)re);
        }
        if (null == ret) {
            String msg = "Job " + this.getJob().getInstanceID() + ": CoalescedCreateElementReplica." + "createSetQSPairInfoINObjectSetPair: " + "Could not create valid Robj_interface_MRCFsetQSPairInfo_IN " + "object with any of the specified P-Vols";
            mLogger.log(Level.SEVERE, msg);
            throw new WBEMException(msg);
        }
        return ret;
    }

    private Robj_interface_MRCFsetQSPairInfo2_IN createSetQSPairInfoINObjectSplitPair(Hashtable<String, DeviceNumber> sVolDNHash) throws WBEMException {
        Robj_interface_MRCFsetQSPairInfo2_IN ret = null;
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
        ArrayList<DeviceNumber> sVolDNList = new ArrayList<DeviceNumber>();
        List<AbstractJobImpl> childJobs = this.getAbstractJobImpls();
        Iterator<AbstractJobImpl> iter = childJobs.iterator();
        Hashtable<String, Integer> childJobBySVolHash = new Hashtable<String, Integer>();
        Hashtable<Integer, DeviceNumber> sVolByChildJobHash = new Hashtable<Integer, DeviceNumber>();
        while (iter.hasNext()) {
            AbstractJobImpl childJob = iter.next();
            String jobID = childJob.getJob().getInstanceID();
            DeviceNumber sVolDN = sVolDNHash.get(jobID);
            if (null == sVolDN) {
                String msg = "Could not locate sVol in hash using key " + jobID + ", hash: " + sVolDNHash;
                this.markAndRemoveChildJobWithError(iter, childJob, msg);
                continue;
            }
            childJobBySVolHash.put(sVolDN.getDNAsString(), childJob.hashCode());
            sVolByChildJobHash.put(childJob.hashCode(), sVolDN);
            sVolDNList.add(sVolDN);
        }
        if (!sVolDNList.isEmpty()) {
            boolean done;
            long WAIT_TIME = 1800000L;
            long startTime = System.currentTimeMillis();
            long END_WAIT_TIME = startTime + 1800000L;
            ArrayList<PairVals> pairValList = new ArrayList<PairVals>();
            Hashtable badJobHash = new Hashtable();
            long logStartTime = System.currentTimeMillis();
            boolean logInfo = true;
            do {
                done = true;
                CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                SnapshotInfo2.getSnapshotInfo2(rmiObj, callback, sVolDNList, Boolean.FALSE);
                LinkedList<SnapshotInfo2> snapshotInfos = callback.getReturnValue();
                if (snapshotInfos.size() < sVolDNList.size()) {
                    done = false;
                    continue;
                }
                for (SnapshotInfo2 snapshotInfo : snapshotInfos) {
                    DeviceNumber sVolDN = snapshotInfo.getSVol();
                    String sVolDNString = sVolDN.getDNAsString();
                    if (logInfo) {
                        mLogger.info("Job " + this.getJob().getInstanceID() + ": createSetQSPairInfoINObjectSplitPair: " + "pair status of sVol \"" + sVolDNString + "\" is " + Integer.toHexString(snapshotInfo.getPairStatus()));
                    }
                    if (snapshotInfo.getPairStatus() == 544) {
                        mLogger.info("Job " + this.getJob().getInstanceID() + ": createSetQSPairInfoINObjectSplitPair: " + "pair status of S-VOL \"" + sVolDNString + "\" is " + Integer.toHexString(snapshotInfo.getPairStatus()));
                        PairVals pairVals = new PairVals(snapshotInfo.getPVol(), sVolDN, (short)snapshotInfo.getMirrorUnit(), 0);
                        pairValList.add(pairVals);
                        sVolDNList.remove(sVolDN);
                        continue;
                    }
                    if (snapshotInfo.getPairStatus() == 528) {
                        long now;
                        if (logInfo) {
                            mLogger.info("Job " + this.getJob().getInstanceID() + ": createSetQSPairInfoINObjectSplitPair: " + "waiting for pair status of S-VOL \"" + sVolDNString + "\" to " + "change from COPY(0x0210) to PAIR(0x0220). " + "pair status is: " + Integer.toHexString(snapshotInfo.getPairStatus()));
                        }
                        if ((now = System.currentTimeMillis()) > END_WAIT_TIME) {
                            String errorMsg = "Waited 1800000 Milliseconds for the pair status of SVol " + sVolDNString + " to change from PAIR(0x0220) to " + "PSUS(0x0230) but it didn't change.  Marking " + "this job as Failed (4)";
                            badJobHash.put(childJobBySVolHash.get(sVolDNString), errorMsg);
                            sVolDNList.remove(sVolDN);
                            continue;
                        }
                        done = false;
                        continue;
                    }
                    String errorMsg = "The pair status value on the getQSPairLdev for this SVol (DN ID:" + sVolDNString + ") should be either 0x0210(COPY) or " + "0x0220(Pair) but it is = " + Integer.toHexString(snapshotInfo.getPairStatus());
                    badJobHash.put(childJobBySVolHash.get(sVolDNString), errorMsg);
                    sVolDNList.remove(sVolDN);
                }
                if (sVolDNList.isEmpty()) {
                    done = true;
                }
                if (done) continue;
                long currentLogTime = System.currentTimeMillis();
                if (currentLogTime - logStartTime > 10000L) {
                    logStartTime = currentLogTime;
                    logInfo = true;
                    continue;
                }
                logInfo = false;
            } while (!done);
            if (!badJobHash.isEmpty()) {
                childJobs = this.getAbstractJobImpls();
                iter = childJobs.iterator();
                while (iter.hasNext()) {
                    AbstractJobImpl childJob = iter.next();
                    String msg = (String)badJobHash.get(childJob.hashCode());
                    if (null == msg) continue;
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                }
            }
            if (!pairValList.isEmpty()) {
                String msg;
                ArrayList<Robj_interface_MRCFsetQSPairDetail2> pairDetailList = new ArrayList<Robj_interface_MRCFsetQSPairDetail2>();
                try {
                    for (PairVals pairVal : pairValList) {
                        Robj_interface_MRCFsetQSPairDetail2 setPairDetail = (Robj_interface_MRCFsetQSPairDetail2)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.MRCFSETQSPAIRDETAIL2);
                        setPairDetail.setRobjPVolIndex(ProviderLibs.getRJiLDEVIndex(rmiObj, pairVal.getDNPVol()));
                        setPairDetail.setRobjSVolIndex(ProviderLibs.getRJiLDEVIndex(rmiObj, pairVal.getDNSVol()));
                        setPairDetail.setSCmdKind((short)2);
                        setPairDetail.setSPairKind((short)0);
                        setPairDetail.setSMuNum(pairVal.getMUNum());
                        setPairDetail.setSPoolId(pairVal.getPoolID());
                        setPairDetail.setSSnapshotKind((short)1);
                        setPairDetail.setSCmdOpt((short)2);
                        if (CreateElementReplica.TypeOfReplica.FastClone == this.typeOfOperation) {
                            ((Robj_interface_MRCFsetQSPairDetail3)setPairDetail).setBCascade(true);
                            ((Robj_interface_MRCFsetQSPairDetail3)setPairDetail).setBClone(true);
                        }
                        pairDetailList.add(setPairDetail);
                    }
                    if (!pairDetailList.isEmpty()) {
                        Robj_interface_MRCFsetQSPairDetail2[] pairDetailArray = pairDetailList.toArray(new Robj_interface_MRCFsetQSPairDetail2[pairDetailList.size()]);
                        Robj_interface_MRCFsetQSPairMain2 qsPairMain = (Robj_interface_MRCFsetQSPairMain2)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.MRCFSETQSPAIRMAIN);
                        qsPairMain.setQSPairDetail2(pairDetailArray);
                        qsPairMain.setIPairNum(pairDetailArray.length);
                        ret = (Robj_interface_MRCFsetQSPairInfo2_IN)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.MRCFSETQSPAIRINFO_IN);
                        ret.setQSPairMain2(qsPairMain);
                    }
                }
                catch (SANRmiException sre) {
                    msg = "Job " + this.getJob().getInstanceID() + ": Exception communicating with backend: " + sre.getErrMsgEn();
                    mLogger.log(Level.SEVERE, msg, sre);
                    throw new WBEMException(1, msg, null, (Throwable)sre);
                }
                catch (RemoteException re) {
                    msg = "Job " + this.getJob().getInstanceID() + ": Remote Exception with backend: " + re;
                    mLogger.log(Level.SEVERE, msg, re);
                    throw new WBEMException(1, msg, null, (Throwable)re);
                }
            }
        }
        if (null == ret) {
            String msg = "Job " + this.getJob().getInstanceID() + ": CoalescedCreateElementReplica." + "createSetQSPairInfoINObjectSplitPair: " + "Could not create valid Robj_interface_MRCFsetQSPairInfo_IN" + "object with any of the specified P-Vols";
            mLogger.log(Level.SEVERE, msg);
            throw new WBEMException(msg);
        }
        return ret;
    }

    private void doNormalSnapShot() throws WBEMException {
        Hashtable<String, DeviceNumber> sVolDNHash = new Hashtable<String, DeviceNumber>();
        Robj_interface_MRCFsetQSPairInfo2_IN rmiPairInfoIN = this.createSetQSPairInfoINObjectSetPair(sVolDNHash);
        LinkedList<Robj_interface_MRCFsetQSPairInfo2_IN> rmiAction = new LinkedList<Robj_interface_MRCFsetQSPairInfo2_IN>();
        rmiAction.add(rmiPairInfoIN);
        this.setItemQueue(rmiAction);
        this.apply2(false);
        Robj_interface_MRCFsetQSPairInfo2_OUT pairInfoOut = (Robj_interface_MRCFsetQSPairInfo2_OUT)this.getResult();
        Robj_interface_MRCFsetQSPairMain2 pairMain = pairInfoOut.getQSPairMain2();
        if (pairMain.getIResult() != 0) {
            throw new WBEMException("Result from apply2 method was: " + pairMain.getIResult() + " when creating snapshot pairs " + " but a value of 0 was expected");
        }
        this.getHitachiJobServiceObject().updateServerJobPercentComplete(50, true);
        this.updateChildrenJobPercentComplete(50);
        rmiPairInfoIN = this.createSetQSPairInfoINObjectSplitPair(sVolDNHash);
        rmiAction = new LinkedList();
        rmiAction.add(rmiPairInfoIN);
        this.setItemQueue(rmiAction);
        this.apply2(false);
        pairInfoOut = (Robj_interface_MRCFsetQSPairInfo2_OUT)this.getResult();
        pairMain = pairInfoOut.getQSPairMain2();
        if (pairMain.getIResult() != 0) {
            throw new WBEMException("Result from apply2 method was: " + pairMain.getIResult() + " when splitting pairs but a " + "value of 0 was expected");
        }
        this.getHitachiJobServiceObject().updateServerJobPercentComplete(75, true);
        this.updateChildrenJobPercentComplete(75);
        this.validateSplitPairs(sVolDNHash);
        this.doStepCompleteNotification(HitachiJobCallbackIF2.StepCompleted.AFTER_STEP_1);
    }

    private void doSnapOnSnap() throws WBEMException {
        Hashtable<String, DeviceNumber> sVolDNHash = new Hashtable<String, DeviceNumber>();
        Robj_interface_MRCFsetQSPairInfo2_IN rmiPairInfoIN = this.createSetQSPairInfoINObjectSetPair(sVolDNHash);
        LinkedList<Robj_interface_MRCFsetQSPairInfo2_IN> rmiAction = new LinkedList<Robj_interface_MRCFsetQSPairInfo2_IN>();
        rmiAction.add(rmiPairInfoIN);
        this.setItemQueue(rmiAction);
        this.apply2(false);
        Robj_interface_MRCFsetQSPairInfo2_OUT pairInfoOut = (Robj_interface_MRCFsetQSPairInfo2_OUT)this.getResult();
        Robj_interface_MRCFsetQSPairMain2 pairMain = pairInfoOut.getQSPairMain2();
        if (pairMain.getIResult() != 0) {
            throw new WBEMException("Result from apply2 method was: " + pairMain.getIResult() + " when creating snapshot pairs " + " but a value of 0 was expected");
        }
        this.getHitachiJobServiceObject().updateServerJobPercentComplete(50, true);
        this.updateChildrenJobPercentComplete(50);
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
        ArrayList<DeviceNumber> dns = new ArrayList<DeviceNumber>(sVolDNHash.values());
        boolean isAllStatusSame = false;
        int count = 0;
        while (!isAllStatusSame) {
            try {
                isAllStatusSame = SnapshotInfo2.doAllPairsHaveStatus(rmiObj, dns, 544);
                if (isAllStatusSame) continue;
                if (0 == count % 1000) {
                    ++count;
                    mLogger.log(Level.INFO, "Job {0}: Not all snapshots have been paired, will waiti and retry.", this.getJob().getInstanceID());
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                throw new WBEMException(1, this.getClass().getSimpleName() + " was interuppted!", null, (Throwable)ie);
            }
        }
        rmiPairInfoIN = this.createSetQSPairInfoINObjectSplitPair(sVolDNHash);
        rmiAction = new LinkedList();
        rmiAction.add(rmiPairInfoIN);
        this.setItemQueue(rmiAction);
        this.apply2(false);
        pairInfoOut = (Robj_interface_MRCFsetQSPairInfo2_OUT)this.getResult();
        pairMain = pairInfoOut.getQSPairMain2();
        if (pairMain.getIResult() != 0) {
            throw new WBEMException("Result from apply2 method was: " + pairMain.getIResult() + " when splitting pairs but a " + "value of 0 was expected");
        }
        this.getHitachiJobServiceObject().updateServerJobPercentComplete(75, true);
        this.updateChildrenJobPercentComplete(75);
        this.validateSplitPairs(sVolDNHash);
        this.doStepCompleteNotification(HitachiJobCallbackIF2.StepCompleted.AFTER_STEP_1);
    }

    @Override
    protected void executeJob(List<AbstractJobImpl> abstractItems) throws WBEMException {
        this.setAbstractJobImpls(abstractItems);
        this.createConcreteJobFromAbstractJobs();
        mLogger.log(Level.INFO, "Job {0}: CoalescedJob starting", this.getJob().getInstanceID());
        this.markServerJobStarted(10);
        CreateElementReplica t = (CreateElementReplica)abstractItems.get(0);
        this.typeOfOperation = t.getReplicaType();
        switch (this.typeOfOperation) {
            case Snapshot: {
                this.doNormalSnapShot();
                break;
            }
            case Snap2Snap: {
                this.doSnapOnSnap();
                break;
            }
            case FastClone: {
                this.doSnapOnSnap();
                break;
            }
            default: {
                throw new WBEMException("Unknown replica type - " + (Object)((Object)t.getReplicaType()));
            }
        }
        this.changeSVolNames();
        this.markServerJobDone();
    }

    public String getClientIP() {
        return this.clientIP;
    }

    private DeviceNumber getDPVolume(DeviceNumber pVolDN, ThinPool thePool, CIMObjectPath targetGoal, List<DeviceNumber> dns, Set<String> ignoreDNNumbers, ProviderHandle providerHandle) throws WBEMException {
        DeviceNumber ret = null;
        List<Object> usableDNs = new ArrayList();
        if (null != pVolDN) {
            for (DeviceNumber dn : dns) {
                if (dn.getDn() == pVolDN.getDn() || !dn.isAOUVol() || thePool.getPoolID() != dn.getThinPoolID() || dn.getNumOfKBytes() != pVolDN.getNumOfKBytes() || !ResourceRestriction.isVolumeUsageUsable(dn) || null != ignoreDNNumbers && ignoreDNNumbers.contains(dn.getDNAsString())) continue;
                SnapshotInfo2 ssi2 = SnapshotInfo2.find(dn);
                if (null != ssi2 && !ssi2.isCascade()) {
                    mLogger.log(Level.FINE, "Job " + this.getJob().getInstanceID() + ": Volume {0} is in a non-cascaded pair, " + "skipping as that is not compatible " + "with 'Snap on Snap'", dn.getDn());
                    continue;
                }
                if (ProviderLibs.checkSettingGoal(targetGoal, dn, providerHandle)) {
                    usableDNs.add(dn);
                    continue;
                }
                mLogger.log(Level.INFO, "Job {0}: Target volume with ID {1} does not match the passed in goal {2}", new Object[]{this.getJob().getInstanceID(), dn.getDNAsString(), targetGoal});
            }
        }
        mLogger.log(Level.FINER, "Job {0}: Found {1} available DNs: {2}", new Object[]{this.getJob().getInstanceID(), usableDNs.size(), usableDNs});
        if (!usableDNs.isEmpty()) {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
            MRCFreadTiPairOfSecondaryVolumes req1 = new MRCFreadTiPairOfSecondaryVolumes(rmiObj, this.getClientIP());
            req1.addDNs(usableDNs);
            usableDNs = req1.getUnpairedDNs();
            if (!usableDNs.isEmpty()) {
                mLogger.log(Level.FINER, "Job {0}: Found {1} unpaired DNs: {2}", new Object[]{this.getJob().getInstanceID(), usableDNs.size(), usableDNs});
                MRCFreadSnapshotRootLdevInfo req2 = new MRCFreadSnapshotRootLdevInfo(rmiObj, this.clientIP);
                req2.addDNs(usableDNs);
                usableDNs = req2.getUsableNonRootLDEVs();
                mLogger.log(Level.FINER, "Job {0}: Found {1} unused DNs: {2}", new Object[]{this.getJob().getInstanceID(), usableDNs.size(), usableDNs});
                if (!usableDNs.isEmpty()) {
                    ret = (DeviceNumber)usableDNs.get(0);
                }
            }
        }
        return ret;
    }

    private short getMUNumber(short pairKind, String pvolDNString, Set<Short> assignedMUSet) throws WBEMException {
        short ret = 0;
        ClosableAddableIteratorCB<SnapshotInfo2> callback = new ClosableAddableIteratorCB<SnapshotInfo2>();
        SnapshotInfo2.getSnapshotInfo2(RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject(), callback, pvolDNString, Boolean.TRUE);
        HashSet<Short> usedMUset = new HashSet<Short>();
        CloseableAddableIterator<SnapshotInfo2> snapshotInfos = callback.getWrappedCloseableAddableIter();
        callback = null;
        while (snapshotInfos.hasNext()) {
            usedMUset.add((short)((SnapshotInfo2)snapshotInfos.next()).getMirrorUnit());
        }
        for (short i = 0; i < 1024; i = (short)(i + 1)) {
            Short shortVal = new Short(i);
            if (usedMUset.contains(shortVal) || assignedMUSet.contains(shortVal)) continue;
            ret = i;
            assignedMUSet.add(shortVal);
            break;
        }
        return ret;
    }

    private synchronized void getRestrictionData() {
        try {
            String temp;
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
            if (null == usableSVols && null != (temp = rmiObj.getSMISDeviceRestrictedVVolForSnapshot())) {
                usableSVols = SnapshotRestriction.parseLDEVStr(temp);
            }
            if (null == usableSnapshotPools && null != (temp = rmiObj.getSMISDeviceRestrictedPoolString())) {
                usableSnapshotPools = SnapshotRestriction.parsePoolIDStr(temp);
            }
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Job " + this.getJob().getInstanceID() + ": Unexpected exception getting Snapshot" + " restriction information", e);
        }
    }

    private DeviceNumber getSnapshotVolume(DeviceNumber pVolDN, CIMObjectPath targetGoal, List<DeviceNumber> dns, Set<String> ignoreDNNumbers, ProviderHandle providerHandle) throws WBEMException {
        DeviceNumber ret = null;
        if (null != pVolDN) {
            for (DeviceNumber dn : dns) {
                if (!dn.hasPaths() || dn.getNumOfKBytes() != pVolDN.getNumOfKBytes() || null != ignoreDNNumbers && ignoreDNNumbers.contains(dn.getDNAsString()) || !SnapshotInfo2.isVolumeUnpaired(dn, Boolean.FALSE)) continue;
                SnapshotInfo2 ssi2 = SnapshotInfo2.find(dn);
                if (null != ssi2 && ssi2.isCascade()) {
                    mLogger.log(Level.FINE, "Job {0}: Volume {0} is in a cascaded pair, skipping as that is not compatible with 'normal snapshots'", new Object[]{this.getJob().getInstanceID(), dn.getDn()});
                    continue;
                }
                if (ProviderLibs.checkSettingGoal(targetGoal, dn, providerHandle)) {
                    boolean ok2Use = SnapshotRestriction.valid2UseSnapshot(usableSVols, dn.getDn());
                    if (ok2Use) {
                        ret = dn;
                        break;
                    }
                    mLogger.log(Level.INFO, "Job {0}: Target volume with ID {1} is restricted", new Object[]{this.getJob().getInstanceID(), dn.getDNAsString()});
                    continue;
                }
                mLogger.log(Level.INFO, "Job {0}: Target volume with ID {1} does not match the passed in goal {2}", new Object[]{this.getJob().getInstanceID(), dn.getDNAsString(), targetGoal});
            }
        }
        return ret;
    }

    private void setChildAffectedElement(AbstractJobImpl childJob, DeviceNumber sVal) {
        CIMObjectPath[] affectedElements = new CIMObjectPath[1];
        if (null != sVal) {
            try {
                CIMObjectPath opSyncedElement;
                StorageVolumeInstrumentation svi = (StorageVolumeInstrumentation)BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation");
                affectedElements[0] = opSyncedElement = svi.generateObjectPath(this.getOwningElement(), sVal);
            }
            catch (WBEMException e) {
                mLogger.log(Level.SEVERE, "Job {0}: Failed to generate objectpath for StorageVolume with a DeviceID of: {1}. Cannot set affected element for child job {2}.", new Object[]{this.getJob().getInstanceID(), sVal.getDNAsString(), null != childJob.getJob() ? childJob.getJob().getInstanceID() : "UNKNOWN"});
            }
        }
        childJob.setAffectedElements(affectedElements);
    }

    private boolean setPoolID(RMIObjectCache rmiObj, DeviceNumber dnPVol, Robj_interface_MRCFsetQSPairDetail2 setPairDetail) {
        ClosableAddableIteratorCB<SnapshotInfo2> callback;
        Short poolID = null;
        boolean ret = false;
        try {
            callback = new ClosableAddableIteratorCB<SnapshotInfo2>();
            SnapshotInfo2.getSnapshotInfo2(rmiObj, callback, dnPVol.getDNAsString(), Boolean.TRUE);
            CloseableAddableIterator<SnapshotInfo2> snapshotIter = callback.getWrappedCloseableAddableIter();
            callback = null;
            while (snapshotIter.hasNext()) {
                short tPoolID;
                boolean ok2Use;
                SnapshotInfo2 snapshotInfo = (SnapshotInfo2)snapshotIter.next();
                ThinPool tp = ThinPool.find(rmiObj, (short)snapshotInfo.getTiPoolID(), ThinPool.ThinPoolType.AOU);
                if (null == tp) {
                    mLogger.log(Level.INFO, "Job {0}: Can not find pool with ID {1}", new Object[]{this.getJob().getInstanceID(), snapshotInfo.getTiPoolID()});
                    break;
                }
                if (8 != tp.getByPoolKind() || !(ok2Use = SnapshotRestriction.valid2UseSnapshotPool(usableSnapshotPools, tPoolID = (short)snapshotInfo.getTiPoolID()))) continue;
                poolID = tPoolID;
            }
        }
        catch (WBEMException we) {
            mLogger.log(Level.SEVERE, "Job " + this.getJob().getInstanceID() + ": Caught WBEMException retrieving SnapshotInfo2 object for " + "pVol with DN of " + dnPVol.getDNAsString(), we);
        }
        if (null == poolID) {
            try {
                callback = new ClosableAddableIteratorCB();
                ThinPool.getThinPools(rmiObj, callback, (short)-1, false);
                CloseableAddableIterator<SnapshotInfo2> snapPoolIter = callback.getWrappedCloseableAddableIter();
                callback = null;
                long largestAvailPoolSpace = 0L;
                while (snapPoolIter.hasNext()) {
                    Long availSpace;
                    ThinPool pool = (ThinPool)snapPoolIter.next();
                    short tPoolID = pool.getPoolID();
                    if (!SnapshotRestriction.valid2UseSnapshotPool(usableSnapshotPools, tPoolID) || (0 != setPairDetail.getSSnapshotKind() || 1 != pool.getByPoolKind()) && (1 != setPairDetail.getSSnapshotKind() || 8 != pool.getByPoolKind()) || (availSpace = Long.valueOf(pool.getPoolCapa() - pool.getPoolUsed())) <= largestAvailPoolSpace) continue;
                    largestAvailPoolSpace = availSpace;
                    poolID = tPoolID;
                    ret = true;
                }
            }
            catch (WBEMException e) {
                mLogger.log(Level.SEVERE, "Job " + this.getJob().getInstanceID() + ": Caught WBEMException trying to " + "get Snapshot pools: " + e.getMessage(), e);
            }
        } else {
            mLogger.log(Level.SEVERE, "Job " + this.getJob().getInstanceID() + ": Could not find valid poolID");
            ret = false;
        }
        if (ret && null != poolID) {
            setPairDetail.setSPoolId(poolID.shortValue());
        } else {
            mLogger.log(Level.SEVERE, "Job " + this.getJob().getInstanceID() + ": Function indicates it found a poolID but it is null");
            ret = false;
        }
        return ret;
    }

    private void validateSplitPairs(Hashtable<String, DeviceNumber> sVolLDevHash) throws WBEMException {
        ArrayList<DeviceNumber> sVolList = new ArrayList<DeviceNumber>();
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
        List<AbstractJobImpl> childJobs = this.getAbstractJobImpls();
        Hashtable<String, Integer> childJobBySVolHash = new Hashtable<String, Integer>();
        Hashtable<Integer, DeviceNumber> sVolByChildJobHash = new Hashtable<Integer, DeviceNumber>();
        SetResourceNameHelper helper = new SetResourceNameHelper(Integer.parseInt(this.getDeviceSerialNumber()));
        Iterator<AbstractJobImpl> iter = childJobs.iterator();
        while (iter.hasNext()) {
            AbstractJobImpl childJob = iter.next();
            String jobID = childJob.getJob().getInstanceID();
            DeviceNumber dnSVol = sVolLDevHash.get(jobID);
            if (null == dnSVol) {
                String msg = "Could not find sVol in hash with key " + jobID + ", hash: " + sVolLDevHash;
                this.markAndRemoveChildJobWithError(iter, childJob, msg);
                continue;
            }
            String sVolDNString = dnSVol.getDNAsString();
            childJobBySVolHash.put(sVolDNString, childJob.hashCode());
            sVolByChildJobHash.put(childJob.hashCode(), dnSVol);
            sVolList.add(dnSVol);
        }
        if (!sVolList.isEmpty()) {
            AbstractJobImpl childJob;
            long WAIT_TIME = 1800000L;
            long startTime = System.currentTimeMillis();
            long END_WAIT_TIME = startTime + 1800000L;
            boolean done = true;
            Hashtable<String, PairVals> pairValsHash = new Hashtable<String, PairVals>();
            Hashtable<Integer, String> badJobHash = new Hashtable<Integer, String>();
            long logStartTime = System.currentTimeMillis();
            boolean logInfo = true;
            do {
                if (!done) {
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (InterruptedException ie) {
                        throw new WBEMException(1, "Job " + this.getJob().getInstanceID() + " validateSplitPairs: Interuppted during wait!", null, (Throwable)ie);
                    }
                }
                done = true;
                CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                SnapshotInfo2.getSnapshotInfo2(rmiObj, callback, sVolList, Boolean.FALSE);
                LinkedList<SnapshotInfo2> snapshotInfos = callback.getReturnValue();
                done = CreateElementReplica.TypeOfReplica.FastClone != this.typeOfOperation ? this.checkStatus4NormalOrSnap2Snap(snapshotInfos, pairValsHash, sVolList, childJobBySVolHash, badJobHash, logInfo) : this.checkStatus4FastClone(snapshotInfos, pairValsHash, sVolList, childJobBySVolHash, badJobHash, logInfo);
                if (sVolList.isEmpty()) {
                    done = true;
                }
                if (done) continue;
                long currentTime = System.currentTimeMillis();
                if (currentTime - logStartTime > 10000L) {
                    logStartTime = currentTime;
                    logInfo = true;
                } else {
                    logInfo = false;
                }
                if (currentTime <= END_WAIT_TIME) continue;
                mLogger.log(Level.SEVERE, "Job {0} validateSplitPairs: timed out waiting for status update for volumes {1}", sVolList);
                String msg = String.format("Job %s validateSplitPairs: Waited %d minutes for status update which has not happened", this.getJob().getInstanceID(), 30L);
                throw new WBEMException(msg);
            } while (!done);
            if (!badJobHash.isEmpty()) {
                childJobs = this.getAbstractJobImpls();
                iter = childJobs.iterator();
                while (iter.hasNext()) {
                    childJob = iter.next();
                    String msg = badJobHash.get(childJob.hashCode());
                    if (null == msg) continue;
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                }
            }
            if (!pairValsHash.isEmpty()) {
                childJobs = this.getAbstractJobImpls();
                iter = childJobs.iterator();
                while (iter.hasNext()) {
                    childJob = (CreateElementReplica)iter.next();
                    DeviceNumber dnSVol = (DeviceNumber)sVolByChildJobHash.get(childJob.hashCode());
                    if (null == dnSVol) {
                        DeviceNumber dnPVol = (DeviceNumber)childJob.getActionItem();
                        String dnNum = dnPVol != null ? dnPVol.getDNAsString() : "null";
                        String msg = "Could not get sVol for job with pVol:" + dnNum;
                        this.markAndRemoveChildJobWithError(iter, childJob, msg);
                        continue;
                    }
                    PairVals pairVals = pairValsHash.get(dnSVol.getDNAsString());
                    if (null == pairVals) {
                        String msg = "Could not get Pair Values for volume:" + dnSVol.getDNAsString();
                        this.markAndRemoveChildJobWithError(iter, childJob, msg);
                        continue;
                    }
                    ElementNameData data = new ElementNameData(dnSVol, ((CreateElementReplica)childJob).getElementName());
                    this.elementNames.add(helper.getResourceNameRMIobject(data));
                }
            }
        }
    }

    private class PairVals {
        DeviceNumber mDNPVol;
        DeviceNumber mDNSVol;
        short mMUNum;
        short mPoolID;

        public PairVals(DeviceNumber pDNPVol, DeviceNumber pDNSVol, short pMUNum, short pPoolID) {
            this.mDNPVol = pDNPVol;
            this.mDNSVol = pDNSVol;
            this.mMUNum = pMUNum;
            this.mPoolID = pPoolID;
        }

        public DeviceNumber getDNPVol() {
            return this.mDNPVol;
        }

        public DeviceNumber getDNSVol() {
            return this.mDNSVol;
        }

        public short getMUNum() {
            return this.mMUNum;
        }

        public short getPoolID() {
            return this.mPoolID;
        }
    }
}

