/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.CoalescedCreateModifyVolumeBase;
import com.hitachi.smi.jobs.CreateModifyNormalVolume;
import com.hitachi.smi.jobs.ElementNameData;
import com.hitachi.smi.jobs.SetResourceNameHelper;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_SetQuickFormat;
import sanproject.serverux.data.SANRmiException;

public class CoalescedCreateModifyNormalVolume
extends CoalescedCreateModifyVolumeBase {
    private final Queue<Robj_interface_SetQuickFormat> formatJobs = new LinkedList<Robj_interface_SetQuickFormat>();

    private void addFormatJob(RMIObjectCache rmiobj, int dkcNum, int cuNum, int ldevNum) throws RemoteException, SANRmiException {
        Robj_interface_SetQuickFormat qf = (Robj_interface_SetQuickFormat)rmiobj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.SETQUICKFORMAT);
        Robj_interface_RJiLDEVIndex ldev = (Robj_interface_RJiLDEVIndex)rmiobj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJILDEVINDEX);
        ldev.setSCU((short)cuNum);
        ldev.setSLDEV((short)ldevNum);
        ldev.setSLDKC((short)dkcNum);
        qf.setIInstruct(0);
        qf.setObjLDEVIndex(new Robj_interface_RJiLDEVIndex[]{ldev});
        this.formatJobs.add(qf);
    }

    private void checkIndividualLDEVs(RMIObjectCache rmiObj, SanList response) throws WBEMException, SanDataException {
        Iterator<AbstractJobImpl> childIter = this.getAbstractJobImpls().iterator();
        SetResourceNameHelper helper = new SetResourceNameHelper(rmiObj);
        int x = -1;
        while (childIter.hasNext()) {
            boolean childError = false;
            CreateModifyNormalVolume child = (CreateModifyNormalVolume)childIter.next();
            Object vols = child.getActionItem();
            Iterator i$ = vols.iterator();
            while (i$.hasNext()) {
                SanObject result;
                SanObject errorInfo;
                int errorCode;
                CreateModifyNormalVolume.CreateNormalVolumeData vol = (CreateModifyNormalVolume.CreateNormalVolumeData)i$.next();
                if (childError) {
                    ++x;
                    continue;
                }
                if (0 == (errorCode = (errorInfo = (result = response.getObj(++x)).getObj("ErrorInfo")).getInt("ErrorCode"))) {
                    int[] ldevInfo = result.getIntArray("Id");
                    long dn = BaseDeviceNumber.makeUniqueDN((short)ldevInfo[0], (short)ldevInfo[1], (short)ldevInfo[2]);
                    vol.setCreatedDNStr(Long.toString(dn));
                    try {
                        this.addFormatJob(rmiObj, ldevInfo[0], ldevInfo[1], ldevInfo[2]);
                    }
                    catch (RemoteException | SANRmiException e) {
                        mLogger.log(Level.SEVERE, "Unable to format Volume " + dn, e);
                    }
                    this.elementNames.add(this.getResourceNameRMIObject(helper, (short)ldevInfo[1], (short)ldevInfo[2], vol.getElementName()));
                    continue;
                }
                int[] msgID = errorInfo.getIntArray("MessageId");
                String msg = String.format("ErrorCode: %d, Message: %d-%d", msgID[0], msgID[0], msgID[1]);
                child.setError(new Throwable(msg));
                childError = true;
            }
        }
    }

    private Queue<SanData> createRMIObjects(RMIObjectCache rmiObj, SanRemote sanRemote) throws WBEMException {
        LinkedList<SanData> ret = new LinkedList<SanData>();
        try {
            ArrayList<CIMObjectPath> affectedElements = new ArrayList<CIMObjectPath>();
            SanData generalParam = null;
            SanRequest sanrequest = null;
            SanList ldevs = null;
            int x = 0;
            Iterator<AbstractJobImpl> iter = this.getAbstractJobImpls().iterator();
            while (iter.hasNext()) {
                AbstractJobImpl childJob = iter.next();
                if (!(childJob instanceof CreateModifyNormalVolume)) {
                    String msg = "Expected all elements of the list to contain instances of CreateModifyNormalVolume, however this job had a " + childJob.getClass().getSimpleName();
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                    continue;
                }
                if (0 == x) {
                    try {
                        generalParam = rmiObj.keyValueAPI_GetStorageInfoParam(sanRemote, childJob.getClientIP());
                        sanrequest = sanRemote.newRequest(generalParam, "MNTcreateLdevs");
                        ldevs = sanrequest.newList("Ldevs");
                        if (null == ldevs) {
                            throw new SanDataException("SanRequest.newList failed");
                        }
                    }
                    catch (SanDataException | SanRmiException e) {
                        Throwable t = e;
                        while (null != t.getCause()) {
                            t = t.getCause();
                        }
                        throw new WBEMException(1, "Error getting key/value objects", null, t);
                    }
                }
                CreateModifyNormalVolume child = (CreateModifyNormalVolume)childJob;
                Object datas = child.getActionItem();
                childJob.setResultIndex(x);
                Iterator i$ = datas.iterator();
                while (i$.hasNext()) {
                    CreateModifyNormalVolume.CreateNormalVolumeData data = (CreateModifyNormalVolume.CreateNormalVolumeData)i$.next();
                    short[] cuLDev = this.getCULdev(rmiObj, data.getEmulationType());
                    if (-1 == cuLDev[0] || -1 == cuLDev[1]) {
                        this.markAndRemoveChildJobWithError(iter, childJob, "Failed to find an available CU/LDEV");
                        continue;
                    }
                    try {
                        SanObject ldev = ldevs.addObj();
                        ldev.putIntArray("Id", new int[]{0, cuLDev[0], cuLDev[1]});
                        ChassisArrayGroup cag = data.getChassisArrayGroup();
                        ldev.putIntArray("ParityGroupId", new int[]{cag.getFb4(), cag.getPg()});
                        ldev.putInt("EmulationType", 625);
                        long blockSize = cag.getBlockSize().longValue();
                        long sizeInBytes = data.getSize();
                        long numBlocks = sizeInBytes / blockSize;
                        if (0L != sizeInBytes % 2L) {
                            ++numBlocks;
                        }
                        mLogger.log(Level.FINE, "Converted {0} bytes to {1} blocks", new Object[]{sizeInBytes, numBlocks});
                        ldev.putLong("Capacity", numBlocks);
                    }
                    catch (SanDataException e) {
                        Throwable t = e;
                        while (null != t.getCause()) {
                            t = t.getCause();
                        }
                        throw new WBEMException(1, "Error getting key/value object for LDEV", null, t);
                    }
                    ++x;
                }
                affectedElements.add(childJob.getJob().getCIMObjectPath(this.getOwningElement()));
            }
            this.setAffectedElements(affectedElements);
            ret.offer(generalParam);
            ret.offer((SanData)sanrequest);
        }
        catch (RemoteException re) {
            String msg = "Remote Exception with backend: " + re;
            mLogger.log(Level.SEVERE, msg, re);
            throw new WBEMException(1, msg, null, (Throwable)re);
        }
        return ret;
    }

    private void doCreateLDEVs() throws WBEMException {
        SanRemote sanRemote;
        mLogger.log(Level.INFO, "Job {0} is now creating volume(s).", this.getJob().getInstanceID());
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber());
        RMIObjectCache rmiObj = device.getRMIObject();
        try {
            sanRemote = rmiObj.keyValueAPI_GetSanRemote();
        }
        catch (NotBoundException | RemoteException e) {
            Throwable t = e;
            while (null != t.getCause()) {
                t = t.getCause();
            }
            throw new WBEMException(1, "Error getting SanRemote object", null, t);
        }
        Queue<SanData> rmiObjects = this.createRMIObjects(rmiObj, sanRemote);
        SanResponse response = this.invoke(rmiObj, rmiObjects.poll(), (SanRequest)rmiObjects.poll(), sanRemote);
        try {
            if (0 != response.errorCode()) {
                SanObject errorInfo = response.getObj("ErrorInfo");
                int[] message = errorInfo.getIntArray("MessageId");
                String msg = String.format("Creating LDEVs failed with code %d, message %d-%d", response.errorCode(), message[0], message[1]);
                throw new WBEMException(msg);
            }
            this.getHitachiJobServiceObject().updateServerJobPercentComplete(33, true);
            this.updateChildrenJobPercentComplete(25);
            this.checkIndividualLDEVs(rmiObj, response.getList("Ldevs"));
        }
        catch (SanDataException e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    private void doElementName() throws WBEMException {
        mLogger.log(Level.INFO, "Job {0} is now setting the volume name(s).", this.getJob().getInstanceID());
        this.getHitachiJobServiceObject().updateServerJobPercentComplete(99, true);
        this.updateChildrenJobPercentComplete(75);
        try {
            ElementNameData.changeElementNames(this, this.elementNames);
        }
        catch (Throwable t) {
            while (null != t.getCause()) {
                t = t.getCause();
            }
            mLogger.log(Level.WARNING, "Naming newly created volumes failed", t);
        }
    }

    private void doFormatJob() {
        mLogger.info("Job " + this.getJob().getInstanceID() + " is now formatting created volume(s).");
        this.getHitachiJobServiceObject().updateServerJobPercentComplete(66, true);
        this.updateChildrenJobPercentComplete(50);
        this.setItemQueue(this.formatJobs);
        try {
            this.apply(false);
        }
        catch (Throwable t) {
            while (null != t.getCause()) {
                t = t.getCause();
            }
            mLogger.log(Level.WARNING, "Formatting newly created volumes failed", t);
        }
    }

    @Override
    protected void executeJob(List<AbstractJobImpl> actionItems) throws WBEMException {
        this.setAbstractJobImpls(actionItems);
        this.createConcreteJobFromAbstractJobs();
        mLogger.log(Level.INFO, "CoalescedJob {0} starting", this.getJob().getInstanceID());
        this.markServerJobStarted(0);
        this.doCreateLDEVs();
        this.doFormatJob();
        this.doElementName();
        this.markServerJobDone();
    }
}

