/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.CoalescedCreateModifyVolumeBase;
import com.hitachi.smi.jobs.CreateModifyThinVolume;
import com.hitachi.smi.jobs.ElementNameData;
import com.hitachi.smi.jobs.HitachiJobCallbackIF2;
import com.hitachi.smi.jobs.SetResourceNameHelper;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_AOUAddVvol;
import sanproject.common.Robj_interface_AOUsetAddVvol_IN;
import sanproject.serverux.data.SANRmiException;

public class CoalescedCreateModifyThinVolume
extends CoalescedCreateModifyVolumeBase {
    private Robj_interface_AOUsetAddVvol_IN createAOUsetAddVvolIN() throws WBEMException {
        Robj_interface_AOUsetAddVvol_IN setAddVvol = null;
        try {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
            ArrayList<CIMObjectPath> affectedElements = new ArrayList<CIMObjectPath>();
            setAddVvol = (Robj_interface_AOUsetAddVvol_IN)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.SETAOUADDVVOL_IN);
            SetResourceNameHelper helper = new SetResourceNameHelper(rmiObj);
            int x = 0;
            Iterator<AbstractJobImpl> iter = this.getAbstractJobImpls().iterator();
            while (iter.hasNext()) {
                AbstractJobImpl childJob = iter.next();
                if (!(childJob instanceof CreateModifyThinVolume)) {
                    String msg = "Expected all elements of the list to contain instances of CreateModifyThinVolume, however this instance was a " + childJob.getClass().getSimpleName();
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                    continue;
                }
                CreateModifyThinVolume child = (CreateModifyThinVolume)childJob;
                Object datas = child.getActionItem();
                child.setResultIndex(x);
                Iterator i$ = datas.iterator();
                while (i$.hasNext()) {
                    CreateModifyThinVolume.CreateThinVolumeData data = (CreateModifyThinVolume.CreateThinVolumeData)i$.next();
                    short[] cuLDev = this.getCULdev(rmiObj, data.getEmulationType());
                    if (-1 == cuLDev[0] || -1 == cuLDev[1]) {
                        this.markAndRemoveChildJobWithError(iter, childJob, "Unable to find an available CU or LDEV");
                        continue;
                    }
                    this.setVirtualVolumeObject(cuLDev[0], cuLDev[1], setAddVvol, data, childJob);
                    this.elementNames.add(this.getResourceNameRMIObject(helper, cuLDev[0], cuLDev[1], data.getElementName()));
                    ++x;
                }
                affectedElements.add(child.getJob().getCIMObjectPath(this.getOwningElement()));
            }
            this.setAffectedElements(affectedElements);
        }
        catch (SANRmiException sre) {
            String msg = "Exception communicating with backend: " + sre.getErrMsgEn();
            mLogger.log(Level.SEVERE, msg, sre);
            throw new WBEMException(1, msg, null, (Throwable)sre);
        }
        catch (RemoteException re) {
            String msg = "Remote Exception with backend: " + re;
            mLogger.log(Level.SEVERE, msg, re);
            throw new WBEMException(1, msg, null, (Throwable)re);
        }
        return setAddVvol;
    }

    private void doCreateVolumesStep() throws WBEMException {
        mLogger.log(Level.INFO, "Job {0} is now creating volume(s).", this.getJob().getInstanceID());
        Robj_interface_AOUsetAddVvol_IN rmiCreateObject = this.createAOUsetAddVvolIN();
        LinkedList<Robj_interface_AOUsetAddVvol_IN> rmiAction = new LinkedList<Robj_interface_AOUsetAddVvol_IN>();
        rmiAction.add(rmiCreateObject);
        this.setItemQueue(rmiAction);
        this.getHitachiJobServiceObject().updateServerJobPercentComplete(66, true);
        this.updateChildrenJobPercentComplete(66);
        this.apply2(false);
        List<Integer> failedJobs = this.doStepCompleteNotification(HitachiJobCallbackIF2.StepCompleted.AFTER_STEP_1);
        if (0 != failedJobs.size()) {
            Collections.reverse(failedJobs);
            for (Integer index : failedJobs) {
                this.elementNames.remove(index);
            }
        }
    }

    private void doElementNameStep() throws WBEMException {
        if (0 != this.elementNames.size()) {
            mLogger.log(Level.INFO, "Job {0} is setting the volume name(s).", this.getJob().getInstanceID());
            this.getHitachiJobServiceObject().updateServerJobPercentComplete(99, true);
            this.updateChildrenJobPercentComplete(99);
            try {
                ElementNameData.changeElementNames(this, this.elementNames);
            }
            catch (Throwable t) {
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                mLogger.log(Level.WARNING, "Naming newly created volumes failed", t);
            }
        } else {
            mLogger.log(Level.WARNING, "Job {0} has no elements to name", this.getJob().getInstanceID());
        }
    }

    @Override
    protected void executeJob(List<AbstractJobImpl> actionItems) throws WBEMException {
        this.setAbstractJobImpls(actionItems);
        this.createConcreteJobFromAbstractJobs();
        mLogger.log(Level.INFO, "CoalescedJob {0} starting", this.getJob().getInstanceID());
        this.markServerJobStarted(0);
        this.getHitachiJobServiceObject().updateServerJobPercentComplete(33, true);
        this.updateChildrenJobPercentComplete(33);
        this.doCreateVolumesStep();
        this.doElementNameStep();
        this.markServerJobDone();
        mLogger.log(Level.INFO, "CoalescedJob {0} done", this.getJob().getInstanceID());
    }

    private void setVirtualVolumeObject(short cu, short ldev, Robj_interface_AOUsetAddVvol_IN setAddVvol, CreateModifyThinVolume.CreateThinVolumeData data, AbstractJobImpl childJob) throws WBEMException, RemoteException, SANRmiException {
        long size;
        Robj_interface_AOUAddVvol vvolData;
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber());
        int ssid = ProviderLibs.getSubSystemID(cu, ldev, true, device.getSerialNumber());
        if (ssid > -1) {
            vvolData = (Robj_interface_AOUAddVvol)device.getRMIObject().smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.AOUADDVVOL);
            vvolData.setPoolID((int)data.getThinPool().getPoolID());
            vvolData.setLDEVIndex((short)0, cu, ldev);
            vvolData.setSSID(ssid);
            size = data.getSize() / 512L;
            if (size % 512L > 0L) {
                ++size;
            }
        } else {
            String msg = "Unable to get SSID for CU: " + cu + ", LDEV: " + ldev;
            mLogger.log(Level.SEVERE, msg);
            throw new WBEMException(msg);
        }
        vvolData.setLLDEVLBASize(size);
        vvolData.setThreshold(0);
        vvolData.setRelocateTier(false);
        vvolData.setSCLPR((short)0);
        vvolData.setEmulationType(data.getEmulationType());
        mLogger.info("Creating an AOU volume w/the following params:\nThin Pool ID: " + data.getThinPool().getPoolID() + ", ssid: " + ssid + ", DKC: 0" + ", cu: " + cu + ", ldev: " + ldev + ", size: " + size);
        setAddVvol.setAddVvol(vvolData);
    }
}

