/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescedCreateModifyThinPoolJob;
import com.hitachi.smi.jobs.ElementNameData;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import com.hitachi.smi.jobs.HitachiJobCallbackIF2;
import com.hitachi.smi.jobs.SetResourceNameHelper;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_AddPoolDataSx;
import sanproject.common.Robj_interface_POOLsetAddPoolSx_OUT;

public class CreateModifyThinPool
extends AbstractJobImpl
implements HitachiJobCallbackIF2 {
    private boolean jobDone;

    public CreateModifyThinPool(String serialNumber, String pUserName, String pIPAddress, CIMObjectPath owningService, List<DeviceNumber> dns, ThinPool pool2Expand, String elementName) throws WBEMException {
        super(serialNumber, "CreateOrModifyStoragePool", pUserName, pIPAddress, owningService, "HITACHI_AffectedJobElementThinProvisioningPool", "HITACHI_StorageCSOwningJobElement", null);
        CreateThinPoolData tpData = new CreateThinPoolData(dns, pool2Expand, elementName);
        this.setActionItem(tpData);
        this.setCallback(this);
        this.jobDone = false;
    }

    @Override
    public CIMObjectPath[] getAffectedElements() {
        CIMObjectPath[] ret = null;
        if (this.jobDone) {
            ret = super.getAffectedElements();
        }
        return ret;
    }

    @Override
    protected Coalescable getCoalescableObject() {
        return new CoalescedCreateModifyThinPoolJob();
    }

    private CIMObjectPath getThinPoolCOP(ThinPool tp) throws Exception {
        BaseInstrumentation instrumentation = BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ThinProvisioningPoolInstrumentation");
        CIMObjectPath affectedElement = instrumentation.generateObjectPath(this.getOwningElement(), tp);
        return affectedElement;
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted();
                break;
            }
            case BEFORE_JOB_COMPLETE: {
                this.getHitachiJobServiceObject().updateElapsedTime();
                break;
            }
            case AFTER_TRANSACTION: {
                this.getHitachiJobServiceObject().updateElapsedTime();
                this.processJobComplete();
                this.jobDone = true;
                break;
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    @Override
    public boolean jobStepCompleted(HitachiJobCallbackIF2.StepCompleted step) {
        boolean ret = true;
        switch (step) {
            case AFTER_STEP_1: {
                ret = this.processStep1();
                break;
            }
            default: {
                mLogger.log(Level.WARNING, "{0} called for {1}, however; that step is not implemented", new Object[]{this.getClass().getSimpleName(), step});
            }
        }
        return ret;
    }

    private void processJobComplete() {
        WBEMException we = null;
        boolean poolCreated = false;
        CreateThinPoolData data = (CreateThinPoolData)this.getActionItem();
        short poolID = data.getPoolID();
        try {
            this.verifyPoolCreated();
            poolCreated = true;
            ElementNameData element = new ElementNameData(Short.toString(poolID), this.getDeviceSerial(), SetResourceNameHelper.ResourceType.POOL, data.getElementName());
            element.processResult(this, this.getResultIndex());
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (Throwable t) {
            while (null != t.getCause()) {
                t = t.getCause();
            }
            we = new WBEMException(1, "Error checking element name", null, t);
        }
        if (null != we && poolCreated) {
            t = we;
            while (null != t.getCause()) {
                t = t.getCause();
            }
            mLogger.log(Level.WARNING, "Unable to name pool " + poolID, t);
            we = null;
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    private boolean processStep1() {
        boolean ret;
        WBEMException we = null;
        try {
            Robj_interface_POOLsetAddPoolSx_OUT jobRet = (Robj_interface_POOLsetAddPoolSx_OUT)this.getRMIResult();
            Robj_interface_AddPoolDataSx[] results = jobRet.getObjPoolData();
            long result = results[this.getResultIndex()].getLErrorCode();
            if (0L != result) {
                String msg = "Job, " + this.getJobID() + ", received error from back end 3005 - " + result;
                mLogger.log(Level.SEVERE, msg);
                we = new WBEMException(msg);
            }
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (ClassCastException cce) {
            we = new WBEMException(1, cce.toString(), null, (Throwable)cce);
        }
        catch (Throwable e) {
            we = new WBEMException(1, "Exception getting transaction result: " + e, null, e);
        }
        if (null != we) {
            this.getHitachiJobServiceObject().markServerJobDone(we);
            this.getHitachiJobServiceObject().markServerjobComplete();
            ret = false;
        } else {
            ret = true;
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CreateModifyThinPool ");
        builder.append(this.getActionItem());
        return builder.toString();
    }

    private void verifyPoolCreated() throws WBEMException {
        CreateThinPoolData tpData = (CreateThinPoolData)this.getActionItem();
        short poolID = tpData.getPoolID();
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerial());
        ThinPool tp = ThinPool.find(device.getRMIObject(), poolID, ThinPool.ThinPoolType.AOU);
        CIMObjectPath[] paths = null;
        for (int retryCount = -1; tp == null && retryCount < 20; ++retryCount) {
            try {
                this.getHitachiJobServiceObject().updateElapsedTime();
                mLogger.fine("Thin Pool(" + poolID + ") not in cache, will retry in" + 30 + " seconds.");
                Thread.sleep(30000L);
            }
            catch (InterruptedException ie) {
                mLogger.log(Level.FINEST, "transaction sleep interrupted - this is OK", ie);
            }
            tp = ThinPool.find(device.getRMIObject(), poolID, ThinPool.ThinPoolType.AOU);
        }
        if (tp != null) {
            paths = new CIMObjectPath[1];
            try {
                paths[0] = this.getThinPoolCOP(tp);
            }
            catch (Exception e) {
                throw new WBEMException(1, "Exception getting ThinPool(" + poolID + ") ObjectPath: " + e, null, (Throwable)e);
            }
        } else {
            throw new WBEMException(1, "Unable to find the thin pool with ID: " + poolID);
        }
        this.setAffectedElements(paths);
    }

    class CreateThinPoolData {
        List<DeviceNumber> dns;
        final ThinPool pool2Expand;
        short poolID;
        final String elementName;

        public CreateThinPoolData(List<DeviceNumber> dns, ThinPool pool2Expand, String elementName) {
            this.dns = dns;
            this.pool2Expand = pool2Expand;
            this.elementName = elementName;
            this.poolID = (short)-1;
        }

        protected List<DeviceNumber> getDns() {
            return this.dns;
        }

        protected String getElementName() {
            return this.elementName;
        }

        protected ThinPool getPool2Expand() {
            return this.pool2Expand;
        }

        protected short getPoolID() {
            return this.poolID;
        }

        protected void setPoolID(short poolID) {
            this.poolID = poolID;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CreateThinPoolData [dns=");
            builder.append(this.dns);
            builder.append(", pool2Expand=");
            builder.append(this.pool2Expand);
            builder.append(", poolID=");
            builder.append(this.poolID);
            builder.append(", elementName=");
            builder.append(this.elementName);
            builder.append("]");
            return builder.toString();
        }
    }
}

