/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.LUPathObject;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescableExposePathsJob;
import com.hitachi.smi.jobs.ExposeHidePathsData;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class ExposeHidePaths
extends AbstractJobImpl
implements HitachiJobCallbackIF,
CacheUpdateNotifier {
    private static String EXPOSE_METHOD_NAME = "ExposePaths";
    private static String HIDE_METHOD_NAME = "HidePaths";
    private final boolean exposePaths;
    private final List<Short> luNums;
    private volatile boolean registeredLUPathCallback;

    public ExposeHidePaths(String pSerialNumber, String pUserName, String pIPAddress, CIMObjectPath pOwningSrvc, FCPort fcPort, short portNum, short hostGrp, String[] initiatorPorts, short[][] luVals, short[] sLunNum, CIMObjectPath[] protocolControllers, String elementName, int hostMode, boolean exposePaths) throws WBEMException {
        super(pSerialNumber, exposePaths ? EXPOSE_METHOD_NAME : HIDE_METHOD_NAME, pUserName, pIPAddress, pOwningSrvc, "HITACHI_AffectedJobElementSCSIProtocolController", "HITACHI_ControllerCSOwningJobElement", null);
        boolean isFC;
        this.exposePaths = exposePaths;
        if (null != fcPort) {
            isFC = !fcPort.isRequestedType(FCPort.PortTypeRequested.iSCSI);
        } else {
            FCPort localFCPort = FCPort.find(portNum, FCPort.PortTypeRequested.ALL, RMIObjectMapping.getRMIObjectMapping(pSerialNumber).getRMIObject());
            if (null == localFCPort) {
                throw new WBEMException("Specified Port is invalid " + portNum);
            }
            isFC = localFCPort.isRequestedType(FCPort.PortTypeRequested.OPEN);
        }
        ExposeHidePathsData data = new ExposeHidePathsData(fcPort, portNum, hostGrp, initiatorPorts, luVals, sLunNum, isFC, elementName, hostMode);
        this.setActionItem(data);
        this.luNums = new ArrayList<Short>(null != sLunNum ? sLunNum.length : 0);
        this.registeredLUPathCallback = false;
        this.setCallback(this);
        if (protocolControllers != null && protocolControllers.length > 0) {
            this.setAffectedElements(protocolControllers);
        }
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        LUPathObject lu = (LUPathObject)pObj;
        ExposeHidePathsData data = this.getActionItem();
        if (this.exposePaths) {
            mLogger.log(Level.FINE, "Job: {0}: cache indicates {1} has been added", new Object[]{this.getJobID(), pObj});
            this.checkLunNumList(lu, data);
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        LUPathObject lu = (LUPathObject)pObj;
        ExposeHidePathsData data = this.getActionItem();
        if (!this.exposePaths) {
            mLogger.log(Level.FINE, "Job: {0}: cache indicates {1} has been deleted", new Object[]{this.getJobID(), pObj});
            this.checkLunNumList(lu, data);
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        mLogger.log(Level.FINE, "Job: {0}: cache indicates {1} has been modified", new Object[]{this.getJobID(), pObj});
    }

    private boolean checkiSCSIRemoteNames(ISCSITargetPort.ISCSITarget target) {
        boolean ret = target != null;
        mLogger.log(Level.INFO, "Job: {0}: Target: {1}", new Object[]{this.getJobID(), target});
        if (!this.exposePaths) {
            if (null != target) {
                ExposeHidePathsData data = this.getActionItem();
                String[] initiators = data.getInitiatorPorts();
                if (null != initiators && initiators.length > 0) {
                    List<String> removedInitPorts = Arrays.asList(initiators);
                    Collections.sort(removedInitPorts);
                    mLogger.log(Level.INFO, "Job: {0}: Verifying that iSCSI Names have been removed: {1}", new Object[]{this.getJobID(), removedInitPorts});
                    for (ISCSITargetPort.RemoteiSCSIName remoteName : target.getRemoteNames()) {
                        int index = Collections.binarySearch(removedInitPorts, remoteName.getName());
                        mLogger.log(Level.INFO, "Job: {0}: Binary search returned: {1}", new Object[]{this.getJobID(), index});
                        if (0 > index) continue;
                        ret = false;
                        break;
                    }
                } else {
                    mLogger.log(Level.WARNING, "Job: {0}: has no iSCSI Names specified", this.getJobID());
                    ret = true;
                }
            } else {
                ret = true;
            }
        }
        mLogger.log(Level.INFO, "Job: {0}: checkTargetPort returning: {1}", new Object[]{this.getJobID(), ret});
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLunNumList(LUPathObject lu, ExposeHidePathsData data) {
        if (data.portNum == lu.getSPort() && data.getHostGrp() == lu.getSHostGrp() && this.checkLUVals(lu, data.getLuVals())) {
            mLogger.log(Level.INFO, "Job: {0}: checking if LUPath has been updated: {1}", new Object[]{this.getJobID(), lu.toString()});
            mLogger.log(Level.INFO, "Job: {0}: ExposeHidePaths.luNums: {1}", new Object[]{this.getJobID(), this.luNums});
            short sLunNum = lu.getSLun();
            mLogger.log(Level.INFO, "Job: {0}: checking if {1} is in luNums({2})", new Object[]{this.getJobID(), sLunNum, this.luNums});
            int index = Collections.binarySearch(this.luNums, sLunNum);
            if (index >= 0) {
                mLogger.log(Level.INFO, "Job: {0}: {1} is in luNums ({2}), at index {3}", new Object[]{this.getJobID(), lu, this.luNums, index});
                try {
                    List<Short> list = this.luNums;
                    synchronized (list) {
                        index = Collections.binarySearch(this.luNums, sLunNum);
                        if (index >= 0) {
                            mLogger.log(Level.INFO, "Job: {0}: {1} still in luNums ({2}), at index {3}", new Object[]{this.getJobID(), lu, this.luNums, index});
                            this.luNums.remove(index);
                            mLogger.log(Level.INFO, "Job: {0}: Index removed, luNums has {1} elements", new Object[]{this.getJobID(), this.luNums.size()});
                        } else {
                            mLogger.log(Level.INFO, "Job: {0}: {1} was removed from luNums ({2})", new Object[]{this.getJobID(), lu, this.luNums});
                        }
                    }
                }
                catch (IndexOutOfBoundsException iobe) {
                    mLogger.log(Level.SEVERE, "Job: {0}: While checking {1} we got an IndexOutOfBoundsException, index is {2} and luNums has {3} elements which are {4}", new Object[]{this.getJobID(), lu, index, this.luNums.size(), this.luNums.toString()});
                }
            }
        }
    }

    private boolean checkLUVals(LUPathObject lu, short[][] luVals) {
        boolean ret = !this.exposePaths;
        for (int x = 0; !ret && x < luVals.length; ++x) {
            short[] vals = luVals[x];
            if (lu.getDKC() != vals[0] || lu.getCU() != vals[1] || lu.getLDEV() != vals[2]) continue;
            ret = true;
        }
        return ret;
    }

    private boolean checkPHGIStatus(PortandHostGroupInfo phgi) {
        boolean phgiTest = phgi != null;
        mLogger.log(Level.INFO, "Job: {0}: Initial phgiTest: {1}", new Object[]{this.getJobID(), phgiTest});
        if (!this.exposePaths) {
            String[] wwns;
            String[] stringArray = wwns = phgiTest ? phgi.getHostWWNs() : null;
            if (phgiTest && null != wwns && wwns.length > 0) {
                ExposeHidePathsData data = this.getActionItem();
                String[] initiators = data.getInitiatorPorts();
                if (null != initiators && initiators.length > 0) {
                    List<String> removedInitPorts = Arrays.asList(initiators);
                    Collections.sort(removedInitPorts);
                    mLogger.log(Level.INFO, "Job: {0}: Verifying that initiators have been removed: {1}", new Object[]{this.getJobID(), removedInitPorts});
                    mLogger.log(Level.INFO, "Job: {0}: Current PHGI: {1}", new Object[]{this.getJobID(), phgi});
                    for (String wwn : wwns) {
                        int index = Collections.binarySearch(removedInitPorts, wwn);
                        mLogger.log(Level.INFO, "Job: {0}: Binary search returned: {1}", new Object[]{this.getJobID(), index});
                        if (0 > index) continue;
                        phgiTest = false;
                        break;
                    }
                }
            } else {
                phgiTest = true;
            }
        }
        mLogger.log(Level.INFO, "Job: {0}: checkPHGIStatus returning: {1}", new Object[]{this.getJobID(), phgiTest});
        return phgiTest;
    }

    @Override
    protected ExposeHidePathsData getActionItem() {
        return (ExposeHidePathsData)super.getActionItem();
    }

    @Override
    protected Coalescable getCoalescableObject() {
        Collections.sort(this.luNums);
        return new CoalescableExposePathsJob(this.exposePaths);
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted(5);
                break;
            }
            case BEFORE_JOB_COMPLETE: {
                break;
            }
            case AFTER_TRANSACTION: {
                this.processResult();
                break;
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResult() {
        ExposeHidePathsData exposePathData;
        WBEMException we = null;
        try {
            this.getRMIResult();
            this.verifyAffectedElementUpdated();
            this.verifyLUPathsUpdated();
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (Throwable t) {
            we = new WBEMException(1, t.toString(), null, t);
        }
        boolean temp = this.registeredLUPathCallback;
        if (temp) {
            ExposeHidePaths exposeHidePaths = this;
            synchronized (exposeHidePaths) {
                temp = this.registeredLUPathCallback;
                if (temp) {
                    CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.LUPATH, this, null);
                    this.registeredLUPathCallback = false;
                    temp = false;
                }
            }
        }
        if (this.exposePaths && null != (exposePathData = this.getActionItem())) {
            LUPathObject.unassignLunNumber(this.getDeviceSerial(), exposePathData.portNum, exposePathData.getHostGrp(), exposePathData.getsLunNums());
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLuNums(short luNum) {
        Object object = this.luNums;
        synchronized (object) {
            this.luNums.add(luNum);
        }
        if (!this.registeredLUPathCallback) {
            object = this;
            synchronized (object) {
                if (!this.registeredLUPathCallback) {
                    CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.LUPATH, this, null);
                    this.registeredLUPathCallback = true;
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder(this.getMethodName());
        ret.append("\n");
        ret.append(this.getActionItem().toString());
        return ret.toString();
    }

    private void verifyAffectedElementUpdated() throws WBEMException {
        ISCSITargetPort targetPort;
        PortandHostGroupInfo phgi;
        ISCSITargetPort.ISCSITarget target;
        CIMObjectPath[] affectedElems = this.getAffectedElements();
        String pcDevID = null;
        for (CIMObjectPath affectedElem : affectedElems) {
            String objName = affectedElem.getObjectName();
            if (!"HITACHI_SCSIProtocolController".equals(objName)) continue;
            pcDevID = (String)affectedElem.getKey("DeviceID").getValue();
            break;
        }
        int retryCount = -1;
        String portID = ProviderLibs.getAllButEndString(pcDevID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
        String domainID = ProviderLibs.getEndString(pcDevID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerial());
        if (this.getActionItem().isFC()) {
            target = null;
            phgi = PortandHostGroupInfo.find(device.getSerialNumber(), null, null, portID, domainID, null, false, null);
        } else {
            phgi = null;
            targetPort = ISCSITargetPort.find(device.getRMIObject(), Short.parseShort(portID));
            target = targetPort.getTarget(Short.parseShort(domainID));
        }
        while (!this.checkPHGIStatus(phgi) && !this.checkiSCSIRemoteNames(target) && retryCount < 20) {
            try {
                this.getHitachiJobServiceObject().updateElapsedTime();
                mLogger.log(Level.FINE, "Job: {0}: SCSIProtocolController({1}) {2} in cache, will retry in {3} seconds.", new Object[]{this.getJobID(), pcDevID, this.exposePaths ? "not" : "still", 30});
                Thread.sleep(30000L);
            }
            catch (InterruptedException ie) {
                mLogger.log(Level.FINEST, "transaction sleep interrupted - this is OK", ie);
            }
            ++retryCount;
            if (this.getActionItem().isFC()) {
                phgi = PortandHostGroupInfo.find(device.getSerialNumber(), null, null, portID, domainID, null, false, null);
                continue;
            }
            targetPort = ISCSITargetPort.find(device.getRMIObject(), Short.parseShort(portID));
            target = targetPort.getTarget(Short.parseShort(domainID));
        }
        if (retryCount >= 20) {
            throw new WBEMException("SCSIProtocolController(" + pcDevID + ") was not " + (this.exposePaths ? "added to" : "removed from") + " cache");
        }
    }

    private void verifyLUPathsUpdated() throws WBEMException {
        mLogger.log(Level.INFO, "Job: {0}, {1}, waiting for {2} LUPaths to be updated", new Object[]{this.getJob().getInstanceID(), this.getMethodName(), this.luNums.size()});
        for (int retryCount = 0; this.luNums.size() > 0 && retryCount < 20; ++retryCount) {
            try {
                this.getHitachiJobServiceObject().updateElapsedTime();
                mLogger.log(Level.FINE, "Job: {0}: Not all LUPaths {1} cache, will wait {2} seconds.", new Object[]{this.getJob().getInstanceID(), this.exposePaths ? "added to" : "removed from", 30});
                Thread.sleep(30000L);
                continue;
            }
            catch (InterruptedException ie) {
                mLogger.log(Level.FINEST, "transaction sleep interrupted - this is OK", ie);
            }
        }
        if (this.luNums.size() > 0) {
            mLogger.log(Level.SEVERE, "Job: {0}, {1}, not all LUPaths have been updated: {2}", new Object[]{this.getJob().getInstanceID(), this.getMethodName(), this.luNums.toString()});
            throw new WBEMException("Job: " + this.getJob().getInstanceID() + ", LUPaths not updated in allowed time.");
        }
        mLogger.log(Level.INFO, "Job: {0}, {1}, all LUPaths have been updated", new Object[]{this.getJob().getInstanceID(), this.getMethodName()});
    }
}

