/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.HitachiCacheMangerService;
import com.hitachi.smi.common.ProviderProperties;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.HitachiJobIF;
import com.hitachi.smi.jobs.HitachiJobService;
import com.ws.wbem.provider.jobservice.CIM_ConcreteJob;
import com.ws.wbem.provider.jobservice.JobImplementation;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDateTimeInterval;
import javax.wbem.WBEMException;

public class JobQueue
extends Thread {
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    private static volatile JobQueue singleton = null;
    private final BlockingQueue<String> jobQ;
    private final AbstractMap<String, List<AbstractJobImpl>> waitingJobs;
    private boolean jobRunning;
    private final Queue<CompletedJob> completedJobs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JobQueue getJobQ() {
        JobQueue result = singleton;
        if (result != null) return result;
        Class<JobQueue> clazz = JobQueue.class;
        synchronized (JobQueue.class) {
            result = singleton;
            if (result != null) return result;
            result = singleton = new JobQueue();
            result.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private JobQueue() {
        super("Hitachi Job Queue");
        this.setDaemon(true);
        this.jobQ = new LinkedBlockingQueue<String>();
        this.waitingJobs = new HashMap<String, List<AbstractJobImpl>>();
        this.completedJobs = new ConcurrentLinkedQueue<CompletedJob>();
        this.jobRunning = false;
    }

    protected void addCompletedJob(HitachiJobIF pJob) {
        if (pJob.getJob() != null) {
            CompletedJob t = new CompletedJob(pJob);
            this.completedJobs.offer(t);
            mLogger.log(Level.INFO, "Job, {0}, added to completed list.", pJob.getJob().getInstanceID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addJobToQueue(AbstractJobImpl newJob, boolean alwaysSubmit) throws WBEMException {
        try {
            boolean jobInQ = true;
            String keyStr = newJob.getMethodName() + newJob.getUserName() + newJob.getDeviceSerial();
            AbstractMap<String, List<AbstractJobImpl>> abstractMap = this.waitingJobs;
            synchronized (abstractMap) {
                if (!alwaysSubmit && !this.waitingJobs.isEmpty()) {
                    throw new WBEMException(11, "Jobs waiting in queue");
                }
                List<AbstractJobImpl> jobs = this.waitingJobs.get(keyStr);
                if (jobs == null) {
                    jobInQ = false;
                    jobs = new ArrayList<AbstractJobImpl>();
                    this.waitingJobs.put(keyStr, jobs);
                }
                jobs.add(newJob);
                if (!jobInQ) {
                    this.jobQ.put(keyStr);
                }
            }
        }
        catch (InterruptedException e) {
            throw new WBEMException(1, "Unable to add job to queue: " + e, null, (Throwable)e);
        }
    }

    public boolean isJobRunning() {
        return this.jobRunning;
    }

    public boolean isJobWaiting() {
        return !this.waitingJobs.isEmpty();
    }

    private void kullCompletedJobs() {
        long current = System.currentTimeMillis();
        int numConsecutiveExceptions = 0;
        Iterator iter = this.completedJobs.iterator();
        while (numConsecutiveExceptions <= 2 && iter.hasNext()) {
            try {
                CompletedJob completedJob = (CompletedJob)iter.next();
                if (completedJob.getExpires() > current) continue;
                iter.remove();
                HitachiJobIF job = completedJob.getJobObject();
                job.getHitachiJobServiceObject().getJobService().unregisterImplementation("HITACHI_ConcreteJob", null, (JobImplementation)job);
                numConsecutiveExceptions = 0;
                mLogger.log(Level.INFO, "job ({0}) has expired & has been removed", job.getJob().getInstanceID());
            }
            catch (Throwable t) {
                ++numConsecutiveExceptions;
                mLogger.log(Level.SEVERE, "Exception occurred during kulling,", t);
            }
        }
        if (numConsecutiveExceptions > 2) {
            mLogger.severe("Too many consecutive exceptions, stop kulling");
        }
    }

    private void markJobsWithError(Coalescable jobCombiner, List<AbstractJobImpl> jobs, Throwable error) {
        if (jobs != null) {
            CIM_ConcreteJob concreteJob = null == jobCombiner ? null : jobCombiner.getJob();
            String jobID = null == concreteJob ? "UNKNOWN" : concreteJob.getInstanceID();
            mLogger.log(Level.INFO, "Coalesced job {0}, marking {1} child jobs as failed.", new Object[]{jobID, jobs.size()});
            for (AbstractJobImpl job : jobs) {
                try {
                    job.getHitachiJobServiceObject().markServerJobDone(error);
                    this.addCompletedJob(job);
                }
                catch (Throwable t) {
                    mLogger.log(Level.WARNING, "Exception updating child job: " + job, t);
                }
            }
        } else {
            CIM_ConcreteJob conJob = jobCombiner == null ? null : jobCombiner.getJob();
            mLogger.log(Level.WARNING, "Coalesced job, {0},  had no child jobs", conJob != null ? conJob.getInstanceID() : "null");
        }
        if (jobCombiner != null) {
            try {
                HitachiJobService hitachiJS = jobCombiner.getHitachiJobServiceObject();
                if (hitachiJS != null) {
                    hitachiJS.markServerJobDone(error);
                    this.addCompletedJob(jobCombiner);
                }
            }
            catch (Throwable t) {
                CIM_ConcreteJob job = jobCombiner.getJob();
                String jobID = null == job ? "UNKNOWN" : job.getInstanceID();
                mLogger.log(Level.WARNING, "Exception updating coalescing job: " + jobID, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!HitachiCacheMangerService.isShuttingDown()) {
            List<AbstractJobImpl> jobs = null;
            Coalescable jobCombiner = null;
            try {
                String jobkey = this.jobQ.poll(60000L, TimeUnit.MILLISECONDS);
                if (jobkey != null) {
                    AbstractMap<String, List<AbstractJobImpl>> abstractMap = this.waitingJobs;
                    synchronized (abstractMap) {
                        jobs = this.waitingJobs.remove(jobkey);
                    }
                    if (jobs != null && jobs.size() > 0) {
                        AbstractJobImpl job = jobs.get(0);
                        jobCombiner = job.getCoalescableObject();
                        try {
                            this.jobRunning = true;
                            jobCombiner.executeJob(jobs);
                            continue;
                        }
                        finally {
                            CIM_ConcreteJob tempJob = jobCombiner.getJob();
                            if (null != tempJob) {
                                mLogger.log(Level.INFO, "CoalescedJob {0} done", tempJob.getInstanceID());
                            } else {
                                mLogger.log(Level.INFO, "Unknown CoalescedJob done");
                            }
                            this.jobRunning = false;
                            continue;
                        }
                    }
                    mLogger.log(Level.WARNING, "Job, {0}, was signaled as ready, however; it was not in the queue", jobkey);
                    continue;
                }
                this.kullCompletedJobs();
            }
            catch (InterruptedException e) {
                mLogger.log(Level.WARNING, "Job queue was interuptted, should be OK", e);
            }
            catch (Throwable t) {
                Throwable temp = t;
                while (null != temp.getCause()) {
                    temp = temp.getCause();
                }
                CIM_ConcreteJob job = null == jobCombiner ? null : jobCombiner.getJob();
                String jobID = null == job ? "UNKNOWN" : job.getInstanceID();
                mLogger.log(Level.SEVERE, "Unexpected Exception creating Coalesced job: " + jobID, temp);
                this.markJobsWithError(jobCombiner, jobs, temp);
            }
        }
        mLogger.info("Job queue thread exiting.");
    }

    private class CompletedJob {
        private final HitachiJobIF theJob;
        private final long expires;

        public CompletedJob(HitachiJobIF pJob) {
            this.theJob = pJob;
            long wait = this.determineWait();
            long current = System.currentTimeMillis();
            this.expires = current + wait;
        }

        long determineWait() {
            long ret = ProviderProperties.getJobWaitB4Delete() * 60 * 1000;
            try {
                CIM_ConcreteJob concreteJob;
                HitachiJobService jobSrvc;
                if (this.theJob != null && (jobSrvc = this.theJob.getHitachiJobServiceObject()) != null && (concreteJob = jobSrvc.getJob()) != null) {
                    CIMDateTimeInterval cdtInterval = (CIMDateTimeInterval)concreteJob.getTimeBeforeRemoval();
                    int hours = cdtInterval.getHours();
                    int min = cdtInterval.getMinutes();
                    int sec = cdtInterval.getSeconds();
                    ret = hours * 60 * 60 * 1000;
                    ret += (long)(min * 60 * 1000);
                    ret += (long)(sec * 1000);
                }
            }
            catch (Exception e) {
                mLogger.log(Level.INFO, "An exception occurred trying to get removal time.", e);
            }
            return ret;
        }

        public long getExpires() {
            return this.expires;
        }

        public HitachiJobIF getJobObject() {
            return this.theJob;
        }
    }
}

