/*
 * Decompiled with CFR 0.152.
 */
package sanproject.server.data;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import sanproject.server.data.GetRmiException;
import sanproject.server.data.RmiConObjErr;

public class RmiConObjOutFile {
    private static final int NUM_BYTE_IN_LOG_LINE = 150;
    private static final byte SPACE_BYTE = 32;
    private static final byte CR_BYTE = 13;
    private static final byte LF_BYTE = 10;
    private static byte[] byteSpaceLine = new byte[150];
    final int LINE_NUM_POS = 11;
    final int LINE_NUM_BUF_SIZE = 20;
    private int nLineWrapRound;
    private RandomAccessFile rf;
    private String fileName;
    private boolean errLogFlag = true;

    private void open() throws GetRmiException {
        try {
            this.rf = new RandomAccessFile(this.fileName, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            RmiConObjErr.putFileErrLog(4001, "RmiConObjOutFile: Could not open " + this.fileName, this.errLogFlag);
            throw RmiConObjErr.makeException(4001);
        }
    }

    private byte[] fillSpace(String string) throws UnsupportedEncodingException {
        byte[] byArray = string.toString().getBytes();
        byte[] byArray2 = new byte[150];
        int n = 0;
        while (n < byArray2.length) {
            byArray2[n] = n < byArray.length ? byArray[n] : 32;
            ++n;
        }
        return byArray2;
    }

    private void initFile() throws IOException {
        byte[] byArray = this.fillSpace("Last Line: 1");
        this.rf.seek(0L);
        this.rf.write(byArray, 0, byteSpaceLine.length);
        this.rf.write(13);
        this.rf.write(10);
        int n = 0;
        while (n < this.nLineWrapRound) {
            this.rf.write(byteSpaceLine, 0, byteSpaceLine.length);
            this.rf.write(13);
            this.rf.write(10);
            ++n;
        }
    }

    private void addLine(long l, int n) throws IOException {
        this.rf.seek(l);
        int n2 = 0;
        while (n2 < n) {
            this.rf.write(byteSpaceLine, 0, byteSpaceLine.length);
            this.rf.write(13);
            this.rf.write(10);
            ++n2;
        }
    }

    private int readLineNum() throws IOException, GetRmiException {
        int n;
        byte[] byArray = new byte[20];
        this.rf.seek(11L);
        this.rf.read(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (byArray[n2] != 32) {
            stringBuffer.append(String.valueOf((char)byArray[n2]));
            ++n2;
        }
        try {
            n = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            RmiConObjErr.putFileErrLog(1006, "RmiConObjOutFile: Format Error of Line Numver: " + this.fileName, this.errLogFlag);
            throw RmiConObjErr.makeException(1006);
        }
        return n;
    }

    private void writeLineNum(int n) throws IOException {
        byte[] byArray = Integer.toString(n).getBytes();
        byte[] byArray2 = new byte[20];
        int n2 = 0;
        while (n2 < byArray2.length) {
            byArray2[n2] = n2 < byArray.length ? byArray[n2] : 32;
            ++n2;
        }
        this.rf.seek(11L);
        this.rf.write(byArray2, 0, byArray2.length);
    }

    private void init() throws GetRmiException {
        boolean bl = false;
        this.open();
        try {
            try {
                long l = this.rf.length();
                if (l == 0L) {
                    this.initFile();
                } else if (l < (long)((this.nLineWrapRound + 1) * 152)) {
                    int n = (int)((long)((this.nLineWrapRound + 1) * 152) - l);
                    if (n % 152 != 0) {
                        RmiConObjErr.putFileErrLog(1005, "RmiConObjOutFile: File Size Error ->File size isn't a multiple of Byte of a Line : " + this.fileName, this.errLogFlag);
                        throw RmiConObjErr.makeException(1005);
                    }
                    this.addLine(l, n / 152);
                } else if (l > (long)((this.nLineWrapRound + 1) * 152)) {
                    RmiConObjErr.putFileErrLog(1005, "RmiConObjOutFile: File Size Error ->File size is bigger than RegulationSize : " + this.fileName, this.errLogFlag);
                    throw RmiConObjErr.makeException(1005);
                }
                bl = true;
            }
            catch (IOException iOException) {
                RmiConObjErr.putFileErrLog(4001, "RmiConObjOutFile: File Access Failed : " + this.fileName, this.errLogFlag);
                throw RmiConObjErr.makeException(4001);
            }
            Object var6_5 = null;
            if (!bl) {
                this.clearAfterErr();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!bl) {
                this.clearAfterErr();
            }
            throw throwable;
        }
    }

    private void clearAfterErr() {
        try {
            this.clear();
        }
        catch (Exception exception) {
            RmiConObjErr.putErrLog("-", "RmiConObjOutFile: " + exception.getMessage());
        }
    }

    public RmiConObjOutFile(String string) throws GetRmiException {
        this.fileName = string;
    }

    public RmiConObjOutFile(String string, int n) throws GetRmiException {
        this.fileName = string;
        this.nLineWrapRound = n;
        this.init();
    }

    public RmiConObjOutFile(String string, int n, boolean bl) throws GetRmiException {
        this.fileName = string;
        this.nLineWrapRound = n;
        this.errLogFlag = bl;
        this.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putLog(String string) throws GetRmiException {
        block6: {
            boolean bl = false;
            try {
                try {
                    byte[] byArray = this.fillSpace(string);
                    int n = (this.readLineNum() - 1) % this.nLineWrapRound + 2;
                    this.rf.seek((n - 1) * 152);
                    this.rf.write(byArray, 0, byArray.length);
                    this.writeLineNum(n);
                    bl = true;
                }
                catch (IOException iOException) {
                    RmiConObjErr.putFileErrLog(4001, "RmiConObjOutFile: File Access Failed : " + this.fileName, this.errLogFlag);
                    throw RmiConObjErr.makeException(4001);
                }
                Object var6_6 = null;
                if (!bl) break block6;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (bl) {
                    this.clear();
                    throw throwable;
                }
                this.clearAfterErr();
                throw throwable;
            }
            this.clear();
            return;
        }
        this.clearAfterErr();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putLog(String string, ArrayList arrayList) throws GetRmiException {
        block9: {
            boolean bl = false;
            try {
                try {
                    int n = 0;
                    while (true) {
                        if (n >= arrayList.size()) {
                            bl = true;
                            break;
                        }
                        byte[] byArray = this.fillSpace(string + (String)arrayList.get(n));
                        int n2 = (this.readLineNum() - 1) % this.nLineWrapRound + 2;
                        this.rf.seek((n2 - 1) * 152);
                        this.rf.write(byArray, 0, byArray.length);
                        this.writeLineNum(n2);
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    RmiConObjErr.putFileErrLog(4001, "RmiConObjOutFile: File Access Failed : " + this.fileName, this.errLogFlag);
                    throw RmiConObjErr.makeException(4001);
                }
                Object var8_8 = null;
                if (!bl) break block9;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (bl) {
                    this.clear();
                    throw throwable;
                }
                this.clearAfterErr();
                throw throwable;
            }
            this.clear();
            return;
        }
        this.clearAfterErr();
    }

    public void putOneLine(String string) throws GetRmiException {
        this.open();
        try {
            try {
                this.rf.writeBytes(string);
                this.rf.write(13);
                this.rf.write(10);
            }
            catch (Exception exception) {
                RmiConObjErr.putFileErrLog(4001, "RmiConObjOutFile: File Access Failed : " + this.fileName, this.errLogFlag);
                throw RmiConObjErr.makeException(4001);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.clear();
            throw throwable;
        }
        this.clear();
    }

    public void clear() throws GetRmiException {
        try {
            this.rf.close();
        }
        catch (IOException iOException) {
            RmiConObjErr.putFileErrLog(4001, "RmiConObjOutFile: close unsuccessuful: " + this.fileName, this.errLogFlag);
            throw RmiConObjErr.makeException(4001);
        }
    }

    static {
        int n = 0;
        while (n < 150) {
            RmiConObjOutFile.byteSpaceLine[n] = 32;
            ++n;
        }
    }
}

