/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.io.Serializable;

public class FastHiloChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 2;
    public static final int HI_SERIES_INDEX = 0;
    public static final int LO_SERIES_INDEX = 1;
    protected MinMax xlim = new MinMax();
    protected MinMax ylim = new MinMax();
    Point start = null;
    Point end = null;
    Rectangle r = null;

    public void draw(Graphics graphics) {
        try {
            if (this.seriesList == null) {
                return;
            }
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            int n = this.seriesList.size() / 2;
            int n2 = 0;
            int n3 = n;
            boolean bl = this.xaxis.isLogarithmic();
            boolean bl2 = this.yaxis.isLogarithmic();
            int n4 = n2;
            while (n4 < n3) {
                JCLineStyle jCLineStyle;
                Serializable serializable;
                boolean bl3 = true;
                boolean bl4 = true;
                int n5 = Integer.MAX_VALUE;
                int n6 = Integer.MAX_VALUE;
                int n7 = 2 * n4;
                int n8 = 0;
                while (n8 < 2) {
                    serializable = (ChartDataViewSeries)this.seriesList.get(n7);
                    if (!((ChartDataViewSeries)serializable).isVisible()) {
                        bl3 = false;
                        break;
                    }
                    if (((ChartDataViewSeries)serializable).maxXIndex() == 0 || ((ChartDataViewSeries)serializable).maxYIndex() == 0) {
                        bl4 = false;
                        break;
                    }
                    n5 = Math.min(n5, ((ChartDataViewSeries)serializable).getFirstPoint());
                    n6 = Math.min(n6, ((ChartDataViewSeries)serializable).getLastPoint());
                    ++n8;
                    ++n7;
                }
                if (bl4 && bl3 && (serializable = ((ChartDataViewSeries)this.seriesList.get(2 * n4)).getStyle()) != null && (jCLineStyle = ((JCChartStyle)serializable).getLineStyle()).updateGraphics(graphics)) {
                    Line2D.Double double_ = new Line2D.Double();
                    PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                    int n9 = n5;
                    while (n9 <= n6) {
                        int n10 = 2 * n4;
                        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n10++);
                        double d = chartDataViewSeries.getX(n9);
                        if (bl && d <= 0.0) {
                            d = this.holeValue;
                        }
                        double d2 = chartDataViewSeries.getY(n9);
                        if (bl2 && d2 <= 0.0) {
                            d2 = this.holeValue;
                        }
                        chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n10++);
                        double d3 = chartDataViewSeries.getX(n9);
                        if (bl && d3 <= 0.0) {
                            d3 = this.holeValue;
                        }
                        double d4 = chartDataViewSeries.getY(n9);
                        if (bl2 && d4 <= 0.0) {
                            d4 = this.holeValue;
                        }
                        plotPointArray[0].valid = false;
                        plotPointArray[1].valid = false;
                        this.financialClip(d, d2, d3, d4, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                        if (plotPointArray[0].valid && plotPointArray[1].valid) {
                            double_.setLine(plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py);
                            ((Graphics2D)graphics).draw(double_);
                        }
                        ++n9;
                    }
                    jCLineStyle.resetGraphics(graphics);
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
        return jCDataIndex.dataView.getXAxis().vertical ? n - this.r.x : n2 - this.r.y;
    }

    public int getNumSeriesPerData() {
        return 2;
    }

    public JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n2 = point.x - rectangle.x;
        int n3 = point.y - rectangle.y;
        int n4 = -1;
        int n5 = -1;
        JCDataIndex jCDataIndex = null;
        double d = Double.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        double d2 = this.dataObject.getHoleValue();
        boolean bl = this.xaxis.isLogarithmic();
        boolean bl2 = this.yaxis.isLogarithmic();
        int n6 = this.seriesList.size() / 2;
        int n7 = 0;
        int n8 = n6;
        try {
            int n9 = n7;
            while (n9 < n8) {
                boolean bl3 = true;
                boolean bl4 = true;
                int n10 = Integer.MAX_VALUE;
                int n11 = Integer.MAX_VALUE;
                int n12 = 2 * n9;
                int n13 = 0;
                while (n13 < 2) {
                    ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n12);
                    if (!chartDataViewSeries.isVisible()) {
                        bl4 = false;
                        break;
                    }
                    if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                        bl3 = false;
                        break;
                    }
                    n10 = Math.min(n10, chartDataViewSeries.getFirstPoint());
                    n11 = Math.min(n11, chartDataViewSeries.getLastPoint());
                    ++n13;
                    ++n12;
                }
                if (bl3 && bl4) {
                    int n14 = 2 * n9;
                    double[] dArray = ((ChartDataViewSeries)this.seriesList.get(n14)).getX();
                    double[] dArray2 = ((ChartDataViewSeries)this.seriesList.get(n14)).getY();
                    double[] dArray3 = ((ChartDataViewSeries)this.seriesList.get(n14 + 1)).getX();
                    double[] dArray4 = ((ChartDataViewSeries)this.seriesList.get(n14 + 1)).getY();
                    double d3 = 0.0;
                    double d4 = 0.0;
                    int n15 = n10;
                    while (n15 <= n11) {
                        int n16 = 0;
                        while (n16 < 2) {
                            switch (n16) {
                                case 0: {
                                    d3 = dArray[n15];
                                    d4 = dArray2[n15];
                                    break;
                                }
                                case 1: {
                                    d3 = dArray3[n15];
                                    d4 = dArray4[n15];
                                    break;
                                }
                            }
                            if (!(d3 == d2 || d4 == d2 || d3 > this.xlim.max || this.xlim.min > d3 || d4 > this.ylim.max || this.ylim.min > d4 || bl && d3 <= 0.0 || bl2 && d4 <= 0.0)) {
                                double d5;
                                switch (n) {
                                    case 1: {
                                        int n17 = this.xaxis.toPixel(d3, this.drawFront);
                                        d5 = this.inverted ? Math.abs(n17 - n3) : Math.abs(n17 - n2);
                                        break;
                                    }
                                    case 2: {
                                        int n18 = this.yaxis.toPixel(d4, this.drawFront);
                                        d5 = this.inverted ? Math.abs(n18 - n2) : Math.abs(n18 - n3);
                                        break;
                                    }
                                    default: {
                                        int n17 = this.xaxis.toPixel(d3, this.drawFront);
                                        int n18 = this.yaxis.toPixel(d4, this.drawFront);
                                        double d6 = d5 = this.inverted ? Math.sqrt((n18 - n2) * (n18 - n2) + (n17 - n3) * (n17 - n3)) : Math.sqrt((n17 - n2) * (n17 - n2) + (n18 - n3) * (n18 - n3));
                                    }
                                }
                                if (d > d5) {
                                    n4 = n9 * 2 + n16;
                                    n5 = n15;
                                    d = d5;
                                }
                            }
                            ++n16;
                        }
                        ++n15;
                    }
                }
                ++n9;
            }
            if (n4 >= 0 && n5 >= 0) {
                jCDataIndex = new JCDataIndex(n5, (ChartDataViewSeries)this.seriesList.get(n4), n4);
                jCDataIndex.distance = (int)d;
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n) {
        super.recalc();
        if (n == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        this.holeValue = this.dataObject.getHoleValue();
        this.inverted = this.xaxis.vertical;
        int n2 = this.seriesList.size() / 2;
        if (n == -1 || n == 0) {
            this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
            this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.getXAxis().vertical;
        this.chartArea.drawRubberLine(this.start, this.end);
        if (this.end == null) {
            this.end = bl ? new Point(n, jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n2);
        } else if (bl) {
            this.end.x = n;
        } else {
            this.end.y = n2;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n = jCDataIndex.series.getDrawingOrder() / 2;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        int n2 = n * 2;
        int n3 = jCDataIndex.seriesIndex - n2;
        double d = ((ChartDataViewSeries)this.seriesList.get(n2 + n3)).getX(jCDataIndex.point);
        double d2 = ((ChartDataViewSeries)this.seriesList.get(n2 + n3)).getY(jCDataIndex.point);
        this.start = this.inverted ? new Point(this.yaxis.toPixel(d2) + this.r.x, this.xaxis.toPixel(d) + this.r.y) : new Point(this.xaxis.toPixel(d) + this.r.x, this.yaxis.toPixel(d2) + this.r.y);
    }

    public Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n2);
        if (chartDataViewSeries == null) {
            return null;
        }
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }
}

