/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.ppa.jsr48;

import com.ws.utilities.Base64;
import com.ws.wbem.jserver.JServerClassLoader;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.ProviderAdapter;
import com.ws.wbem.jserver.profiles.common.WSBaseProvider;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.provider.IndicationProvider;
import javax.wbem.provider.Provider;
import javax.wbem.provider.ProviderHandle;
import javax.wbem.provider.PullAssociatorProvider;
import javax.wbem.provider.PullInstanceProvider;

public class JSR48ProviderAdapter
extends WSBaseProvider
implements ProviderAdapter {
    private static final String PROP_AUTH_ENABLED = "ProviderAuthenticationEnabled";
    private static final String PROP_KEYSTORE_FILE = "KeyStoreFile";
    private static final String PROP_KEYSTORE_PASSWD = "KeyStorePassword";
    private static JServerClassLoader dcl;
    private final Map<String, Provider> mProviderCache = new HashMap<String, Provider>();
    protected static Logger mLogger;
    private final String mProviderPath;
    private final String mPPASetting;

    protected static void removePath(String string) throws Exception {
    }

    private static String replaceSubString(String string, String string2, String string3) {
        if (string2 == null || string3 == null || string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.indexOf(string2);
        while (n >= 0) {
            stringBuffer.replace(n, n + string2.length(), string3);
            n = stringBuffer.indexOf(string2);
        }
        return stringBuffer.toString();
    }

    protected static void updatePath(String string) throws WBEMException {
        String string2 = JServerProperties.getBasedir();
        Object[] objectArray = new Object[]{string2};
        String string3 = MessageFormat.format(string, objectArray);
        dcl.addToClassPath(string3);
    }

    public JSR48ProviderAdapter() {
        mLogger = Logger.getLogger("com.ws.wbem.jserver");
        this.mProviderPath = JServerSettings.replaceSchemaClassName((String)"WS_JSR48ProviderAdapterClassPath");
        this.mPPASetting = JServerSettings.replaceSchemaClassName((String)"WS_JSR48POMASettingData");
        this.initClassLoader();
    }

    public void clearProviderCache() throws WBEMException {
        JSR48ProviderAdapter.setClassLoader(null);
        this.initClassLoader();
        this.initialize(mHandle);
    }

    private String decryptPassword(String string) {
        try {
            byte[] byArray = "She drives a red car Drives her red hat She's got a red door Plays with her red cat She's got a red light That lights up her red room She eats her red cake With my favorite red spoon".getBytes("UTF8");
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
            Cipher cipher = Cipher.getInstance("DESede");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
            cipher.init(2, secretKey);
            byte[] byArray2 = Base64.decode((String)string);
            byte[] byArray3 = cipher.doFinal(byArray2);
            StringBuffer stringBuffer = new StringBuffer();
            for (byte by : byArray3) {
                stringBuffer.append((char)by);
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            mLogger.log(Level.SEVERE, "Could not decrypt provider authorization keystore password,", throwable);
            return "";
        }
    }

    public IndicationProvider getIndicationProvider(String string, String string2, String[] stringArray) throws WBEMException {
        try {
            Provider provider = this.loadProvider(string, stringArray);
            if (provider instanceof IndicationProvider) {
                return (IndicationProvider)provider;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder("Provider ");
            stringBuilder.append(string);
            stringBuilder.append(" for class ");
            stringBuilder.append(string2);
            stringBuilder.append(" cannot be found");
            mLogger.fine(stringBuilder.toString());
            throw new WBEMException(1, stringBuilder.toString());
        }
        return null;
    }

    public Provider getProviderAdapter(Object object) throws ClassNotFoundException {
        if (object instanceof Provider) {
            return (Provider)object;
        }
        throw new ClassNotFoundException("Unrecognized object!");
    }

    public PullAssociatorProvider getPullAssociatorProvider(String string, String string2, String[] stringArray) throws WBEMException {
        try {
            Provider provider = this.loadProvider(string, stringArray);
            if (provider instanceof PullAssociatorProvider) {
                return (PullAssociatorProvider)provider;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder("Provider ");
            stringBuilder.append(string);
            stringBuilder.append(" for class ");
            stringBuilder.append(string2);
            stringBuilder.append(" cannot be found");
            mLogger.fine(stringBuilder.toString());
            throw new WBEMException(1, stringBuilder.toString());
        }
        return null;
    }

    public PullInstanceProvider getPullInstanceProvider(String string, String string2, String[] stringArray) throws WBEMException {
        try {
            Provider provider = this.loadProvider(string, stringArray);
            if (provider instanceof PullInstanceProvider) {
                return (PullInstanceProvider)provider;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder("Provider ");
            stringBuilder.append(string);
            stringBuilder.append(" for class ");
            stringBuilder.append(string2);
            stringBuilder.append(" cannot be found");
            mLogger.fine(stringBuilder.toString());
            throw new WBEMException(1, stringBuilder.toString());
        }
        return null;
    }

    private void initClassLoader() {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        dcl = classLoader instanceof JServerClassLoader ? (JServerClassLoader)classLoader : new JServerClassLoader(((Object)((Object)this)).getClass().getClassLoader());
    }

    public void initialize(ProviderHandle providerHandle) throws WBEMException {
        Object object;
        CIMInstance cIMInstance;
        CloseableIterator closeableIterator;
        super.initialize(providerHandle);
        CIMObjectPath cIMObjectPath = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), this.mProviderPath, null);
        try {
            closeableIterator = mInternalProvider.enumerateInstances(cIMObjectPath, null, null, null, false);
            while (closeableIterator.hasNext()) {
                cIMInstance = (CIMInstance)closeableIterator.next();
                CIMProperty cIMProperty = cIMInstance.getKeys()[0];
                try {
                    object = (String)cIMProperty.getValue();
                    JSR48ProviderAdapter.updatePath((String)object);
                }
                catch (Exception exception) {
                    mLogger.log(Level.WARNING, "Failure updating the classpath", exception);
                }
            }
        }
        catch (Exception exception) {
            mLogger.log(Level.SEVERE, "Problem enumerating path info", exception);
        }
        try {
            closeableIterator = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), this.mPPASetting, null);
            cIMInstance = (CIMInstance)mInternalProvider.enumerateInstances((CIMObjectPath)closeableIterator, null, null, null, false).next();
            boolean bl = false;
            object = (Boolean)cIMInstance.getPropertyValue(PROP_AUTH_ENABLED);
            bl = (Boolean)object;
            if (bl) {
                String string = (String)cIMInstance.getPropertyValue(PROP_KEYSTORE_PASSWD);
                String string2 = (String)cIMInstance.getPropertyValue(PROP_KEYSTORE_FILE);
                string2 = JSR48ProviderAdapter.replaceSubString(string2, "{0}", JServerProperties.getBasedir());
                String string3 = string;
                if (string != null && string.length() > 0) {
                    string3 = this.decryptPassword(string);
                }
                dcl.setKeystoreInfo(string2, string3);
            }
        }
        catch (Exception exception) {
            mLogger.log(Level.INFO, "no provider authorization information found", exception);
        }
    }

    private Provider loadProvider(String string, String[] stringArray) throws ClassNotFoundException {
        StringBuilder stringBuilder;
        try {
            mLogger.log(Level.INFO, "Request to load provider {0}", string);
            stringBuilder = null;
            Provider provider = this.mProviderCache.get(string);
            if (provider != null) {
                mLogger.log(Level.INFO, "Provider {0} was found in the cached", string);
                return provider;
            }
            if (!dcl.verifyClassAuthorized(string)) {
                mLogger.log(Level.WARNING, "could not load provider {0}. Provider could not be authorized", new Object[]{string});
                throw new WBEMException("Could not authorize provider:" + string);
            }
            Class clazz = dcl.loadClass(string);
            mLogger.log(Level.INFO, "Loaded provider: {0}", clazz.getName());
            stringBuilder = (StringBuilder)clazz.newInstance();
            if (stringBuilder instanceof Provider) {
                Provider provider2 = (Provider)stringBuilder;
                mLogger.log(Level.FINE, "Initializing {0} provider", clazz.getName());
                provider2.initialize(mHandle);
                mLogger.log(Level.FINE, "provider {0} initialized", clazz.getName());
                this.mProviderCache.put(string, provider2);
                return provider2;
            }
        }
        catch (InstantiationException instantiationException) {
            mLogger.log(Level.WARNING, "Caught InstantiationException: {0}", instantiationException.getLocalizedMessage());
            throw new ClassNotFoundException(instantiationException.toString(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            mLogger.log(Level.WARNING, "Caught IllegalAccessException: {0}", illegalAccessException.getLocalizedMessage());
            throw new ClassNotFoundException(illegalAccessException.toString(), illegalAccessException);
        }
        catch (WBEMException wBEMException) {
            mLogger.log(Level.WARNING, "Caught WBEMException: {0}", wBEMException.getLocalizedMessage());
            throw new ClassNotFoundException(wBEMException.toString(), wBEMException);
        }
        stringBuilder = new StringBuilder(string);
        stringBuilder.append(" can not be loaded since it is not of type \"Provider\".");
        mLogger.warning(stringBuilder.toString());
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private static void setClassLoader(JServerClassLoader jServerClassLoader) {
        dcl = jServerClassLoader;
    }

    public void start(CIMInstance cIMInstance) {
    }

    public void stop() {
        for (Provider provider : this.mProviderCache.values()) {
            try {
                provider.close();
            }
            catch (WBEMException wBEMException) {
                mLogger.warning("Received exception trying to call close() on provider: " + provider.getClass().getName());
            }
        }
    }

    public void shutdown() {
    }
}

