/*
 * Decompiled with CFR 0.152.
 */
package sanproject.exauthrelay.thread;

import sanproject.exauthrelay.SJexauthExAuthRelay;
import sanproject.exauthrelay.data.EX_AUTH_IF_STRUCTURE;
import sanproject.exauthrelay.data.EX_AUTH_STRUCT;
import sanproject.exauthrelay.sender.SJexauthSender;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJexauthExAuthRelayThread
extends Thread {
    private static final String LOG_FUNC = "ExAuthRelay";
    private static final String LOG_TITLE = SJexauthExAuthRelayThread.class.getSimpleName();
    private SJcLoggerInterface logger = null;
    private SJexauthSender sender = null;
    EX_AUTH_IF_STRUCTURE ifStructure = new EX_AUTH_IF_STRUCTURE();
    String userId = null;
    String passWd = null;
    int ssoOpt = 0;

    public SJexauthExAuthRelayThread(EX_AUTH_IF_STRUCTURE paramStructure) throws Throwable {
        String LOG_SUBTITLE = "SJexauthExAuthRelayThread";
        try {
            this.logger = SJcLogUty.getLogger();
            this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "Start.");
            this.printEX_AUTH_IF_STRUCTURE(paramStructure);
            this.sender = new SJexauthSender();
            this.initEX_AUTH_IF_STRUCTURE(paramStructure);
            this.userId = this.getString(paramStructure.gumMapIfStruct.userId, 256);
            this.passWd = this.getString(paramStructure.gumMapIfStruct.passWord, 256);
            this.ssoOpt = paramStructure.gumMapIfStruct.hcsSsoFlg;
            this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "End. userId:" + this.userId);
        }
        catch (Throwable th) {
            this.logger.error(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "Throwable occured.", th);
            throw th;
        }
    }

    public void run() {
        String LOG_SUBTITLE = "run";
        EX_AUTH_STRUCT result = null;
        this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "Start.userId:" + this.userId + " " + "SSO_Option:" + this.ssoOpt);
        try {
            SJexauthExAuthRelay relay = new SJexauthExAuthRelay(this.ssoOpt);
            result = relay.authentication(this.userId, this.passWd);
            this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "relay.authentication() result:" + result.result);
            this.printEX_AUTH_STRUCT(result);
            this.setResult(result);
            EX_AUTH_IF_STRUCTURE param = this.ifStructure;
            int param_len = this.ifStructure.size();
            this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "param_len:" + param_len);
            this.sender.sendExAuthResponse((Object)param, param_len);
        }
        catch (Throwable th) {
            this.logger.error(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "Throwable occured.", th);
        }
        this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "End.");
    }

    private void setResult(EX_AUTH_STRUCT result) {
        String LOG_SUBTITLE = "setResult";
        this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "Start.");
        this.ifStructure.setResult(result.result);
        this.ifStructure.setGroupID(result.groupID);
        this.ifStructure.setRoleID(result.roleID);
        this.ifStructure.setRscGroupMap(result.resourceGroupMap);
        this.ifStructure.setAllRSG(result.isAllRSG);
        this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "End.");
    }

    private String getString(byte[] srcArray, int size) {
        String result = null;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size && srcArray[i] != 0; ++i) {
            sb.append((char)srcArray[i]);
        }
        result = sb.toString();
        return result;
    }

    private String getResourceGroupMapString(byte[] srcArray, int size) {
        String result = null;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            byte value = srcArray[i];
            for (int j = 0; j < 8; ++j) {
                if ((128 >> j & value) == 128 >> j) {
                    sb.append("1");
                    continue;
                }
                sb.append("0");
            }
        }
        result = sb.toString();
        return result;
    }

    private void initEX_AUTH_IF_STRUCTURE(EX_AUTH_IF_STRUCTURE paramStructure) {
        this.ifStructure.comHeaderStruct = paramStructure.comHeaderStruct;
        this.ifStructure.gumMapIfStruct.userId = paramStructure.gumMapIfStruct.userId;
        this.ifStructure.gumMapIfStruct.passWord = paramStructure.gumMapIfStruct.passWord;
    }

    private void printEX_AUTH_IF_STRUCTURE(EX_AUTH_IF_STRUCTURE st) {
        String LOG_SUBTITLE = "printEX_AUTH_IF_STRUCTURE";
        if (st == null) {
            this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "st is null.");
            return;
        }
        if (st.comHeaderStruct == null) {
            this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "st.comHeaderStruct is null.");
            return;
        }
        if (st.gumMapIfStruct == null) {
            this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "st.gumMapIfStruct is null.");
            return;
        }
        String header = this.getString(st.comHeaderStruct.header, 208);
        String userid = this.getString(st.gumMapIfStruct.userId, 256);
        this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "header:" + header);
        this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "userid:" + userid);
        this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "hcsssoflg:" + st.gumMapIfStruct.hcsSsoFlg);
    }

    private void printEX_AUTH_STRUCT(EX_AUTH_STRUCT st) {
        int i$;
        int len$;
        byte[][] arr$;
        String LOG_SUBTITLE = "printEX_AUTH_STRUCT";
        if (st == null) {
            this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "st is null.");
            return;
        }
        if (st.userName != null) {
            String userid = this.getString(st.userName, 256);
            this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "userid:" + userid);
        }
        this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "result:" + st.result);
        if (!st.result) {
            return;
        }
        if (st.groupID != null) {
            byte[] groupIdArray;
            String gourpId;
            arr$ = st.groupID;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$ && (gourpId = this.getString(groupIdArray = arr$[i$], 64)) != null && !gourpId.equals(""); ++i$) {
                this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "gourpId:" + gourpId);
            }
        }
        if (st.roleID != null) {
            byte[] roleIdArray;
            String roleId;
            arr$ = st.roleID;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$ && (roleId = this.getString(roleIdArray = arr$[i$], 64)) != null && !roleId.equals(""); ++i$) {
                this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "roleId:" + roleId);
            }
        }
        if (st.resourceGroupMap != null) {
            String resourceGroupMap = this.getResourceGroupMapString(st.resourceGroupMap, 128);
            this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "resourceGroupMap:" + resourceGroupMap);
        }
        this.logger.info(LOG_FUNC, LOG_TITLE, LOG_SUBTITLE, "isAllRSG:" + st.isAllRSG);
    }
}

