/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class SanProperties {
    protected Properties properties = new Properties();
    protected File file;

    public static void main(String[] stringArray) {
        SanProperties sanProperties = new SanProperties(new File(stringArray[0]));
        if (stringArray[1].equals("getProperty")) {
            System.out.print(sanProperties.getProperty(stringArray[2]));
        } else if (stringArray[1].equals("setProperty")) {
            sanProperties.setProperty(stringArray[2], stringArray[3]);
            sanProperties.writeProperties();
        }
    }

    public SanProperties() {
        this.file = null;
    }

    public SanProperties(File file) {
        this.file = file;
        this.readProperties(file);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean readProperties() {
        return this.readProperties(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readProperties(File file) {
        boolean bl = false;
        this.file = file;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            this.properties.load(bufferedReader);
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                } else if (inputStreamReader != null) {
                    inputStreamReader.close();
                } else if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }

    public boolean writeProperties() {
        return this.writeProperties(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeProperties(File file) {
        boolean bl = false;
        this.file = file;
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            this.properties.store(bufferedWriter, null);
            bl = true;
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                } else if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                } else if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public Object setProperty(String string, String string2) {
        return this.properties.setProperty(string, string2);
    }

    public Set<String> stringPropertyNames() {
        return this.properties.stringPropertyNames();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println();
        this.properties.list(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public SanProperties copyTo(SanProperties sanProperties) {
        sanProperties.file = this.file;
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            sanProperties.setProperty(string, string2);
        }
        return sanProperties;
    }

    protected class Properties
    extends java.util.Properties {
        private final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        protected Properties() {
        }

        private String saveConvert(String string, boolean bl, boolean bl2) {
            int n = string.length();
            int n2 = n * 2;
            if (n2 < 0) {
                n2 = Integer.MAX_VALUE;
            }
            StringBuffer stringBuffer = new StringBuffer(n2);
            block8: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c > '=' && c < '\u007f') {
                    if (c == '\\') {
                        stringBuffer.append('\\');
                        stringBuffer.append('\\');
                        continue;
                    }
                    stringBuffer.append(c);
                    continue;
                }
                switch (c) {
                    case ' ': {
                        if (i == 0 || bl) {
                            stringBuffer.append('\\');
                        }
                        stringBuffer.append(' ');
                        continue block8;
                    }
                    case '\t': {
                        stringBuffer.append('\\');
                        stringBuffer.append('t');
                        continue block8;
                    }
                    case '\n': {
                        stringBuffer.append('\\');
                        stringBuffer.append('n');
                        continue block8;
                    }
                    case '\r': {
                        stringBuffer.append('\\');
                        stringBuffer.append('r');
                        continue block8;
                    }
                    case '\f': {
                        stringBuffer.append('\\');
                        stringBuffer.append('f');
                        continue block8;
                    }
                    case '!': 
                    case '#': 
                    case ':': 
                    case '=': {
                        stringBuffer.append('\\');
                        stringBuffer.append(c);
                        continue block8;
                    }
                    default: {
                        if ((c < ' ' || c > '~') & bl2) {
                            stringBuffer.append('\\');
                            stringBuffer.append('u');
                            stringBuffer.append(this.toHex(c >> 12 & 0xF));
                            stringBuffer.append(this.toHex(c >> 8 & 0xF));
                            stringBuffer.append(this.toHex(c >> 4 & 0xF));
                            stringBuffer.append(this.toHex(c & 0xF));
                            continue block8;
                        }
                        stringBuffer.append(c);
                    }
                }
            }
            return stringBuffer.toString();
        }

        private void writeComments(BufferedWriter bufferedWriter, String string) throws IOException {
            int n;
            bufferedWriter.write("#");
            int n2 = string.length();
            int n3 = 0;
            char[] cArray = new char[6];
            cArray[0] = 92;
            cArray[1] = 117;
            for (n = 0; n < n2; ++n) {
                char c = string.charAt(n);
                if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
                if (n3 != n) {
                    bufferedWriter.write(string.substring(n3, n));
                }
                if (c > '\u00ff') {
                    cArray[2] = this.toHex(c >> 12 & 0xF);
                    cArray[3] = this.toHex(c >> 8 & 0xF);
                    cArray[4] = this.toHex(c >> 4 & 0xF);
                    cArray[5] = this.toHex(c & 0xF);
                    bufferedWriter.write(new String(cArray));
                } else {
                    bufferedWriter.newLine();
                    if (c == '\r' && n != n2 - 1 && string.charAt(n + 1) == '\n') {
                        ++n;
                    }
                    if (n == n2 - 1 || string.charAt(n + 1) != '#' && string.charAt(n + 1) != '!') {
                        bufferedWriter.write("#");
                    }
                }
                n3 = n + 1;
            }
            if (n3 != n) {
                bufferedWriter.write(string.substring(n3, n));
            }
            bufferedWriter.newLine();
        }

        @Override
        public void store(Writer writer, String string) throws IOException {
            this.store0(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), string, false);
        }

        @Override
        public void store(OutputStream outputStream, String string) throws IOException {
            this.store0(new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1")), string, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void store0(BufferedWriter bufferedWriter, String string, boolean bl) throws IOException {
            if (string != null) {
                this.writeComments(bufferedWriter, string);
            }
            bufferedWriter.write("#" + new Date().toString());
            bufferedWriter.newLine();
            Properties properties = this;
            synchronized (properties) {
                ArrayList<String> arrayList = new ArrayList<String>(this.stringPropertyNames());
                Collections.sort(arrayList);
                for (String string2 : arrayList) {
                    String string3 = this.getProperty(string2);
                    string2 = this.saveConvert(string2, true, bl);
                    string3 = this.saveConvert(string3, false, bl);
                    bufferedWriter.write(string2 + "=" + string3);
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.flush();
        }

        @Override
        public void list(PrintStream printStream) {
            printStream.println("-- listing properties --");
            ArrayList<String> arrayList = new ArrayList<String>(this.stringPropertyNames());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                String string2 = this.getProperty(string);
                if (string2.length() > 40) {
                    string2 = string2.substring(0, 37) + "...";
                }
                printStream.println(string + "=" + string2);
            }
        }

        @Override
        public void list(PrintWriter printWriter) {
            printWriter.println("-- listing properties --");
            ArrayList<String> arrayList = new ArrayList<String>(this.stringPropertyNames());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                String string2 = this.getProperty(string);
                if (string2.length() > 40) {
                    string2 = string2.substring(0, 37) + "...";
                }
                printWriter.println(string + "=" + string2);
            }
        }

        private char toHex(int n) {
            return this.hexDigit[n & 0xF];
        }
    }
}

