/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.csv;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import sanproject.sn2.rptdt.csv.wrapper.SJdtCSVWrapperBase;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;

public class SJdtCSVWrapperManager {
    private static Logger logger = Logger.getLogger(SJdtCSVWrapperManager.class.getName());
    public static String inputDir = null;
    private static Properties validatorProc = null;
    private static Map<String, SJdtCSVWrapperBase> csvDataMap = new HashMap<String, SJdtCSVWrapperBase>();
    private static int NOTHING_DATA = -1;

    public static void setInputDir(String dir) {
        inputDir = dir;
    }

    public static void setValidatorData(Properties proc) {
        validatorProc = proc;
    }

    public static String getValidatorValue(String key) {
        return (String)validatorProc.get(key);
    }

    public static void setCsvWrapper(String csvFileName, SJdtCSVWrapperBase csvWrapper) {
        csvDataMap.put(csvFileName, csvWrapper);
    }

    public static SJdtCSVWrapperBase getCsvWrapper(String csvFileName) {
        return csvDataMap.get(csvFileName);
    }

    public static List<String[]> getCsvData_onlyUseData(String csvFileName, String csvFilePath) throws SJdtRPTDTException {
        ArrayList<String[]> csvData = new ArrayList<String[]>();
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(csvFilePath);
            isr = new InputStreamReader((InputStream)fis, "utf-8");
            br = new BufferedReader(isr);
            String lineDataFirstLow = br.readLine();
            String[] csvDataFirstLow = lineDataFirstLow.split(",", -1);
            csvData.add(csvDataFirstLow);
            String lineDataSecondLow = br.readLine();
            String[] csvDataSecondLow = lineDataSecondLow.split(",", -1);
            String useLineData = SJdtCSVWrapperManager.getValidatorValue(csvFileName + ".usedata");
            String[] useCsvDataColumn = useLineData.split(",", -1);
            String[] useCsvColumnRecord = new String[useCsvDataColumn.length];
            int[] useCsvIndex = new int[useCsvDataColumn.length];
            block11: for (int useIndex = 0; useIndex < useCsvDataColumn.length; ++useIndex) {
                useCsvIndex[useIndex] = NOTHING_DATA;
                useCsvColumnRecord[useIndex] = "";
                for (int csvIndex = 0; csvIndex < csvDataSecondLow.length; ++csvIndex) {
                    if (!useCsvDataColumn[useIndex].equals(csvDataSecondLow[csvIndex])) continue;
                    useCsvIndex[useIndex] = csvIndex;
                    useCsvColumnRecord[useIndex] = csvDataSecondLow[csvIndex];
                    continue block11;
                }
            }
            csvData.add(useCsvColumnRecord);
            String lineDataThirdLow = "";
            while ((lineDataThirdLow = br.readLine()) != null) {
                String[] csvDataThirdLow = lineDataThirdLow.split(",", -1);
                String[] useCsvData = new String[useCsvDataColumn.length];
                for (int useIndex = 0; useIndex < useCsvDataColumn.length; ++useIndex) {
                    if (useCsvIndex[useIndex] == NOTHING_DATA) continue;
                    useCsvData[useIndex] = csvDataThirdLow[useCsvIndex[useIndex]];
                }
                csvData.add(useCsvData);
            }
        }
        catch (FileNotFoundException e) {
            logger.severe("filePath=[" + csvFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        catch (UnsupportedEncodingException e) {
            logger.severe("filePath=[" + csvFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        catch (IOException e) {
            logger.severe("filePath=[" + csvFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
            }
        }
        return csvData;
    }

    public static List<String[]> getCsvData(String csvFilePath) throws SJdtRPTDTException {
        String[] lineArray;
        ArrayList<String[]> csvData = new ArrayList<String[]>();
        List<String> lineList = SJdtCSVWrapperManager.getLineList(csvFilePath, "utf-8");
        for (String line : lineArray = lineList.toArray(new String[0])) {
            String[] s = line.split(",", -1);
            csvData.add(s);
        }
        return csvData;
    }

    public static List<String> getLineList(String filePath, String encoding) throws SJdtRPTDTException {
        ArrayList<String> lineList = new ArrayList<String>();
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(filePath);
            isr = new InputStreamReader((InputStream)fis, encoding);
            br = new BufferedReader(isr);
            String str = null;
            while ((str = br.readLine()) != null) {
                lineList.add(str);
            }
        }
        catch (FileNotFoundException e) {
            logger.severe("filePath=[" + filePath + "]");
            throw new SJdtRPTDTException(e);
        }
        catch (UnsupportedEncodingException e) {
            logger.severe("filePath=[" + filePath + "]");
            throw new SJdtRPTDTException(e);
        }
        catch (IOException e) {
            logger.severe("filePath=[" + filePath + "]");
            throw new SJdtRPTDTException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
            }
        }
        return lineList;
    }

    public static Map<String, Integer> getCsvColumnMap(String[] columnArray) {
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        for (int i = 0; i < columnArray.length; ++i) {
            columnMap.put(columnArray[i], i);
        }
        return columnMap;
    }
}

