/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.VelocityContext;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtHduInfoCSVWrapper;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;
import sanproject.sn2.rptdt.report.SJdtReportGeneratorManager;
import sanproject.sn2.rptdt.report.generator.SJdtReportGeneratorBase;
import sanproject.sn2.rptdt.report.generator.TableHeaderInfo;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;

public abstract class SJdtTableReportGenerator
extends SJdtReportGeneratorBase {
    private static Logger logger = Logger.getLogger(SJdtTableReportGenerator.class.getName());
    protected static Map<String, Integer> headerMap = new HashMap<String, Integer>();
    private static final String TABLE_NO_INFOMATION_AVAILABLE_FOR_KEY = "Common.table.noInformationAvailableFor";
    protected static final String TABLE_HEADER_KEY = ".table.header";
    private static final String CONTENTS_BODY_TABLE_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/common/vm/contentsBody_FlexTable.vm";
    private static final String CONTENTS_BODY_MULTITABLE_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/common/vm/contentsBody_Flex";
    private static final String CONTENTS_BODY_NOT_TABLE_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/common/vm/contentsBody_NotTable.vm";
    private static int SORT_INDEX_MAX = 700000;
    private static String[] SORT_INDEX = null;
    private static VelocityContext context = null;
    static Pattern parityPattern = Pattern.compile("^(\\D*)(\\d+)-(\\d+)$");
    static Pattern bytePattern = Pattern.compile("^(\\d+\\.\\d+|\\d+)(\\D+)$");

    protected static int getColumnLengthForKeySort(int headerKeyArrayLength) {
        return headerKeyArrayLength * 2;
    }

    @Override
    public void generateReportDir() {
        super.generateReportDir();
        SJdtReportGeneratorManager.generateDir(this.OUTPUT_DATA_DIR);
    }

    public int numberOfTables() {
        return 0;
    }

    public boolean isMultiTable() {
        return false;
    }

    @Override
    public void generateContentsBody() throws SJdtRPTDTException {
        this.setTableHeaderMap(this.getTableHeaderKeyArray());
        context = SJdtReportGeneratorManager.getVelocityContext();
        List<String[]> tableDataList = this.getTableDataList();
        String vmFilePath = null;
        if (tableDataList.size() > 0) {
            if (SORT_INDEX == null) {
                SORT_INDEX = new String[SORT_INDEX_MAX];
                for (int i = 0; i < SORT_INDEX_MAX; ++i) {
                    SJdtTableReportGenerator.SORT_INDEX[i] = String.valueOf(i + 1000000);
                }
            }
            if (this.isEnableSortKey()) {
                this.setSortKey(tableDataList);
            }
            TableHeaderInfo tableHeaderInfo = this.getTableHeaderInfo();
            tableDataList.add(0, tableHeaderInfo.getNameArray());
            String generateCsvFilePath = this.getReportName() + ".csv";
            SJdtReportGeneratorManager.generateFile(tableDataList, this.OUTPUT_DATA_DIR + generateCsvFilePath);
            String vars = this.getFlashVers(tableHeaderInfo, generateCsvFilePath);
            context.put("FlashVars", (Object)vars);
            if (this.isMultiTable()) {
                this.generateContentsBodyMulti();
                if (SJdtRPTDTDevice.isHmdev()) {
                    String model = SJdtRPTDTDevice.getModel(SJdtRPTDTDevice.getModelInfo());
                    vmFilePath = CONTENTS_BODY_MULTITABLE_VM_FILE_PATH + this.getReportName() + "HM_" + model + ".vm";
                } else {
                    vmFilePath = CONTENTS_BODY_MULTITABLE_VM_FILE_PATH + this.getReportName() + ".vm";
                }
            } else {
                vmFilePath = CONTENTS_BODY_TABLE_VM_FILE_PATH;
            }
        } else {
            context.put("noInformationAvailableFor", (Object)SJdtReportGeneratorManager.getGuidanceValue(TABLE_NO_INFOMATION_AVAILABLE_FOR_KEY));
            context.put("menuLinkStr", (Object)SJdtReportGeneratorManager.getGuidanceValue(this.getMenuLinkViewKey()));
            vmFilePath = CONTENTS_BODY_NOT_TABLE_VM_FILE_PATH;
        }
        this.setHduInfo();
        String generateFilePath = this.OUTPUT_HTML_DIR + this.getContentsBodyHtmlFileName();
        SJdtReportGeneratorManager.generateFile(context, vmFilePath, generateFilePath);
    }

    private void generateContentsBodyMulti() throws SJdtRPTDTException {
        boolean AFA_Flg = false;
        for (int k = 0; k < this.numberOfTables(); ++k) {
            String[] tableHeaderKeyArrayMulti = this.getTableHeaderKeyArrayMulti(k).get(k).toArray(new String[0]);
            this.setTableHeaderMap(tableHeaderKeyArrayMulti);
            List<String[]> tableDataListMulti = this.getTableDataListMulti(k, tableHeaderKeyArrayMulti).get(k);
            if (tableDataListMulti.size() <= 0) continue;
            if (SORT_INDEX == null) {
                SORT_INDEX = new String[SORT_INDEX_MAX];
                for (int i = 0; i < SORT_INDEX_MAX; ++i) {
                    SJdtTableReportGenerator.SORT_INDEX[i] = String.valueOf(i + 1000000);
                }
            }
            if (this.isEnableSortKey()) {
                this.setSortKey(tableDataListMulti, tableHeaderKeyArrayMulti);
            }
            String[] tableData = this.setHduInfo1(k);
            TableHeaderInfo tableHeaderInfoMulti = this.getTableHeaderInfoEx(tableData);
            tableDataListMulti.add(0, tableHeaderInfoMulti.getNameArray());
            String generateCsvFilePathMulti = this.getReportName() + (k + 1) + ".csv";
            SJdtReportGeneratorManager.generateFile(tableDataListMulti, this.OUTPUT_DATA_DIR + generateCsvFilePathMulti);
            String varsMulti = this.getFlashVers(tableHeaderInfoMulti, generateCsvFilePathMulti);
            context.put("FlashVars" + k, (Object)varsMulti);
        }
    }

    public boolean isEnableSortKey() {
        return false;
    }

    private void setSortKey(List<String[]> table) {
        for (String tableHeaderKey : this.getTableHeaderKeyArray()) {
            String key = this.getTableHeaderBaseKey() + "." + tableHeaderKey;
            String line = SJdtReportGeneratorManager.getGuidanceValue(key);
            String[] strArray = line.split(",", -1);
            if ("none".equals(strArray[1])) continue;
            this.setSortKey(table, tableHeaderKey, strArray[1]);
        }
    }

    private void setSortKey(List<String[]> table, String[] getTableHeaderArray) {
        for (String tableHeaderKey : getTableHeaderArray) {
            String key = this.getTableHeaderBaseKey() + "." + tableHeaderKey;
            String line = SJdtReportGeneratorManager.getGuidanceValue(key);
            String[] strArray = line.split(",", -1);
            if ("none".equals(strArray[1])) continue;
            this.setSortKey(table, tableHeaderKey, strArray[1]);
        }
    }

    private void setTableHeaderMap(String[] headerArray) {
        int count = 0;
        for (int i = 0; i < headerArray.length; ++i) {
            headerMap.put(headerArray[i], count++);
            if (!this.isEnableSortKey()) continue;
            headerMap.put(headerArray[i] + "_key", count++);
        }
    }

    private TableHeaderInfo getTableHeaderInfo() {
        String[] tableHeaderKeyArray;
        TableHeaderInfo tableHeaderInfo = new TableHeaderInfo();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> sortTypeList = new ArrayList<String>();
        ArrayList<String> positionList = new ArrayList<String>();
        for (String tableHeaderKey : tableHeaderKeyArray = this.getTableHeaderKeyArray()) {
            String key = this.getTableHeaderBaseKey() + "." + tableHeaderKey;
            String line = SJdtReportGeneratorManager.getGuidanceValue(key);
            String[] strArray = line.split(",", -1);
            nameList.add(strArray[0]);
            sortTypeList.add(strArray[1]);
            positionList.add(strArray[2]);
            if (!this.isEnableSortKey()) continue;
            nameList.add(strArray[0] + "(key)");
            sortTypeList.add("charSort");
            positionList.add("na");
        }
        tableHeaderInfo.setNameArray(nameList.toArray(new String[0]));
        tableHeaderInfo.setSortTypeList(sortTypeList);
        tableHeaderInfo.setPositionList(positionList);
        return tableHeaderInfo;
    }

    private TableHeaderInfo getTableHeaderInfo(String[] tableHeaderKeyArray) {
        TableHeaderInfo tableHeaderInfo = new TableHeaderInfo();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> sortTypeList = new ArrayList<String>();
        ArrayList<String> positionList = new ArrayList<String>();
        for (String tableHeaderKey : tableHeaderKeyArray) {
            String key = this.getTableHeaderBaseKey() + "." + tableHeaderKey;
            String line = SJdtReportGeneratorManager.getGuidanceValue(key);
            String[] strArray = line.split(",", -1);
            nameList.add(strArray[0]);
            sortTypeList.add(strArray[1]);
            positionList.add(strArray[2]);
            if (!this.isEnableSortKey()) continue;
            nameList.add(strArray[0] + "(key)");
            sortTypeList.add("charSort");
            positionList.add("na");
        }
        tableHeaderInfo.setNameArray(nameList.toArray(new String[0]));
        tableHeaderInfo.setSortTypeList(sortTypeList);
        tableHeaderInfo.setPositionList(positionList);
        return tableHeaderInfo;
    }

    private String getFlashVers(TableHeaderInfo tableHeaderInfo, String csvFilePath) {
        StringBuilder sb = new StringBuilder();
        sb.append("FILEPATH=");
        sb.append("../data/").append(csvFilePath);
        sb.append("&");
        sb.append("POS=");
        List<String> positionList = tableHeaderInfo.getPositionList();
        for (int i = 0; i < positionList.size(); ++i) {
            String positon = positionList.get(i);
            sb.append(i).append(":").append(positon).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("&");
        sb.append("ALLSORTOFF=");
        sb.append("true");
        List<String> sortTypeList = tableHeaderInfo.getSortTypeList();
        if (this.existsSortHeader(sortTypeList)) {
            sb.append("&");
            sb.append("SORTON=");
            StringBuilder sortTypeBuilder = new StringBuilder();
            sortTypeBuilder.append("SORTTYPE=");
            for (int i = 0; i < sortTypeList.size(); ++i) {
                String sortType = sortTypeList.get(i);
                if ("none".equals(sortType)) continue;
                sb.append(i).append(",");
                sortTypeBuilder.append(i).append(":").append(sortType).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("&");
            sortTypeBuilder.deleteCharAt(sortTypeBuilder.length() - 1);
            sb.append((CharSequence)sortTypeBuilder);
        }
        if (this.isEnableSortKey()) {
            sb.append("&");
            sb.append("SORTKEY=");
            sb.append("true");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("FlashVars=[" + sb.toString() + "]");
        }
        return sb.toString();
    }

    private boolean existsSortHeader(List<String> sortTypeList) {
        boolean result = false;
        for (String sortType : sortTypeList) {
            if ("none".equals(sortType)) continue;
            result = true;
            break;
        }
        return result;
    }

    public abstract String[] getTableHeaderKeyArray();

    public HashMap<Integer, List<String>> getTableHeaderKeyArrayMulti(int cnt) {
        return null;
    }

    public abstract String getTableHeaderBaseKey();

    public abstract List<String[]> getTableDataList();

    public HashMap<Integer, List<String[]>> getTableDataListMulti(int cnt, String[] tableHeader) {
        return null;
    }

    public void setSortKey(List<String[]> table, String target, String type) {
        String[] one;
        int i;
        String[][] work = new String[table.size()][3];
        int indexTarget = headerMap.get(target);
        int indexKey = headerMap.get(target + "_key");
        for (i = 0; i < table.size(); ++i) {
            one = table.get(i);
            work[i][0] = one[indexTarget];
            work[i][1] = SORT_INDEX[i];
        }
        this.workSort(work, type, 0);
        for (i = 0; i < work.length; ++i) {
            work[i][2] = SORT_INDEX[i];
        }
        this.workSort(work, "charSort", 1);
        for (i = 0; i < table.size(); ++i) {
            one = table.get(i);
            one[indexKey] = work[i][2];
        }
    }

    public void workSort(String[][] work, String type, int columnIndex) {
        TwoDimensionComparator c = null;
        c = type.equals("numSort") ? new NumTwoDimentionComparator(columnIndex) : (type.equals("PARITY") ? new ParityTwoDimentionComparator(columnIndex) : (type.equals("BYTE") ? new ByteTwoDimensionComparator(columnIndex) : (type.equals("SPNUM") ? new SpNumTwoDimentionComparator(columnIndex) : (type.equals("MIX") ? new MixTwoDimensionComparator(columnIndex) : (type.equals("PMIX") ? new MixAndPointTwoDimensionComparator(columnIndex) : new TwoDimensionComparator(columnIndex))))));
        Arrays.sort(work, c);
    }

    private double convertByte(double value, String unit) {
        if (unit.equals("KB")) {
            return value * Math.pow(10.0, 3.0);
        }
        if (unit.equals("MB")) {
            return value * Math.pow(10.0, 6.0);
        }
        if (unit.equals("GB")) {
            return value * Math.pow(10.0, 9.0);
        }
        if (unit.equals("TB")) {
            return value * Math.pow(10.0, 12.0);
        }
        if (unit.equals("PB")) {
            return value * Math.pow(10.0, 15.0);
        }
        return value;
    }

    public void setHduInfo() {
        int Cnt = 0;
        SJdtHduInfoCSVWrapper hduInfo = (SJdtHduInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("HduInfo.csv");
        List<String[]> hduInfoRecordList = hduInfo.getPrefixMatchedAllRecord("DB", "DB Location");
        for (String[] hduInfoRecord : hduInfoRecordList) {
            String hduLocation = hduInfo.getValue(hduInfoRecord, "DB Location");
            context.put("FlashDB" + Cnt, (Object)hduLocation);
            ++Cnt;
        }
    }

    public String[] setHduInfo1(int cnt) {
        return null;
    }

    private TableHeaderInfo getTableHeaderInfoEx(String[] tableHeaderKeyArray) {
        TableHeaderInfo tableHeaderInfo = new TableHeaderInfo();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> sortTypeList = new ArrayList<String>();
        ArrayList<String> positionList = new ArrayList<String>();
        for (String tableHeaderKey : tableHeaderKeyArray) {
            String[] strArray = tableHeaderKey.split(",", -1);
            nameList.add(strArray[0]);
            sortTypeList.add(strArray[1]);
            positionList.add(strArray[2]);
            if (!this.isEnableSortKey()) continue;
            nameList.add(strArray[0] + "(key)");
            sortTypeList.add("charSort");
            positionList.add("na");
        }
        tableHeaderInfo.setNameArray(nameList.toArray(new String[0]));
        tableHeaderInfo.setSortTypeList(sortTypeList);
        tableHeaderInfo.setPositionList(positionList);
        return tableHeaderInfo;
    }

    class MixAndPointTwoDimensionComparator
    extends MixTwoDimensionComparator {
        private final String REGULAR_EXPRESSION_MIXANDPOINT_TWODIMENSION_COMPARATOR = "(\\d+)(\\.\\d*|\\.?)";

        public MixAndPointTwoDimensionComparator(int columnIndex) {
            super(columnIndex);
            this.REGULAR_EXPRESSION_MIXANDPOINT_TWODIMENSION_COMPARATOR = "(\\d+)(\\.\\d*|\\.?)";
        }

        @Override
        protected String getMixString(String dat) {
            StringBuffer buf = new StringBuffer();
            Matcher matcher = Pattern.compile("(\\d+)(\\.\\d*|\\.?)").matcher(dat);
            int length = this.getZeroPaddingLength();
            StringBuilder pad = new StringBuilder(length);
            while (matcher.find()) {
                pad.delete(0, pad.length());
                String group = matcher.group(1);
                int padNum = length - group.length();
                for (int i = 0; i < padNum; ++i) {
                    pad.append('0');
                }
                pad.append(group);
                String group2 = matcher.group(2);
                int padNum2 = 0;
                if (group2.length() > 0) {
                    pad.append(group2);
                    padNum2 = length - group2.length() + 1;
                } else {
                    pad.append('.');
                    padNum2 = length;
                }
                for (int i = 0; i < padNum2; ++i) {
                    pad.append('0');
                }
                matcher.appendReplacement(buf, pad.toString());
            }
            matcher.appendTail(buf);
            return buf.toString();
        }
    }

    class MixTwoDimensionComparator
    extends TwoDimensionComparator {
        private final String REGULAR_EXPRESSION_MIX_TWODIMENSION_COMPARATOR = "\\d+";
        private final int ZERO_PADDING_LENGTH = 10;

        public MixTwoDimensionComparator(int columnIndex) {
            super(columnIndex);
            this.REGULAR_EXPRESSION_MIX_TWODIMENSION_COMPARATOR = "\\d+";
            this.ZERO_PADDING_LENGTH = 10;
        }

        @Override
        public int compare(Object o1, Object o2) {
            String[] oo1 = (String[])o1;
            String[] oo2 = (String[])o2;
            return this.getMixString(oo1[this.columnIndex]).compareTo(this.getMixString(oo2[this.columnIndex]));
        }

        protected String getMixString(String dat) {
            StringBuffer buf = new StringBuffer();
            Matcher matcher = Pattern.compile("\\d+").matcher(dat);
            int length = this.getZeroPaddingLength();
            StringBuilder pad = new StringBuilder(length);
            while (matcher.find()) {
                pad.delete(0, pad.length());
                String group = matcher.group();
                int padNum = length - group.length();
                for (int i = 0; i < padNum; ++i) {
                    pad.append('0');
                }
                pad.append(group);
                matcher.appendReplacement(buf, pad.toString());
            }
            matcher.appendTail(buf);
            return buf.toString();
        }

        protected int getZeroPaddingLength() {
            return 10;
        }
    }

    class SpNumTwoDimentionComparator
    extends TwoDimensionComparator {
        public SpNumTwoDimentionComparator(int columnIndex) {
            super(columnIndex);
        }

        @Override
        public int compare(Object o1, Object o2) {
            String[] oo1 = (String[])o1;
            String[] oo2 = (String[])o2;
            Double ooo1 = 0.0;
            Double ooo2 = 0.0;
            boolean bErr1 = false;
            boolean bErr2 = false;
            try {
                ooo1 = Double.parseDouble(oo1[this.columnIndex].substring(0, oo1[this.columnIndex].indexOf(40)));
            }
            catch (StringIndexOutOfBoundsException e1) {
                bErr1 = true;
            }
            catch (NumberFormatException e1) {
                bErr1 = true;
            }
            try {
                ooo2 = Double.parseDouble(oo2[this.columnIndex].substring(0, oo2[this.columnIndex].indexOf(40)));
            }
            catch (StringIndexOutOfBoundsException e1) {
                bErr2 = true;
            }
            catch (NumberFormatException e1) {
                bErr2 = true;
            }
            if (bErr1 && bErr2) {
                return 0;
            }
            if (bErr1) {
                return -1;
            }
            if (bErr2) {
                return 1;
            }
            return ooo1 > ooo2 ? 1 : (ooo1 < ooo2 ? -1 : 0);
        }
    }

    class ByteTwoDimensionComparator
    extends TwoDimensionComparator {
        public ByteTwoDimensionComparator(int columnIndex) {
            super(columnIndex);
        }

        @Override
        public int compare(Object o1, Object o2) {
            double d2;
            String[] oo1 = (String[])o1;
            String[] oo2 = (String[])o2;
            boolean bErr1 = false;
            boolean bErr2 = false;
            Matcher m1 = bytePattern.matcher(oo1[this.columnIndex]);
            Matcher m2 = bytePattern.matcher(oo2[this.columnIndex]);
            if (!m1.find()) {
                bErr1 = true;
            }
            if (!m2.find()) {
                bErr2 = true;
            }
            double dTemp1 = 0.0;
            double dTemp2 = 0.0;
            String s1 = "";
            String s2 = "";
            if (!bErr1) {
                try {
                    dTemp1 = Double.parseDouble(m1.group(1));
                    s1 = m1.group(2);
                }
                catch (NumberFormatException e1) {
                    bErr1 = true;
                }
            }
            if (!bErr2) {
                try {
                    dTemp2 = Double.parseDouble(m2.group(1));
                    s2 = m2.group(2);
                }
                catch (NumberFormatException e1) {
                    bErr2 = true;
                }
            }
            if (bErr1 && bErr2) {
                return 0;
            }
            if (bErr1) {
                return -1;
            }
            if (bErr2) {
                return 1;
            }
            double d1 = SJdtTableReportGenerator.this.convertByte(dTemp1, s1);
            return d1 > (d2 = SJdtTableReportGenerator.this.convertByte(dTemp2, s2)) ? 1 : (d1 < d2 ? -1 : 0);
        }
    }

    class ParityTwoDimentionComparator
    extends TwoDimensionComparator {
        public ParityTwoDimentionComparator(int columnIndex) {
            super(columnIndex);
        }

        @Override
        public int compare(Object o1, Object o2) {
            String[] oo1 = (String[])o1;
            String[] oo2 = (String[])o2;
            boolean bErr1 = false;
            boolean bErr2 = false;
            Matcher m1 = parityPattern.matcher(oo1[this.columnIndex]);
            Matcher m2 = parityPattern.matcher(oo2[this.columnIndex]);
            if (!m1.find()) {
                bErr1 = true;
            }
            if (!m2.find()) {
                bErr2 = true;
            }
            if (bErr1 && bErr2) {
                return 0;
            }
            if (bErr1) {
                return -1;
            }
            if (bErr2) {
                return 1;
            }
            String s1 = m1.group(1);
            if (s1 == null) {
                s1 = "";
            }
            int i1a = Integer.parseInt(m1.group(2));
            int i1b = Integer.parseInt(m1.group(3));
            String s2 = m2.group(1);
            if (s2 == null) {
                s2 = "";
            }
            int i2a = Integer.parseInt(m2.group(2));
            int i2b = Integer.parseInt(m2.group(3));
            if (!s1.equals(s2)) {
                return s1.compareTo(s2);
            }
            if (i1a != i2a) {
                return i1a > i2a ? 1 : (i1a < i2a ? -1 : 0);
            }
            return i1b > i2b ? 1 : (i1b < i2b ? -1 : 0);
        }
    }

    class NumTwoDimentionComparator
    extends TwoDimensionComparator {
        public NumTwoDimentionComparator(int columnIndex) {
            super(columnIndex);
        }

        @Override
        public int compare(Object o1, Object o2) {
            String[] oo1 = (String[])o1;
            String[] oo2 = (String[])o2;
            boolean bErr1 = false;
            boolean bErr2 = false;
            Double ooo1 = 0.0;
            Double ooo2 = 0.0;
            try {
                ooo1 = Double.parseDouble(oo1[this.columnIndex]);
            }
            catch (NumberFormatException e1) {
                bErr1 = true;
            }
            try {
                ooo2 = Double.parseDouble(oo2[this.columnIndex]);
            }
            catch (NumberFormatException e1) {
                bErr2 = true;
            }
            if (bErr1 && bErr2) {
                return 0;
            }
            if (bErr1) {
                return -1;
            }
            if (bErr2) {
                return 1;
            }
            return ooo1 > ooo2 ? 1 : (ooo1 < ooo2 ? -1 : 0);
        }
    }

    class TwoDimensionComparator
    implements Comparator<Object> {
        protected int columnIndex = 0;
        protected static final int RET_COMPARE_EQ = 0;
        protected static final int RET_COMPARE_LT = -1;
        protected static final int RET_COMPARE_GT = 1;

        public TwoDimensionComparator(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public int compare(Object o1, Object o2) {
            String[] oo1 = (String[])o1;
            String[] oo2 = (String[])o2;
            return oo1[this.columnIndex].compareTo(oo2[this.columnIndex]);
        }
    }
}

