/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2msg.controller.makecsv;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Level;
import sanproject.sn2msg.SN2MsgLogger;
import sanproject.sn2msg.controller.SN2MsgCtrlException;
import sanproject.sn2msg.controller.SN2MsgCtrlMacro;
import sanproject.sn2msg.controller.makecsv.SN2MsgCtrlMakecsvMacro;
import sanproject.sn2msg.model.data.SN2MsgMdlAllData;
import sanproject.sn2msg.model.data.SN2MsgMdlMsgData;
import sanproject.sn2msg.model.data.SN2MsgMdlMsgIdxData;
import zero.soo.SerialObjectOutput;

public class SN2MsgCtrlMakecsvMessage
implements SN2MsgCtrlMacro,
SN2MsgCtrlMakecsvMacro {
    ArrayList<SN2MsgMdlAllData> m_AlMsgData = null;
    String m_StrPath = null;
    boolean m_BRsv = false;

    public SN2MsgCtrlMakecsvMessage(String strPath, ArrayList<SN2MsgMdlAllData> alMdlData, boolean bRsv) throws SN2MsgCtrlException {
        if (strPath == null || alMdlData == null) {
            SN2MsgCtrlException ctrlExp = new SN2MsgCtrlException("Invalid Parameter(null)");
            ctrlExp.setIErrorCode(3);
            throw ctrlExp;
        }
        this.m_AlMsgData = alMdlData;
        this.m_StrPath = strPath;
        this.m_BRsv = bRsv;
    }

    public String getFilePathHIE_EN() {
        return String.valueOf(this.m_StrPath) + File.separator + "Message_" + "HIE_EN.csv";
    }

    public String getFilePathHIE_JA() {
        return String.valueOf(this.m_StrPath) + File.separator + "Message_" + "HIE_JA.csv";
    }

    public String getFilePathHIJ_EN() {
        return String.valueOf(this.m_StrPath) + File.separator + "Message_" + "HIJ_EN.csv";
    }

    public String getFilePathHIJ_JA() {
        return String.valueOf(this.m_StrPath) + File.separator + "Message_" + "HIJ_JA.csv";
    }

    public String getFilePathHPE_EN() {
        return String.valueOf(this.m_StrPath) + File.separator + "Message_" + "HPE_EN.csv";
    }

    public String getFilePathHPE_JA() {
        return String.valueOf(this.m_StrPath) + File.separator + "Message_" + "HPE_JA.csv";
    }

    public String getFilePathHPJ_EN() {
        return String.valueOf(this.m_StrPath) + File.separator + "Message_" + "HPJ_EN.csv";
    }

    public String getFilePathHPJ_JA() {
        return String.valueOf(this.m_StrPath) + File.separator + "Message_" + "HPJ_JA.csv";
    }

    public SN2MsgMdlMsgData getStringData(SN2MsgMdlAllData allData) {
        return allData.getMessage();
    }

    public void outputCSV() throws SN2MsgCtrlException {
        int iOutCnt = 0;
        FileOutputStream fos_HIE_EN = null;
        BufferedWriter bw_HIE_EN = null;
        String path_HIE_EN = this.getFilePathHIE_EN();
        FileOutputStream fos_HIE_JA = null;
        BufferedWriter bw_HIE_JA = null;
        String path_HIE_JA = this.getFilePathHIE_JA();
        FileOutputStream fos_HIJ_EN = null;
        BufferedWriter bw_HIJ_EN = null;
        String path_HIJ_EN = this.getFilePathHIJ_EN();
        FileOutputStream fos_HIJ_JA = null;
        BufferedWriter bw_HIJ_JA = null;
        String path_HIJ_JA = this.getFilePathHIJ_JA();
        FileOutputStream fos_HPE_EN = null;
        BufferedWriter bw_HPE_EN = null;
        String path_HPE_EN = this.getFilePathHPE_EN();
        FileOutputStream fos_HPE_JA = null;
        BufferedWriter bw_HPE_JA = null;
        String path_HPE_JA = this.getFilePathHPE_JA();
        FileOutputStream fos_HPJ_EN = null;
        BufferedWriter bw_HPJ_EN = null;
        String path_HPJ_EN = this.getFilePathHPJ_EN();
        FileOutputStream fos_HPJ_JA = null;
        BufferedWriter bw_HPJ_JA = null;
        String path_HPJ_JA = this.getFilePathHPJ_JA();
        try {
            try {
                fos_HIE_EN = new FileOutputStream(path_HIE_EN);
                bw_HIE_EN = new BufferedWriter(new OutputStreamWriter((OutputStream)fos_HIE_EN, Charset.forName("MS932")));
                fos_HIE_JA = new FileOutputStream(path_HIE_JA);
                bw_HIE_JA = new BufferedWriter(new OutputStreamWriter((OutputStream)fos_HIE_JA, Charset.forName("MS932")));
                fos_HIJ_EN = new FileOutputStream(path_HIJ_EN);
                bw_HIJ_EN = new BufferedWriter(new OutputStreamWriter((OutputStream)fos_HIJ_EN, Charset.forName("MS932")));
                fos_HIJ_JA = new FileOutputStream(path_HIJ_JA);
                bw_HIJ_JA = new BufferedWriter(new OutputStreamWriter((OutputStream)fos_HIJ_JA, Charset.forName("MS932")));
                fos_HPE_EN = new FileOutputStream(path_HPE_EN);
                bw_HPE_EN = new BufferedWriter(new OutputStreamWriter((OutputStream)fos_HPE_EN, Charset.forName("MS932")));
                fos_HPE_JA = new FileOutputStream(path_HPE_JA);
                bw_HPE_JA = new BufferedWriter(new OutputStreamWriter((OutputStream)fos_HPE_JA, Charset.forName("MS932")));
                fos_HPJ_EN = new FileOutputStream(path_HPJ_EN);
                bw_HPJ_EN = new BufferedWriter(new OutputStreamWriter((OutputStream)fos_HPJ_EN, Charset.forName("MS932")));
                fos_HPJ_JA = new FileOutputStream(path_HPJ_JA);
                bw_HPJ_JA = new BufferedWriter(new OutputStreamWriter((OutputStream)fos_HPJ_JA, Charset.forName("MS932")));
                int iMsg = 0;
                while (iMsg < this.m_AlMsgData.size()) {
                    SN2MsgMdlMsgData msgData;
                    String strErrCode;
                    SN2MsgMdlAllData allData = this.m_AlMsgData.get(iMsg);
                    SN2MsgMdlMsgIdxData idxData = allData.getMsgIdx();
                    if ((this.m_BRsv || !idxData.getBRsv()) && (strErrCode = (msgData = this.getStringData(allData)).getStrMsgId()).length() != 0) {
                        bw_HIE_EN.write(strErrCode);
                        bw_HIE_EN.write("\t");
                        bw_HIE_EN.write(msgData.getStrHie_en());
                        bw_HIE_EN.write("\r\n");
                        bw_HIE_JA.write(strErrCode);
                        bw_HIE_JA.write("\t");
                        if (idxData.isAnnotationMsg()) {
                            bw_HIE_JA.write(this.convertHieHssc(msgData.getStrHie_en()));
                        } else {
                            bw_HIE_JA.write(msgData.getStrHie_ja());
                        }
                        bw_HIE_JA.write("\r\n");
                        bw_HIJ_EN.write(strErrCode);
                        bw_HIJ_EN.write("\t");
                        bw_HIJ_EN.write(msgData.getStrHij_en());
                        bw_HIJ_EN.write("\r\n");
                        bw_HIJ_JA.write(strErrCode);
                        bw_HIJ_JA.write("\t");
                        if (idxData.isAnnotationMsg()) {
                            bw_HIJ_JA.write(msgData.getStrHij_en());
                        } else {
                            bw_HIJ_JA.write(msgData.getStrHij_ja());
                        }
                        bw_HIJ_JA.write("\r\n");
                        bw_HPE_EN.write(strErrCode);
                        bw_HPE_EN.write("\t");
                        bw_HPE_EN.write(msgData.getStrHpe_en());
                        bw_HPE_EN.write("\r\n");
                        bw_HPE_JA.write(strErrCode);
                        bw_HPE_JA.write("\t");
                        if (idxData.isAnnotationMsg()) {
                            bw_HPE_JA.write(this.convertHpeHssc(msgData.getStrHpe_en()));
                        } else {
                            bw_HPE_JA.write(msgData.getStrHpe_ja());
                        }
                        bw_HPE_JA.write("\r\n");
                        bw_HPJ_EN.write(strErrCode);
                        bw_HPJ_EN.write("\t");
                        bw_HPJ_EN.write(msgData.getStrHpj_en());
                        bw_HPJ_EN.write("\r\n");
                        bw_HPJ_JA.write(strErrCode);
                        bw_HPJ_JA.write("\t");
                        if (idxData.isAnnotationMsg()) {
                            bw_HPJ_JA.write(msgData.getStrHpj_en());
                        } else {
                            bw_HPJ_JA.write(msgData.getStrHpj_ja());
                        }
                        bw_HPJ_JA.write("\r\n");
                        ++iOutCnt;
                    }
                    ++iMsg;
                }
                bw_HIE_EN.flush();
                bw_HIE_JA.flush();
                bw_HIJ_EN.flush();
                bw_HIJ_JA.flush();
                bw_HPE_EN.flush();
                bw_HPE_JA.flush();
                bw_HPJ_EN.flush();
                bw_HPJ_JA.flush();
                SN2MsgLogger.getLogger().info("Number of output messages:" + iOutCnt);
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                SN2MsgCtrlException ctrlExp = new SN2MsgCtrlException(jvExp.getCause());
                ctrlExp.setIErrorCode(-1);
                SN2MsgLogger.getLogger().log(Level.WARNING, "outputCSV failed.", jvExp);
                throw ctrlExp;
            }
        }
        finally {
            try {
                if (bw_HIE_EN != null) {
                    bw_HIE_EN.flush();
                    bw_HIE_EN.close();
                }
                if (bw_HIE_JA != null) {
                    bw_HIE_JA.flush();
                    bw_HIE_JA.close();
                }
                if (bw_HIJ_EN != null) {
                    bw_HIJ_EN.flush();
                    bw_HIJ_EN.close();
                }
                if (bw_HIJ_JA != null) {
                    bw_HIJ_JA.flush();
                    bw_HIJ_JA.close();
                }
                if (bw_HPE_EN != null) {
                    bw_HPE_EN.flush();
                    bw_HPE_EN.close();
                }
                if (bw_HPE_JA != null) {
                    bw_HPE_JA.flush();
                    bw_HPE_JA.close();
                }
                if (bw_HPJ_EN != null) {
                    bw_HPJ_EN.flush();
                    bw_HPJ_EN.close();
                }
                if (bw_HPJ_JA != null) {
                    bw_HPJ_JA.flush();
                    bw_HPJ_JA.close();
                }
            }
            catch (Exception bufExp) {
                bufExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(bufExp.getMessage());
            }
            try {
                if (fos_HIE_EN != null) {
                    fos_HIE_EN.close();
                }
                if (fos_HIE_JA != null) {
                    fos_HIE_JA.close();
                }
                if (fos_HIJ_EN != null) {
                    fos_HIJ_EN.close();
                }
                if (fos_HIJ_JA != null) {
                    fos_HIJ_JA.close();
                }
                if (fos_HPE_EN != null) {
                    fos_HPE_EN.close();
                }
                if (fos_HPE_JA != null) {
                    fos_HPE_JA.close();
                }
                if (fos_HPJ_EN != null) {
                    fos_HPJ_EN.close();
                }
                if (fos_HPJ_JA != null) {
                    fos_HPJ_JA.close();
                }
            }
            catch (Exception flExp) {
                flExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(flExp.getMessage());
            }
        }
    }

    void outputBIN() throws SN2MsgCtrlException {
        String[] csvFiles = new String[]{this.getFilePathHIE_EN(), this.getFilePathHIE_JA(), this.getFilePathHIJ_EN(), this.getFilePathHIJ_JA(), this.getFilePathHPE_EN(), this.getFilePathHPE_JA(), this.getFilePathHPJ_EN(), this.getFilePathHPJ_JA()};
        try {
            SerialObjectOutput.main((String[])csvFiles);
        }
        catch (Exception jvExp) {
            jvExp.printStackTrace();
            SN2MsgLogger.getLogger().warning("Make Message BIN file failed.");
            SN2MsgCtrlException ctrlExp = new SN2MsgCtrlException(jvExp.getCause());
            ctrlExp.setIErrorCode(-1);
            throw ctrlExp;
        }
    }

    public void makeCSV() throws SN2MsgCtrlException {
        this.outputCSV();
        this.outputBIN();
    }

    public String convertHieHssc(String strSrc) {
        String strRet = strSrc.replaceAll("Hitachi Data Systems Support Center", "HSSC");
        return strRet.replaceAll("Support Center", "HSSC");
    }

    public String convertHpeHssc(String strSrc) {
        return strSrc.replaceAll("contact HP Technical Support", "call the HSSC");
    }
}

