/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLReader {
    static final String ERR_STR_INVALID_FORMAT = "[Error]\u30d5\u30a1\u30a4\u30eb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u4e0d\u6b63\u3067\u3059\u3002\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3059\u3002\u30de\u30b9\u30bf\u30fc\u30d5\u30a1\u30a4\u30eb\u3092Excel\u3067\u518d\u4fdd\u5b58\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u3053\u306e\u3068\u304d\u201d\u30d5\u30a1\u30a4\u30eb\u306e\u7a2e\u985e\u201d[XML\u30c7\u30fc\u30bf(*.xml)]\u3092\u6307\u5b9a\u3057\u3066\u3044\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\uff1a";
    static final String ROOT_EXL2003_SPD = "Workbook";

    public static LinkedHashSet<HashMap<String, String>> readXMLs(String strDir, String prefix) {
        LinkedHashSet<HashMap<String, String>> messageSet = new LinkedHashSet<HashMap<String, String>>();
        File dir = null;
        dir = strDir.isEmpty() ? new File(".") : new File(strDir);
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.getName().startsWith(prefix)) {
                String strPath = "";
                strPath = strDir.isEmpty() ? file.getName() : String.valueOf(strDir) + File.separator + file.getName();
                System.out.println("Reading ... " + file.getName());
                XMLReader.readXML(strPath, messageSet);
            }
            ++i;
        }
        return messageSet;
    }

    private static LinkedHashSet<HashMap<String, String>> readXML(String fileName, LinkedHashSet<HashMap<String, String>> messageSet) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            File f = new File(fileName);
            Document doc = builder.parse(f);
            Element root = doc.getDocumentElement();
            if (root.getNodeName().equals(ROOT_EXL2003_SPD)) {
                System.err.println(ERR_STR_INVALID_FORMAT + fileName);
                System.exit(1);
            }
            NodeList children = root.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof Element) {
                    Element childElement = (Element)child;
                    NodeList e = childElement.getChildNodes();
                    HashMap<String, String> map = new HashMap<String, String>();
                    int j = 0;
                    while (j < e.getLength()) {
                        Node n = e.item(j);
                        if (n instanceof Element) {
                            map.put(((Element)n).getTagName(), n.getTextContent());
                        }
                        ++j;
                    }
                    if (!map.isEmpty()) {
                        messageSet.add(map);
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return messageSet;
    }

    public static LinkedHashSet<HashMap<String, String>> readGuidanceXML(String fileStr) {
        LinkedHashSet<HashMap<String, String>> guidanceSet = new LinkedHashSet<HashMap<String, String>>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            File f = new File(fileStr);
            Document doc = builder.parse(f);
            Element root = doc.getDocumentElement();
            NodeList children = root.getChildNodes();
            if (root.getNodeName().equals(ROOT_EXL2003_SPD)) {
                System.err.println(ERR_STR_INVALID_FORMAT + fileStr);
                System.exit(1);
            }
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof Element) {
                    Element childElement = (Element)child;
                    NodeList e = childElement.getChildNodes();
                    HashMap<String, String> map = new HashMap<String, String>();
                    int j = 0;
                    while (j < e.getLength()) {
                        Node n = e.item(j);
                        if (n instanceof Element) {
                            map.put(((Element)n).getTagName(), n.getTextContent());
                        }
                        ++j;
                    }
                    if (!map.isEmpty()) {
                        guidanceSet.add(map);
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return guidanceSet;
    }
}

