/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getexptool;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import sanproject.getexptool.RJElCmdParser;
import sanproject.getexptool.RJElConfig;
import sanproject.getexptool.RJElLogger;
import sanproject.getexptool.RJElMessage;

public class RJElCmdManager
extends RJElCmdParser {
    private RJElConfig config;
    private static final Boolean TRACE_ON = Boolean.TRUE;
    private static final int MAX_DKCSN_LENGTH = 6;
    private static final String PATTERN_DECIMAL = "\\d+";
    private Object[][] commandTable = new Object[][]{{"ip", TRACE_ON, new RJElCmdParser.CommandAction(){

        public void actionPerformed() throws ParseException {
            RJElCmdManager.this.action_svpip();
        }
    }}, {"dkcsn", TRACE_ON, new RJElCmdParser.CommandAction(){

        public void actionPerformed() throws ParseException {
            RJElCmdManager.this.action_dkcsn();
        }
    }}};

    public RJElCmdManager(RJElConfig rJElConfig) {
        this.config = rJElConfig;
    }

    public void load() throws IOException, FileNotFoundException, ParseException {
        String string = this.config.cmdFilePath;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            RJElLogger.message(RJElMessage.message("MSG000", string));
            throw fileNotFoundException;
        }
        this.analyze(fileInputStream);
    }

    protected Object[][] getCommandTable() {
        return this.commandTable;
    }

    public void analyze(InputStream inputStream) throws IOException, ParseException {
        try {
            super.analyze(inputStream);
        }
        catch (IOException iOException) {
            String string = RJElMessage.message("MSG000", this.config.cmdFilePath);
            RJElLogger.message(string);
            throw iOException;
        }
        catch (ParseException parseException) {
            String string = parseException.getMessage();
            if (string != null) {
                RJElLogger.message(string + " [line = " + this.getLineNumber() + "]");
            }
            throw parseException;
        }
    }

    private void action_svpip() throws ParseException {
        String string = null;
        String string2 = null;
        char c = this.nextToken(".[]:%");
        if (c == 'I' || c == 'L') {
            string = this.getToken();
            if (string.matches("\\[.*\\]") || string.matches("\\[.*\\]:\\d+")) {
                String[] stringArray = string.split("]");
                string2 = stringArray[0];
                string2 = string2 + "]";
            } else {
                String[] stringArray = string.split(":");
                string2 = stringArray[0];
            }
            try {
                this.config.svpip = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                throw RJElMessage.parseException("MSG003", string2);
            }
        } else {
            throw RJElMessage.parseException("MSG013");
        }
        RJElLogger.trace("\tipAddress = " + this.config.svpip.getHostAddress());
        this.nextToken();
    }

    private void action_dkcsn() throws ParseException {
        String string = null;
        this.nextToken();
        string = this.getToken();
        if (string.length() != 6) {
            throw RJElMessage.parseException("MSG011", this.getLine());
        }
        if (!string.matches(PATTERN_DECIMAL)) {
            throw RJElMessage.parseException("MSG011", this.getLine());
        }
        this.config.dkcSn = string;
        this.nextToken();
    }
}

