/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getexptool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import sanproject.getexptool.RJElCmdManager;
import sanproject.getexptool.RJElConfig;
import sanproject.getexptool.RJElDownloader;
import sanproject.getexptool.RJElException;
import sanproject.getexptool.RJElFileManager;
import sanproject.getexptool.RJElLogger;
import sanproject.getexptool.RJElMessage;
import sanproject.getexptool.RJElMsgID;
import sanproject.getexptool.RJElToolExecutor;

public class RJElMain
implements RJElMsgID {
    public static final String PROPERTY_COMMAND = "md.command";
    public static final String PROPERTY_LOGPATH = "el.logpath";
    public static final String PROPERTY_LOGFILE = "el.logfile";
    public static final String PROPERTY_MODE = "el.mode";
    public static final String PROPERTY_PORT = "el.dlport";
    public static final String PROPERTY_MODE_ALL = "all";
    public static final String PROPERTY_MODE_DELETE = "delete";
    public static final String PROPERTY_DEFAULT_LOGPATH = ".";
    public static final String PROPERTY_DEFAULT_MODE = "all";
    public static final String PROPERTY_TOOL_LOGPATH = "md.logpath";
    public static final String PROPERTY_TOOL_LOGFILE = "md.logfile";
    public static final String PROPERTY_TOOL_DEFAULT_LOGPATH = ".";
    private RJElConfig config;
    private RJElFileManager fileMgr;
    private final int EXITCODE_SUCCESS = 0;
    private final int EXITCODE_ERROR = 101;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startLoader() {
        int n = 101;
        RJElLogger.message("Loading ExportTool...");
        try {
            this.setupConfig();
            this.setupSvpip();
            if (this.config.mode == 0) {
                this.fileMgr = new RJElFileManager(this.config);
                this.setupTempDirectory();
                this.downloadFiles();
                n = this.execExportTool();
            } else {
                this.fileMgr = new RJElFileManager(this.config);
                this.config.tempDirName = this.fileMgr.makeTempDirName(this.config);
                n = 0;
            }
        }
        catch (IOException iOException) {
            RJElLogger.trace("ExportLoader fail.");
        }
        catch (ParseException parseException) {
            RJElLogger.trace("ExportLoader fail.");
        }
        catch (RJElException rJElException) {
            RJElLogger.trace("ExportLoader fail.");
        }
        finally {
            this.deleteTempDirectory();
        }
        RJElLogger.trace("ExportLoader finish. exitcode=" + n);
        return n;
    }

    private void setupConfig() throws RJElException, FileNotFoundException {
        Object object;
        String string = null;
        this.config = new RJElConfig();
        this.config.logPath = System.getProperty(PROPERTY_LOGPATH, ".");
        this.config.logFile = System.getProperty(PROPERTY_LOGFILE);
        if (this.config.logFile == null || this.config.logFile.length() == 0) {
            object = new SimpleDateFormat("MMddHHmmss");
            this.config.logFile = "loader" + ((DateFormat)object).format(new Date()) + ".log";
        }
        try {
            RJElLogger.setConfig(this.config);
        }
        catch (FileNotFoundException fileNotFoundException) {
            RJElLogger.message("Connot create log file \"" + this.config.logFile + "\" in \"" + this.config.logPath + "\"");
            throw fileNotFoundException;
        }
        try {
            this.checkLogFilePath(this.config.logPath, this.config.logFile);
        }
        catch (IOException iOException) {
            RJElLogger.trace("IOException in checkLogFilePath().");
        }
        this.config.cmdFilePath = System.getProperty(PROPERTY_COMMAND);
        if (this.config.cmdFilePath == null || this.config.cmdFilePath.length() == 0) {
            string = RJElMessage.message("MSG001");
            RJElLogger.message(string);
            throw new RJElException(string);
        }
        object = System.getProperty(PROPERTY_MODE, "all");
        if ("all".equalsIgnoreCase((String)object)) {
            this.config.mode = 0;
        } else if (PROPERTY_MODE_DELETE.equalsIgnoreCase((String)object)) {
            this.config.mode = 1;
        } else {
            string = RJElMessage.message("MSG009", (String)object);
            RJElLogger.message(string);
            throw new RJElException(string);
        }
        String string2 = System.getProperty(PROPERTY_PORT);
        if (string2 != null) {
            try {
                this.config.port = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string = RJElMessage.message("MSG016", string2);
                RJElLogger.message(string);
                throw new RJElException(string);
            }
        }
        this.startLogMessage();
    }

    private void startLogMessage() {
        RJElLogger.trace("start Export Loader Version : " + this.config.version);
        RJElLogger.trace(" command file path=" + this.config.cmdFilePath);
        RJElLogger.trace(" log file path    =" + this.config.logPath);
        RJElLogger.trace(" log file name    =" + this.config.logFile);
        String string = this.config.mode == 0 ? "ALL" : "DELETE";
        RJElLogger.trace(" ExportLoader mode=" + string);
        RJElLogger.trace(" download port    =" + this.config.port);
    }

    private void checkLogFilePath(String string, String string2) throws RJElException, IOException {
        String string3 = System.getProperty(PROPERTY_TOOL_LOGFILE);
        if (string3 == null) {
            return;
        }
        String string4 = System.getProperty(PROPERTY_TOOL_LOGPATH, string);
        File file = new File(string4, string3);
        String string5 = file.getCanonicalPath();
        File file2 = new File(string, string2);
        String string6 = file2.getCanonicalPath();
        if (string6.equals(string5)) {
            String string7 = RJElMessage.message("MSG010", string6);
            RJElLogger.message(string7);
            throw new RJElException(string7);
        }
    }

    private void setupSvpip() throws IOException, ParseException, RJElException {
        RJElLogger.trace("read target address from command file.");
        RJElCmdManager rJElCmdManager = new RJElCmdManager(this.config);
        rJElCmdManager.load();
        if (this.config.svpip == null) {
            String string = RJElMessage.message("MSG002");
            RJElLogger.message(string);
            throw new RJElException(string);
        }
        RJElLogger.trace(" ->target address=" + this.config.svpip);
        if (this.config.dkcSn == null) {
            String string = RJElMessage.message("MSG015");
            RJElLogger.message(string);
            throw new RJElException(string);
        }
        RJElLogger.trace(" ->target DKC SN=" + this.config.dkcSn);
    }

    private void setupTempDirectory() throws RJElException {
        RJElLogger.trace("Create temporary directory.");
        this.config.tempDirName = this.fileMgr.makeTempDirName(this.config);
        File file = new File(this.config.tempDirName);
        if (!file.exists()) {
            file.mkdirs();
        } else if (file.isDirectory()) {
            RJElLogger.trace(" temporary directory already exist. delete old files.");
            this.fileMgr.deleteDownloadFiles(this.config.tempDirName);
        }
        if (!file.isDirectory()) {
            String string = RJElMessage.message("MSG004", this.config.tempDirName);
            RJElLogger.message(string);
            throw new RJElException(string);
        }
        RJElLogger.trace(" done. path=" + this.config.tempDirName);
    }

    private void downloadFiles() throws IOException, RJElException {
        RJElLogger.trace("Download export tool.");
        RJElDownloader rJElDownloader = new RJElDownloader(this.config);
        rJElDownloader.execDownload();
        RJElLogger.trace(" done.");
    }

    private int execExportTool() throws IOException {
        int n = 0;
        RJElLogger.trace("Execute export tool.");
        RJElToolExecutor rJElToolExecutor = new RJElToolExecutor(this.config);
        n = rJElToolExecutor.execTool();
        RJElLogger.trace(" done.");
        return n;
    }

    private void deleteTempDirectory() {
        File file;
        if (this.config.tempDirName != null && (file = new File(this.config.tempDirName)).isDirectory()) {
            RJElLogger.trace("Delete temporary directory.");
            this.fileMgr.deleteTempDirectory(this.config.tempDirName);
            RJElLogger.trace(" done.");
        }
    }

    public static void main(String[] stringArray) {
        RJElMain rJElMain = new RJElMain();
        int n = rJElMain.startLoader();
        System.exit(n);
    }
}

