/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getexptool;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import sanproject.getexptool.RJElMessage;
import sanproject.getexptool.RJElMsgID;

public class RJElCmdParser
implements RJElMsgID {
    public static final char TK_LT = '<';
    public static final char TK_GT = '>';
    public static final char TK_PLUS = '+';
    public static final char TK_MINUS = '-';
    public static final char TK_SLASH = '/';
    public static final char TK_BACKSLASH = '\\';
    public static final char TK_ASTER = '*';
    public static final char TK_EQUAL = '=';
    public static final char TK_SHARP = '#';
    public static final char TK_DQUOTE = '\"';
    public static final char TK_SEMICOLON = ';';
    public static final char TK_COLON = ':';
    public static final char TK_PERIOD = '.';
    public static final char TK_COMMA = ',';
    public static final char TK_SPACE = ' ';
    public static final char TK_EOL = '\u0000';
    public static final char TK_ID = 'I';
    public static final char TK_LITERAL = 'L';
    public static final int MD_PREVIEW = 1;
    public static final int MD_ZENKAKU = 2;
    private String line;
    private int lineNumber = 0;
    private StringBuffer token;
    private char nextC;
    private int current;
    private char kind;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze(InputStream inputStream) throws IOException, ParseException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            this.lineNumber = 1;
            while ((this.line = bufferedReader.readLine()) != null) {
                if (this.line.length() > 0) {
                    this.analyzeLine();
                }
                ++this.lineNumber;
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    protected void analyzeLine() throws ParseException {
        block4: {
            char c;
            block3: {
                this.current = 0;
                this.nextC = this.getC();
                c = this.nextToken();
                if (c != 'I') break block3;
                String string = this.getToken();
                Object[][] objectArray = this.getCommandTable();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!string.equals(objectArray[i][0])) continue;
                    ((CommandAction)objectArray[i][2]).actionPerformed();
                    break;
                }
                while (this.getKind() != '\u0000') {
                    this.nextToken();
                }
                break block4;
            }
            if (c == '\u0000') break block4;
            while (this.getKind() != '\u0000') {
                this.nextToken();
            }
        }
    }

    protected Object[][] getCommandTable() {
        return null;
    }

    public String getLine() {
        return this.line;
    }

    public String getRemain() {
        return this.line.substring(this.current);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public char getC() throws ParseException {
        return this.getC(0);
    }

    public char getC(int n) throws ParseException {
        char c = '\u0000';
        if (this.current >= 0) {
            if (this.current < this.line.length()) {
                c = this.line.charAt(this.current);
                if ((n & 2) == 0 && !Character.UnicodeBlock.of(c).equals(Character.UnicodeBlock.BASIC_LATIN)) {
                    throw RJElMessage.parseException("MSG012", String.valueOf(c));
                }
            }
            if ((n & 1) == 0) {
                ++this.current;
            }
        }
        return c;
    }

    public void skipOperand() {
        this.kind = '\u0000';
        this.current = this.line.length();
    }

    public char nextToken() throws ParseException {
        return this.nextToken(null);
    }

    public char nextToken(String string) throws ParseException {
        while (Character.isWhitespace(this.nextC)) {
            this.nextC = this.getC();
        }
        return this.nextTokenS(string);
    }

    public char nextTokenS() throws ParseException {
        return this.nextTokenS(null);
    }

    public char nextTokenS(String string) throws ParseException {
        if (this.nextC == ';') {
            this.nextC = this.getC(2);
            while (this.nextC != '\u0000') {
                this.nextC = this.getC(2);
            }
        }
        if (this.nextC == '\"') {
            this.nextC = this.getC();
            this.kind = (char)76;
            this.token = new StringBuffer();
            while (this.nextC != '\u0000' && this.nextC != '\"') {
                if (this.nextC == '\\') {
                    this.nextC = this.getC(2);
                    this.nextC = this.getEscapedChar(this.nextC);
                }
                this.token.append(this.nextC);
                this.nextC = this.getC(2);
            }
            this.nextC = this.getC();
        } else if (this.checkCharSet(this.nextC, string)) {
            this.kind = (char)73;
            this.token = new StringBuffer();
            while (this.checkCharSet(this.nextC, string)) {
                this.token.append(this.nextC);
                this.nextC = this.getC();
            }
        } else if (Character.isWhitespace(this.nextC)) {
            this.kind = (char)32;
            do {
                this.nextC = this.getC();
            } while (Character.isWhitespace(this.nextC));
        } else {
            this.kind = this.nextC;
            this.nextC = this.getC();
        }
        return this.kind;
    }

    private boolean checkCharSet(char c, String string) {
        boolean bl = false;
        if (Character.isLetterOrDigit(c)) {
            bl = true;
        } else if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (c != string.charAt(i)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private char getEscapedChar(char n) {
        int n2 = n;
        switch (n) {
            case 98: {
                n2 = 8;
                break;
            }
            case 102: {
                n2 = 12;
                break;
            }
            case 110: {
                n2 = 10;
                break;
            }
            case 114: {
                n2 = 13;
                break;
            }
            case 116: {
                n2 = 9;
                break;
            }
            case 48: {
                n2 = 0;
                break;
            }
        }
        return (char)n2;
    }

    public String getToken() {
        String string = "";
        if (this.token != null) {
            string = this.token.toString();
        }
        return string;
    }

    public char getKind() {
        return this.kind;
    }

    protected void traceLine(String string) {
    }

    protected static interface CommandAction {
        public void actionPerformed() throws ParseException;
    }
}

