/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getexptool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import sanproject.getexptool.RJElConfig;
import sanproject.getexptool.RJElLogger;
import sanproject.getexptool.RJElMessage;
import sanproject.getexptool.RJElMsgID;

public class RJElToolExecutor
extends Thread
implements RJElMsgID {
    private RJElConfig config;
    private String libPath;
    private List properties;
    private static final String PROPERTY_HEAPSIZE = "el.tool.Xmx";
    private static final String PROPERTY_DEFAULT_HEAPSIZE = "536870912";
    private static final String PROPERTY_PROXY_HOST = "http.proxyHost";
    private static final String PROPERTY_PROXY_PORT = "http.proxyPort";
    private static final String PROPERTY_PREFIX_TOOL = "md.";
    private static final String PROPERTY_TOOL_LOGPATH = "md.logpath";
    private static final String PROPERTY_LOADER_LOGPATH = "el.logpath";
    private Process toolProcess = null;

    public RJElToolExecutor(RJElConfig rJElConfig) {
        this.config = rJElConfig;
        this.setupLibPath(rJElConfig);
        this.setupProperties();
    }

    public void run() {
        if (this.toolProcess != null) {
            RJElLogger.trace("Destroy ExportTool Process");
            this.toolProcess.destroy();
        }
    }

    public int execTool() throws IOException {
        Runtime.getRuntime().addShutdownHook(this);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("java");
        arrayList.add("-classpath");
        arrayList.add(this.libPath);
        arrayList.addAll(this.properties);
        arrayList.add("sanproject.getmondat.RJMdMain");
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        List<String> list = processBuilder.command();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("command=");
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append((Object)list.get(i)).append(" ");
        }
        RJElLogger.trace(stringBuffer.toString());
        processBuilder.redirectErrorStream(true);
        RJElLogger.trace("start Export Tool-------------------.");
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            this.toolProcess = processBuilder.start();
            inputStream = this.toolProcess.getInputStream();
            outputStream = this.toolProcess.getOutputStream();
            RedirectThread redirectThread = new RedirectThread(inputStream, System.out);
            redirectThread.start();
            RedirectThread redirectThread2 = new RedirectThread(System.in, outputStream);
            redirectThread2.setDaemon(true);
            redirectThread2.start();
            try {
                this.toolProcess.waitFor();
                redirectThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
            RJElLogger.message(RJElMessage.message("MSG008"));
            throw iOException;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                RJElLogger.trace("IOException in close");
            }
        }
        RJElLogger.trace("finish Export Tool-------------------.");
        int n = this.toolProcess.exitValue();
        RJElLogger.trace(" exit code=" + n);
        this.toolProcess = null;
        return n;
    }

    private void setupLibPath(RJElConfig rJElConfig) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("path.separator");
        for (int i = 0; i < rJElConfig.downloadFiles.length; ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(rJElConfig.tempDirName).append(File.separator).append(rJElConfig.downloadFiles[i][0]);
        }
        this.libPath = stringBuffer.toString();
    }

    private void setupProperties() {
        String string;
        String string2;
        this.properties = new ArrayList();
        String string3 = System.getProperty(PROPERTY_HEAPSIZE, PROPERTY_DEFAULT_HEAPSIZE);
        this.properties.add("-Xmx" + string3);
        String string4 = System.getProperty(PROPERTY_TOOL_LOGPATH);
        if (string4 == null) {
            string4 = System.getProperty(PROPERTY_LOADER_LOGPATH);
        }
        if (string4 != null) {
            this.properties.add(this.getPropertyLine(PROPERTY_TOOL_LOGPATH, string4));
        }
        Enumeration<Object> enumeration = System.getProperties().keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (string2.equals(PROPERTY_TOOL_LOGPATH) && this.config.logPath != null || !string2.startsWith(PROPERTY_PREFIX_TOOL)) continue;
            string = System.getProperty(string2);
            this.properties.add(this.getPropertyLine(string2, string));
        }
        string2 = System.getProperty(PROPERTY_PROXY_HOST);
        if (string2 != null) {
            this.properties.add(this.getPropertyLine(PROPERTY_PROXY_HOST, string2));
        }
        if ((string = System.getProperty(PROPERTY_PROXY_PORT)) != null) {
            this.properties.add(this.getPropertyLine(PROPERTY_PROXY_PORT, string));
        }
    }

    private String getPropertyLine(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-D").append(string).append("=").append(string2);
        return stringBuffer.toString();
    }

    class RedirectThread
    extends Thread {
        private InputStream is;
        private OutputStream os;
        private static final int BUFFER_SIZE = 512;

        public RedirectThread(InputStream inputStream, OutputStream outputStream) {
            this.is = inputStream;
            this.os = outputStream;
        }

        public void run() {
            try {
                byte[] byArray = new byte[512];
                int n = -1;
                while ((n = this.is.read(byArray)) > -1) {
                    this.os.write(byArray, 0, n);
                    this.os.flush();
                }
            }
            catch (IOException iOException) {
                RJElLogger.message("IOException in redirect thread.");
            }
        }
    }
}

