package HiCH_LOG; # Name of the module and namespace
#!/usr/bin/perl
# Author: Maik Ernst
# History:
# 2016-11-19 - initial module
#
# LICENSE
# Hitachi, Ltd. All rights reserved
# Hitachi Data Systems products and services can be ordered only under the terms and conditions
# of the applicable Hitachi Data Systems agreements.
#
# NAME
# HiCH_LOG
#
# DESCRIPTION
# This module is doing all the LOG stuff
#
# AUTHOR
#   Maik Ernst (maik.ernst@hds.com)
#
# MODIFICATIONS
#   2016-11-19 - v1.0.0		- initial module
#							  Functions: LOG_MSG_OPEN, LOG_MSG_CLOSE,LOG_MSG

use strict;
use warnings;
require Exporter;
use Data::Dumper;
use IO::Handle; # required for autoflush
use POSIX qw(strftime);

use vars qw(@ISA @EXPORT);
@ISA = qw(Exporter);

# All functions and variables which need to be exported and available in the importing scripts.
@EXPORT = qw(
LOG_MSG_OPEN
LOG_MSG_CLOSE
LOG_MSG
);

# LOG_MSG_OPEN
# Parameter needed:	path to logfile
# Returns: File handle

# LOG_MSG_CLOSE
# Parameter needed:	File handle from LOG_MSG_OPEN
# Returns: n/a

# LOG_MSG
# Parameter needed:	File handle from LOG_MSG_OPEN, verbose mode to standard out (0|1), standard out level (n|st|s|v|x)*, 
#					log level (normal|debug), severity like syslog (3|4|5|7), Keyword, message
#
# *Console output ... n = normal, s = short, st = short with time, v = verbose only, x = no output 
# Returns: n/a

# Example:
# my $logfie = "logfile.txt";
# $log_fh = LOG_MSG_OPEN($logfile);
# LOG_MSG($log_fh,"0","n","normal",5,"GENERAL","Starting Script $0");
# LOG_MSG_CLOSE($log_fh);

sub LOG_MSG_OPEN
{
	my $par_filepath = $_[0];
	open(my $fh, ">", $par_filepath) or die ("Can't open $par_filepath: $!\n");
	$fh->autoflush(1);
	return *$fh;
}

sub LOG_MSG_CLOSE
{
	my $par_fh = $_[0];
	close $par_fh;
}

sub LOG_MSG
{
	my $par_fh = shift (@_);
	my $par_vbse = shift (@_);
	my $par_stdout = shift (@_);
	my $par_LEVEL = shift (@_);
	my $par_SEVERITY = shift (@_);
	my $par_FUNCTION = shift (@_);
	my @line =  @_;
	my $logdate = strftime("%Y.%m.%d", localtime);
	my $logtime = strftime("%H:%M:%S", localtime);
	
	my $SEV_KEYWORD;
	chomp (@line);
	if ($par_SEVERITY == 3) {$SEV_KEYWORD = "ERROR";}
	if ($par_SEVERITY == 4) {$SEV_KEYWORD = "WARNING";}
	if ($par_SEVERITY == 5) {$SEV_KEYWORD = "NOTICE";}
	if ($par_SEVERITY == 7) {$SEV_KEYWORD = "DEBUG";}
		
	if  ($par_LEVEL eq "debug")
	{
		print $par_fh "$logdate,$logtime,$SEV_KEYWORD,$par_FUNCTION,@line\n";
	}
	else # e.g. "normal"
	{
		# Write to logfile if not DEBUG
		unless ($SEV_KEYWORD eq "DEBUG")
		{
			print $par_fh "$logdate,$logtime,$SEV_KEYWORD,$par_FUNCTION,@line\n";
		}
	}
	
	# Console output ... n = normal, s = short, st = short with time, v = verbose only, x = no output
	if ($par_stdout eq "n")
	{
		print "$logdate,$logtime,$SEV_KEYWORD,$par_FUNCTION,@line\n";
	}
	
	elsif ($par_stdout eq "st")
	{
		print "$logdate,$logtime,@line\n";
	}
	
	elsif ($par_stdout eq "s")
	{
		print "@line\n";
	}
	
	elsif ($par_stdout eq "v")
	{
		if ($par_vbse)
		{
			print "$logdate,$logtime,$SEV_KEYWORD,$par_FUNCTION,@line\n";
		}
	}
	
}
1; # End of the module with a true value