/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.ctl.confirm;

import sanproject.hlm.com.SJhlmRunnable;
import sanproject.hlm.ctl.SJhlmControllerInterface;
import sanproject.hlm.exception.SJhlmException;
import sanproject.hlm.handler.SJhlmErrorHandler;
import sanproject.hlm.manager.SJhlmExitManager;
import sanproject.hlm.manager.SJhlmUIEventRunnerManager;
import sanproject.hlm.manager.SJhlmUIManager;
import sanproject.hlm.util.SJhlmLogUtility;

public abstract class SJhlmConfirmController
implements SJhlmControllerInterface {
    private static final String CLASSNAME = SJhlmConfirmController.class.getSimpleName();
    private String message;
    private SJhlmRunnable confirm;
    private SJhlmRunnable cancel;

    public SJhlmConfirmController(final boolean bl) {
        this.setCancel(new SJhlmRunnable(){

            @Override
            public void run() {
                SJhlmUIManager.closeDialog();
                if (bl) {
                    SJhlmExitManager.exit(0);
                }
            }
        });
    }

    public SJhlmRunnable pushConfirmButton() {
        return new SJhlmRunnable(){

            @Override
            public void run() {
                SJhlmLogUtility.putLog(CLASSNAME, "pushConfirmButton.invoke", "Start");
                try {
                    SJhlmUIEventRunnerManager.run(SJhlmConfirmController.this.confirm);
                }
                catch (SJhlmException sJhlmException) {
                    SJhlmErrorHandler.handle(sJhlmException);
                }
            }
        };
    }

    public SJhlmRunnable pushCancelButton() {
        return new SJhlmRunnable(){

            @Override
            public void run() {
                SJhlmLogUtility.putLog(CLASSNAME, "pushCancelButton.invoke", "Start");
                try {
                    SJhlmUIEventRunnerManager.run(SJhlmConfirmController.this.cancel);
                }
                catch (SJhlmException sJhlmException) {
                    SJhlmErrorHandler.handle(sJhlmException);
                }
            }
        };
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setConfirm(SJhlmRunnable sJhlmRunnable) {
        this.confirm = sJhlmRunnable;
    }

    public void setCancel(SJhlmRunnable sJhlmRunnable) {
        this.cancel = sJhlmRunnable;
    }
}

