/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.factory;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import sanproject.hlm.exception.SJhlmDirectoryLockedException;
import sanproject.hlm.exception.SJhlmException;
import sanproject.hlm.factory.SJhlmExceptionFactory;
import sanproject.hlm.model.SJhlmLockedDirectoryModel;
import sanproject.hlm.util.SJhlmLogUtility;

public class SJhlmLockedDirectoryModelFactory {
    private static final String CLASSNAME = SJhlmLockedDirectoryModelFactory.class.getSimpleName();
    public static final String CACHE_FOLDER_NAME = "./cache";

    public static SJhlmLockedDirectoryModel createTmpDir() throws SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "createTmpDir()", "Started.");
        String string = SJhlmLockedDirectoryModelFactory.generateTmpDirName();
        String string2 = CACHE_FOLDER_NAME + File.separator + string;
        File file = new File(string2);
        if (file.exists()) {
            SJhlmLogUtility.putError(CLASSNAME, "createTmpDir()", string2 + " is exist.");
            throw SJhlmExceptionFactory.create();
        }
        SJhlmLockedDirectoryModel sJhlmLockedDirectoryModel = null;
        try {
            sJhlmLockedDirectoryModel = new SJhlmLockedDirectoryModel(string2);
        }
        catch (IOException iOException) {
            throw SJhlmExceptionFactory.create("22252-007003");
        }
        catch (SJhlmDirectoryLockedException sJhlmDirectoryLockedException) {
            throw SJhlmExceptionFactory.create("22252-007003", sJhlmDirectoryLockedException);
        }
        SJhlmLogUtility.putLog(CLASSNAME, "createTmpDir()", "End. (path=" + string2 + ")");
        return sJhlmLockedDirectoryModel;
    }

    private static String generateTmpDirName() {
        SJhlmLogUtility.putLog(CLASSNAME, "generateTmpDirName", "Started.");
        Date date = new Date();
        String string = date.getTime() + "-" + UUID.randomUUID();
        SJhlmLogUtility.putLog(CLASSNAME, "generateTmpDirName", "End. (ret=" + string + ")");
        return string;
    }
}

