/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.logic;

import java.io.IOException;
import sanproject.hlm.com.SJhlmRunnable;
import sanproject.hlm.ctl.confirm.SJhlmGumInvalidSignConfirmController;
import sanproject.hlm.ctl.confirm.SJhlmSVPInvalidSignConfirmController;
import sanproject.hlm.ctl.message.SJhlmMessageController;
import sanproject.hlm.data.SJhlmJWSParamData;
import sanproject.hlm.exception.SJhlmConfirmingException;
import sanproject.hlm.exception.SJhlmException;
import sanproject.hlm.exception.SJhlmGumInvalidSignConfirmException;
import sanproject.hlm.exception.SJhlmSVPInvalidSignConfirmException;
import sanproject.hlm.factory.SJhlmExceptionFactory;
import sanproject.hlm.factory.SJhlmJWSModelFactory;
import sanproject.hlm.handler.SJhlmErrorHandler;
import sanproject.hlm.manager.SJhlmUIManager;
import sanproject.hlm.model.SJhlmJWSModel;
import sanproject.hlm.util.SJhlmFileIOUtility;
import sanproject.hlm.util.SJhlmLogUtility;
import sanproject.hlm.util.SJhlmParseJNLPUtility;
import sanproject.hlm.util.SJhlmXMLErrorFixUtility;

public class SJhlmJNLPLaunchLogic {
    private static final String CLASSNAME = SJhlmJNLPLaunchLogic.class.getSimpleName();
    private static final String[] IGNORE_URL = new String[]{"file://"};

    public static void startCommandLine(String string) {
        SJhlmLogUtility.putLog(CLASSNAME, "startCommandLine()", "start(path=" + string + ")");
        try {
            SJhlmUIManager.showDialog(new SJhlmMessageController());
            SJhlmJWSParamData sJhlmJWSParamData = SJhlmJNLPLaunchLogic.readJNLPFile(string);
            SJhlmJWSModel sJhlmJWSModel = SJhlmJWSModelFactory.create(sJhlmJWSParamData);
            SJhlmJNLPLaunchLogic.startJWS(sJhlmJWSModel);
        }
        catch (SJhlmException sJhlmException) {
            SJhlmErrorHandler.handle(sJhlmException.fatal());
        }
        SJhlmLogUtility.putLog(CLASSNAME, "startCommandLine()", "End.");
    }

    private static SJhlmRunnable onStartJWS() {
        return new SJhlmRunnable(){

            @Override
            public void run() {
                SJhlmUIManager.closeDialog();
            }
        };
    }

    private static void startJWS(SJhlmJWSModel sJhlmJWSModel) throws SJhlmException {
        try {
            sJhlmJWSModel.start(SJhlmJNLPLaunchLogic.onStartJWS());
        }
        catch (SJhlmConfirmingException sJhlmConfirmingException) {
            SJhlmUIManager.closeDialog();
            if (sJhlmConfirmingException instanceof SJhlmGumInvalidSignConfirmException) {
                SJhlmGumInvalidSignConfirmException sJhlmGumInvalidSignConfirmException = (SJhlmGumInvalidSignConfirmException)sJhlmConfirmingException;
                SJhlmGumInvalidSignConfirmController sJhlmGumInvalidSignConfirmController = new SJhlmGumInvalidSignConfirmController(sJhlmGumInvalidSignConfirmException.getJws(), true);
                sJhlmGumInvalidSignConfirmController.setConfirm(SJhlmJNLPLaunchLogic.getConfirm(sJhlmGumInvalidSignConfirmException.getJws()));
                SJhlmUIManager.showDialog(sJhlmGumInvalidSignConfirmController);
            }
            if (sJhlmConfirmingException instanceof SJhlmSVPInvalidSignConfirmException) {
                SJhlmSVPInvalidSignConfirmException sJhlmSVPInvalidSignConfirmException = (SJhlmSVPInvalidSignConfirmException)sJhlmConfirmingException;
                SJhlmSVPInvalidSignConfirmController sJhlmSVPInvalidSignConfirmController = new SJhlmSVPInvalidSignConfirmController(sJhlmSVPInvalidSignConfirmException.getJws(), true);
                sJhlmSVPInvalidSignConfirmController.setConfirm(SJhlmJNLPLaunchLogic.getConfirm(sJhlmSVPInvalidSignConfirmException.getJws()));
                SJhlmUIManager.showDialog(sJhlmSVPInvalidSignConfirmController);
            }
            throw SJhlmExceptionFactory.create().fatal();
        }
    }

    private static SJhlmRunnable getConfirm(final SJhlmJWSModel sJhlmJWSModel) {
        return new SJhlmRunnable(){

            @Override
            public void run() {
                SJhlmUIManager.closeDialog();
                SJhlmUIManager.showDialog(new SJhlmMessageController());
                try {
                    sJhlmJWSModel.skipVerify().start(SJhlmJNLPLaunchLogic.onStartJWS());
                }
                catch (SJhlmConfirmingException sJhlmConfirmingException) {
                    SJhlmErrorHandler.handle(SJhlmExceptionFactory.create(sJhlmConfirmingException).fatal());
                }
                catch (SJhlmException sJhlmException) {
                    SJhlmErrorHandler.handle(sJhlmException.fatal());
                }
            }
        };
    }

    public static SJhlmJWSParamData readJNLPFile(String string) throws SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "readJNLPFile()", "start(path=" + string + ")");
        string = SJhlmJNLPLaunchLogic.trimJNLPFilePath(string);
        String string2 = "";
        try {
            string2 = SJhlmFileIOUtility.readString(string);
            string2 = SJhlmXMLErrorFixUtility.fixXML(string2);
        }
        catch (IOException iOException) {
            throw SJhlmExceptionFactory.create("22252-005001", iOException);
        }
        SJhlmJWSParamData sJhlmJWSParamData = SJhlmParseJNLPUtility.parseJNLP(string2);
        SJhlmLogUtility.putLog(CLASSNAME, "readJNLPFile()", "End.");
        return sJhlmJWSParamData;
    }

    private static String trimJNLPFilePath(String string) {
        SJhlmLogUtility.putLog(CLASSNAME, "trimJNLPFilePath()", "start(path=" + string + ")");
        for (String string2 : IGNORE_URL) {
            if (!string.startsWith(string2)) continue;
            string = string.substring(string2.length());
        }
        SJhlmLogUtility.putLog(CLASSNAME, "trimJNLPFilePath()", "End(path=" + string + ")");
        return string;
    }
}

