/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.manager;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import sanproject.hlm.exception.SJhlmException;
import sanproject.hlm.factory.SJhlmExceptionFactory;
import sanproject.hlm.util.SJhlmLogUtility;

public class SJhlmKeyManager {
    private static final String CLASSNAME = SJhlmKeyManager.class.getSimpleName();
    private static final String PUBLIC_KEY_FILE = "sign.pub";
    private static PublicKey puKey = null;

    public static PublicKey getPublicKey() throws SJhlmException {
        if (puKey == null) {
            puKey = SJhlmKeyManager.createPublicKey();
        }
        return puKey;
    }

    private static PublicKey createPublicKey() throws SJhlmException {
        Object object;
        Object object2;
        SJhlmLogUtility.putLog(CLASSNAME, "createPublicKey()", "Started.");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object2 = ClassLoader.getSystemResourceAsStream(PUBLIC_KEY_FILE);
            try {
                object = new byte[1024];
                int n = 0;
                while ((n = ((InputStream)object2).read((byte[])object)) >= 0) {
                    byteArrayOutputStream.write((byte[])object, 0, n);
                }
            }
            finally {
                if (object2 != null) {
                    ((InputStream)object2).close();
                }
            }
        }
        catch (IOException iOException) {
            throw SJhlmExceptionFactory.create(iOException);
        }
        object2 = new X509EncodedKeySpec(byteArrayOutputStream.toByteArray());
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            object = keyFactory.generatePublic((KeySpec)object2);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw SJhlmExceptionFactory.create(generalSecurityException);
        }
        SJhlmLogUtility.putLog(CLASSNAME, "createPublicKey()", "End.");
        return object;
    }
}

