/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.manager;

import java.util.regex.Pattern;
import sanproject.hlm.data.SJhlmJWSParamData;
import sanproject.hlm.data.SJhlmJarInfoData;
import sanproject.hlm.util.SJhlmLogUtility;

public class SJhlmWhiteListManager {
    private static final String CLASSNAME = SJhlmWhiteListManager.class.getSimpleName();
    private static final String[] WHITELIST_GUM_REGEX = new String[]{"java/HiMicroUpdate\\.jar(\\?.+)?$", "java/HiHnasInstall\\.jar(\\?.+)?$", "java/commons\\-net\\-3\\.[36]\\.jar(\\?.+)?$"};
    private static final String[] WHITELIST_SVP_REGEX = new String[]{"san/StartSVPApp.jar$", "san/JSanRmiServerUx.jar$"};

    public static boolean isListedGum(SJhlmJWSParamData sJhlmJWSParamData) {
        SJhlmLogUtility.putLog(CLASSNAME, "isListed(JWS)", "Started.");
        boolean bl = true;
        for (SJhlmJarInfoData sJhlmJarInfoData : sJhlmJWSParamData.getJar()) {
            String string = sJhlmJarInfoData.getPath();
            if (SJhlmWhiteListManager.isListedGum(string)) continue;
            bl = false;
        }
        SJhlmLogUtility.putLog(CLASSNAME, "isListed(JWS)", "End.(ret=" + bl + ")");
        return bl;
    }

    public static boolean isListedSVP(SJhlmJWSParamData sJhlmJWSParamData) {
        SJhlmLogUtility.putLog(CLASSNAME, "isListed(JWS)", "Started.");
        boolean bl = true;
        for (SJhlmJarInfoData sJhlmJarInfoData : sJhlmJWSParamData.getJar()) {
            String string = sJhlmJarInfoData.getPath();
            if (SJhlmWhiteListManager.isListedSVP(string)) continue;
            bl = false;
        }
        SJhlmLogUtility.putLog(CLASSNAME, "isListed(JWS)", "End.(ret=" + bl + ")");
        return bl;
    }

    public static boolean isListedGum(String string) {
        boolean bl = false;
        for (String string2 : WHITELIST_GUM_REGEX) {
            Pattern pattern = Pattern.compile(string2);
            if (!pattern.matcher(string).find()) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean isListedSVP(String string) {
        boolean bl = false;
        for (String string2 : WHITELIST_SVP_REGEX) {
            Pattern pattern = Pattern.compile(string2);
            if (!pattern.matcher(string).find()) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean isLocal(SJhlmJWSParamData sJhlmJWSParamData) {
        SJhlmLogUtility.putLog(CLASSNAME, "isLocal", "Started.");
        boolean bl = true;
        for (SJhlmJarInfoData sJhlmJarInfoData : sJhlmJWSParamData.getJar()) {
            String string = sJhlmJarInfoData.getPath();
            if (SJhlmWhiteListManager.isListedSVP(string)) continue;
            bl = false;
        }
        SJhlmLogUtility.putLog(CLASSNAME, "isLocal", "End.(ret=" + bl + ")");
        return bl;
    }
}

