/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import sanproject.hlm.data.SJhlmJWSParamData;
import sanproject.hlm.exception.SJhlmException;
import sanproject.hlm.factory.SJhlmExceptionFactory;
import sanproject.hlm.util.SJhlmHTTPConnectionUtility;
import sanproject.hlm.util.SJhlmJSONConvertUtility;
import sanproject.hlm.util.SJhlmLogUtility;

public class SJhlmGumModel {
    private static final String CLASSNAME = SJhlmGumModel.class.getSimpleName();
    private SJhlmJWSParamData jwsParam = null;
    public static final String[] SUCCESS_RETCODE = new String[]{"30762-200000", "30662-200000"};

    public SJhlmGumModel(SJhlmJWSParamData sJhlmJWSParamData) {
        String string = CLASSNAME;
        SJhlmLogUtility.putLog(CLASSNAME, string, "Start.(codebase=" + sJhlmJWSParamData.getCodeBase() + ")");
        this.jwsParam = sJhlmJWSParamData;
        SJhlmLogUtility.putLog(CLASSNAME, string, "End.");
    }

    public boolean isTrust() throws SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "isTrust", "Start.");
        boolean bl = false;
        try {
            bl = this.executeGUM();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            SJhlmLogUtility.putError(CLASSNAME, "isTrust", iOException);
        }
        SJhlmLogUtility.putLog(CLASSNAME, "isTrust", "End.(" + bl + ")");
        return bl;
    }

    private String getSessionID() {
        int n = 3;
        if (this.jwsParam.getJar().size() == 2) {
            n = 2;
        }
        if (this.jwsParam.getArgs().size() > n) {
            SJhlmLogUtility.putLog(CLASSNAME, "getSessionID", "SessionID=" + this.jwsParam.getArgs().get(n - 1));
            return this.jwsParam.getArgs().get(n - 1);
        }
        return null;
    }

    private boolean executeGUM() throws IOException, SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "executeGUM", "Start.");
        String string = "{\"header\":{\"service\":\"System\", \"action\":\"getSystemInfo\", \"returnCode\":\"\", \"client\":\"NORMAL\"}, \"body\":{}}";
        HttpURLConnection httpURLConnection = null;
        boolean bl = false;
        while (!bl) {
            try {
                String string22;
                httpURLConnection = this.createGUMConnection(string);
                httpURLConnection.connect();
                this.doPOST(string, httpURLConnection.getOutputStream());
                Map<String, List<String>> map = httpURLConnection.getHeaderFields();
                boolean bl2 = true;
                Pattern pattern = Pattern.compile(".*Unauthorized.*");
                for (String string22 : map.keySet()) {
                    SJhlmLogUtility.putLog(CLASSNAME, "executeGUM", string22 + ": " + map.get(string22));
                    if (!"Status".equals(string22)) continue;
                    for (String string3 : map.get(string22)) {
                        if (!pattern.matcher(string3).matches()) continue;
                        bl2 = false;
                    }
                }
                if (!bl2) {
                    SJhlmLogUtility.putError(CLASSNAME, "executeGUM", "Authentication error");
                    return false;
                }
                Object object = null;
                object = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "JISAutoDetect"));
                string22 = ((BufferedReader)object).readLine();
                while (null != string22) {
                    SJhlmLogUtility.putLog(CLASSNAME, "executeGUM", "Response:" + string22);
                    this.checkResp(string22);
                    string22 = ((BufferedReader)object).readLine();
                }
                bl = true;
            }
            catch (SSLHandshakeException sSLHandshakeException) {
                sSLHandshakeException.printStackTrace();
                SJhlmLogUtility.putError(CLASSNAME, "executeGUM", "handshakeException(Ignored)", sSLHandshakeException);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                SJhlmLogUtility.putError(CLASSNAME, "executeGUM", "error occured", iOException);
                return false;
            }
        }
        SJhlmLogUtility.putLog(CLASSNAME, "executeGUM", "End.");
        return true;
    }

    private void checkResp(String string) throws SJhlmException {
        try {
            Object object = SJhlmJSONConvertUtility.convJSON2Object(string);
            Map<String, Object> map = SJhlmJSONConvertUtility.castMap(object);
            Object object2 = map.get("header");
            Map<String, Object> map2 = SJhlmJSONConvertUtility.castMap(object2);
            Object object3 = map2.get("action");
            String string2 = (String)object3;
            if (!"getSystemInfo".equals(string2)) {
                throw SJhlmExceptionFactory.create();
            }
            Object object4 = map.get("body");
            Map<String, Object> map3 = SJhlmJSONConvertUtility.castMap(object4);
            Object object5 = map3.get("storageSystemName");
            if (object5 == null) {
                throw SJhlmExceptionFactory.create();
            }
        }
        catch (Exception exception) {
            SJhlmLogUtility.putError(CLASSNAME, "checkResp", "Parse failed", exception);
            throw SJhlmExceptionFactory.create(exception);
        }
    }

    private HttpURLConnection createGUMConnection(String string) throws IOException, SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "createSSLConnection", "Start.");
        String string2 = this.jwsParam.getCodeBase() + "/cgi-bin/easygui.cgi";
        SJhlmLogUtility.putLog(CLASSNAME, "createSSLConnection", "URL=" + string2);
        HttpURLConnection httpURLConnection = SJhlmHTTPConnectionUtility.createConnection(string2);
        try {
            httpURLConnection.setRequestMethod("POST");
        }
        catch (ProtocolException protocolException) {
            protocolException.printStackTrace();
            SJhlmLogUtility.putError(CLASSNAME, "createSSLConnection", "error occured", protocolException);
            throw SJhlmExceptionFactory.create(protocolException);
        }
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setRequestProperty("Accept-Language", "ja-JP,en;q=0.7,en-US;q=0.3");
        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(string.length()));
        httpURLConnection.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        httpURLConnection.setRequestProperty("Session-ID", this.getSessionID());
        SJhlmLogUtility.putLog(CLASSNAME, "createSSLConnection", "End.");
        return httpURLConnection;
    }

    private void doPOST(String string, OutputStream outputStream) throws SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "doPOST", "Start.");
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, "utf-8")));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw SJhlmExceptionFactory.create(iOException);
        }
        printWriter.print(string);
        printWriter.close();
        SJhlmLogUtility.putLog(CLASSNAME, "doPOST", "End.");
    }
}

