/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.ui.parts;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import sanproject.hlm.com.SJhlmRunnable;
import sanproject.hlm.exception.SJhlmException;
import sanproject.hlm.manager.SJhlmUIManager;
import sanproject.hlm.manager.SJhlmWordManager;
import sanproject.hlm.model.SJhlmHistoryModel;
import sanproject.hlm.ui.parts.SJhlmButton;
import sanproject.hlm.ui.parts.SJhlmJNLPFilter;
import sanproject.hlm.ui.parts.pane.SJhlmPaneBase;
import sanproject.hlm.util.SJhlmLogUtility;

public class SJhlmFileChooser
extends SJhlmPaneBase {
    private static final String CLASSNAME = SJhlmFileChooser.class.getSimpleName();
    private JTextField filePath;
    private SJhlmButton choseBtn;
    private SJhlmRunnable afterSet;

    public SJhlmFileChooser(SJhlmRunnable sJhlmRunnable) {
        this.afterSet = sJhlmRunnable;
        SJhlmPaneBase sJhlmPaneBase = new SJhlmPaneBase();
        this.filePath = new JTextField();
        this.filePath.setFocusable(false);
        this.filePath.setEditable(false);
        sJhlmPaneBase.add((Component)this.filePath, "Center");
        this.choseBtn = new SJhlmButton(SJhlmWordManager.getGuidance("BUTTON_BROWSE"));
        this.choseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SJhlmFileChooser.this.showFileChooser();
                    }
                });
            }
        });
        SJhlmPaneBase sJhlmPaneBase2 = new SJhlmPaneBase();
        sJhlmPaneBase2.add(Box.createHorizontalStrut(16), "Before");
        sJhlmPaneBase2.add((Component)this.choseBtn, "After");
        sJhlmPaneBase.add((Component)sJhlmPaneBase2, "After");
        this.add((Component)sJhlmPaneBase, "First");
    }

    public String getSelectedPath() {
        String string = this.filePath.getText();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void showFileChooser() {
        SJhlmLogUtility.putLog(CLASSNAME, "showFileChooser", "Start.");
        String string = null;
        try {
            string = new SJhlmHistoryModel().readHistory();
            SJhlmLogUtility.putLog(CLASSNAME, "showFileChooser", "defPath=" + string);
        }
        catch (SJhlmException sJhlmException) {
            SJhlmLogUtility.putError(CLASSNAME, "showFileChooser", sJhlmException.getMessage() + sJhlmException.getCode());
            SJhlmLogUtility.putError(CLASSNAME, "showFileChooser", sJhlmException);
        }
        File file = null;
        if (!(string == null || string.length() <= 0 || (file = new File(string)).exists() && file.isDirectory())) {
            file = null;
        }
        JFileChooser jFileChooser = new JFileChooser(file);
        SJhlmJNLPFilter sJhlmJNLPFilter = new SJhlmJNLPFilter();
        jFileChooser.addChoosableFileFilter(sJhlmJNLPFilter);
        jFileChooser.setDialogTitle(SJhlmWordManager.getGuidance("FILECHOOSE_TITLE"));
        jFileChooser.setFileFilter(sJhlmJNLPFilter);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        int n = jFileChooser.showOpenDialog(SJhlmUIManager.getTopFrame());
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            if (file2 == null) {
                SJhlmLogUtility.putLog(CLASSNAME, "showFileChooser", "End(Not Selected).");
                return;
            }
            try {
                new SJhlmHistoryModel().setHistory(file2.getParent());
            }
            catch (SJhlmException sJhlmException) {
                SJhlmLogUtility.putError(CLASSNAME, "showFileChooser", sJhlmException.getMessage() + sJhlmException.getCode());
                SJhlmLogUtility.putError(CLASSNAME, "showFileChooser", sJhlmException);
            }
            this.filePath.setText(file2.getAbsolutePath());
        }
        this.afterSet.run();
        SJhlmLogUtility.putLog(CLASSNAME, "showFileChooser", "End.");
    }
}

