/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import sanproject.hlm.exception.SJhlmException;
import sanproject.hlm.factory.SJhlmExceptionFactory;
import sanproject.hlm.util.SJhlmLogUtility;

public class SJhlmHTTPConnectionUtility {
    private static final String CLASSNAME = SJhlmHTTPConnectionUtility.class.getSimpleName();
    private static final int HANDSHAKE_RETRY_COUNT = 5;

    public static String getString(String string) throws SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "getString()", "Start. (url=" + string + ")");
        StringBuffer stringBuffer = new StringBuffer();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(SJhlmHTTPConnectionUtility.getInputStream(string), "JISAutoDetect"));){
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                SJhlmLogUtility.putLog(CLASSNAME, "getString()", "Response:" + string2);
                stringBuffer.append(string2);
            }
        }
        catch (IOException iOException) {
            throw SJhlmExceptionFactory.create("22252-005002", iOException);
        }
        SJhlmLogUtility.putLog(CLASSNAME, "getString()", "End.");
        return stringBuffer.toString();
    }

    public static InputStream getInputStream(String string) throws SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "getInputStream()", "Start. (url=" + string + ")");
        InputStream inputStream = null;
        HttpURLConnection httpURLConnection = null;
        boolean bl = false;
        int n = 0;
        while (!bl) {
            try {
                httpURLConnection = SJhlmHTTPConnectionUtility.createConnection(string);
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.connect();
                inputStream = httpURLConnection.getInputStream();
                bl = true;
            }
            catch (SSLHandshakeException sSLHandshakeException) {
                sSLHandshakeException.printStackTrace();
                SJhlmLogUtility.putError(CLASSNAME, "getInputStream()", "handshakeException:" + ++n, sSLHandshakeException);
                if (n > 5) {
                    throw SJhlmExceptionFactory.create("22252-005003", sSLHandshakeException);
                }
                SJhlmLogUtility.putLog(CLASSNAME, "getInputStream()", "handshakeException(Ignored)");
            }
            catch (IOException iOException) {
                throw SJhlmExceptionFactory.create("22252-005002");
            }
        }
        SJhlmLogUtility.putLog(CLASSNAME, "getInputStream()", "End.");
        return inputStream;
    }

    public static HttpURLConnection createConnection(String string) throws SJhlmException {
        SJhlmLogUtility.putLog(CLASSNAME, "createConnection", "Start. (url=" + string + ")");
        boolean bl = string.startsWith("http:");
        HttpURLConnection httpURLConnection = bl ? SJhlmHTTPConnectionUtility.createHTTPConnection(string) : SJhlmHTTPConnectionUtility.createSSLConnection(string);
        SJhlmLogUtility.putLog(CLASSNAME, "createConnection", "End.");
        return httpURLConnection;
    }

    public static HttpURLConnection createHTTPConnection(String string) throws SJhlmException {
        HttpURLConnection httpURLConnection;
        SJhlmLogUtility.putLog(CLASSNAME, "createHTTPConnection", "Start. (url=" + string + ")");
        try {
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
        }
        catch (IOException iOException) {
            throw SJhlmExceptionFactory.create("22252-005002", iOException);
        }
        SJhlmLogUtility.putLog(CLASSNAME, "createHTTPConnection", "End.");
        return httpURLConnection;
    }

    public static HttpURLConnection createSSLConnection(String string) throws SJhlmException {
        HttpsURLConnection httpsURLConnection;
        SJhlmLogUtility.putLog(CLASSNAME, "createSSLConnection", "Start. (url=" + string + ")");
        try {
            httpsURLConnection = (HttpsURLConnection)new URL(string).openConnection();
        }
        catch (IOException iOException) {
            throw SJhlmExceptionFactory.create("22252-005002", iOException);
        }
        httpsURLConnection.setSSLSocketFactory(SJhlmHTTPConnectionUtility.createNoCheckSSLFactory());
        httpsURLConnection.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        });
        httpsURLConnection.setAllowUserInteraction(false);
        httpsURLConnection.setInstanceFollowRedirects(true);
        SJhlmLogUtility.putLog(CLASSNAME, "createSSLConnection", "End.");
        return httpsURLConnection;
    }

    private static SSLSocketFactory createNoCheckSSLFactory() throws SJhlmException {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        SSLContext sSLContext = null;
        try {
            sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            throw SJhlmExceptionFactory.create(generalSecurityException);
        }
        return sSLContext.getSocketFactory();
    }
}

