/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SJhlmJSONConvertUtility {
    public static String convString2JSON(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (char c : string.toCharArray()) {
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("\\\"");
                continue;
            }
            if (c == '/') {
                stringBuffer.append("\\/");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String convObject2JSON(Object object) {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Map) {
            stringBuffer.append('{');
            object2 = SJhlmJSONConvertUtility.castMap(object);
            stringBuffer.append(SJhlmJSONConvertUtility.convMap2JSON(object2));
            stringBuffer.append('}');
        }
        if (object instanceof List) {
            stringBuffer.append('[');
            object2 = SJhlmJSONConvertUtility.castList(object);
            stringBuffer.append(SJhlmJSONConvertUtility.convList2JSON((List<Object>)object2));
            stringBuffer.append(']');
        }
        if (object instanceof String) {
            stringBuffer.append('\"');
            object2 = (String)object;
            stringBuffer.append(SJhlmJSONConvertUtility.convString2JSON((String)object2));
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    private static String convMap2JSON(Map<String, Object> map) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : map.keySet()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(SJhlmJSONConvertUtility.convObject2JSON(string));
            stringBuffer.append(":");
            stringBuffer.append(SJhlmJSONConvertUtility.convObject2JSON(map.get(string)));
        }
        return stringBuffer.toString();
    }

    private static String convList2JSON(List<Object> list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (Object object : list) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(SJhlmJSONConvertUtility.convObject2JSON(object));
        }
        return stringBuffer.toString();
    }

    public static Object convJSON2Object(String string) {
        String string2 = string.trim();
        List<Object> list = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (char c : string2.toCharArray()) {
            if (n3 > 0) {
                --n3;
                if (bl && c == 'u') {
                    n3 = 4;
                    if (n2 > 0) {
                        stringBuffer.append('\\');
                    }
                }
                bl = false;
                if (n2 <= 0) continue;
                stringBuffer.append(c);
                continue;
            }
            if (c == '\\' && n3 == 0) {
                n3 = 1;
                bl = true;
                stringBuffer.append("\\");
                continue;
            }
            if (n2 == 0) {
                if (c == '{') {
                    n2 = 1;
                    ++n;
                    continue;
                }
                if (c == '[') {
                    n2 = 2;
                    ++n;
                    continue;
                }
                if (c != '\"') continue;
                n2 = 3;
                continue;
            }
            if (n2 == 1) {
                if (c == '{') {
                    ++n;
                } else if (c == '}' && --n == 0) {
                    list = SJhlmJSONConvertUtility.convJSON2Map(stringBuffer.toString().trim());
                    stringBuffer = new StringBuffer();
                }
                if (n <= 0) continue;
                stringBuffer.append(c);
                continue;
            }
            if (n2 == 2) {
                if (c == '[') {
                    ++n;
                } else if (c == ']' && --n == 0) {
                    list = SJhlmJSONConvertUtility.convJSON2Array(stringBuffer.toString().trim());
                    stringBuffer = new StringBuffer();
                }
                if (n <= 0) continue;
                stringBuffer.append(c);
                continue;
            }
            if (n2 != 3) continue;
            if (c == '\"') {
                list = SJhlmJSONConvertUtility.convJSON2String(stringBuffer.toString().trim());
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append(c);
        }
        return list;
    }

    private static Map<String, Object> convJSON2Set(String string) {
        String string2 = string.trim();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        boolean bl = false;
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        Object object = null;
        int n = 0;
        boolean bl3 = false;
        for (char c : string2.toCharArray()) {
            if (n > 0) {
                --n;
                if (bl3 && c == 'u') {
                    n = 4;
                }
                bl3 = false;
                stringBuffer.append(c);
                continue;
            }
            if (c == '\\' && n == 0) {
                n = 1;
                bl3 = true;
                stringBuffer.append("\\");
                continue;
            }
            if (bl2) {
                if (c == '\"') {
                    bl = !bl;
                    continue;
                }
                if (!bl && c == ':') {
                    bl2 = false;
                    string3 = stringBuffer.toString();
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        object = SJhlmJSONConvertUtility.convJSON2Object(stringBuffer.toString().trim());
        hashMap.put(string3, object);
        return hashMap;
    }

    private static String convJSON2String(String string) {
        return string;
    }

    private static List<Object> convJSON2Array(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        for (char c : string.toCharArray()) {
            if (n3 > 0) {
                --n3;
                if (bl2 && c == 'u') {
                    n3 = 4;
                }
                bl2 = false;
                stringBuffer.append(c);
                continue;
            }
            if (c == '\\' && n3 == 0) {
                n3 = 1;
                bl2 = true;
                stringBuffer.append("\\");
                continue;
            }
            if (c == ',' && n == 0 && n2 == 0 && !bl) {
                arrayList.add(SJhlmJSONConvertUtility.convJSON2Object(stringBuffer.toString().trim()));
                stringBuffer = new StringBuffer();
                continue;
            }
            if (c == '{') {
                ++n2;
            }
            if (c == '}') {
                --n2;
            }
            if (c == '[') {
                ++n;
            }
            if (c == ']') {
                --n;
            }
            if (c == '\"') {
                bl = !bl;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.toString().trim().length() > 0) {
            arrayList.add(SJhlmJSONConvertUtility.convJSON2Object(stringBuffer.toString().trim()));
        }
        return arrayList;
    }

    private static Map<String, Object> convJSON2Map(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        for (char c : string.toCharArray()) {
            if (n3 > 0) {
                --n3;
                if (bl2 && c == 'u') {
                    n3 = 4;
                }
                bl2 = false;
                stringBuffer.append(c);
                continue;
            }
            if (c == '\\' && n3 == 0) {
                n3 = 1;
                bl2 = true;
                continue;
            }
            if (c == ',' && n == 0 && n2 == 0 && !bl) {
                hashMap.putAll(SJhlmJSONConvertUtility.convJSON2Set(stringBuffer.toString().trim()));
                stringBuffer = new StringBuffer();
                continue;
            }
            if (c == '{') {
                ++n2;
            }
            if (c == '}') {
                --n2;
            }
            if (c == '[') {
                ++n;
            }
            if (c == ']') {
                --n;
            }
            if (c == '\"') {
                bl = !bl;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.toString().trim().length() > 0) {
            hashMap.putAll(SJhlmJSONConvertUtility.convJSON2Set(stringBuffer.toString().trim()));
        }
        return hashMap;
    }

    public static Map<String, Object> castMap(Object object) {
        Map map = (Map)object;
        return map;
    }

    public static List<Object> castList(Object object) {
        List list = (List)object;
        return list;
    }
}

