/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sanproject.hlm.data.SJhlmJWSParamData;
import sanproject.hlm.data.SJhlmJarInfoData;
import sanproject.hlm.exception.SJhlmException;
import sanproject.hlm.factory.SJhlmExceptionFactory;
import sanproject.hlm.util.SJhlmLogUtility;

public class SJhlmParseJNLPUtility {
    private static final String CLASSNAME = SJhlmParseJNLPUtility.class.getSimpleName();
    public static final String NODE_JNLP = "jnlp";
    public static final String NODE_RESOURCES = "resources";
    public static final String NODE_J2SE = "j2se";
    public static final String NODE_JAR = "jar";
    public static final String NODE_PROPERTY = "property";
    public static final String NODE_APP_DESC = "application-desc";
    public static final String NODE_ARG = "argument";
    public static final String ATTR_CODEBASE = "codebase";
    public static final String ATTR_VMARG = "java-vm-args";
    public static final String ATTR_INIT_HEAP = "initial-heap-size";
    public static final String ATTR_MAX_HEAP = "max-heap-size";
    public static final String ATTR_HREF = "href";
    public static final String ATTR_MAIN = "main";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_MAIN_CLASS = "main-class";

    /*
     * WARNING - void declaration
     */
    public static SJhlmJWSParamData parseJNLP(String string) throws SJhlmException {
        Object object;
        SJhlmLogUtility.putLog(CLASSNAME, "getJWSData()", "Start. (xml=" + string + ")");
        SJhlmJWSParamData sJhlmJWSParamData = new SJhlmJWSParamData();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        Document document = null;
        try {
            object = documentBuilderFactory.newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(new ByteArrayInputStream(string.getBytes("utf-8")));
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw SJhlmExceptionFactory.create("22252-005000", exception);
        }
        try {
            Object object2;
            Object object3;
            Object object5;
            object = document.getFirstChild();
            String string2 = object.getAttributes().getNamedItem(ATTR_CODEBASE).getTextContent();
            sJhlmJWSParamData.setCodeBase(string2);
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            Node node = SJhlmParseJNLPUtility.getNode((Node)object, NODE_RESOURCES);
            ArrayList<SJhlmJarInfoData> arrayList = new ArrayList<SJhlmJarInfoData>();
            Node node2 = SJhlmParseJNLPUtility.getNode(node, NODE_J2SE);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (node2.getAttributes().getNamedItem(ATTR_VMARG) != null) {
                object5 = node2.getAttributes().getNamedItem(ATTR_VMARG).getTextContent();
                for (String object42 : ((String)object5).split(" ")) {
                    arrayList2.add(object42);
                }
            }
            sJhlmJWSParamData.setVmArg(arrayList2);
            object5 = SJhlmParseJNLPUtility.getNodes(node, NODE_JAR);
            Object object6 = object5.iterator();
            while (object6.hasNext()) {
                void var15_24;
                Node node3 = (Node)object6.next();
                SJhlmJarInfoData sJhlmJarInfoData = new SJhlmJarInfoData();
                String string3 = node3.getAttributes().getNamedItem(ATTR_HREF).getTextContent();
                if (string3.startsWith("/")) {
                    object3 = new StringBuffer();
                    int n = 0;
                    for (char c : string2.toCharArray()) {
                        if (c == '/' && ++n > 2) break;
                        ((StringBuffer)object3).append(c);
                    }
                    string2 = ((StringBuffer)object3).toString();
                } else {
                    String string4 = "/" + string3;
                }
                object3 = string2 + (String)var15_24;
                object2 = SJhlmParseJNLPUtility.getFileName((String)object3);
                sJhlmJarInfoData.setFileName((String)object2);
                sJhlmJarInfoData.setPath((String)object3);
                arrayList.add(sJhlmJarInfoData);
            }
            sJhlmJWSParamData.setJar(arrayList);
            object6 = new HashMap();
            List<Node> list = SJhlmParseJNLPUtility.getNodes(node, NODE_PROPERTY);
            for (Node node3 : list) {
                object3 = node3.getAttributes().getNamedItem(ATTR_NAME).getTextContent();
                object2 = node3.getAttributes().getNamedItem(ATTR_VALUE).getTextContent();
                object6.put(object3, object2);
            }
            sJhlmJWSParamData.setProperties((Map<String, String>)object6);
            Object object7 = "";
            Node node4 = SJhlmParseJNLPUtility.getNode((Node)object, NODE_APP_DESC);
            object7 = node4.getAttributes().getNamedItem(ATTR_MAIN_CLASS).getTextContent();
            sJhlmJWSParamData.setMainClass((String)object7);
            object3 = new ArrayList();
            object2 = SJhlmParseJNLPUtility.getNodes(node4, NODE_ARG);
            Object object4 = object2.iterator();
            while (object4.hasNext()) {
                Node node5 = (Node)object4.next();
                object3.add(node5.getFirstChild().getNodeValue());
            }
            sJhlmJWSParamData.setArgs((List<String>)object3);
        }
        catch (NullPointerException nullPointerException) {
            throw SJhlmExceptionFactory.create("22252-005000", nullPointerException);
        }
        SJhlmLogUtility.putLog(CLASSNAME, "getJWSData()", "End.");
        return sJhlmJWSParamData;
    }

    private static List<Node> getNodes(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!string.equals(nodeList.item(i).getNodeName())) continue;
            arrayList.add(nodeList.item(i));
        }
        return arrayList;
    }

    private static Node getNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        Node node2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!string.equals(nodeList.item(i).getNodeName())) continue;
            node2 = nodeList.item(i);
            break;
        }
        return node2;
    }

    private static String getFileName(String string) {
        int n;
        int n2 = string.lastIndexOf("?");
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        if ((n = string.lastIndexOf("/")) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }
}

