/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.util.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.util.HashSet;
import org.slf4j.LoggerFactory;
import sanproject.hlm.util.SJhlmSystemUtility;
import sanproject.hlm.util.log.SJhlmRollingPolicy;

public class SJhlmLogger {
    public static final int LOG_LEVEL = 20000;
    public static final int LOG_LEVEL_ERROR = 40000;
    private static final String SECTION_PAUSE_START = "[";
    private static final String SECTION_PAUSE_END = "]";
    private static final String NO_SLF4J_LOGGER_MSG = "Please set Log4J Logger";
    private static final String LOG_OUTPUT_PATTERN = "[%d{yy/MM/dd HH:mm:ss.SSS}][%-5level][%thread]%msg%n";
    private static final String CHAR_SET = "utf-8";
    private static final String NUMBER_SYMBOL = "_%i";
    private static final String LOG_SIZE_UNIT = "MB";
    private static final String MEMORY_SIZE_UNIT = "KB";
    private static final String LOG_ITEM_SEPARETOR = ":";
    private static final String SEARCH_TEXT = ".";
    private static final String MEMORY_SEPARETOR = "/";
    private static final String LINE_FEED_CODE = System.getProperty("line.separator", "\n");
    private static final String USER_INFO_DEFAULT = "System";
    private static final int CONVERT_BYTE = 1024;
    private static final String SJCAPPENDER = "SJSDLAPPENDER";
    private Logger logger = null;
    private String userInfo = "System";
    private static String processInfo = null;
    private static HashSet<String> loggerNameSet = new HashSet();
    private String logDir = null;

    public SJhlmLogger(String string, String string2, int n, int n2) {
        this.initialize(string, string2, n, n2);
    }

    private void initialize(String string, String string2, int n, int n2) {
        this.setProcessInfo();
        this.setDir(string);
        String string3 = this.getFilePath(string2);
        String string4 = string3.toUpperCase();
        Logger logger = (Logger)LoggerFactory.getLogger((String)string4);
        int n3 = Integer.MIN_VALUE;
        if (loggerNameSet.contains(string4)) {
            this.logger = logger;
            this.setLogLevel(n3);
            this.setLogSize(n);
            this.setLogCount(n2);
            this.info("LoggerUtility", this.getClass().getSimpleName(), "initialize", "Set exist logger : " + logger.getName());
            return;
        }
        Level level = Level.toLevel(n3, Level.INFO);
        logger.setLevel(level);
        if (n == 0 || n2 == 0) {
            this.logger = logger;
            this.info("LoggerUtility", this.getClass().getSimpleName(), "initialize", "Set No file output logger : " + logger.getName());
            return;
        }
        LoggerContext loggerContext = logger.getLoggerContext();
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setContext((Context)loggerContext);
        patternLayout.setPattern(LOG_OUTPUT_PATTERN);
        patternLayout.start();
        RollingFileAppender rollingFileAppender = new RollingFileAppender();
        rollingFileAppender.setName(SJCAPPENDER);
        rollingFileAppender.setContext((Context)loggerContext);
        rollingFileAppender.setFile(string3);
        LayoutWrappingEncoder layoutWrappingEncoder = new LayoutWrappingEncoder();
        layoutWrappingEncoder.setContext((Context)loggerContext);
        layoutWrappingEncoder.setCharset(Charset.forName(CHAR_SET));
        layoutWrappingEncoder.setImmediateFlush(true);
        layoutWrappingEncoder.setLayout((Layout)patternLayout);
        rollingFileAppender.setEncoder((Encoder)layoutWrappingEncoder);
        SJhlmRollingPolicy sJhlmRollingPolicy = new SJhlmRollingPolicy();
        String string5 = this.getRotationFilePath(string2);
        sJhlmRollingPolicy.setFileNamePattern(string5);
        sJhlmRollingPolicy.setMaxIndex(n2);
        sJhlmRollingPolicy.setContext((Context)loggerContext);
        sJhlmRollingPolicy.setParent((FileAppender)rollingFileAppender);
        rollingFileAppender.setRollingPolicy((RollingPolicy)sJhlmRollingPolicy);
        sJhlmRollingPolicy.start();
        SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy = new SizeBasedTriggeringPolicy();
        String string6 = String.valueOf(n) + LOG_SIZE_UNIT;
        sizeBasedTriggeringPolicy.setMaxFileSize(FileSize.valueOf((String)string6));
        sizeBasedTriggeringPolicy.setContext((Context)loggerContext);
        sizeBasedTriggeringPolicy.start();
        rollingFileAppender.setTriggeringPolicy((TriggeringPolicy)sizeBasedTriggeringPolicy);
        rollingFileAppender.start();
        logger.addAppender((Appender<ILoggingEvent>)rollingFileAppender);
        this.logger = logger;
        this.info("LoggerUtility", this.getClass().getSimpleName(), "initialize", "Set new logger : " + logger.getName());
        loggerNameSet.add(string4);
    }

    private void setProcessInfo() {
        if (processInfo == null) {
            processInfo = "";
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            if (runtimeMXBean != null) {
                processInfo = runtimeMXBean.getName();
            }
        }
    }

    private String getFilePath(String string) {
        return this.logDir + string;
    }

    private String getRotationFilePath(String string) {
        File file = new File(string);
        String string2 = file.getName();
        int n = string2.lastIndexOf(SEARCH_TEXT);
        if (n == -1) {
            n = string2.length();
        }
        String string3 = string2.substring(0, n) + NUMBER_SYMBOL + string2.substring(n);
        if (file.getParent() != null) {
            string3 = file.getParent() + File.separator + string3;
        }
        return this.getFilePath(string3);
    }

    private void setLogLevel(int n) {
        if (this.logger == null) {
            return;
        }
        Level level = this.logger.getLevel();
        int n2 = level.toInt();
        if (n2 != n) {
            Level level2 = Level.toLevel(n, Level.INFO);
            this.logger.setLevel(level2);
            this.logger.trace("Set new level. " + level2);
        }
    }

    private void setLogSize(int n) {
        if (this.logger == null) {
            return;
        }
        RollingFileAppender rollingFileAppender = (RollingFileAppender)this.logger.getAppender(SJCAPPENDER);
        if (rollingFileAppender == null) {
            return;
        }
        if (n == 0) {
            this.logger.detachAppender(SJCAPPENDER);
            this.info("LoggerUtility", this.getClass().getSimpleName(), "setLogSize", "Appender Stop" + this.logger.getName());
            return;
        }
        SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy = (SizeBasedTriggeringPolicy)rollingFileAppender.getTriggeringPolicy();
        if (sizeBasedTriggeringPolicy == null) {
            return;
        }
        String string = String.valueOf(n) + LOG_SIZE_UNIT;
        sizeBasedTriggeringPolicy.setMaxFileSize(FileSize.valueOf((String)string));
        this.info("LoggerUtility", this.getClass().getSimpleName(), "setLogSize", "Set new size. " + string);
    }

    private void setLogCount(int n) {
        if (this.logger == null) {
            return;
        }
        RollingFileAppender rollingFileAppender = (RollingFileAppender)this.logger.getAppender(SJCAPPENDER);
        if (rollingFileAppender == null) {
            return;
        }
        if (n == 0) {
            this.logger.detachAppender(SJCAPPENDER);
            this.info("LoggerUtility", this.getClass().getSimpleName(), "setLogCount", "Appender Stop" + this.logger.getName());
            return;
        }
        FixedWindowRollingPolicy fixedWindowRollingPolicy = (FixedWindowRollingPolicy)rollingFileAppender.getRollingPolicy();
        if (fixedWindowRollingPolicy == null) {
            return;
        }
        int n2 = fixedWindowRollingPolicy.getMaxIndex();
        if (n2 != n) {
            fixedWindowRollingPolicy.setMaxIndex(n);
            this.info("LoggerUtility", this.getClass().getSimpleName(), "setLogCount", "Set new max index. " + n);
        }
    }

    public void info(String string, String string2, String string3, String string4) {
        this.putLog(string, string2, string3, string4, 20000);
    }

    public void info(String string, String string2, String string3, String string4, Throwable throwable) {
        this.putLog(string, string2, string3, string4, throwable, 20000);
    }

    public void error(String string, String string2, String string3, String string4) {
        this.putLog(string, string2, string3, string4, 40000);
    }

    public void error(String string, String string2, String string3, String string4, Throwable throwable) {
        this.putLog(string, string2, string3, string4, throwable, 40000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLog(String string, String string2, String string3, String string4, Throwable throwable, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string4);
        StringWriter stringWriter = null;
        PrintWriter printWriter = null;
        try {
            if (throwable != null) {
                stringWriter = new StringWriter();
                printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                stringWriter.flush();
                stringBuffer.append(LOG_ITEM_SEPARETOR);
                stringBuffer.append(LINE_FEED_CODE);
                stringBuffer.append(stringWriter.toString());
            }
        }
        finally {
            try {
                if (stringWriter != null) {
                    stringWriter.close();
                }
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Throwable throwable2) {
                System.out.println("Exception occured.");
            }
        }
        this.putLog(string, string2, string3, stringBuffer.toString(), n);
    }

    public void putLog(String string, String string2, String string3, String string4, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SECTION_PAUSE_START);
        stringBuffer.append(string);
        stringBuffer.append(SECTION_PAUSE_END);
        stringBuffer.append(SECTION_PAUSE_START);
        stringBuffer.append(string2);
        stringBuffer.append(SECTION_PAUSE_END);
        stringBuffer.append(SECTION_PAUSE_START);
        stringBuffer.append(string3);
        stringBuffer.append(SECTION_PAUSE_END);
        stringBuffer.append(SECTION_PAUSE_START);
        stringBuffer.append(string4);
        stringBuffer.append(SECTION_PAUSE_END);
        this.putLog(stringBuffer.toString(), n);
    }

    public void putLog(String string, int n) {
        if (n == 40000) {
            this.error(string);
        } else {
            this.info(string);
        }
    }

    public void info(String string) {
        if (this.logger.isInfoEnabled()) {
            try {
                this.logger.info(this.getUserMsg() + string + this.getMemoryInfo());
            }
            catch (NullPointerException nullPointerException) {
                System.out.println(NO_SLF4J_LOGGER_MSG);
                nullPointerException.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void error(String string) {
        if (this.logger.isErrorEnabled()) {
            try {
                this.logger.error(this.getUserMsg() + string + this.getMemoryInfo());
            }
            catch (NullPointerException nullPointerException) {
                System.out.println(NO_SLF4J_LOGGER_MSG);
                nullPointerException.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private String getMemoryInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        long l = SJhlmSystemUtility.getUsedMemory() / 1024L;
        long l2 = SJhlmSystemUtility.getCommittedMemory() / 1024L;
        long l3 = SJhlmSystemUtility.getMaxMemory() / 1024L;
        stringBuffer.append(SECTION_PAUSE_START);
        stringBuffer.append(l);
        stringBuffer.append(MEMORY_SIZE_UNIT).append(MEMORY_SEPARETOR);
        stringBuffer.append(l2);
        stringBuffer.append(MEMORY_SIZE_UNIT).append(MEMORY_SEPARETOR);
        stringBuffer.append(l3);
        stringBuffer.append(MEMORY_SIZE_UNIT);
        stringBuffer.append(SECTION_PAUSE_END);
        return stringBuffer.toString();
    }

    private String getUserMsg() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SECTION_PAUSE_START);
        stringBuffer.append(processInfo);
        stringBuffer.append(SECTION_PAUSE_END);
        stringBuffer.append(SECTION_PAUSE_START);
        stringBuffer.append(this.userInfo);
        stringBuffer.append(SECTION_PAUSE_END);
        return stringBuffer.toString();
    }

    public void setDir(String string) {
        this.logDir = string;
    }
}

