/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.util.log;

import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class SJhlmRollingPolicy
extends FixedWindowRollingPolicy {
    private static final String ENCODE = "UTF-8";
    private static final String NUMBER_SYMBOL = "%i";
    private static final String LOG_EXT = ".log";
    private static final String LOG_REGEX = ".*";
    private static final String LOG_EXT_REGEX = "\\.log";
    private static final String DATE_FORMAT = "yyyyMMdd-HHmmss";
    private static final String SEARCH_EXT = ".";
    private static final String HISTORY_EXT = ".history";
    RenameUtil util = new RenameUtil();
    String historyMngFilePath = null;

    public void start() {
        super.start();
        this.util.setContext(this.context);
        this.historyMngFilePath = this.getHistroyMngFile();
    }

    public void rollover() throws RolloverFailure {
        List<File> list = this.readHistory();
        list = list.size() == 0 ? this.serachHistroyFile() : this.mergeHistroyFile(list);
        ArrayList<File> arrayList = new ArrayList<File>(list);
        int n = list.size();
        if (this.getMaxIndex() <= n) {
            for (File file : list) {
                if (this.getMaxIndex() > n) break;
                boolean bl = file.delete();
                if (bl) {
                    arrayList.remove(file);
                }
                --n;
            }
        }
        String string = this.getLogReplaceName();
        this.util.rename(this.getActiveFileName(), string);
        arrayList.add(new File(string));
        this.updateHistory(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> readHistory() {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File(this.historyMngFilePath);
        if (!file.exists()) {
            return arrayList;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ENCODE));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                File file2 = new File(this.concatFile(string));
                if (!file2.exists()) continue;
                arrayList.add(file2);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHistory(List<File> list) {
        File file = new File(this.historyMngFilePath);
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODE));
            for (File file2 : list) {
                bufferedWriter.write(file2.getName());
                bufferedWriter.newLine();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getHistroyMngFile() {
        String string = this.getActiveFileName();
        int n = this.getExtPosition(string);
        String string2 = string.substring(0, n) + HISTORY_EXT;
        return string2;
    }

    private List<File> serachHistroyFile() {
        List<File> list = new ArrayList<File>();
        File file = new File(this.getFileNamePattern());
        String string = file.getName();
        String string2 = string.replace(NUMBER_SYMBOL, LOG_REGEX);
        string2 = string2.replace(LOG_EXT, LOG_EXT_REGEX);
        File file2 = new File(this.getDirName());
        File[] fileArray = file2.listFiles(this.getFileRegexFilter(string2));
        if (fileArray != null) {
            Arrays.sort(fileArray, new FileComparator());
            list = Arrays.asList(fileArray);
        }
        return list;
    }

    private List<File> mergeHistroyFile(List<File> list) {
        ArrayList<File> arrayList = new ArrayList<File>(list);
        List<File> list2 = this.serachHistroyFile();
        for (File file : list2) {
            if (list.contains(file)) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    private String getLogReplaceName() {
        File file;
        String string = this.getFileNamePattern();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        String string2 = simpleDateFormat.format(new Date());
        String string3 = string.replace(NUMBER_SYMBOL, string2);
        int n = 0;
        while ((file = new File(string3)).exists()) {
            string3 = string.replace(NUMBER_SYMBOL, string2 + "-" + ++n);
        }
        return string3;
    }

    private FilenameFilter getFileRegexFilter(String string) {
        final String string2 = string;
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                boolean bl = string.matches(string2);
                return bl;
            }
        };
    }

    private String getDirName() {
        File file = new File(this.getActiveFileName());
        String string = file.getParent();
        return string;
    }

    private String concatFile(String string) {
        String string2 = this.getDirName();
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        string2 = string2 + string;
        return string2;
    }

    private int getExtPosition(String string) {
        int n = string.lastIndexOf(SEARCH_EXT);
        if (n == -1) {
            n = string.length();
        }
        return n;
    }

    private class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File file, File file2) {
            long l = file2.lastModified() - file.lastModified();
            if (l > 0L) {
                return -1;
            }
            if (l == 0L) {
                return 0;
            }
            return 1;
        }
    }
}

