/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.ctl.input;

import sanproject.hlm.com.SJhlmRunnable;
import sanproject.hlm.ctl.SJhlmControllerInterface;
import sanproject.hlm.ctl.confirm.SJhlmGumInvalidSignConfirmController;
import sanproject.hlm.ctl.confirm.SJhlmSVPInvalidSignConfirmController;
import sanproject.hlm.ctl.message.SJhlmMessageController;
import sanproject.hlm.data.SJhlmJWSParamData;
import sanproject.hlm.exception.SJhlmConfirmingException;
import sanproject.hlm.exception.SJhlmException;
import sanproject.hlm.exception.SJhlmGumInvalidSignConfirmException;
import sanproject.hlm.exception.SJhlmSVPInvalidSignConfirmException;
import sanproject.hlm.factory.SJhlmExceptionFactory;
import sanproject.hlm.factory.SJhlmJWSModelFactory;
import sanproject.hlm.handler.SJhlmErrorHandler;
import sanproject.hlm.logic.SJhlmJNLPLaunchLogic;
import sanproject.hlm.manager.SJhlmUIEventRunnerManager;
import sanproject.hlm.manager.SJhlmUIManager;
import sanproject.hlm.model.SJhlmJWSModel;
import sanproject.hlm.util.SJhlmLogUtility;

public class SJhlmInputParameterController
implements SJhlmControllerInterface {
    private static final String CLASSNAME = SJhlmInputParameterController.class.getSimpleName();
    private String path = null;

    public SJhlmRunnable pushConnectButton() {
        return new SJhlmRunnable(){

            @Override
            public void run() {
                SJhlmLogUtility.putLog(CLASSNAME, "pushConnectButton.invoke", "Start");
                try {
                    SJhlmUIEventRunnerManager.run(new SJhlmRunnable(){

                        @Override
                        public void run() {
                            try {
                                SJhlmUIManager.showDialog(new SJhlmMessageController());
                                SJhlmJWSParamData sJhlmJWSParamData = SJhlmJNLPLaunchLogic.readJNLPFile(SJhlmInputParameterController.this.getPath());
                                SJhlmJWSModel sJhlmJWSModel = SJhlmJWSModelFactory.create(sJhlmJWSParamData);
                                SJhlmInputParameterController.this.startJWS(sJhlmJWSModel);
                            }
                            catch (SJhlmException sJhlmException) {
                                SJhlmUIManager.closeDialog();
                                SJhlmErrorHandler.handle(sJhlmException);
                            }
                        }
                    });
                }
                catch (SJhlmException sJhlmException) {
                    SJhlmErrorHandler.handle(sJhlmException);
                }
            }
        };
    }

    private SJhlmRunnable onStartJWS() {
        return new SJhlmRunnable(){

            @Override
            public void run() {
                SJhlmUIManager.closeScreen();
                SJhlmUIManager.closeDialog();
            }
        };
    }

    private void startJWS(SJhlmJWSModel sJhlmJWSModel) throws SJhlmException {
        try {
            sJhlmJWSModel.start(this.onStartJWS());
        }
        catch (SJhlmConfirmingException sJhlmConfirmingException) {
            SJhlmUIManager.closeDialog();
            if (sJhlmConfirmingException instanceof SJhlmGumInvalidSignConfirmException) {
                SJhlmGumInvalidSignConfirmException sJhlmGumInvalidSignConfirmException = (SJhlmGumInvalidSignConfirmException)sJhlmConfirmingException;
                SJhlmGumInvalidSignConfirmController sJhlmGumInvalidSignConfirmController = new SJhlmGumInvalidSignConfirmController(sJhlmGumInvalidSignConfirmException.getJws(), false);
                sJhlmGumInvalidSignConfirmController.setConfirm(this.getConfirm(sJhlmGumInvalidSignConfirmException.getJws()));
                SJhlmUIManager.showDialog(sJhlmGumInvalidSignConfirmController);
            }
            if (sJhlmConfirmingException instanceof SJhlmSVPInvalidSignConfirmException) {
                SJhlmSVPInvalidSignConfirmException sJhlmSVPInvalidSignConfirmException = (SJhlmSVPInvalidSignConfirmException)sJhlmConfirmingException;
                SJhlmSVPInvalidSignConfirmController sJhlmSVPInvalidSignConfirmController = new SJhlmSVPInvalidSignConfirmController(sJhlmSVPInvalidSignConfirmException.getJws(), false);
                sJhlmSVPInvalidSignConfirmController.setConfirm(this.getConfirm(sJhlmSVPInvalidSignConfirmException.getJws()));
                SJhlmUIManager.showDialog(sJhlmSVPInvalidSignConfirmController);
            }
            throw SJhlmExceptionFactory.create().fatal();
        }
    }

    private SJhlmRunnable getConfirm(final SJhlmJWSModel sJhlmJWSModel) {
        return new SJhlmRunnable(){

            @Override
            public void run() {
                SJhlmUIManager.closeDialog();
                SJhlmUIManager.showDialog(new SJhlmMessageController());
                try {
                    sJhlmJWSModel.skipVerify().start(SJhlmInputParameterController.this.onStartJWS());
                }
                catch (SJhlmConfirmingException sJhlmConfirmingException) {
                    SJhlmErrorHandler.handle(SJhlmExceptionFactory.create(sJhlmConfirmingException).fatal());
                }
                catch (SJhlmException sJhlmException) {
                    SJhlmUIManager.closeDialog();
                    SJhlmErrorHandler.handle(sJhlmException);
                }
            }
        };
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }
}

