/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.manager;

import java.io.File;
import java.util.Locale;
import sanproject.hlm.manager.SJhlmLoggerManager;
import sanproject.hlm.manager.SJhlmWordManager;
import sanproject.hlm.model.SJhlmLockedDirectoryModel;
import sanproject.hlm.util.SJhlmLogUtility;

public class SJhlmInitialManager {
    private static final String CLASSNAME = SJhlmInitialManager.class.getSimpleName();

    public static void init() {
        SJhlmInitialManager.setSVPInternal();
        SJhlmLogUtility.putLog(CLASSNAME, "init", "Started.");
        SJhlmInitialManager.setLocale();
        SJhlmInitialManager.deleteCache();
        SJhlmLogUtility.putLog(CLASSNAME, "init", "End.");
    }

    private static void setSVPInternal() {
        File file = new File("./svp");
        if (file.exists()) {
            SJhlmLoggerManager.svpInternal = true;
        }
    }

    private static void setLocale() {
        SJhlmWordManager.setLang(Locale.getDefault().getLanguage());
        SJhlmLogUtility.putLog(CLASSNAME, "setLocale()", "End.(lang=" + Locale.getDefault().getLanguage() + ")");
    }

    public static void deleteCache() {
        SJhlmLogUtility.putLog(CLASSNAME, "deleteCache", "Start.");
        String string = "./cache";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
        for (File file2 : file.listFiles()) {
            if (file2.isFile() && file2.exists()) {
                SJhlmLogUtility.putLog(CLASSNAME, "deleteCache", "deleting file(" + file2.getAbsolutePath() + ")");
                file2.delete();
                SJhlmLogUtility.putLog(CLASSNAME, "deleteCache", "completed.");
            }
            if (!file2.isDirectory() || !file2.exists()) continue;
            SJhlmLogUtility.putLog(CLASSNAME, "deleteCache", "deleting dir(" + file2.getAbsolutePath() + ")");
            try {
                SJhlmLockedDirectoryModel sJhlmLockedDirectoryModel = new SJhlmLockedDirectoryModel(file2.getAbsolutePath());
                sJhlmLockedDirectoryModel.destroy();
            }
            catch (Exception exception) {
                SJhlmLogUtility.putError(CLASSNAME, "deleteCache", "cannot delete(ignored) (" + file2.getAbsolutePath() + ")", exception);
            }
            SJhlmLogUtility.putLog(CLASSNAME, "deleteCache", "completed.");
        }
        SJhlmLogUtility.putLog(CLASSNAME, "deleteCache", "finish.");
    }
}

