/*
 * Decompiled with CFR 0.152.
 */
package sanproject.hlm.manager;

import java.awt.Frame;
import javax.swing.SwingUtilities;
import sanproject.hlm.ctl.SJhlmControllerInterface;
import sanproject.hlm.ctl.confirm.SJhlmConfirmController;
import sanproject.hlm.ctl.error.SJhlmErrorController;
import sanproject.hlm.ctl.input.SJhlmInputParameterController;
import sanproject.hlm.ctl.message.SJhlmMessageController;
import sanproject.hlm.factory.SJhlmExceptionFactory;
import sanproject.hlm.ui.dialog.SJhlmErrorDialog;
import sanproject.hlm.ui.dialog.SJhlmScreenDialog;
import sanproject.hlm.ui.parts.SJhlmTopFrame;
import sanproject.hlm.ui.screen.SJhlmScreenBase;
import sanproject.hlm.ui.screen.confirm.SJhlmConfirmScreen;
import sanproject.hlm.ui.screen.input.SJhlmInputParameterScreen;
import sanproject.hlm.ui.screen.message.SJhlmMessageScreen;
import sanproject.hlm.util.SJhlmLogUtility;

public class SJhlmUIManager {
    private static final String CLASSNAME = SJhlmUIManager.class.getSimpleName();
    private static SJhlmTopFrame top = null;
    private static SJhlmScreenDialog dialog = null;
    private static SJhlmErrorDialog error = null;
    private static SJhlmControllerInterface screenCtl = null;
    private static SJhlmControllerInterface dialogCtl = null;
    private static SJhlmErrorController errCtl = null;

    public static void showScreen(SJhlmControllerInterface sJhlmControllerInterface) {
        SJhlmLogUtility.putLog(CLASSNAME, "showScreen", "Start.(ctl=" + sJhlmControllerInterface.getClass().getSimpleName() + ")");
        screenCtl = sJhlmControllerInterface;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SJhlmUIManager.invokeShowScreen(screenCtl);
            }
        });
        SJhlmLogUtility.putLog(CLASSNAME, "showScreen", "End.");
    }

    private static void invokeShowScreen(SJhlmControllerInterface sJhlmControllerInterface) {
        SJhlmLogUtility.putLog(CLASSNAME, "invokeShowScreen", "Start.(ctl=" + sJhlmControllerInterface.getClass().getSimpleName() + ")");
        SJhlmUIManager.invokeCloseScreen();
        if (top == null) {
            top = new SJhlmTopFrame();
        }
        top.showScreen(SJhlmUIManager.createScreen(sJhlmControllerInterface));
        top.setVisible(true);
        SJhlmLogUtility.putLog(CLASSNAME, "invokeShowScreen", "End.");
    }

    public static void closeScreen() {
        SJhlmLogUtility.putLog(CLASSNAME, "closeScreen", "Start.");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SJhlmUIManager.invokeCloseScreen();
            }
        });
        SJhlmLogUtility.putLog(CLASSNAME, "closeScreen", "End.");
    }

    public static SJhlmTopFrame getTopFrame() {
        return top;
    }

    private static void invokeCloseScreen() {
        SJhlmLogUtility.putLog(CLASSNAME, "invokeCloseScreen", "Start.");
        if (top != null) {
            top.setVisible(false);
            top.dispose();
            top = null;
        }
        SJhlmLogUtility.putLog(CLASSNAME, "invokeCloseScreen", "End.");
    }

    public static void showDialog(SJhlmControllerInterface sJhlmControllerInterface) {
        SJhlmLogUtility.putLog(CLASSNAME, "showDialog", "Start.(ctl=" + sJhlmControllerInterface.getClass().getSimpleName() + ")");
        dialogCtl = sJhlmControllerInterface;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SJhlmUIManager.invokeShowDialog(dialogCtl);
            }
        });
        SJhlmLogUtility.putLog(CLASSNAME, "showDialog", "End.");
    }

    private static void invokeShowDialog(SJhlmControllerInterface sJhlmControllerInterface) {
        SJhlmLogUtility.putLog(CLASSNAME, "invokeShowDialog", "Start.(ctl=" + sJhlmControllerInterface.getClass().getSimpleName() + ")");
        SJhlmUIManager.invokeCloseDialog();
        if (dialog == null) {
            dialog = new SJhlmScreenDialog((Frame)top, true);
        }
        dialog.showScreen(SJhlmUIManager.createScreen(sJhlmControllerInterface));
        dialog.setVisible(true);
        SJhlmLogUtility.putLog(CLASSNAME, "invokeShowDialog", "End.");
    }

    public static void closeDialog() {
        SJhlmLogUtility.putLog(CLASSNAME, "closeDialog", "Start.");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SJhlmUIManager.invokeCloseDialog();
            }
        });
        SJhlmLogUtility.putLog(CLASSNAME, "closeDialog", "End.");
    }

    private static void invokeCloseDialog() {
        SJhlmLogUtility.putLog(CLASSNAME, "invokeCloseDialog", "Start.");
        if (dialog != null) {
            dialog.setVisible(false);
            dialog.dispose();
            dialog = null;
        }
        SJhlmLogUtility.putLog(CLASSNAME, "invokeCloseDialog", "End.");
    }

    public static void showErrorDialog(SJhlmErrorController sJhlmErrorController) {
        SJhlmLogUtility.putLog(CLASSNAME, "showErrorDialog", "Start.");
        errCtl = sJhlmErrorController;
        if (error == null) {
            error = new SJhlmErrorDialog((Frame)top, true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                error.showScreen(errCtl);
                error.setVisible(true);
            }
        });
        SJhlmLogUtility.putLog(CLASSNAME, "showErrorDialog", "End.");
    }

    public static void hideErrorDialog() {
        SJhlmLogUtility.putLog(CLASSNAME, "hideErrorDialog", "Start.");
        if (error != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    error.setVisible(false);
                }
            });
        }
        SJhlmLogUtility.putLog(CLASSNAME, "hideErrorDialog", "End.");
    }

    private static SJhlmScreenBase createScreen(SJhlmControllerInterface sJhlmControllerInterface) {
        SJhlmLogUtility.putLog(CLASSNAME, "createScreen", "Start.(ctl=" + sJhlmControllerInterface.getClass().getSimpleName() + ")");
        if (sJhlmControllerInterface instanceof SJhlmInputParameterController) {
            SJhlmInputParameterController sJhlmInputParameterController = (SJhlmInputParameterController)sJhlmControllerInterface;
            return new SJhlmInputParameterScreen(sJhlmInputParameterController);
        }
        if (sJhlmControllerInterface instanceof SJhlmMessageController) {
            SJhlmMessageController sJhlmMessageController = (SJhlmMessageController)sJhlmControllerInterface;
            return new SJhlmMessageScreen(sJhlmMessageController);
        }
        if (sJhlmControllerInterface instanceof SJhlmConfirmController) {
            SJhlmConfirmController sJhlmConfirmController = (SJhlmConfirmController)sJhlmControllerInterface;
            return new SJhlmConfirmScreen(sJhlmConfirmController);
        }
        SJhlmLogUtility.putError(CLASSNAME, "createScreen", "invalid ctl");
        SJhlmUIManager.showErrorDialog(new SJhlmErrorController(SJhlmExceptionFactory.create()));
        return null;
    }
}

